/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.spark;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.streaming.DatasetWriteRequest;
import com.dataiku.dip.dataflow.streaming.DatasetWritingService;
import com.dataiku.dip.output.CSVOutputFormatter;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.rpc.TicketBasedIntercomAPIClient;
import com.dataiku.dip.spark.StdDataikuSparkContext$;
import com.dataiku.dip.spark.package$;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.http.HttpEntity;
import com.dataiku.dss.shadelib.org.apache.http.entity.InputStreamEntity;
import com.dataiku.dss.spark.WriteMode$;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.apache.log4j.Logger;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.math.Ordering;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.Tuple2Zipped;
import scala.runtime.Tuple2Zipped$;

public final class RemoteDatasetRDD$
implements scala.Serializable {
    public static RemoteDatasetRDD$ MODULE$;
    private final Logger com$dataiku$dip$spark$RemoteDatasetRDD$$logger;

    static {
        new RemoteDatasetRDD$();
    }

    public Iterator<Row> extractRows(List<String> columnNames, List<SchemaColumn> schemaColumns, Iterator<List<String>> rddPartition) {
        int nCol = schemaColumns.length();
        IntRef failedRows = IntRef.create((int)0);
        return rddPartition.flatMap((Function1 & Serializable & scala.Serializable)dkuRow -> {
            Iterable iterable;
            try {
                Predef$.MODULE$.require(dkuRow.length() == nCol, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("invalid number of columns in row: ").append(dkuRow.length()).append(" expected ").append(nCol).toString());
                List rowVals = (List)Tuple2Zipped$.MODULE$.map$extension(Tuple2Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple2ToZippedOps(new Tuple2(dkuRow, (Object)schemaColumns)), (Function1)Predef$.MODULE$.$conforms(), (Function1)Predef$.MODULE$.$conforms()), (Function2 & Serializable & scala.Serializable)(v, t) -> package$.MODULE$.dkuToSpark((String)v, (SchemaColumn)t), List$.MODULE$.canBuildFrom());
                iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)Row$.MODULE$.fromSeq((Seq)rowVals)));
            }
            catch (Exception e) {
                if (failedRows$1.elem < 2) {
                    MODULE$.com$dataiku$dip$spark$RemoteDatasetRDD$$logger().warn((Object)"Failed to load row", (Throwable)e);
                }
                ++failedRows$1.elem;
                iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            return iterable;
        });
    }

    public RDD<List<String>> resizeToOnePartition(RDD<List<String>> rdd) {
        int n = rdd.partitions().length;
        switch (n) {
            case 0: {
                int x$1 = 1;
                Ordering x$2 = rdd.repartition$default$2(x$1);
                return rdd.repartition(x$1, x$2);
            }
            case 1: {
                return rdd;
            }
        }
        int x$3 = 1;
        boolean x$4 = rdd.coalesce$default$2();
        Option x$5 = rdd.coalesce$default$3();
        Ordering x$6 = rdd.coalesce$default$4(x$3, x$4, x$5);
        return rdd.coalesce(x$3, x$4, x$5, x$6);
    }

    public void saveToDataset(RDD<List<String>> rdd, Dataset dataset, String targetPartition, Enumeration.Value writeMode, String apiTicket) {
        this.saveToDatasetInternal(rdd, dataset.getFullName(), dataset.getSchema(), targetPartition, writeMode, null, apiTicket);
    }

    public String saveToDataset$default$3() {
        return null;
    }

    public Enumeration.Value saveToDataset$default$4() {
        return WriteMode$.MODULE$.Overwrite();
    }

    public void saveToDatasetInternal(RDD<List<String>> rdd, String datasetFullName, Schema datasetSchema, String targetPartition, Enumeration.Value writeMode, String batchId, String apiTicket) {
        this.com$dataiku$dip$spark$RemoteDatasetRDD$$logger().info((Object)new StringBuilder(64).append("Saving RDD to dataset: ").append(datasetFullName).append(", targetPartition=").append(targetPartition).append(" rdd.partitions.length=").append(rdd.partitions().length).toString());
        if (rdd.partitions().length != 1) {
            throw new IllegalArgumentException("RDD must contain only 1 partition");
        }
        String apiURL = StdDataikuSparkContext$.MODULE$.apiRemoteURL();
        String apiServerCert = StdDataikuSparkContext$.MODULE$.apiServerCert();
        String apiPath = StdDataikuSparkContext$.MODULE$.apiPath();
        String activityId = StdDataikuSparkContext$.MODULE$.activityId();
        String fullName = datasetFullName;
        Schema schema = datasetSchema;
        int nCols = schema.getColumns().size();
        String schemaJson = JSON.json((Object)schema);
        rdd.foreachPartition((Function1 & Serializable & scala.Serializable)rddPartition -> {
            RemoteDatasetRDD$.$anonfun$saveToDatasetInternal$1(apiURL, apiServerCert, apiTicket, fullName, targetPartition, activityId, schemaJson, writeMode, batchId, apiPath, nCols, rddPartition);
            return BoxedUnit.UNIT;
        });
    }

    public String saveToDatasetInternal$default$4() {
        return null;
    }

    public Enumeration.Value saveToDatasetInternal$default$5() {
        return WriteMode$.MODULE$.Overwrite();
    }

    public String saveToDatasetInternal$default$6() {
        return null;
    }

    public Logger com$dataiku$dip$spark$RemoteDatasetRDD$$logger() {
        return this.com$dataiku$dip$spark$RemoteDatasetRDD$$logger;
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ void $anonfun$saveToDatasetInternal$4(BooleanRef first$1, OutputStreamWriter pipeOut$1, char sep$1, char quote$1, String cell) {
        if (first$1.elem) {
            first$1.elem = false;
        } else {
            pipeOut$1.write(sep$1);
        }
        CSVOutputFormatter.appendExcelStyle((Writer)pipeOut$1, (String)cell, (char)sep$1, (char)quote$1);
    }

    public static final /* synthetic */ void $anonfun$saveToDatasetInternal$2(int nCols$1, OutputStreamWriter pipeOut$1, char sep$1, char quote$1, IntRef writtenRecords$1, String fullName$1, List row) {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Predef$.MODULE$.require(row.size() == nCols$1, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Trying to save ").append(nCols$1).append(" columns but RDD contains ").append(row.size()).toString());
        BooleanRef first = BooleanRef.create((boolean)true);
        row.foreach((Function1 & Serializable & scala.Serializable)cell -> {
            RemoteDatasetRDD$.$anonfun$saveToDatasetInternal$4(first, pipeOut$1, sep$1, quote$1, cell);
            return BoxedUnit.UNIT;
        });
        pipeOut$1.write(10);
        ++writtenRecords$1.elem;
        if (writtenRecords$1.elem % 100000 == 0) {
            MODULE$.com$dataiku$dip$spark$RemoteDatasetRDD$$logger().info((Object)new StringBuilder(25).append("dataset=").append(fullName$1).append(" written ").append(writtenRecords$1.elem).append(" records").toString());
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$saveToDatasetInternal$1(String apiURL$1, String apiServerCert$1, String apiTicket$1, String fullName$1, String targetPartition$1, String activityId$1, String schemaJson$1, Enumeration.Value writeMode$1, String batchId$1, String apiPath$1, int nCols$1, Iterator rddPartition) {
        TicketBasedIntercomAPIClient apiClient = new TicketBasedIntercomAPIClient(apiURL$1, apiServerCert$1, apiTicket$1);
        DatasetWriteRequest writeRequest = new DatasetWriteRequest();
        writeRequest.fullDatasetName = fullName$1;
        writeRequest.partitionSpec = targetPartition$1;
        writeRequest.activityId = activityId$1;
        writeRequest.dataSchema = (Schema)JSON.parse((String)schemaJson$1, Schema.class);
        writeRequest.method = DatasetWriteRequest.Method.STREAM;
        writeRequest.writeMode = Output.WriteMode.valueOf((String)writeMode$1.toString());
        writeRequest.fixedId = batchId$1;
        MODULE$.com$dataiku$dip$spark$RemoteDatasetRDD$$logger().info((Object)"Opening write session");
        String sessionId = ((DatasetWritingService.SessionId)apiClient.postFormToJSON((String)new StringBuilder((int)29).append((String)apiPath$1).append((String)"/datasets/init-write-session/").toString(), DatasetWritingService.SessionId.class, (Object[])new Object[]{"request", JSON.json((Object)writeRequest)})).id;
        MODULE$.com$dataiku$dip$spark$RemoteDatasetRDD$$logger().info((Object)new StringBuilder(10).append("sessionId=").append(sessionId).toString());
        PipedInputStream pipeIn = new PipedInputStream();
        OutputStreamWriter pipeOut = new OutputStreamWriter((OutputStream)new PipedOutputStream(pipeIn), StandardCharsets.UTF_8);
        Thread enumThread = Thread.currentThread();
        ObjectRef pushFailed = ObjectRef.create(null);
        Thread pushThread = new Thread(sessionId, apiClient, apiPath$1, pipeIn, pushFailed, enumThread){
            private final String sessionId$1;
            private final TicketBasedIntercomAPIClient apiClient$1;
            private final String apiPath$1;
            private final PipedInputStream pipeIn$1;
            private final ObjectRef pushFailed$1;
            private final Thread enumThread$1;

            public void run() {
                try {
                    try {
                        RemoteDatasetRDD$.MODULE$.com$dataiku$dip$spark$RemoteDatasetRDD$$logger().info((Object)new StringBuilder(32).append("Pushing dataset data, sessionId=").append(this.sessionId$1).toString());
                        this.apiClient$1.postAnyToJSON(new StringBuilder(24).append(this.apiPath$1).append("/datasets/push-data/?id=").append(this.sessionId$1).toString(), Void.class, (HttpEntity)new InputStreamEntity((InputStream)this.pipeIn$1, -1L));
                        RemoteDatasetRDD$.MODULE$.com$dataiku$dip$spark$RemoteDatasetRDD$$logger().info((Object)new StringBuilder(37).append("Done pushing dataset data, sessionId=").append(this.sessionId$1).toString());
                    }
                    catch (Throwable t) {
                        this.pushFailed$1.elem = t;
                        RemoteDatasetRDD$.MODULE$.com$dataiku$dip$spark$RemoteDatasetRDD$$logger().error((Object)new StringBuilder(33).append("Error pushing dataset, sessionId=").append(this.sessionId$1).toString(), t);
                        this.enumThread$1.interrupt();
                        throw t;
                    }
                }
                finally {
                    this.pipeIn$1.close();
                }
            }
            {
                this.sessionId$1 = sessionId$1;
                this.apiClient$1 = apiClient$1;
                this.apiPath$1 = apiPath$1;
                this.pipeIn$1 = pipeIn$1;
                this.pushFailed$1 = pushFailed$1;
                this.enumThread$1 = enumThread$1;
            }
        };
        ObjectRef waitFailed = ObjectRef.create(null);
        Thread waitThread = new Thread(sessionId, apiClient, apiPath$1, waitFailed, enumThread, pushThread){
            private final String sessionId$1;
            private final TicketBasedIntercomAPIClient apiClient$1;
            private final String apiPath$1;
            private final ObjectRef waitFailed$1;
            private final Thread enumThread$1;
            private final Thread pushThread$1;

            public void run() {
                try {
                    RemoteDatasetRDD$.MODULE$.com$dataiku$dip$spark$RemoteDatasetRDD$$logger().info((Object)new StringBuilder(48).append("Waiting for push session to complete, sessionId=").append(this.sessionId$1).toString());
                    DatasetWritingService.WriteSessionResult result = (DatasetWritingService.WriteSessionResult)this.apiClient$1.get(new StringBuilder(33).append(this.apiPath$1).append("/datasets/wait-write-session/?id=").append(this.sessionId$1).toString(), DatasetWritingService.WriteSessionResult.class);
                    if (!result.ok) {
                        throw new Exception(new StringBuilder(21).append("Push session failed: ").append(result.message).toString());
                    }
                    RemoteDatasetRDD$.MODULE$.com$dataiku$dip$spark$RemoteDatasetRDD$$logger().info((Object)new StringBuilder(35).append("Push session complete, writtenRows=").append(result.writtenRows).toString());
                }
                catch (Throwable t) {
                    this.waitFailed$1.elem = t;
                    RemoteDatasetRDD$.MODULE$.com$dataiku$dip$spark$RemoteDatasetRDD$$logger().error((Object)new StringBuilder(54).append("Error waiting for push session to complete, sessionId=").append(this.sessionId$1).toString(), t);
                    this.enumThread$1.interrupt();
                    this.pushThread$1.interrupt();
                    throw t;
                }
            }
            {
                this.sessionId$1 = sessionId$1;
                this.apiClient$1 = apiClient$1;
                this.apiPath$1 = apiPath$1;
                this.waitFailed$1 = waitFailed$1;
                this.enumThread$1 = enumThread$1;
                this.pushThread$1 = pushThread$1;
            }
        };
        try {
            MODULE$.com$dataiku$dip$spark$RemoteDatasetRDD$$logger().info((Object)"Starting wait thread");
            waitThread.start();
            MODULE$.com$dataiku$dip$spark$RemoteDatasetRDD$$logger().info((Object)"Starting push thread");
            pushThread.start();
            MODULE$.com$dataiku$dip$spark$RemoteDatasetRDD$$logger().info((Object)"Enumerating RDD");
            IntRef writtenRecords = IntRef.create((int)0);
            try {
                char sep = ',';
                char quote = '\"';
                rddPartition.foreach((Function1 & Serializable & scala.Serializable)row -> {
                    RemoteDatasetRDD$.$anonfun$saveToDatasetInternal$2(nCols$1, pipeOut, sep, quote, writtenRecords, fullName$1, row);
                    return BoxedUnit.UNIT;
                });
            }
            finally {
                pipeOut.close();
            }
            MODULE$.com$dataiku$dip$spark$RemoteDatasetRDD$$logger().info((Object)"Waiting for push thread to complete");
            pushThread.join();
            if ((Throwable)pushFailed.elem != null) {
                throw new Exception("Push thread failed", (Throwable)pushFailed.elem);
            }
            MODULE$.com$dataiku$dip$spark$RemoteDatasetRDD$$logger().info((Object)"Waiting for wait thread to complete");
            waitThread.join();
            if ((Throwable)waitFailed.elem != null) {
                throw new Exception("Wait thread failed", (Throwable)waitFailed.elem);
            }
            MODULE$.com$dataiku$dip$spark$RemoteDatasetRDD$$logger().info((Object)"Done saving RDD partition");
        }
        catch (Throwable e) {
            MODULE$.com$dataiku$dip$spark$RemoteDatasetRDD$$logger().error((Object)"Error saving RDD to dataset", e);
            pushThread.interrupt();
            waitThread.interrupt();
            throw e;
        }
    }

    private RemoteDatasetRDD$() {
        MODULE$ = this;
        this.com$dataiku$dip$spark$RemoteDatasetRDD$$logger = Logger.getLogger((String)"dku.spark.dataset.remote");
    }
}

