/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.spark;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.EC2Connection;
import com.dataiku.dip.connections.SnowflakeConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.datasets.SamplingParam;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.datasets.fs.AzureBlobDatasetHandler;
import com.dataiku.dip.datasets.fs.BuiltinFSDatasets;
import com.dataiku.dip.datasets.fs.FilesystemDatasetConfig;
import com.dataiku.dip.datasets.fs.GCSDatasetHandler;
import com.dataiku.dip.datasets.fs.HDFSDatasetHandler;
import com.dataiku.dip.datasets.fs.S3DatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.expressions.Expression;
import com.dataiku.dip.expressions.GrelToQueryMapping;
import com.dataiku.dip.expressions.GrelToQueryTranslator;
import com.dataiku.dip.expressions.GrelTranslator;
import com.dataiku.dip.hadoop.HadoopFlavorUtils;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.spark.StdDataikuSparkContext$;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SnowflakeSQLDialect;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.spark.sql.SQLContext;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Set$;
import scala.runtime.BoxesRunTime;

public final class StorageBackendsSupport$ {
    public static StorageBackendsSupport$ MODULE$;
    private final Logger logger;

    static {
        new StorageBackendsSupport$();
    }

    public Tuple2<Object, String> isFilesystemDatasetCompatible(Dataset dataset, SQLContext ctx) {
        String key = "spark.dku.disable.native.filesystem.access";
        boolean value = new StringOps(Predef$.MODULE$.augmentString(ctx.sparkContext().getConf().get(key, "true"))).toBoolean();
        if (value) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"Native filesystem access is disallowed");
        }
        String connectionName = ((AbstractFSDatasetHandler.AbstractFSConfig)dataset.getParamsAs(FilesystemDatasetConfig.class)).connection;
        if (StringUtils.isNotBlank((String)connectionName)) {
            DSSConnection conn = ConnectionsDAO.get().getConnection((AuthCtx)DSSAuthCtx.newNone(), connectionName);
            if (conn == null) {
                return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"Filesystem connection details are not available in Spark driver: do you need to authorize it?");
            }
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), null);
        }
        return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), null);
    }

    public Tuple2<Object, String> isHDFSDatasetCompatible(Dataset dataset) {
        String connectionName = ((AbstractFSDatasetHandler.AbstractFSConfig)dataset.getParamsAs(HDFSDatasetHandler.Config.class)).connection;
        if (StringUtils.isNotBlank((String)connectionName)) {
            DSSConnection conn = ConnectionsDAO.get().getConnection((AuthCtx)DSSAuthCtx.newNone(), connectionName);
            if (conn == null) {
                return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"HDFS connection details are not available in Spark driver: do you need to authorize it?");
            }
            if (((AbstractFSDatasetHandler.AbstractFSConfig)dataset.getParamsAs(AbstractFSDatasetHandler.AbstractFSConfig.class)).variablesExpansionLoopConfig.isEnabled()) {
                return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"Repeating dataset is enabled");
            }
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), null);
        }
        if (((AbstractFSDatasetHandler.AbstractFSConfig)dataset.getParamsAs(AbstractFSDatasetHandler.AbstractFSConfig.class)).variablesExpansionLoopConfig.isEnabled()) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"Repeating dataset is enabled");
        }
        return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), null);
    }

    public Tuple2<Object, String> isS3DatasetCompatible(Dataset dataset, AuthCtx authCtx, boolean forWrite) {
        String connectionName = ((AbstractFSDatasetHandler.AbstractFSConfig)dataset.getParamsAs(BuiltinFSDatasets.S3DatasetConfig.class)).connection;
        if (StringUtils.isNotBlank((String)connectionName)) {
            DSSConnection conn = ConnectionsDAO.get().getConnection((AuthCtx)DSSAuthCtx.newNone(), connectionName);
            if (conn == null) {
                return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"S3 connection details are not available in Spark driver: do you need to authorize it?");
            }
            if (forWrite && !((EC2Connection)conn).params.encryptionMode.sparkDirectWrite && !HadoopFlavorUtils.isAtLeast((int[])new int[]{2, 9})) {
                return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new StringBuilder(65).append("Encryption mode ").append(((EC2Connection)conn).params.encryptionMode).append(" is not compatible with direct Spark S3 interface").toString());
            }
        }
        S3DatasetHandler dsh = (S3DatasetHandler)DatasetHandlerFactory.build((AuthCtx)authCtx, (Dataset)dataset);
        if (((AbstractFSDatasetHandler.AbstractFSConfig)dsh.getDataset().getParamsAs(AbstractFSDatasetHandler.AbstractFSConfig.class)).variablesExpansionLoopConfig.isEnabled()) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"Repeating dataset is enabled");
        }
        String rootPath = dsh.getFullyQualifiedRootPath();
        if (rootPath == null) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"S3 Spark interface is disabled for dataset");
        }
        return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)"");
    }

    public Tuple2<Object, String> isAzureDatasetCompatible(Dataset dataset, AuthCtx authCtx, boolean forWrite) {
        DSSConnection conn;
        String connectionName = ((AbstractFSDatasetHandler.AbstractFSConfig)dataset.getParamsAs(BuiltinFSDatasets.AzureBlobDatasetConfig.class)).connection;
        if (StringUtils.isNotBlank((String)connectionName) && (conn = ConnectionsDAO.get().getConnection((AuthCtx)DSSAuthCtx.newNone(), connectionName)) == null) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"Azure connection details are not available in Spark driver: do you need to authorize it?");
        }
        AzureBlobDatasetHandler dsh = (AzureBlobDatasetHandler)DatasetHandlerFactory.build((AuthCtx)authCtx, (Dataset)dataset);
        if (((AbstractFSDatasetHandler.AbstractFSConfig)dsh.getDataset().getParamsAs(AbstractFSDatasetHandler.AbstractFSConfig.class)).variablesExpansionLoopConfig.isEnabled()) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"Repeating dataset is enabled");
        }
        String rootPath = dsh.getFullyQualifiedRootPath();
        if (rootPath == null) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"Azure Blob Spark interface is disabled for dataset");
        }
        return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), null);
    }

    public Tuple2<Object, String> isGCSDatasetCompatible(Dataset dataset, AuthCtx authCtx, boolean forWrite) {
        DSSConnection conn;
        String connectionName = ((AbstractFSDatasetHandler.AbstractFSConfig)dataset.getParamsAs(BuiltinFSDatasets.GCSDatasetConfig.class)).connection;
        if (StringUtils.isNotBlank((String)connectionName) && (conn = ConnectionsDAO.get().getConnection((AuthCtx)DSSAuthCtx.newNone(), connectionName)) == null) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"GCS connection details are not available in Spark driver: do you need to authorize it?");
        }
        GCSDatasetHandler dsh = (GCSDatasetHandler)DatasetHandlerFactory.build((AuthCtx)authCtx, (Dataset)dataset);
        if (((AbstractFSDatasetHandler.AbstractFSConfig)dsh.getDataset().getParamsAs(AbstractFSDatasetHandler.AbstractFSConfig.class)).variablesExpansionLoopConfig.isEnabled()) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"Repeating dataset is enabled");
        }
        String rootPath = dsh.getFullyQualifiedRootPath();
        if (rootPath == null) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"Direct Spark GCS interface is disabled for dataset");
        }
        return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), null);
    }

    public Tuple2<Object, String> isSnowflakeDatasetCompatible(Dataset dataset) {
        AbstractSQLDatasetHandler.AbstractSQLConfig datasetParams = (AbstractSQLDatasetHandler.AbstractSQLConfig)dataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class);
        String connectionName = datasetParams.connection;
        if (StringUtils.isBlank((String)connectionName)) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"Connection name is blank");
        }
        if (!"table".equals(datasetParams.mode)) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"Native Spark-Snowflake integration is only supported for SQL datasets in 'table' mode");
        }
        if (datasetParams.variablesExpansionLoopConfig.isEnabled()) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"Repeating mode enabled on input");
        }
        DSSConnection conn = ConnectionsDAO.get().getConnection((AuthCtx)DSSAuthCtx.newNone(), connectionName);
        if (conn == null) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"Snowflake connection details are not available in Spark driver: do you need to authorize it?");
        }
        SnowflakeConnection.Params connectionParams = ((SnowflakeConnection)conn).params;
        if (!connectionParams.useSparkNativeIntegration) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"Native Spark-Snowflake integration is not enabled in Snowflake connection");
        }
        if (connectionParams.useURL) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"Native Spark-Snowflake integration is not supported when using a custom JDBC URL");
        }
        if (StringUtils.isNotBlank((String)connectionParams.driver)) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"Native Spark-Snowflake integration is not supported when using a custom JDBC driver");
        }
        return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), null);
    }

    public Tuple2<Object, String> isSnowflakeReadCompatible(Dataset dataset, String filterExpression, SamplingParam sampling) {
        Tuple2<Object, String> isDatasetCompatible = this.isSnowflakeDatasetCompatible(dataset);
        if (!isDatasetCompatible._1$mcZ$sp()) {
            return isDatasetCompatible;
        }
        if (filterExpression != null) {
            try {
                GrelToQueryTranslator translator = new GrelToQueryTranslator((GrelTranslator.GrelMapping)new GrelToQueryMapping((SQLDialect)new SnowflakeSQLDialect()));
                Expression expression = new Expression(filterExpression, dataset.getSchema());
                if (!translator.translateToQuery((Expression)expression, (boolean)true).isFullyTranslated) {
                    return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"Unable to fully translate filter expression to Snowflake SQL");
                }
            }
            catch (IllegalArgumentException ex) {
                this.logger().info((Object)"Exception while trying to translate filter expression to Snowflake SQL", (Throwable)ex);
                return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new StringBuilder(72).append("Exception while trying to translate filter expression to Snowflake SQL: ").append(ex.getMessage()).toString());
            }
        }
        if (!StdDataikuSparkContext$.MODULE$.isHDFSCompatible(sampling)) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"Requested sampling is not supported");
        }
        return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), null);
    }

    public boolean isReadDatasetAccessible(Dataset dataset) {
        String connectionName = ((AbstractFSDatasetHandler.AbstractFSConfig)dataset.getParamsAs(AbstractFSDatasetHandler.AbstractFSConfig.class)).connection;
        this.logger().info((Object)new StringBuilder(27).append("Check access to connection ").append(connectionName).toString());
        if (StringUtils.isNotBlank((String)connectionName)) {
            DSSConnection conn = ConnectionsDAO.get().getConnection((AuthCtx)DSSAuthCtx.newNone(), connectionName);
            if (conn == null) {
                this.logger().warn((Object)"Don't have connection details in Spark driver, can't use direct real dataset and maybe direct Spark access");
                return false;
            }
            return true;
        }
        return true;
    }

    public Tuple2<Object, String> isSQLDatasetCompatible(Dataset dataset, boolean readOrWrite) {
        AbstractSQLDatasetHandler.AbstractSQLConfig datasetConfig = (AbstractSQLDatasetHandler.AbstractSQLConfig)dataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class);
        String connectionName = datasetConfig.connection;
        if (StringUtils.isBlank((String)connectionName)) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"Connection name is blank");
        }
        DSSConnection conn = ConnectionsDAO.get().getConnection((AuthCtx)DSSAuthCtx.newNone(), connectionName);
        if (conn == null) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"SQL connection details are not available in Spark driver: do you need to authorize it?");
        }
        AbstractSQLConnection sqlConn = (AbstractSQLConnection)conn;
        InfoMessage.InfoMessages connCanHaveSparkIntegration = sqlConn.canHaveSparkIntegration();
        InfoMessage.Severity severity = connCanHaveSparkIntegration.maxSeverity;
        InfoMessage.Severity severity2 = InfoMessage.Severity.ERROR;
        if (!(severity != null ? !severity.equals(severity2) : severity2 != null)) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)StringUtils.defaultIfBlank((String)((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(connCanHaveSparkIntegration.messages).asScala()).map((Function1 & Serializable & scala.Serializable)m -> m.message, Set$.MODULE$.canBuildFrom())).mkString("; "), (String)"Can't be used directly from spark"));
        }
        InfoMessage.InfoMessages datasetCanHaveSparkIntegration = datasetConfig.canHaveSparkIntegration(Predef$.MODULE$.boolean2Boolean(readOrWrite));
        InfoMessage.Severity severity3 = datasetCanHaveSparkIntegration.maxSeverity;
        InfoMessage.Severity severity4 = InfoMessage.Severity.ERROR;
        if (!(severity3 != null ? !severity3.equals(severity4) : severity4 != null)) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)StringUtils.defaultIfBlank((String)((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(datasetCanHaveSparkIntegration.messages).asScala()).map((Function1 & Serializable & scala.Serializable)m -> m.message, Set$.MODULE$.canBuildFrom())).mkString("; "), (String)"Can't be used directly from spark"));
        }
        return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), null);
    }

    public Tuple2<Object, String> isSQLReadCompatible(Dataset dataset, String filterExpression, SamplingParam sampling) {
        Tuple2<Object, String> isDatasetCompatible = this.isSQLDatasetCompatible(dataset, true);
        if (!isDatasetCompatible._1$mcZ$sp()) {
            return isDatasetCompatible;
        }
        if (filterExpression != null) {
            try {
                String connectionName = ((AbstractSQLDatasetHandler.AbstractSQLConfig)dataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class)).connection;
                DSSConnection conn = ConnectionsDAO.get().getConnection((AuthCtx)DSSAuthCtx.newNone(), connectionName);
                SQLDialect dialect = ((AbstractSQLConnection)conn).getDialect();
                GrelToQueryTranslator translator = new GrelToQueryTranslator((GrelTranslator.GrelMapping)new GrelToQueryMapping(dialect));
                Expression expression = new Expression(filterExpression, dataset.getSchema());
                if (!translator.translateToQuery((Expression)expression, (boolean)true).isFullyTranslated) {
                    return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"Unable to fully translate filter expression to SQL");
                }
            }
            catch (IllegalArgumentException ex) {
                this.logger().info((Object)"Exception while trying to translate filter expression to SQL", (Throwable)ex);
                return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new StringBuilder(62).append("Exception while trying to translate filter expression to SQL: ").append(ex.getMessage()).toString());
            }
        }
        if (!StdDataikuSparkContext$.MODULE$.isHDFSCompatible(sampling)) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"Requested sampling is not supported");
        }
        return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), null);
    }

    public Tuple2<Object, String> isSQLWriteCompatible(Dataset dataset) {
        return this.isSQLDatasetCompatible(dataset, false);
    }

    private Logger logger() {
        return this.logger;
    }

    private StorageBackendsSupport$() {
        MODULE$ = this;
        this.logger = Logger.getLogger((String)"dku.spark.context");
    }
}

