/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import org.geotools.util.logging.Logging;

public final class WeakCollectionCleaner
extends Thread {
    public static final WeakCollectionCleaner DEFAULT = new WeakCollectionCleaner();
    ReferenceQueue<Object> referenceQueue = new ReferenceQueue();

    private WeakCollectionCleaner() {
        super("WeakCollectionCleaner");
        this.setPriority(8);
        this.setDaemon(true);
        this.start();
    }

    public synchronized ReferenceQueue<Object> getReferenceQueue() {
        return this.referenceQueue;
    }

    @Override
    public void run() {
        ReferenceQueue<Object> rq;
        while ((rq = this.getReferenceQueue()) != null) {
            try {
                Reference<Object> ref = rq.remove();
                if (ref == null) {
                    WeakCollectionCleaner.sleep(15000L);
                    break;
                }
                ref.clear();
            }
            catch (InterruptedException ref) {
            }
            catch (AssertionError | Exception exception) {
                Logging.unexpectedException(WeakCollectionCleaner.class, "remove", (Throwable)exception);
            }
        }
        Logging.getLogger(WeakCollectionCleaner.class).info("Weak collection cleaner stopped");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exit() {
        WeakCollectionCleaner weakCollectionCleaner = this;
        synchronized (weakCollectionCleaner) {
            this.referenceQueue = null;
        }
        this.interrupt();
        try {
            this.join(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

