/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util.factory;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.geotools.metadata.i18n.Errors;
import org.geotools.util.factory.FactoryNotFoundException;
import org.geotools.util.factory.FactoryRegistry;
import org.geotools.util.factory.FactoryRegistryException;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;

public class FactoryCreator
extends FactoryRegistry {
    private static final Class<?>[] HINTS_ARGUMENT = new Class[]{Hints.class};
    private final Map<Class<?>, List<Reference<?>>> cache = new HashMap();
    private final Set<Class<?>> underConstruction = new HashSet();

    public FactoryCreator(Class<?> category) {
        super(category);
    }

    public FactoryCreator(Class<?> ... categories) {
        super(categories);
    }

    public FactoryCreator(Collection<Class<?>> categories) {
        super(categories);
    }

    @Override
    final <T> List<Reference<T>> getCachedFactories(Class<T> category) {
        List<Reference<T>> c = this.cache.get(category);
        if (c == null) {
            c = new LinkedList();
            this.cache.put(category, c);
        }
        List<Reference<T>> cheat = c;
        return cheat;
    }

    private <T> void cache(Class<T> category, T factory) {
        this.getCachedFactories(category).add(new WeakReference<T>(factory));
    }

    @Override
    public <T> T getFactory(Class<T> category, Predicate<? super T> filter, Hints hints, Hints.Key key) throws FactoryRegistryException {
        try {
            return super.getFactory(category, filter, hints, key);
        }
        catch (FactoryNotFoundException exception) {
            Class[] types;
            FactoryNotFoundException notFound = exception;
            if (hints == null || key == null) {
                types = null;
            } else {
                Object hint = hints.get(key);
                if (hint == null) {
                    types = null;
                } else {
                    types = hint instanceof Class[] ? (Class[])hint : new Class[]{(Class)hint};
                    for (Class type : types) {
                        T candidate;
                        int modifiers;
                        if (type == null || !category.isAssignableFrom(type) || Modifier.isAbstract(modifiers = type.getModifiers()) || (candidate = this.createSafe(category, type, hints)) == null) continue;
                        if (this.isAcceptable(candidate, category, hints, filter)) {
                            this.cache(category, candidate);
                            return candidate;
                        }
                        FactoryCreator.dispose(candidate);
                    }
                }
            }
            Iterable unfilteredFactories = this.getUnfilteredFactories(category)::iterator;
            for (Object factory : unfilteredFactories) {
                T candidate;
                Class<?> implementation = factory.getClass();
                if (types != null && !FactoryCreator.isTypeOf(types, implementation) || filter != null && !filter.test(factory)) continue;
                try {
                    candidate = this.createSafe(category, implementation, hints);
                }
                catch (FactoryNotFoundException exception2) {
                    Logging.recoverableException(LOGGER, FactoryCreator.class, "getFactory", exception2);
                    continue;
                }
                catch (FactoryRegistryException exception3) {
                    if (exception3.getCause() instanceof NoSuchMethodException) continue;
                    throw exception3;
                }
                if (candidate == null) continue;
                if (this.isAcceptable(candidate, category, hints, filter)) {
                    this.cache(category, candidate);
                    return candidate;
                }
                FactoryCreator.dispose(candidate);
            }
            throw notFound;
        }
    }

    private static boolean isTypeOf(Class<?>[] types, Class<?> implementation) {
        for (Class<?> type : types) {
            if (!type.isAssignableFrom(implementation)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T createSafe(Class<T> category, Class<?> implementation, Hints hints) {
        if (!this.underConstruction.add(implementation)) {
            return null;
        }
        try {
            T t = this.createFactory(category, implementation, hints);
            return t;
        }
        finally {
            if (!this.underConstruction.remove(implementation)) {
                throw new AssertionError();
            }
        }
    }

    protected <T> T createFactory(Class<T> category, Class<?> implementation, Hints hints) throws FactoryRegistryException {
        Throwable cause;
        block7: {
            try {
                try {
                    return category.cast(implementation.getConstructor(HINTS_ARGUMENT).newInstance(hints));
                }
                catch (NoSuchMethodException exception2) {
                    cause = exception2;
                    try {
                        return category.cast(implementation.getConstructor(null).newInstance(null));
                    }
                    catch (NoSuchMethodException exception2) {
                    }
                }
            }
            catch (IllegalAccessException | InstantiationException exception) {
                cause = exception;
            }
            catch (InvocationTargetException exception) {
                cause = exception.getCause();
                if (!(cause instanceof FactoryRegistryException)) break block7;
                throw (FactoryRegistryException)cause;
            }
        }
        throw new FactoryRegistryException(Errors.format(23, implementation), cause);
    }

    private static void dispose(Object factory) {
    }
}

