/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.common.audit;

import com.dataiku.common.server.APIKeyBase;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.api.UpgradeRequest;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public class AuditContextBase {
    public static final String AUDIT_LOG_REF_API_KEY_IS_MANAGED = "authIsManagedKey";
    private static ThreadLocal<AuditContextData> tl = new ThreadLocal();

    public static AuditContextData getContextData() {
        return tl.get();
    }

    public static void setContextData(AuditContextData contextData) {
        tl.set(contextData);
    }

    public static void fillWithContext(JsonObject obj) {
        AuditContextData ctx = tl.get();
        if (ctx == null) {
            return;
        }
        if (ctx.clientIP != null) {
            obj.addProperty("clientIP", ctx.clientIP);
        }
        if (ctx.originalIP != null) {
            obj.addProperty("originalIP", ctx.originalIP);
        }
        if (ctx.xForwardedFor != null) {
            obj.addProperty("xForwardedFor", ctx.xForwardedFor);
        }
        AuditContextBase.fillAuthCtx(ctx.authCtx, obj);
        if (ctx.path != null) {
            obj.addProperty("callPath", ctx.path);
        }
        for (Map.Entry elt : ctx.custom.entrySet()) {
            obj.add((String)elt.getKey(), (JsonElement)elt.getValue());
        }
    }

    public static void fillAuthCtx(AuthCtx authCtx, JsonObject obj) {
        if (authCtx != null) {
            obj.addProperty("authUser", authCtx.getIdentifier());
            obj.addProperty("authSource", authCtx.getAuthSource().toString());
            APIKeyBase apiKey = authCtx.getApiKey();
            if (apiKey != null && apiKey.isManagedKey()) {
                obj.addProperty(AUDIT_LOG_REF_API_KEY_IS_MANAGED, Boolean.valueOf(true));
            }
            if (!authCtx.getVia().isEmpty()) {
                JsonArray arr = new JsonArray();
                for (String via : authCtx.getVia()) {
                    arr.add((JsonElement)new JsonPrimitive(via));
                }
                obj.add("authVia", (JsonElement)arr);
            }
        }
    }

    public static void reset() {
        tl.set(null);
    }

    public static void setIPInfo(HttpServletRequest request) {
        if (tl.get() == null) {
            tl.set(new AuditContextData());
        }
        AuditContextData ctx = tl.get();
        ctx.clientIP = request.getRemoteAddr();
        if (request.getHeader("x-dss-nginx-client-ip") != null) {
            ctx.clientIP = request.getHeader("x-dss-nginx-client-ip");
        }
        if (request.getHeader("X-Forwarded-For") != null) {
            String xff = request.getHeader("X-Forwarded-For");
            String[] chunks = StringUtils.split((String)xff, (String)",");
            ctx.originalIP = chunks[0].trim();
            ctx.xForwardedFor = xff;
        } else if (request.getHeader("X-Real-IP") != null) {
            ctx.originalIP = request.getHeader("X-Real-IP");
        }
    }

    public static void setIPInfo(UpgradeRequest request) {
        if (tl.get() == null) {
            tl.set(new AuditContextData());
        }
        AuditContextData ctx = tl.get();
        if (request.getHeader("x-dss-nginx-client-ip") != null) {
            ctx.clientIP = request.getHeader("x-dss-nginx-client-ip");
        }
        if (request.getHeader("X-Forwarded-For") != null) {
            String xff = request.getHeader("X-Forwarded-For");
            String[] chunks = StringUtils.split((String)xff, (String)",");
            ctx.originalIP = chunks[0].trim();
            ctx.xForwardedFor = xff;
        }
    }

    public static void setAuthContext(AuthCtx authCtx) {
        if (tl.get() == null) {
            tl.set(new AuditContextData());
        }
        AuditContextData ctx = tl.get();
        Validate.notNull((Object)authCtx);
        ctx.authCtx = authCtx;
    }

    public static AuthCtx getAuthContext() {
        if (tl.get() == null) {
            tl.set(new AuditContextData());
        }
        AuditContextData ctx = tl.get();
        return ctx.authCtx;
    }

    public static void setPath(String path) {
        if (tl.get() == null) {
            tl.set(new AuditContextData());
        }
        AuditContextBase.tl.get().path = path;
    }

    public static void addCustom(String key, String value) {
        if (tl.get() == null) {
            tl.set(new AuditContextData());
        }
        AuditContextBase.tl.get().custom.addProperty(key, value);
    }

    public static JsonObject getCustom(String key) {
        if (tl.get() == null) {
            tl.set(new AuditContextData());
        }
        return AuditContextBase.tl.get().custom;
    }

    public static class AuditContextData {
        public String path;
        public String clientIP;
        public String originalIP;
        public String xForwardedFor;
        public AuthCtx authCtx;
        public JsonObject custom = new JsonObject();
    }
}

