/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.common.server;

import com.dataiku.common.server.APIError;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.exceptions.NotAuthenticatedException;
import com.dataiku.dip.reports.IReflectedEventsService;
import com.dataiku.dip.security.MimeTypesSecurity;
import com.dataiku.dip.security.auth.NotLoggedInException;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.log4j.MDC;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.servlet.HandlerMapping;

public abstract class DKUControllerBase {
    private static Logger logger = Logger.getLogger((String)"dku.server.common");

    private static String buildMalformedRequestExceptionMessage(String name) {
        return String.format("Could not parse a %s from request body", name);
    }

    public void checkNotEmpty(String ... checked) throws MissingServletRequestParameterException {
        for (String value : checked) {
            if (value != null && value.length() != 0) continue;
            throw new MissingServletRequestParameterException("a param", "String");
        }
    }

    public static String extractPathFromRequest(HttpServletRequest req) {
        String fullPath = req.getServletPath();
        String bestMatchPattern = (String)req.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE);
        AntPathMatcher apm = new AntPathMatcher();
        return apm.extractPathWithinPattern(bestMatchPattern, fullPath);
    }

    protected <T> T getRequestBodyAs(HttpServletRequest req, Class<T> clazz) throws IOException {
        T t = this.getRequestBodyAsOrNull(req, clazz);
        if (t == null) {
            throw new MalformedRequestException(DKUControllerBase.buildMalformedRequestExceptionMessage(clazz.getSimpleName()));
        }
        return t;
    }

    protected <T> T getRequestBodyAs(HttpServletRequest req, TypeToken<T> clazz) {
        T t = this.getRequestBodyAsOrNull(req, clazz);
        if (t == null) {
            throw new MalformedRequestException(DKUControllerBase.buildMalformedRequestExceptionMessage(clazz.getType().getTypeName()));
        }
        return t;
    }

    protected <T> T getRequestBodyAsOrNull(HttpServletRequest req, Class<T> clazz) throws IOException {
        try {
            return (T)JSON.parse((InputStream)req.getInputStream(), clazz);
        }
        catch (Exception e) {
            throw new MalformedRequestException(DKUControllerBase.buildMalformedRequestExceptionMessage(clazz.getSimpleName()), e);
        }
    }

    protected <T> T getRequestBodyAsOrNull(HttpServletRequest req, TypeToken<T> clazz) {
        try {
            return (T)JSON.parse((InputStream)req.getInputStream(), clazz);
        }
        catch (Exception e) {
            throw new MalformedRequestException(DKUControllerBase.buildMalformedRequestExceptionMessage(clazz.getType().getTypeName()), e);
        }
    }

    protected static void resetResponseButKeepHeaders(HttpServletResponse resp) {
        HashMap<String, List> headers = new HashMap<String, List>();
        for (String string : resp.getHeaderNames()) {
            headers.computeIfAbsent(string, key -> new ArrayList()).addAll(resp.getHeaders(string));
        }
        resp.reset();
        for (Map.Entry entry : headers.entrySet()) {
            String headerKey = (String)entry.getKey();
            for (String headerValue : (List)entry.getValue()) {
                resp.addHeader(headerKey, headerValue);
            }
        }
    }

    public static void writeJSONString(HttpServletResponse resp, String json) throws IOException {
        DKUControllerBase.setBackendTimeHeader(resp);
        DKUControllerBase.setJsonContentType(resp);
        resp.getWriter().write(json);
    }

    private static void setBackendTimeHeader(HttpServletResponse resp) {
        Long startTime = (Long)MDC.get((String)"_apiCallStartTime");
        if (startTime != null) {
            resp.setHeader("DKU-Call-BackendTime", Long.toString(System.currentTimeMillis() - startTime));
        }
    }

    private static void setJsonContentType(HttpServletResponse resp) {
        resp.setContentType("application/json; charset=UTF-8");
    }

    public static void writeHTML(HttpServletResponse resp, String html) throws IOException {
        DKUControllerBase.setBackendTimeHeader(resp);
        resp.setContentType("text/html; charset=UTF-8");
        resp.getWriter().write(html);
    }

    public static void writeJSON(HttpServletResponse resp, Object o) throws IOException {
        DKUControllerBase.setBackendTimeHeader(resp);
        DKUControllerBase.setJsonContentType(resp);
        try {
            JSON.json((Object)o, (Writer)resp.getWriter());
        }
        catch (IllegalArgumentException e) {
            IReflectedEventsService.ReflectedEvent event = new IReflectedEventsService.ReflectedEvent(e.getMessage(), e);
            SpringUtils.getBean(IReflectedEventsService.class).publish(event);
            throw e;
        }
    }

    public static void writeJSONPretty(HttpServletResponse resp, Object o) throws IOException {
        String json = JSON.pretty((Object)o);
        DKUControllerBase.writeJSONString(resp, json);
    }

    public static void writeJSONNoNaN(HttpServletResponse resp, Object o) throws IOException {
        DKUControllerBase.setBackendTimeHeader(resp);
        DKUControllerBase.setJsonContentType(resp);
        JSON.jsonNoNaN((Object)o, (Writer)resp.getWriter());
    }

    public static void writeJSONWithNoNaNAndNull(HttpServletResponse resp, Object o) throws IOException {
        DKUControllerBase.setBackendTimeHeader(resp);
        DKUControllerBase.setJsonContentType(resp);
        JSON.jsonWithNoNaNAndNull((Object)o, (Writer)resp.getWriter());
    }

    public static void writeEmptyJSONObj(HttpServletResponse resp) throws IOException {
        DKUControllerBase.writeJSONString(resp, "{}");
    }

    protected static void writeJsonToOutputStream(HttpServletResponse resp, Object o) throws IOException {
        DKUControllerBase.setBackendTimeHeader(resp);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)resp.getOutputStream()));
        writer.write(new Gson().toJson(o));
        writer.flush();
    }

    protected void writeFileForDownload(HttpServletResponse resp, File file, String mimeType, String filename) throws IOException {
        this.writeFile(resp, file, mimeType, filename);
    }

    protected void writeFile(HttpServletResponse resp, File file, String mimeType) throws IOException {
        this.writeFile(resp, file, mimeType, null);
    }

    private void writeFile(HttpServletResponse resp, File file, String mimeType, String filename) throws IOException {
        if (!file.exists()) {
            logger.error((Object)("File does not exist: " + file.getAbsolutePath()));
            throw ErrorContext.iae((String)"File does not exist");
        }
        resp.setContentType(StringUtils.isNotBlank((String)mimeType) ? mimeType : "text/plain");
        if (StringUtils.isNotBlank((String)filename)) {
            resp.setHeader("Content-Disposition", "attachment; filename=\"" + filename + "\"");
        }
        DKUControllerBase.setBackendTimeHeader(resp);
        resp.setStatus(200);
        try (FileInputStream input = new FileInputStream(file);){
            BufferedOutputStream bos = new BufferedOutputStream((OutputStream)resp.getOutputStream());
            IOUtils.copy((InputStream)input, (OutputStream)bos);
            bos.flush();
        }
    }

    protected void writeStream(HttpServletResponse resp, InputStream is, String mimeType, String filename) throws IOException {
        resp.setContentType(mimeType);
        String contentDisposition = MimeTypesSecurity.isSafeForInlineContentDisposition(mimeType) ? "inline" : "attachment";
        resp.setHeader("Content-Disposition", contentDisposition + "; filename=\"" + filename + "\"");
        resp.setStatus(200);
        try (BufferedOutputStream bos = new BufferedOutputStream((OutputStream)resp.getOutputStream());){
            IOUtils.copy((InputStream)is, (OutputStream)bos);
            bos.flush();
        }
    }

    protected ResponseEntity<Resource> buildStreamedResponseEntity(File file, MediaType mimeType) throws IOException {
        InputStreamResource resource = new InputStreamResource((InputStream)new FileInputStream(file));
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentLength(file.length()).contentType(mimeType).header("X-Last-Modified", new String[]{Long.toString(file.lastModified())})).header("Content-Disposition", new String[]{"attachment; filename=\"" + file.getName() + "\""})).body((Object)resource);
    }

    public static void sendErrorFromThrowableWithStack(Throwable e, int httpCode, HttpServletResponse resp) throws IOException {
        APIError apiErr = new APIError(e, !DKUApp.hideErrorStacks(), !DKUApp.hideErrorStacks(), !DKUApp.hideLogTails());
        apiErr.unicizeStack();
        resp.setStatus(httpCode);
        resp.setContentType("application/json");
        DKUControllerBase.writeJsonToOutputStream(resp, apiErr);
    }

    public static void sendErrorFromThrowableNoStack(Throwable e, int httpCode, HttpServletResponse resp) throws IOException {
        APIError apiErr = new APIError(e, false, !DKUApp.hideErrorStacks(), !DKUApp.hideLogTails());
        resp.setStatus(httpCode);
        resp.setContentType("application/json");
        DKUControllerBase.writeJsonToOutputStream(resp, apiErr);
    }

    public static void sendErrorExplicit(int httpCode, String errorType, String message, HttpServletResponse resp) throws IOException {
        APIError apiErr = new APIError(errorType, message);
        resp.setStatus(httpCode);
        resp.setContentType("application/json");
        DKUControllerBase.writeJsonToOutputStream(resp, apiErr);
    }

    public static void send404(String message, HttpServletResponse resp) throws IOException {
        APIError apiErr = new APIError("NotFoundException", message);
        resp.setStatus(404);
        resp.setContentType("application/json");
        DKUControllerBase.writeJsonToOutputStream(resp, apiErr);
    }

    public static boolean exceptionStackIsWorthPrintingInLogs(Throwable t) {
        if (t instanceof NotAuthenticatedException || t instanceof NotLoggedInException) {
            return false;
        }
        String msg = t.getMessage();
        if (msg != null && msg.contains("Ticket not given or unrecognized")) {
            return false;
        }
        return !ExceptionUtils.hasCauseWithMessage((Throwable)t, (String)"Project does not exist");
    }

    public static class MalformedRequestException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public MalformedRequestException(String msg) {
            super(msg);
        }

        public MalformedRequestException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }
}

