/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dao;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.dao.UserLastActivity;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.utils.NativeCache;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class UsersActivityDAO {
    private static final RelFile dataFile = new RelFile(RelFile.global("run"), "user-last-activity.json");
    private final NativeCache.CachedReadWriteFS cache = NativeCache.build(DKUApp.getBaseFolderF());
    private static final Logger logger = Logger.getLogger((String)"dku.users.informative_last_activity.files");

    public UsersActivityDAO() throws IOException {
        this.cache.registerMetrics("dku.users.informative_last_activity.files.cache", DSSMetrics.registry());
    }

    public synchronized void updateUserLastSessionActivity(String userLogin) {
        try {
            UserLastActivityFile f = this.readSessionsFile(true);
            UserLastActivity userLastActivity = f.getOrDefault(userLogin, new UserLastActivity(userLogin));
            userLastActivity.lastSessionActivity = System.currentTimeMillis();
            f.put(userLogin, userLastActivity);
            this.cache.writeObject(dataFile, f);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to read user-last-activity.json file", (Throwable)e);
        }
    }

    public synchronized void updateUserLastLogin(String userLogin, Boolean success) {
        try {
            UserLastActivityFile f = this.readSessionsFile(true);
            UserLastActivity userLastActivity = f.getOrDefault(userLogin, new UserLastActivity(userLogin));
            if (success.booleanValue()) {
                userLastActivity.lastSuccessfulLogin = System.currentTimeMillis();
            } else {
                userLastActivity.lastFailedLogin = System.currentTimeMillis();
            }
            f.put(userLogin, userLastActivity);
            this.cache.writeObject(dataFile, f);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to read user-last-activity.json file", (Throwable)e);
        }
    }

    public UserLastActivity getUserLastActivity(String userLogin) throws IOException {
        UserLastActivityFile f = this.readSessionsFile(false);
        return f.getOrDefault(userLogin, new UserLastActivity(userLogin));
    }

    public Map<String, UserLastActivity> getAllUsersActivity(boolean recreateOnError) throws IOException {
        return this.readSessionsFile(recreateOnError);
    }

    private UserLastActivityFile readSessionsFile(boolean recreateOnError) throws IOException {
        if (this.cache.isFile(dataFile)) {
            try {
                UserLastActivityFile f = this.cache.readObjectUnsafe(dataFile, UserLastActivityFile.class);
                if (f != null) {
                    return f;
                }
                logger.warn((Object)"Found empty or incorrect user-last-activity.json file, will recreate");
            }
            catch (Exception e) {
                if (recreateOnError) {
                    logger.warn((Object)"Failed to read user-last-activity.json file, will recreate", (Throwable)e);
                }
                throw e;
            }
        }
        return new UserLastActivityFile();
    }

    public static class UserLastActivityFile
    extends HashMap<String, UserLastActivity> {
    }
}

