/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.io;

import com.dataiku.dip.io.PortRangeParams;
import com.dataiku.dip.io.SecretProtectedKernelLink;
import com.dataiku.dip.io.SingleCommandKernelLink;
import com.dataiku.dip.io.SocketBlockLinkInteraction;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang.StringUtils;

public class ResponderKernelLink
extends SecretProtectedKernelLink {
    public ResponderKernelLink(String secret, PortRangeParams portRange) throws IOException {
        super(secret, portRange);
    }

    public ResponderKernelLink(PortRangeParams portRange, SSLContext sslContext) throws IOException {
        super(SecretKeyGenerator.generate(16), portRange, sslContext);
    }

    public ResponderKernelLink(PortRangeParams portRange) throws IOException {
        this(portRange, null);
    }

    public ResponderKernelLink(String secret) throws IOException {
        super(secret);
    }

    public ResponderKernelLink() throws IOException {
        super(SecretKeyGenerator.generate(16));
    }

    public <TReq, TResp> TResp execute(TReq command, Class<? extends TResp> clazz) throws IOException {
        return this.executeAsync(command, clazz, null).call();
    }

    public <TReq, TResp> TResp execute(TReq command, TypeToken<? extends TResp> clazz) throws IOException {
        return this.executeAsync(command, clazz, null).call();
    }

    public <TReq> String executeString(TReq command) throws IOException {
        return this.executeStringAsync(command, null).call();
    }

    public <TReq, TResp> TResp execute(TReq command, Class<? extends TResp> clazz, String exceptionIfNullMessage) throws IOException {
        return this.executeAsync(command, clazz, exceptionIfNullMessage).call();
    }

    public <TReq, TResp> SingleCommandKernelLink.IOCallable<TResp> executeAsync(TReq command, Class<? extends TResp> clazz, String exceptionIfNullMessage) throws IOException {
        return this.executeAsync(command, clazz, null, false, exceptionIfNullMessage);
    }

    public <TReq, TResp> SingleCommandKernelLink.IOCallable<TResp> executeAsync(TReq command, TypeToken<? extends TResp> clazz, String exceptionIfNullMessage) throws IOException {
        return this.executeAsync(command, null, clazz, false, exceptionIfNullMessage);
    }

    public <TReq> SingleCommandKernelLink.IOCallable<String> executeStringAsync(TReq command, String exceptionIfNullMessage) throws IOException {
        return this.executeAsync(command, null, null, true, exceptionIfNullMessage);
    }

    private <TReq, TResp> SingleCommandKernelLink.IOCallable<TResp> executeAsync(TReq req, Class<? extends TResp> clazz, TypeToken<? extends TResp> typeToken, boolean isString, String exceptionIfNullMessage) throws IOException {
        SocketBlockLinkInteraction interaction = this.newInteraction();
        if (StringUtils.isNotBlank((String)exceptionIfNullMessage)) {
            interaction.withExceptionIfNullMessage(exceptionIfNullMessage);
        }
        if (req != null) {
            interaction.withRequest(req);
        }
        if (clazz != null) {
            interaction.expectsObject(clazz);
        } else if (typeToken != null) {
            interaction.expectsObject(typeToken);
        } else if (isString) {
            interaction.expectsString();
        }
        final SocketBlockLinkInteraction.AsyncResult execution = interaction.executeAsync();
        return new SingleCommandKernelLink.IOCallable<TResp>(){

            @Override
            public TResp call() throws IOException {
                return execution.get();
            }
        };
    }
}

