/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.io;

import com.dataiku.dip.exceptions.ExceptionWithForeignStackTrace;
import com.dataiku.dip.exceptions.ExceptionWithSerializedThrowable;
import com.dataiku.dip.exceptions.StackTraceElt;
import com.dataiku.dip.io.SocketBlockLinkException;
import com.dataiku.dip.io.SocketBlockLinkInteraction;
import com.dataiku.dip.kernels.IDSSKernelBase;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.dip.warnings.WarningsContext;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class SocketBlockLinkKernelException
extends SocketBlockLinkException
implements ExceptionWithSerializedThrowable,
ExceptionWithForeignStackTrace {
    private static final long serialVersionUID = 1L;
    public SocketBlockLinkInteraction.SocketBlockLinkKernelError error;
    public String title;
    private SmartLogTail logTail;

    public SocketBlockLinkKernelException(String title, SocketBlockLinkInteraction.SocketBlockLinkKernelError error) {
        super(StringUtils.defaultIfBlank((String)error.message, (String)""));
        this.title = title;
        this.error = error;
    }

    public WarningsContext.SerializedThrowable getSerializedThrowable() {
        return this.error == null ? null : this.error.getSerializedThrowable();
    }

    @Override
    public SmartLogTail getLogTail() {
        return this.logTail;
    }

    @Override
    public SocketBlockLinkKernelException withLogTail(SmartLogTail logTail) {
        this.logTail = logTail;
        return this;
    }

    @Override
    public SocketBlockLinkKernelException withLogTail(IDSSKernelBase kernel) {
        kernel.waitForShutdownNoException(500L);
        this.logTail = kernel.getLogTail();
        return this;
    }

    public List<StackTraceElt> getForeignStackTrace() {
        return this.error == null ? new ArrayList() : this.error.getStackTraceElts();
    }

    public SmartLogTail getLogTailWithStackTrace() {
        SmartLogTail fullLogTail;
        List<StackTraceElt> foreignStackTrace = this.getForeignStackTrace();
        SmartLogTail smartLogTail = fullLogTail = this.logTail == null ? new SmartLogTail() : (SmartLogTail)JSON.deepCopy((Object)this.logTail);
        if (!foreignStackTrace.isEmpty()) {
            fullLogTail.lines.add("");
            for (StackTraceElt elt : foreignStackTrace) {
                fullLogTail.lines.add(elt.getForeignRepr());
            }
        }
        return fullLogTail;
    }
}

