/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.auth;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.util.ServletUtils;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.api.UpgradeRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;

public abstract class UIAuthServiceBase {
    public static final String ACCESS_TOKEN_COOKIE_PREFIX = "dss_access_token_";
    public static final String SAAS_ACCESS_TOKEN_COOKIE = "dss_saas_access_token";
    public static final String XSRF_TOKEN_HEADER = "X-XSRF-TOKEN";
    public static final String XSRF_TOKEN_COOKIE_PREFIX = "dss_xsrf_token_";

    public static String getAccessCookieName() {
        return ACCESS_TOKEN_COOKIE_PREFIX + DigestUtils.md5Hex((String)DKUApp.dipInstanceId());
    }

    public static String getXSRFCookieName() {
        return XSRF_TOKEN_COOKIE_PREFIX + DigestUtils.md5Hex((String)DKUApp.dipInstanceId());
    }

    protected static String computeXSRFToken(String accessToken, String xsrfTokenSalt) {
        return DigestUtils.sha256Hex((String)(xsrfTokenSalt + ":" + accessToken));
    }

    protected static void checkXSRF(String accessToken, String xsrfTokenSalt, String xsrfHeaderValue) {
        String expectedXSRFToken;
        if (System.getenv("DKU_NO_XSRF") == null && !(expectedXSRFToken = UIAuthServiceBase.computeXSRFToken(accessToken, xsrfTokenSalt)).equals(xsrfHeaderValue)) {
            throw new SecurityException("XSRF validation failed, please refresh the page.");
        }
    }

    protected abstract AuthCtx getUserInternal(Map<String, String> var1, String var2, String var3, boolean var4) throws IOException;

    public AuthCtx getUser(HttpServletRequest req) throws IOException {
        Map<String, String> cookies = ServletUtils.parseCookies(req);
        String apiKeyHeader = req.getHeader("X-DKU-APIKey");
        String xsrfTokenHeader = req.getHeader(XSRF_TOKEN_HEADER);
        return this.getUserInternal(cookies, apiKeyHeader, xsrfTokenHeader, true);
    }

    public AuthCtx getUserNoXSRF(HttpServletRequest req) throws IOException {
        Map<String, String> cookies = ServletUtils.parseCookies(req);
        String apiKeyHeader = req.getHeader("X-DKU-APIKey");
        return this.getUserInternal(cookies, apiKeyHeader, null, false);
    }

    public AuthCtx getMandatoryUser(UpgradeRequest req) throws IOException {
        Map<String, String> cookies = ServletUtils.parseCookies(req);
        boolean checkXSRF = true;
        String xsrfToken = null;
        block0 : switch (WebSocketXsrfStrategy.valueOf(DKUApp.getProperty("dku.security.websocket.xsrfStrategy", WebSocketXsrfStrategy.SUBPROTOCOL.name()))) {
            case NONE: {
                checkXSRF = false;
                break;
            }
            case SUBPROTOCOL: {
                if (req.getSubProtocols() == null) break;
                for (String protocol : req.getSubProtocols()) {
                    if (protocol == null || !protocol.startsWith("xsrf-")) continue;
                    xsrfToken = protocol.substring(5);
                    break block0;
                }
                break;
            }
        }
        AuthCtx u = this.getUserInternal(cookies, null, xsrfToken, checkXSRF);
        if (u == null) {
            throw new NotLoggedInException("Not logged-in");
        }
        return u;
    }

    public AuthCtx getMandatoryUser(HttpServletRequest req) throws IOException {
        AuthCtx u = this.getUser(req);
        if (u == null) {
            throw new NotLoggedInException("Not logged-in");
        }
        return u;
    }

    public <T extends AuthCtx> T getMandatoryUserAs(HttpServletRequest req, Class<T> ofClazz) throws IOException {
        AuthCtx u = this.getUser(req);
        if (u == null) {
            throw new NotLoggedInException("Not logged-in");
        }
        return (T)((AuthCtx)ofClazz.cast(u));
    }

    public <T extends AuthCtx> T getMandatoryUserNoXSRF(HttpServletRequest req, Class<T> ofClazz) throws IOException {
        AuthCtx u = this.getUserNoXSRF(req);
        if (u == null) {
            throw new NotLoggedInException("Not logged-in");
        }
        return (T)((AuthCtx)ofClazz.cast(u));
    }

    public AuthCtx getMandatoryUserNoXSRF(HttpServletRequest req) throws IOException {
        AuthCtx u = this.getUserNoXSRF(req);
        if (u == null) {
            throw new NotLoggedInException("Not logged-in");
        }
        return u;
    }

    public abstract void setXSRFCookie(HttpServletRequest var1, HttpServletResponse var2) throws IOException;

    public static enum WebSocketXsrfStrategy {
        NONE,
        SUBPROTOCOL;

    }

    public static class NotLoggedInException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public NotLoggedInException(String string) {
            super(string);
        }
    }
}

