/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.transactions.fs;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.transactions.fs.FSyncUtils;
import com.dataiku.dip.transactions.fs.FileContentFactory;
import com.dataiku.dip.transactions.fs.Journal;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import com.google.common.hash.Hashing;
import java.io.Closeable;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import org.apache.commons.lang.StringUtils;

public class AtomicWriter
implements Closeable {
    private final FSyncUtils fsyncUtils;
    private boolean rejectSymlinks;
    private File root;
    public static final String TEMP_DIRNAME = ".ts";
    public static final String JOURNAL_FILENAME = ".journal";
    private File tempDirectory;
    private File journalFile;
    private FailureInjector failureInjector = new NiceInjector();
    private volatile boolean inconsistentState;
    private static final DKULogger logger = DKULogger.getLogger((String)"dip.transactions");

    public synchronized void checkState() throws IOError {
        if (this.inconsistentState) {
            throw new IOError(new IOException("Inconsistent and non-recoverable state"));
        }
    }

    private synchronized void enterBrokenStateAndThrow(Throwable t) throws IOError {
        this.inconsistentState = true;
        throw new IOError(t);
    }

    @VisibleForTesting
    public AtomicWriter(File root, int nThreads, boolean enableCRC32Check) throws IOException {
        this.fsyncUtils = new FSyncUtils(nThreads, enableCRC32Check, true);
        this.init(root);
    }

    public AtomicWriter(File root, FailureInjector injector, int nThreads, boolean enableCRC32Check) throws IOException {
        this(root, injector, DKUApp.getParams().getBoolParam("dku.core.fs.checkSymlinksAtWriteTime", false), nThreads, enableCRC32Check);
    }

    public AtomicWriter(File root, FailureInjector injector, boolean rejectSymlinks, int nThreads, boolean enableCRC32Check) throws IOException {
        this.fsyncUtils = new FSyncUtils(nThreads, enableCRC32Check, DKUApp.getParams().getBoolParam("dku.core.fs.fsyncEnabled", true));
        this.failureInjector = injector;
        this.rejectSymlinks = rejectSymlinks;
        this.init(root);
    }

    @VisibleForTesting
    void init(File root) throws IOException {
        this.root = root;
        this.tempDirectory = new File(root, TEMP_DIRNAME);
        this.journalFile = new File(root, JOURNAL_FILENAME);
        Journal journal = this.readJournalFile();
        if (journal != null) {
            this.execJournal(journal, false);
        }
        if (this.journalFile.exists()) {
            this.journalFile.delete();
        }
        this.cleanupTempDirectory();
    }

    private synchronized void cleanupTempDirectory() throws IOException {
        this.checkState();
        if (!this.tempDirectory.exists()) {
            DKUFileUtils.mkdirs((File)this.tempDirectory);
        } else {
            File[] tempDirectoryFiles = this.tempDirectory.listFiles();
            if (tempDirectoryFiles != null) {
                for (File file : tempDirectoryFiles) {
                    if (file.isFile()) {
                        if (file.delete()) continue;
                        throw new IOException("Unable to delete " + file.getAbsolutePath());
                    }
                    throw new IOException("Unexpected directory " + file.getAbsolutePath());
                }
            }
        }
    }

    private Journal readJournalFile() throws IOException {
        if (!this.journalFile.isFile()) {
            return null;
        }
        String content = DKUFileUtils.readFileToStringUTF8((File)this.journalFile);
        if (StringUtils.isBlank((String)content)) {
            return null;
        }
        Journal journal = null;
        try {
            journal = (Journal)JSON.parse((String)content, Journal.class);
        }
        catch (Exception e) {
            logger.info((Object)"Unable to read the journal file. It may be corrupted.", (Throwable)e);
        }
        return journal;
    }

    private void ensureNoSymlinks(RelFile rf) throws IOException {
        if (!this.rejectSymlinks) {
            return;
        }
        for (RelFile parentRf : rf.walk()) {
            BasicFileAttributes attrs;
            Path parentPath;
            block4: {
                parentPath = parentRf.resolve(this.root).toPath();
                attrs = null;
                try {
                    attrs = Files.readAttributes(parentPath, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
                }
                catch (IOException e) {
                    if (!logger.isTraceEnabled()) break block4;
                    logger.trace((Object)("Error reading attributes of " + String.valueOf(parentPath) + ": " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
                }
            }
            if (attrs == null || !attrs.isSymbolicLink()) continue;
            throw new IOException("Rejected symlink: " + String.valueOf(parentPath));
        }
    }

    private synchronized void execJournal(Journal journal, boolean canEnterBrokenState) throws IOError, IOException {
        logger.info((Object)"Executing journal");
        Stopwatch sw = Stopwatch.createStarted();
        this.checkState();
        try {
            for (RelFile relFile : journal.deletedFiles) {
                this.failureInjector.shouldFailPhase2(relFile, 0);
                File resolved = relFile.resolve(this.root);
                if (resolved.isFile()) {
                    boolean ret = resolved.delete();
                    if (!ret) {
                        logger.info((Object)("Unable to delete " + resolved.getAbsolutePath() + ", but it's likely to be normal. "));
                    }
                    if (!resolved.isFile()) continue;
                    throw new IOException("The file " + relFile.resolve(this.root).getAbsolutePath() + " cannot be deleted");
                }
                logger.info((Object)("The file (and NOT the hypothetical directory!) " + resolved.getAbsolutePath() + ", doesn't need to be deleted because it doesn't exist anyway"));
            }
            for (RelFile relFile : journal.deletedDirectories) {
                this.failureInjector.shouldFailPhase2(relFile, 1);
                File resolved2 = relFile.resolve(this.root);
                if (resolved2.isDirectory()) {
                    try {
                        DKUFileUtils.deleteDirectory((File)resolved2);
                    }
                    catch (IOException ret) {
                        // empty catch block
                    }
                }
                if (!resolved2.isDirectory()) continue;
                throw new IOException("The directory " + relFile.resolve(this.root).getAbsolutePath() + " cannot be deleted");
            }
            for (RelFile relFile : journal.createdDirectories) {
                this.failureInjector.shouldFailPhase2(relFile, 2);
                try {
                    DKUFileUtils.mkdirs((File)relFile.resolve(this.root));
                }
                catch (IOException resolved2) {
                    // empty catch block
                }
                if (relFile.resolve(this.root).isDirectory()) continue;
                throw new IOException("The directory " + relFile.resolve(this.root).getAbsolutePath() + " cannot be created");
            }
            for (Journal.WrittenFile writtenFile : journal.getWrittenFiles()) {
                File resolvedFile = writtenFile.file.resolve(this.root);
                File tempFile = this.getTempFile(writtenFile);
                this.failureInjector.shouldFailPhase2(writtenFile.file, 3);
                if (tempFile.isFile()) {
                    if (resolvedFile.exists() && !resolvedFile.isFile()) {
                        throw new IOException(resolvedFile.getAbsolutePath() + " is not a file and shouldn't exist at this point?!");
                    }
                    Files.move(tempFile.toPath(), resolvedFile.toPath(), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
                } else {
                    logger.warn((Object)("The file " + tempFile.getAbsolutePath() + " doesn't exist. If you are recovering from a failure, it may be normal. Otherwise, this is likely to be a critical issue."));
                }
                if (!resolvedFile.isFile()) {
                    throw new IOException("The file (and NOT the directory) " + resolvedFile.getAbsolutePath() + " is missing and it's content has been lost (" + tempFile.getAbsolutePath() + " doesn't exist anymore!). This is not recoverable.");
                }
                String md5 = com.google.common.io.Files.asByteSource((File)resolvedFile).hash(Hashing.md5()).toString();
                if (md5.equals(writtenFile.md5)) continue;
                logger.error((Object)("The expected md5 of " + resolvedFile.getAbsolutePath() + " is " + md5 + " and was expected to be " + writtenFile.md5 + " (stored in the journal)"));
                throw new IOException("The file " + resolvedFile.getAbsolutePath() + " is corrupted");
            }
            this.journalFile.delete();
            if (this.journalFile.isFile()) {
                throw new IOException("Unable to delete the journal file " + this.journalFile.getAbsolutePath());
            }
        }
        catch (IOException e) {
            if (canEnterBrokenState) {
                this.enterBrokenStateAndThrow(e);
            }
            logger.fatal((Object)"Unable to execute the journal, recent changes may have been lost", (Throwable)e);
            this.journalFile.delete();
        }
        this.cleanupTempDirectory();
        logger.info((Object)("Journal executed in " + DKUtils.getElapsed((Stopwatch)sw.stop())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void executeAtomically(Journal journal) throws IOException, IOError {
        Stopwatch sw = Stopwatch.createStarted();
        logger.info((Object)"Writing journal");
        this.checkState();
        if (this.journalFile.exists()) {
            this.enterBrokenStateAndThrow(new IOException("the previous transaction hasn't been properly aborted/committed properly"));
        }
        this.cleanupTempDirectory();
        if (!journal.isEmpty()) {
            for (RelFile relFile : journal.deletedDirectories) {
                this.ensureNoSymlinks(relFile);
            }
            for (RelFile relFile : journal.deletedFiles) {
                this.ensureNoSymlinks(relFile);
            }
            for (RelFile relFile : journal.createdDirectories) {
                this.ensureNoSymlinks(relFile);
            }
            for (Journal.WrittenFile writtenFile : journal.getWrittenFiles()) {
                this.ensureNoSymlinks(writtenFile.file);
            }
            try {
                try {
                    for (Journal.WrittenFile writtenFile : journal.getWrittenFiles()) {
                        this.failureInjector.shouldFailPhase1(writtenFile.file);
                        this.fsyncUtils.writeAndSync(this.getTempFile(writtenFile), writtenFile.content::getAsNewStream);
                    }
                }
                finally {
                    this.fsyncUtils.flush();
                }
                try {
                    this.fsyncUtils.writeAndSync(this.journalFile, () -> FileContentFactory.DEFAULT.fromObject(journal).getAsNewStream());
                }
                finally {
                    this.fsyncUtils.flush();
                }
                this.failureInjector.shouldFailAfterWritingJournal();
            }
            catch (IOException e) {
                try {
                    this.journalFile.delete();
                    this.cleanupTempDirectory();
                }
                finally {
                    throw e;
                }
            }
            logger.info((Object)("Journal written in " + DKUtils.getElapsed((Stopwatch)sw.stop())));
            this.execJournal(journal, true);
        }
    }

    private synchronized File getTempFile(Journal.WrittenFile file) {
        this.checkState();
        String tmpPath = file.getTmpPath();
        if (tmpPath == null) {
            tmpPath = file.file.getFullPath().replace("-", "-~").replace("/", "--");
        }
        return new File(this.tempDirectory, tmpPath);
    }

    @Override
    public void close() {
        this.fsyncUtils.close();
    }

    public static class NiceInjector
    implements FailureInjector {
        @Override
        public void shouldFailPhase1(RelFile rf) {
        }

        @Override
        public void shouldFailPhase2(RelFile rf, int step) {
        }

        @Override
        public void shouldFailAfterWritingJournal() {
        }
    }

    public static interface FailureInjector {
        public void shouldFailPhase1(RelFile var1) throws IOException;

        public void shouldFailPhase2(RelFile var1, int var2) throws IOException;

        public void shouldFailAfterWritingJournal() throws IOException;
    }
}

