/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.transactions.git.jgit;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.git.BaseDiffBuilder;
import com.dataiku.dip.git.JGitLogBuilder;
import com.dataiku.dip.git.ObjectSpecificDiffBuilder;
import com.dataiku.dip.transactions.git.GitCodes;
import com.dataiku.dip.transactions.git.GitModel;
import com.dataiku.dip.transactions.git.jgit.JGitManager;
import com.dataiku.dip.transactions.git.jgit.JGitWrapper;
import com.dataiku.dip.utils.AutoCloseableLock;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NamedLock;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.DeleteBranchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.RemoteListCommand;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.TagCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.BranchTrackingStatus;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.merge.MergeResult;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.merge.ResolveMerger;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.RevWalkUtils;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public class GitLocalCommands
extends JGitWrapper {
    public GitLocalCommands(Git git) {
        super(git);
    }

    public void disableSymlinksIfNeeded() throws IOException {
        StoredConfig config;
        if (DKUApp.getParams().getBoolParam("dku.core.fs.disableSymlinksInGit", true) && (config = this.git.getRepository().getConfig()).getBoolean("core", null, "symlinks", true)) {
            config.setBoolean("core", null, "symlinks", false);
            config.save();
        }
    }

    public void disableHooksIfNeeded() throws IOException {
        StoredConfig config;
        if (DKUApp.getParams().getBoolParam("dku.core.fs.disableGitHooks", true) && !"/dev/null".equals((config = this.git.getRepository().getConfig()).getString("core", null, "hooksPath"))) {
            config.setString("core", null, "hooksPath", "/dev/null");
            config.save();
        }
    }

    public GitModel.FileChange getStringDiff(String base, String target) throws IOException {
        return new BaseDiffBuilder(this.git).diffStrings(base, target);
    }

    public GitModel.SingleCommitObjectDiff singleCommitDiff(String commitId) throws IOException, GitAPIException {
        GitModel.SingleCommitObjectDiff ret = new GitModel.SingleCommitObjectDiff();
        ObjectId commit = this.git.getRepository().resolve(commitId);
        try (RevWalk revWalk = new RevWalk(this.git.getRepository());){
            RevCommit revCommit = revWalk.parseCommit((AnyObjectId)commit);
            ret.commit = GitModel.DKULogEntry.fromCommit(revCommit, this.getTagsByCommitId());
            BaseDiffBuilder diffBuilder = new BaseDiffBuilder(this.git);
            ret.diffEntries = diffBuilder.diffSingleCommit(null, revCommit);
            ret.computeStats();
        }
        return ret;
    }

    public GitModel.DKULog getLog(List<String> paths, String since, int count) throws IOException, GitAPIException {
        GitModel.DKULog log = new GitModel.DKULog();
        logger.info((Object)("Get git log for paths " + String.valueOf(paths)));
        ObjectId sinceCommit = StringUtils.isNotBlank((String)since) ? this.git.getRepository().resolve(since) : null;
        JGitLogBuilder le = new JGitLogBuilder(this.git, this.getTagsByCommitId());
        log.logEntries = le.build(sinceCommit, count + 1, paths);
        if (!log.logEntries.isEmpty() && log.logEntries.size() == count + 1) {
            log.nextCommit = log.logEntries.get((int)count).commitId;
            log.logEntries.remove(count);
        }
        return log;
    }

    public GitModel.DKULog getLog(String path, String from, String to) throws IOException, GitAPIException {
        ObjectId toCommit;
        GitModel.DKULog log = new GitModel.DKULog();
        logger.info((Object)("Get git log for path " + path));
        ObjectId fromCommit = StringUtils.isNotBlank((String)from) ? this.git.getRepository().resolve(from) : null;
        ObjectId objectId = toCommit = StringUtils.isNotBlank((String)to) ? this.git.getRepository().resolve(to) : null;
        if (fromCommit == null) {
            throw new RefNotFoundException("Could not resolved commit from '" + from + "'");
        }
        if (toCommit == null) {
            throw new RefNotFoundException("Could not resolved commit to '" + to + "'");
        }
        JGitLogBuilder le = new JGitLogBuilder(this.git, this.getTagsByCommitId());
        log.logEntries = le.build(fromCommit, toCommit, path);
        return log;
    }

    public GitModel.DKULog getLogSince(List<String> paths, String reference, String since, int count) throws IOException, GitAPIException {
        GitModel.DKULog log = new GitModel.DKULog();
        logger.info((Object)("Get git log since " + since));
        ObjectId referenceCommit = null;
        if (StringUtils.isNotBlank((String)reference) && (referenceCommit = this.git.getRepository().resolve(reference)) == null) {
            return log;
        }
        ObjectId sinceCommit = null;
        if (StringUtils.isNotBlank((String)since) && (sinceCommit = this.git.getRepository().resolve(since)) == null) {
            return log;
        }
        JGitLogBuilder logBuilder = new JGitLogBuilder(this.git, this.getTagsByCommitId());
        log.logEntries = logBuilder.buildSince(referenceCommit, sinceCommit, count + 1, paths);
        if (!log.logEntries.isEmpty() && log.logEntries.size() == count + 1) {
            log.nextCommit = log.logEntries.get((int)count).commitId;
            log.logEntries.remove(count);
        }
        return log;
    }

    public GitModel.DKULog getLogUntil(List<String> paths, String reference, String until, int count) throws IOException, GitAPIException {
        GitModel.DKULog log = new GitModel.DKULog();
        logger.info((Object)("Get git log until " + until));
        ObjectId referenceCommit = null;
        if (StringUtils.isNotBlank((String)reference) && (referenceCommit = this.git.getRepository().resolve(reference)) == null) {
            return log;
        }
        ObjectId untilCommit = null;
        if (StringUtils.isNotBlank((String)until) && (untilCommit = this.git.getRepository().resolve(until)) == null) {
            return log;
        }
        JGitLogBuilder logBuilder = new JGitLogBuilder(this.git, this.getTagsByCommitId());
        JGitLogBuilder.LogsUntil logsUntil = logBuilder.buildUntil(referenceCommit, untilCommit, count, paths);
        log.logEntries = logsUntil.logEntries;
        log.countUntil = logsUntil.countUntil;
        return log;
    }

    public GitModel.MultiCommitDiff diff(String to, TreeFilter tf, boolean nameOnly) throws IOException, GitAPIException {
        GitModel.MultiCommitDiff diff = new GitModel.MultiCommitDiff();
        ObjectId toCommit = this.git.getRepository().resolve(to);
        ObjectId toTree = this.git.getRepository().resolve(to + "^{tree}");
        try (RevWalk revWalk = new RevWalk(this.git.getRepository());){
            Map<String, Set<GitModel.GitTag>> tagsByCommitId = this.getTagsByCommitId();
            diff.commitTo = GitModel.DKULogEntry.fromCommit(revWalk.parseCommit((AnyObjectId)toCommit), tagsByCommitId);
            logger.infoV("Getting `git diff %s` toCommit=%s toTree=%s", new Object[]{to, toCommit, toTree});
            ObjectSpecificDiffBuilder diffBuilder = new ObjectSpecificDiffBuilder(this.git);
            diff.diffEntries = diffBuilder.diffObjectTrees(tf, toTree, nameOnly);
            diff.computeStats();
        }
        return diff;
    }

    public GitModel.MultiCommitDiff diff(String from, String to, TreeFilter tf, boolean nameOnly) throws IOException, GitAPIException {
        GitModel.MultiCommitDiff diff = new GitModel.MultiCommitDiff();
        ObjectId fromCommit = this.git.getRepository().resolve(from);
        ObjectId toCommit = this.git.getRepository().resolve(to);
        ObjectId fromTree = this.git.getRepository().resolve(from + "^{tree}");
        ObjectId toTree = this.git.getRepository().resolve(to + "^{tree}");
        try (RevWalk revWalk = new RevWalk(this.git.getRepository());){
            Map<String, Set<GitModel.GitTag>> tagsByCommitId = this.getTagsByCommitId();
            diff.commitFrom = GitModel.DKULogEntry.fromCommit(revWalk.parseCommit((AnyObjectId)fromCommit), tagsByCommitId);
            diff.commitTo = GitModel.DKULogEntry.fromCommit(revWalk.parseCommit((AnyObjectId)toCommit), tagsByCommitId);
            logger.infoV("Getting diff (%s..%s) fromCommit=%s toCommit=%s fromTree=%s toTree=%s", new Object[]{from, to, fromCommit, toCommit, fromTree, toTree});
            ObjectSpecificDiffBuilder diffBuilder = new ObjectSpecificDiffBuilder(this.git);
            diff.diffEntries = diffBuilder.diffObjectTrees(tf, fromTree, toTree, nameOnly);
            diff.computeStats();
        }
        return diff;
    }

    public String mergeBase(String from, String to) throws IOException, GitAPIException {
        try (RevWalk revWalk = new RevWalk(this.git.getRepository());){
            RevCommit commitA = revWalk.parseCommit((AnyObjectId)this.git.getRepository().resolve(from));
            RevCommit commitB = revWalk.parseCommit((AnyObjectId)this.git.getRepository().resolve(to));
            revWalk.setRevFilter(RevFilter.MERGE_BASE);
            revWalk.markStart(commitA);
            revWalk.markStart(commitB);
            Map<String, Set<GitModel.GitTag>> tagsByCommitId = this.getTagsByCommitId();
            RevCommit commit = revWalk.next();
            if (commit == null) {
                String string = null;
                return string;
            }
            String string = GitModel.DKULogEntry.fromCommit((RevCommit)commit, tagsByCommitId).commitId;
            return string;
        }
    }

    public GitModel.MultiCommitDiff workingCopyDiff(TreeFilter tf) throws IOException {
        GitModel.MultiCommitDiff diff = new GitModel.MultiCommitDiff();
        ObjectSpecificDiffBuilder diffBuilder = new ObjectSpecificDiffBuilder(this.git);
        diff.diffEntries = diffBuilder.diffWorkingCopy(tf);
        diff.computeStats();
        return diff;
    }

    public void checkout(String hash, List<String> paths) throws GitAPIException {
        CheckoutCommand command = this.git.checkout();
        command.setStartPoint(hash);
        for (String path : paths) {
            command.addPath(path);
        }
        command.call();
    }

    public String getHashOf(String ref) throws IOException {
        return this.git.getRepository().findRef(ref).getObjectId().getName();
    }

    public String getCommitHashFromRef(String ref) throws IOException {
        try (RevWalk walk = new RevWalk(this.git.getRepository());){
            RevCommit commit = walk.parseCommit((AnyObjectId)this.git.getRepository().findRef(ref).getObjectId());
            String string = commit.getName();
            return string;
        }
    }

    public InfoMessage.InfoMessages revertSingleCommit(GitModel.GitAuthor author, String hash) throws IOException, InterruptedException {
        InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
        try (RevWalk revWalk = new RevWalk(this.git.getRepository());){
            RevCommit revCommit = revWalk.parseCommit((AnyObjectId)this.git.getRepository().resolve(hash));
            RevCommit parentCommit = revCommit.getParent(0);
            revWalk.parseHeaders((RevObject)parentCommit);
            RevCommit headCommit = revWalk.parseCommit((AnyObjectId)this.git.getRepository().resolve("HEAD"));
            logger.info((Object)("Evaluating merge of " + String.valueOf(revCommit) + " into " + String.valueOf(headCommit)));
            ResolveMerger merger = (ResolveMerger)MergeStrategy.RESOLVE.newMerger(this.git.getRepository(), true);
            merger.setWorkingTreeIterator((WorkingTreeIterator)new FileTreeIterator(this.git.getRepository()));
            merger.setBase((AnyObjectId)revCommit.getTree());
            if (!merger.merge(new AnyObjectId[]{headCommit, parentCommit})) {
                if (merger.failed()) {
                    throw new IllegalStateException("Should not happen with in-core mergers");
                }
                for (Map.Entry e : merger.getMergeResults().entrySet()) {
                    if (!((MergeResult)e.getValue()).containsConflicts()) continue;
                    ret.withFatal((InfoMessage.MessageCode)GitCodes.ERR_GIT_REVERT_FAILED_CONFLICT, "Conflict in " + (String)e.getKey());
                }
            }
        }
        logger.info((Object)("Revert check result: " + JSON.json((Object)ret)));
        logger.info((Object)"Verify if the commit is a merge commit");
        if (this.isMergeCommit(hash)) {
            ret.withFatal((InfoMessage.MessageCode)GitCodes.ERR_GIT_REVERT_FAILED_MERGE_COMMIT, "Commit '" + hash + "' is a merge commit");
        }
        if (!ret.anyFatal()) {
            try {
                this.executeGitCommand(author, "revert", "--no-commit", "--strategy=resolve", hash);
            }
            catch (Throwable e) {
                logger.error((Object)("Single commit revert failed, aborting:" + ExceptionUtils.getMessageWithCauses((Throwable)e)));
                this.executeGitCommand(author, "revert", "--abort");
                ret.withFatal((InfoMessage.MessageCode)GitCodes.ERR_GIT_REVERT_FAILED_CONFLICT, ExceptionUtils.getMessageWithCauses((Throwable)e));
            }
        }
        return ret;
    }

    public boolean isMergeCommit(String commitHash) throws IOException {
        try (RevWalk revWalk = new RevWalk(this.git.getRepository());){
            ObjectId commitId = this.git.getRepository().resolve(commitHash);
            if (commitId == null) {
                throw new IllegalArgumentException("Commit " + commitHash + " not found");
            }
            RevCommit commit = revWalk.parseCommit((AnyObjectId)commitId);
            boolean bl = commit.getParentCount() > 1;
            return bl;
        }
    }

    public void revertToRevision(GitModel.GitAuthor author, String hash) throws IOException, InterruptedException {
        logger.info((Object)("Reverting to revision " + hash));
        try {
            this.executeGitCommand(author, "revert", "--no-commit", hash + "..HEAD");
        }
        catch (Throwable e) {
            logger.error((Object)("Revert to revision failed, aborting:" + ExceptionUtils.getMessageWithCauses((Throwable)e)));
            this.executeGitCommand(author, "revert", "--abort");
            throw e;
        }
    }

    public void mergeContinue(GitModel.GitAuthor author, String defaultCommitMessage) throws IOException, InterruptedException {
        File gitDir = this.git.getRepository().getDirectory();
        String mergeMsgPath = gitDir.getAbsolutePath() + "/MERGE_MSG";
        File mergeMsgFile = new File(mergeMsgPath);
        Path path = Paths.get(mergeMsgPath, new String[0]);
        if (mergeMsgFile.exists()) {
            String commitMessage = new String(Files.readAllBytes(path)).trim();
            if (commitMessage.isEmpty()) {
                Files.write(path, defaultCommitMessage.getBytes(), new OpenOption[0]);
            }
        } else {
            Files.write(path, defaultCommitMessage.getBytes(), new OpenOption[0]);
        }
        this.executeGitCommand(author, "-c", "core.editor=true", "merge", "--continue");
    }

    public void commit(GitModel.GitAuthor author, String message) throws IOException, InterruptedException {
        this.executeGitCommand(author, "commit", "-m", message);
    }

    public void addFile(String file) throws GitAPIException {
        this.git.add().addFilepattern(file).call();
    }

    public List<GitModel.GitRemote> listRemotes() throws GitAPIException {
        ArrayList<GitModel.GitRemote> ret = new ArrayList<GitModel.GitRemote>();
        RemoteListCommand command = this.git.remoteList();
        for (RemoteConfig config : command.call()) {
            GitModel.GitRemote grm = new GitModel.GitRemote();
            grm.name = config.getName();
            grm.url = this.getProperURL(config);
            ret.add(grm);
        }
        return ret;
    }

    public boolean hasRemoteWithAuth() throws GitAPIException, URISyntaxException {
        for (GitModel.GitRemote remote : this.listRemotes()) {
            URIBuilder uri;
            String userInfo;
            if (remote.url == null || !remote.url.toLowerCase().startsWith("http") || !StringUtils.isNotEmpty((String)(userInfo = (uri = new URIBuilder(remote.url)).getUserInfo()))) continue;
            return true;
        }
        return false;
    }

    private String getProperURL(RemoteConfig config) {
        return ((URIish)config.getURIs().get(0)).toString();
    }

    public List<String> listLocalBranches() throws GitAPIException {
        ArrayList<String> ret = new ArrayList<String>();
        ListBranchCommand command = this.git.branchList();
        for (Ref ref : command.call()) {
            ret.add(GitLocalCommands.shortenRefName(ref.getName()));
        }
        return ret;
    }

    public GitModel.GitTrackingCount getGitTrackingCount() throws IOException {
        BranchTrackingStatus trackingStatus = BranchTrackingStatus.of((Repository)this.git.getRepository(), (String)this.git.getRepository().getBranch());
        GitModel.GitTrackingCount gitTrackingCount = new GitModel.GitTrackingCount();
        if (trackingStatus != null) {
            gitTrackingCount.ahead = trackingStatus.getAheadCount();
            gitTrackingCount.behind = trackingStatus.getBehindCount();
        }
        return gitTrackingCount;
    }

    public List<String> listRemoteBranches(boolean shortenRemoteNames) throws GitAPIException {
        ArrayList<String> ret = new ArrayList<String>();
        ListBranchCommand command = this.git.branchList().setListMode(ListBranchCommand.ListMode.REMOTE);
        for (Ref ref : command.call()) {
            ret.add(shortenRemoteNames ? this.shortenRemoteBranchName(ref.getName()) : GitLocalCommands.shortenRefName(ref.getName()));
        }
        return ret;
    }

    public String getCurrentBranch() throws IOException {
        return this.git.getRepository().getBranch();
    }

    public void deleteLocalBranch(String branchName, boolean forceDelete) throws GitAPIException {
        Preconditions.checkNotNull((Object)branchName);
        this.deleteBranchCommand("refs", "heads", branchName).setForce(forceDelete).call();
    }

    public void deleteRemoteBranch(@Nullable String remoteName, String branchName, boolean forceDelete) throws GitAPIException {
        Preconditions.checkNotNull((Object)branchName);
        String remoteOrigin = StringUtils.defaultIfBlank((String)remoteName, (String)"origin");
        this.deleteBranchCommand("refs", "remotes", remoteOrigin, branchName).setForce(forceDelete).call();
    }

    private DeleteBranchCommand deleteBranchCommand(String ... path) {
        return this.git.branchDelete().setBranchNames(new String[]{Joiner.on((String)"/").join((Object[])path)});
    }

    public String getRemoteTrackingBranch() throws IOException {
        BranchTrackingStatus trackingStatus = BranchTrackingStatus.of((Repository)this.git.getRepository(), (String)this.git.getRepository().getBranch());
        return trackingStatus == null ? null : trackingStatus.getRemoteTrackingBranch();
    }

    public void hardResetTo(String ref) throws CodedException {
        try {
            this.git.reset().setMode(ResetCommand.ResetType.HARD).setRef(ref).call();
        }
        catch (GitAPIException ex) {
            throw new CodedException((InfoMessage.MessageCode)GitCodes.ERR_GIT_RESET_FAILED, "Could not reset local repository to reference '" + ref + "'", (Throwable)ex);
        }
    }

    public void cleanUntrackedFiles() throws CodedException {
        try {
            this.git.clean().setCleanDirectories(true).setForce(true).call();
        }
        catch (GitAPIException ex) {
            throw new CodedException((InfoMessage.MessageCode)GitCodes.ERR_GIT_CLEAN_FAILED, "Could not clean untracked files and directories", (Throwable)ex);
        }
    }

    public static String shortenRefName(String name) {
        return name != null ? Repository.shortenRefName((String)name) : null;
    }

    public String shortenRemoteBranchName(String name) {
        return name != null ? this.git.getRepository().shortenRemoteBranchName(name) : null;
    }

    private GitModel.GitTag newGitTagOrNull(RevWalk walk, Ref tagRef) throws IOException {
        RevObject obj = walk.parseAny((AnyObjectId)tagRef.getObjectId());
        if (obj instanceof RevTag) {
            return new GitModel.GitTag((RevTag)obj);
        }
        if (obj instanceof RevCommit) {
            return new GitModel.GitTag(tagRef, (RevCommit)obj);
        }
        return null;
    }

    public Set<GitModel.GitTag> getTags() throws GitAPIException, IOException {
        List tagRefs = this.git.tagList().call();
        try (RevWalk walk = new RevWalk(this.git.getRepository());){
            HashSet<GitModel.GitTag> tags = new HashSet<GitModel.GitTag>();
            for (Ref tagRef : tagRefs) {
                GitModel.GitTag gitTag = this.newGitTagOrNull(walk, tagRef);
                if (gitTag == null) continue;
                tags.add(gitTag);
            }
            HashSet<GitModel.GitTag> hashSet = tags;
            return hashSet;
        }
    }

    public Set<GitModel.GitTag> getFilteredTags(Predicate<String> nameFilter, Predicate<String> messageFilter) throws GitAPIException, IOException {
        List tagRefs = this.git.tagList().call();
        try (RevWalk walk = new RevWalk(this.git.getRepository());){
            HashSet<GitModel.GitTag> tags = new HashSet<GitModel.GitTag>();
            for (Ref tagRef : tagRefs) {
                GitModel.GitTag tag = this.newGitTagOrNull(walk, tagRef);
                if (tag == null || !nameFilter.apply((Object)StringUtils.defaultIfEmpty((String)tag.name, (String)"")) || !messageFilter.apply((Object)StringUtils.defaultIfEmpty((String)(tag.annotations != null ? tag.annotations.message : ""), (String)""))) continue;
                tags.add(tag);
            }
            HashSet<GitModel.GitTag> hashSet = tags;
            return hashSet;
        }
    }

    public Map<String, Set<GitModel.GitTag>> getTagsByCommitId() throws GitAPIException, IOException {
        return this.getTags().stream().collect(Collectors.groupingBy(ref -> ref.commitId, Collectors.mapping(ref -> ref, Collectors.toSet())));
    }

    public boolean canReachFromHead(GitModel.GitTag tag) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        try (RevWalk walk = new RevWalk(this.git.getRepository());){
            Ref head = this.git.getRepository().findRef("HEAD");
            ArrayList<Ref> tested = new ArrayList<Ref>();
            tested.add(head);
            ObjectId commit = this.git.getRepository().resolve(tag.commitId);
            boolean bl = !RevWalkUtils.findBranchesReachableFrom((RevCommit)walk.parseCommit((AnyObjectId)commit), (RevWalk)walk, tested).isEmpty();
            return bl;
        }
    }

    public void addTag(GitModel.GitAuthor author, String name, String message, String reference) throws IOException, GitAPIException {
        String lockName = JGitManager.getRepositoryLockName(this.git);
        try (AutoCloseableLock ignored = NamedLock.acquire(lockName);){
            TagCommand tag = this.git.tag();
            if (StringUtils.isNotBlank((String)reference)) {
                ObjectId commit = this.git.getRepository().resolve(reference);
                try (RevWalk revWalk = new RevWalk(this.git.getRepository());){
                    RevCommit revCommit = revWalk.parseCommit((AnyObjectId)commit);
                    tag.setObjectId((RevObject)revCommit);
                }
            }
            tag.setName(name);
            tag.setTagger(new PersonIdent(author.name, StringUtils.defaultIfEmpty((String)author.email, (String)author.name)));
            if (StringUtils.isNotBlank((String)message)) {
                tag.setMessage(message);
            }
            tag.call();
        }
    }

    public void removeTag(String name) throws GitAPIException {
        String lockName = JGitManager.getRepositoryLockName(this.git);
        try (AutoCloseableLock ignored = NamedLock.acquire(lockName);){
            this.git.tagDelete().setTags(new String[]{name}).call();
        }
    }

    public void clean() throws GitAPIException {
        String lockName = JGitManager.getRepositoryLockName(this.git);
        try (AutoCloseableLock ignored = NamedLock.acquire(lockName);){
            this.git.clean().call();
        }
    }

    public GitModel.GitTag findLastTag(Predicate<GitModel.GitTag> tagFilter) throws GitAPIException, IOException {
        List tagRefs = this.git.tagList().call();
        try (RevWalk walk = new RevWalk(this.git.getRepository());){
            for (Ref tagRef : tagRefs) {
                GitModel.GitTag gitTag = this.newGitTagOrNull(walk, tagRef);
                if (gitTag == null || !tagFilter.apply((Object)gitTag)) continue;
                GitModel.GitTag gitTag2 = gitTag;
                return gitTag2;
            }
        }
        return null;
    }

    public GitModel.GitTag findLastTag(String hash, Predicate<GitModel.GitTag> tagFilter) throws GitAPIException, IOException {
        try (RevWalk walk = new RevWalk(this.git.getRepository());){
            RevCommit commit = walk.parseCommit((AnyObjectId)this.git.getRepository().resolve(hash));
            Map tagRefsByCommitId = this.git.tagList().call().stream().map(t -> {
                try {
                    return this.newGitTagOrNull(walk, (Ref)t);
                }
                catch (IOException e) {
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.groupingBy(tag -> tag.commitId, Collectors.toList()));
            walk.markStart(commit);
            for (RevCommit currentCommit : walk) {
                List gitTags;
                if (!tagRefsByCommitId.containsKey(currentCommit.getName()) || (gitTags = tagRefsByCommitId.get(currentCommit.getName()).stream().filter(gitTag -> gitTag != null && tagFilter.apply(gitTag)).sorted((t1, t2) -> Long.compare(t2.annotations != null ? t2.annotations.timestamp : 0L, t1.annotations != null ? t1.annotations.timestamp : 0L)).collect(Collectors.toList())).isEmpty()) continue;
                logger.infoV("Found tags for commit %s: %s. Selecting the most recent: %s", new Object[]{currentCommit.getName(), gitTags.stream().map(t -> t.name).collect(Collectors.joining(", ")), ((GitModel.GitTag)gitTags.get((int)0)).name});
                GitModel.GitTag gitTag2 = (GitModel.GitTag)gitTags.get(0);
                return gitTag2;
            }
        }
        return null;
    }

    public GitModel.GitWorkingTreeStatus getStatus() throws GitAPIException {
        String lockName = JGitManager.getRepositoryLockName(this.git);
        try (AutoCloseableLock ignored = NamedLock.acquire(lockName);){
            Status status = this.git.status().call();
            GitModel.GitWorkingTreeStatus wtStatus = new GitModel.GitWorkingTreeStatus();
            wtStatus.hasUncommittedChanges = status.hasUncommittedChanges();
            wtStatus.clean = status.isClean();
            wtStatus.added = status.getAdded();
            wtStatus.changed = status.getChanged();
            wtStatus.removed = status.getRemoved();
            wtStatus.missing = status.getMissing();
            wtStatus.modified = status.getModified();
            wtStatus.conflicting = status.getConflicting();
            wtStatus.untracked = status.getUntracked();
            wtStatus.untrackedFolders = status.getUntrackedFolders();
            GitModel.GitWorkingTreeStatus gitWorkingTreeStatus = wtStatus;
            return gitWorkingTreeStatus;
        }
    }

    public RepositoryState getRepositoryStatus() {
        String lockName = JGitManager.getRepositoryLockName(this.git);
        try (AutoCloseableLock ignored = NamedLock.acquire(lockName);){
            RepositoryState repositoryState = this.git.getRepository().getRepositoryState();
            return repositoryState;
        }
    }
}

