/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.util;

import java.io.StringWriter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public class SecretKeyGenerator {
    private static final String URL_FRIENDLY_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890";
    static SecureRandom random = new SecureRandom();

    public static byte[] getRandomBytes(int size) {
        byte[] rndBytes = new byte[size];
        random.nextBytes(rndBytes);
        return rndBytes;
    }

    public static String getRandomSHA256() {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error("The imposible happened", e);
        }
        md.update(SecretKeyGenerator.getRandomBytes(64));
        byte[] byteData = md.digest();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < byteData.length; ++i) {
            sb.append(Integer.toString((byteData[i] & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }

    public static String generateSmall() {
        return SecretKeyGenerator.generate(7);
    }

    public static String generate() {
        return SecretKeyGenerator.generate(64);
    }

    public static String generate(int charLength) {
        StringWriter writer = new StringWriter();
        for (int i = 0; i < charLength; ++i) {
            int charIdx = random.nextInt(URL_FRIENDLY_CHARS.length());
            writer.append(URL_FRIENDLY_CHARS.charAt(charIdx));
        }
        return writer.toString();
    }
}

