/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.util.jcleanstack;

import com.dataiku.dip.exceptions.StackTraceElt;
import java.util.List;
import java.util.regex.Pattern;

public class StackUnicizer {
    static Pattern cglibPattern = Pattern.compile("\\$\\$[0-9a-f]+");
    static Pattern generatedAccessorPattern = Pattern.compile("GeneratedMethodAccessor[0-9]+");
    static Pattern proxyPattern = Pattern.compile("\\$Proxy[0-9]+");

    public static void unicizeStackTrace(List<StackTraceElt> elts) {
        for (StackTraceElt elt : elts) {
            if (elt.function.contains("$$FastClassBySpringCGLIB$$")) {
                elt.function = cglibPattern.matcher(elt.function).replaceAll("__");
                continue;
            }
            if (elt.function.contains("$$EnhancerBySpringCGLIB$$")) {
                elt.function = cglibPattern.matcher(elt.function).replaceAll("__");
                continue;
            }
            if (elt.function.startsWith("sun.reflect.GeneratedMethodAccessor")) {
                elt.function = generatedAccessorPattern.matcher(elt.function).replaceAll("GeneratedMethodAccessor__");
                continue;
            }
            if (!elt.function.startsWith("com.sun.proxy.$Proxy")) continue;
            elt.function = proxyPattern.matcher(elt.function).replaceAll("DollarProxy__");
        }
    }
}

