/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils.j3ts;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.utils.j3ts.TSTranslator;
import com.dataiku.dip.utils.j3ts.Translator;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class DkuFrontendCoreJ3TSMain {
    public static void main(String[] args) throws Exception {
        File installDir = DkuFrontendCoreJ3TSMain.initAndGetInstallDir();
        File outDir = new File(installDir, "dku-frontend-core/projects/dku-frontend-core/src/generated-sources/j2ts");
        TSTranslator translator = new TSTranslator();
        if ("INTELLIJ".equals(System.getenv("J3TS_MODE"))) {
            translator.addRootMapping(new File(installDir, "out/production/app-platform/"), "app-platform/src/main/java");
            translator.addRootMapping(new File(installDir, "out/production/dku-core/"), "dku-core/src/main/java");
        } else if ("JARS".equals(System.getenv("J3TS_MODE"))) {
            translator.addRootMapping(new File(installDir, "dist/dataiku-app-platform.jar"), "app-platform/src/main/java");
            translator.addRootMapping(new File(installDir, "dist/dataiku-core.jar"), "dku-core/src/main/java");
        } else {
            throw new RuntimeException("Please set env J3TS_MODE to INTELLIJ or JARS");
        }
        ((Translator)translator).translateInto(outDir, true);
    }

    public static File initAndGetInstallDir() throws IOException {
        Path dir = Files.createTempDirectory("j3ts", new FileAttribute[0]);
        String installDirStr = System.getenv("DKUINSTALLDIR");
        if (installDirStr == null) {
            throw new RuntimeException("DKUINSTALLDIR is not set");
        }
        File installDir = new File(installDirStr).getCanonicalFile();
        if (!new File(installDirStr, "app-platform/src/main/java").isDirectory()) {
            throw new RuntimeException("DKUINSTALLDIR is not set to the root of the DSS git repository");
        }
        DKUApp.configureNoConfig(dir.toAbsolutePath().toString(), installDir.toString());
        return installDir;
    }
}

