/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.activity;

import com.dataiku.dip.activity.UsageSummaryBuilderUtils;
import com.dataiku.dip.reports.ReportsManagementService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.ReadOnlyJobsInternalDB;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class JobsReportBuilder {
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ReadOnlyJobsInternalDB jobsDatabaseAccessService;
    private UsageSummaryBuilderUtils usbu = new UsageSummaryBuilderUtils();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.usage");

    public JobsReportBuilder() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    private ProjectJobsReport buildForProject(String projectKey) throws Exception {
        ProjectJobsReport ret = new ProjectJobsReport();
        ret.projectId = DigestUtils.md5Hex((String)projectKey);
        logger.info((Object)("Building jobs report for project " + projectKey));
        long since = System.currentTimeMillis() - 604800000L;
        this.jobsDatabaseAccessService.fillProjectReport(projectKey, ret, since);
        return ret;
    }

    public JobsReport build() throws Exception {
        JobsReport ret = new JobsReport();
        List<String> projectKeys = null;
        try (Transaction t = this.transactionService.beginRead();){
            projectKeys = this.projectsService.listProjectKeys();
        }
        for (String projectKey : projectKeys) {
            try {
                ret.projects.add(this.buildForProject(projectKey));
            }
            catch (Exception e) {
                logger.warn((Object)("Failed to build jobs report for project " + projectKey), (Throwable)e);
            }
        }
        for (ProjectJobsReport rep : ret.projects) {
            ret.global.nbJobs += rep.nbJobs;
            ret.global.nbJobsFromScenarios += rep.nbJobsFromScenarios;
            ret.global.nbJobs_0_30 += rep.nbJobs_0_30;
            ret.global.nbJobs_30_60 += rep.nbJobs_30_60;
            ret.global.nbJobs_60_180 += rep.nbJobs_60_180;
            ret.global.nbJobs_180_900 += rep.nbJobs_180_900;
            ret.global.nbJobs_900_3600 += rep.nbJobs_900_3600;
            ret.global.nbJobs_3600_and_above += rep.nbJobs_3600_and_above;
            ret.global.nbJobsFromScenarios_0_30 += rep.nbJobsFromScenarios_0_30;
            ret.global.nbJobsFromScenarios_30_60 += rep.nbJobsFromScenarios_30_60;
            ret.global.nbJobsFromScenarios_60_180 += rep.nbJobsFromScenarios_60_180;
            ret.global.nbJobsFromScenarios_180_900 += rep.nbJobsFromScenarios_180_900;
            ret.global.nbJobsFromScenarios_900_3600 += rep.nbJobsFromScenarios_900_3600;
            ret.global.nbJobsFromScenarios_3600_and_above += rep.nbJobsFromScenarios_3600_and_above;
            ret.global.totalDuration += rep.totalDuration;
            ret.global.totalDurationFromScenarios += rep.totalDurationFromScenarios;
            ret.global.totalDuration_0_30 += rep.totalDuration_0_30;
            ret.global.totalDuration_30_60 += rep.totalDuration_30_60;
            ret.global.totalDuration_60_180 += rep.totalDuration_60_180;
            ret.global.totalDuration_180_900 += rep.totalDuration_180_900;
            ret.global.totalDuration_900_3600 += rep.totalDuration_900_3600;
            ret.global.totalDuration_3600_and_above += rep.totalDuration_3600_and_above;
            ret.global.totalDurationFromScenarios_0_30 += rep.totalDurationFromScenarios_0_30;
            ret.global.totalDurationFromScenarios_30_60 += rep.totalDurationFromScenarios_30_60;
            ret.global.totalDurationFromScenarios_60_180 += rep.totalDurationFromScenarios_60_180;
            ret.global.totalDurationFromScenarios_180_900 += rep.totalDurationFromScenarios_180_900;
            ret.global.totalDurationFromScenarios_900_3600 += rep.totalDurationFromScenarios_900_3600;
            ret.global.totalDurationFromScenarios_3600_and_above += rep.totalDurationFromScenarios_3600_and_above;
            ret.global.totalWarnings += rep.totalWarnings;
            ret.global.jobsDone += rep.jobsDone;
            ret.global.jobsFailed += rep.jobsFailed;
            ret.global.jobsAborted += rep.jobsAborted;
            ret.global.scenarioRuns += rep.scenarioRuns;
            UsageSummaryBuilderUtils.mergeCountMap(ret.global.stepRuns, rep.stepRuns);
            UsageSummaryBuilderUtils.mergeCountMap(ret.global.reportItems, rep.reportItems);
        }
        return ret;
    }

    public ReportsManagementService.ReadyReport buildReport() throws Exception {
        return new ReportsManagementService.ReadyReport("jobs", JSON.toJsonObject((Object)this.build()));
    }

    public static class ProjectJobsReport {
        public String projectId;
        public int nbJobs;
        public int nbJobsFromScenarios;
        public long nbJobs_0_30;
        public long nbJobs_30_60;
        public long nbJobs_60_180;
        public long nbJobs_180_900;
        public long nbJobs_900_3600;
        public long nbJobs_3600_and_above;
        public long nbJobsFromScenarios_0_30;
        public long nbJobsFromScenarios_30_60;
        public long nbJobsFromScenarios_60_180;
        public long nbJobsFromScenarios_180_900;
        public long nbJobsFromScenarios_900_3600;
        public long nbJobsFromScenarios_3600_and_above;
        public long totalDuration;
        public long totalDurationFromScenarios;
        public long totalDuration_0_30;
        public long totalDuration_30_60;
        public long totalDuration_60_180;
        public long totalDuration_180_900;
        public long totalDuration_900_3600;
        public long totalDuration_3600_and_above;
        public long totalDurationFromScenarios_0_30;
        public long totalDurationFromScenarios_30_60;
        public long totalDurationFromScenarios_60_180;
        public long totalDurationFromScenarios_180_900;
        public long totalDurationFromScenarios_900_3600;
        public long totalDurationFromScenarios_3600_and_above;
        public int totalWarnings;
        public int jobsDone;
        public int jobsFailed;
        public int jobsAborted;
        public int scenarioRuns;
        public Map<String, Integer> stepRuns = new HashMap<String, Integer>();
        public Map<String, Integer> reportItems = new HashMap<String, Integer>();
    }

    public static class JobsReport {
        public ProjectJobsReport global = new ProjectJobsReport();
        public List<ProjectJobsReport> projects = new ArrayList<ProjectJobsReport>();
    }
}

