/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.agents.tools.custom;

import com.dataiku.dip.agents.tools.AgentTool;
import com.dataiku.dip.agents.tools.AgentToolMeta;
import com.dataiku.dip.agents.tools.AgentToolParams;
import com.dataiku.dip.agents.tools.AgentToolRunner;
import com.dataiku.dip.agents.tools.custom.CustomAgentToolDesc;
import com.dataiku.dip.agents.tools.custom.CustomAgentToolRunner;
import com.dataiku.dip.agents.tools.custom.LoadedCustomAgentTool;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.custom.IPluginifiedMeta;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.llm.LLMStructuredRef;
import com.dataiku.dip.savedmodels.agents.CustomAgentDependenciesCollector;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.util.JsonUtils;
import com.dataiku.dip.utils.Params;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CustomAgentToolMeta
extends AgentToolMeta
implements IPluginifiedMeta {
    public final LoadedCustomAgentTool loaded;

    public CustomAgentToolMeta(LoadedCustomAgentTool loaded) {
        super(true);
        this.loaded = loaded;
    }

    @Override
    public String getType() {
        return "Custom_" + this.loaded.getType();
    }

    @Override
    public Class<? extends AgentToolParams> paramsClass() {
        return CustomAgentToolRunner.CustomAgentToolParams.class;
    }

    @Override
    public List<SavedModel.AgentDependency> getDependencies(AgentTool tool) {
        CustomAgentToolRunner.CustomAgentToolParams p = tool.getParamsCopyAs(CustomAgentToolRunner.CustomAgentToolParams.class);
        return CustomAgentDependenciesCollector.collect(this.getAgentDesc().params, p.config);
    }

    @Override
    public Set<String> listConnectionNames(AgentTool tool) {
        HashSet<String> connections = new HashSet<String>();
        CustomAgentToolRunner.CustomAgentToolParams p = tool.getParamsCopyAs(CustomAgentToolRunner.CustomAgentToolParams.class);
        CustomAgentToolDesc agentDesc = this.getAgentDesc();
        if (p == null || p.config == null || agentDesc == null) {
            return connections;
        }
        for (LLMStructuredRef llmRef : CustomAgentDependenciesCollector.collectLlmDependencies(agentDesc.params, p.config).values()) {
            if (llmRef == null || llmRef.connection == null) continue;
            connections.add(llmRef.connection);
        }
        return connections;
    }

    @Override
    public boolean remapConnections(AgentTool tool, Map<String, String> replacements) {
        CustomAgentToolRunner.CustomAgentToolParams p = tool.getParamsCopyAs(CustomAgentToolRunner.CustomAgentToolParams.class);
        CustomAgentToolDesc agentDesc = this.getAgentDesc();
        if (p == null || p.config == null || agentDesc == null) {
            return false;
        }
        boolean remapped = false;
        for (Map.Entry<String, LLMStructuredRef> entry : CustomAgentDependenciesCollector.collectLlmDependencies(agentDesc.params, p.config).entrySet()) {
            String newConnection;
            LLMStructuredRef llmRef = entry.getValue();
            if (llmRef == null || llmRef.connection == null || (newConnection = replacements.get(llmRef.connection)) == null) continue;
            LLMStructuredRef newLlmRef = llmRef.withOtherConnection(newConnection);
            JsonUtils.addFieldIfNotNull(p.config, entry.getKey(), newLlmRef.encodeToId());
            remapped = true;
        }
        tool.setParams(p);
        return remapped;
    }

    @Override
    public AgentToolMeta.ToolDescriptor getResultingDescriptor(AuthCtx authCtx, String projectKey, AgentTool tool) throws Exception {
        TransactionContext.assertNoAttachedTransaction();
        try (CustomAgentToolRunner runner = new CustomAgentToolRunner((DSSAuthCtx)authCtx, tool, false, false);){
            AgentToolMeta.ToolDescriptor toolDescriptor = runner.getResultingDescriptor(tool);
            return toolDescriptor;
        }
    }

    @Override
    public JsonObject loadSampleQuery(AuthCtx authCtx, String projectKey, AgentTool tool) throws Exception {
        try (CustomAgentToolRunner runner = new CustomAgentToolRunner((DSSAuthCtx)authCtx, tool, true, false);){
            JsonObject jsonObject = runner.loadSampleQuery(tool);
            return jsonObject;
        }
    }

    @Override
    public AgentToolRunner buildRunner(AuthCtx authCtx, String projectKey, AgentTool tool, boolean devKernel) throws Exception {
        Params dkuParams = AbstractSQLConnection.CustomDatabaseProperty.toParams(tool.dkuProperties);
        boolean devMode = dkuParams.getBoolParam("dku.agents.tool.python.devMode", false);
        return new CustomAgentToolRunner((DSSAuthCtx)authCtx, tool, devKernel, devMode);
    }

    public CustomAgentToolDesc getAgentDesc() {
        return this.loaded.desc;
    }

    public String getOwnerPluginId() {
        return this.loaded.ownerPluginId;
    }

    @Override
    public LoadedCustomAgentTool getLoadedDesc() {
        return this.loaded;
    }
}

