/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.agents.tools.mcp;

import com.dataiku.dip.agents.tools.AbstractPythonAgentToolRunner;
import com.dataiku.dip.agents.tools.AgentTool;
import com.dataiku.dip.agents.tools.AgentToolRunner;
import com.dataiku.dip.agents.tools.mcp.GenericStdioMCPClientTool;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.code.CodeEnvSelector;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.containers.exec.ContainerExecConfigSelector;
import com.dataiku.dip.custom.PluginSettingsResolver;
import com.dataiku.dip.io.CustomPythonKernelException;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class GenericStdioMCPClientToolRunner
extends AbstractPythonAgentToolRunner {
    private final GenericStdioMCPClientTool.Params params;
    @Autowired
    private PasswordEncryptionService encryptionService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.genai.agents.tools");

    public GenericStdioMCPClientToolRunner(DSSAuthCtx authCtx, AgentTool at, boolean devKernel, boolean devMode) throws Exception {
        super(authCtx, at);
        this.params = at.getParamsCopyAs(GenericStdioMCPClientTool.Params.class);
        this.devKernel = devKernel;
        this.devMode = devMode;
        SpringUtils.getInstance().autowire((Object)this);
    }

    @Override
    protected synchronized void initOnce() throws IOException {
        if (this.serverAPI == null) {
            try {
                if (!this.params.useCodeEnvPythonAsCommand && StringUtils.isBlank((String)this.params.command)) {
                    throw new IllegalArgumentException("The command to start the server is required.");
                }
                String envName = new CodeEnvSelector().selectForPythonRecipe(this.projectKey, this.params.codeEnvSelection);
                String containerConfName = new ContainerExecConfigSelector().selectConfName_autoTXN(this.authCtx, this.projectKey, this.params.containerExecSelection);
                String clusterId = new ClusterSelector().selectForProject(this.authCtx, this.projectKey).getClusterId();
                JsonObject config = JSON.toJsonObject((Object)this.params);
                HashMap<String, String> resolvedEnv = new HashMap<String, String>();
                JsonArray passwordParams = new JsonArray();
                for (AbstractSQLConnection.CustomDatabaseProperty customDatabaseProperty : this.params.env) {
                    if (customDatabaseProperty.secret && StringUtils.isNotBlank((String)customDatabaseProperty.value)) {
                        customDatabaseProperty.value = this.encryptionService.decryptIfEncrypted(customDatabaseProperty.value);
                        passwordParams.add(customDatabaseProperty.name);
                    }
                    if (!StringUtils.isNotBlank((String)customDatabaseProperty.name)) continue;
                    resolvedEnv.put(customDatabaseProperty.name, customDatabaseProperty.value);
                }
                if (config.has("env")) {
                    config.remove("env");
                }
                config.add("env", (JsonElement)JSON.toJsonObject(resolvedEnv));
                HashMap<String, String> resolvedProperties = new HashMap<String, String>();
                for (AbstractSQLConnection.CustomDatabaseProperty cdp : this.at.dkuProperties) {
                    if (cdp.secret && StringUtils.isNotBlank((String)cdp.value)) {
                        cdp.value = this.encryptionService.decryptIfEncrypted(cdp.value);
                        passwordParams.add(cdp.name);
                    }
                    if (!StringUtils.isNotBlank((String)cdp.name)) continue;
                    resolvedProperties.put(cdp.name, cdp.value);
                }
                if (config.has("dkuProperties")) {
                    config.remove("dkuProperties");
                }
                config.add("dkuProperties", (JsonElement)JSON.toJsonObject(resolvedProperties));
                config.add("dkuPasswordParams", (JsonElement)passwordParams);
                String string = "dataiku.llm.agent_tools.mcp.generic_stdio.GenericStdioMCPClient";
                this.initToolServer(envName, containerConfName, clusterId, null, "dataiku.llm.agent_tools.mcp.generic_stdio.GenericStdioMCPClient", null, null, new PluginSettingsResolver.ResolvedSettings(config, null), false);
            }
            catch (CustomPythonKernelException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException("Failed to initialize Python Agent Tool", e);
            }
        }
    }

    @Override
    public AgentToolRunner.AgentToolOutput run(AgentToolRunner.AgentToolInput input) throws Exception {
        if (StringUtils.isBlank((String)input.subtoolName)) {
            throw new IllegalArgumentException("Subtool name is required, please set the name of the subtool to use in the 'subtoolName' field.");
        }
        return super.run(input);
    }
}

