/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.aigenerations.recipes;

import com.dataiku.dip.aigenerations.AIRecipeGenerationService;
import com.dataiku.dip.aigenerations.recipes.AIRecipe;
import com.dataiku.dip.aigenerations.recipes.FilterOperatorValidator;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.exec.filter.FilterDesc;
import com.dataiku.dip.dataflow.exec.split.SplitRecipePayloadParams;
import com.dataiku.dip.i18n.TranslationService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class AISplit
extends AIRecipe {
    public static final String type = "split";
    public Params params;
    private static final DKULogger logger = DKULogger.getLogger(AISplit.class);

    @Override
    public List<AIRecipeGenerationService.CreationMessage> validate(List<Dataset> datasets, String contextProjectKey, String lang) {
        ArrayList<AIRecipeGenerationService.CreationMessage> creationMessages = new ArrayList<AIRecipeGenerationService.CreationMessage>();
        this.params.checkSingleInputDataset(datasets, type, contextProjectKey);
        this.params.checkMultipleOutputDatasets(type);
        TranslationService ts = (TranslationService)SpringUtils.getBean(TranslationService.class);
        if (this.params.value_split_mode == null) {
            this.params.value_split_mode = ValueSplitMode.COLUMN_VALUES;
        }
        if (this.params.split_mode.equals((Object)SplitMode.VALUE_RANGES)) {
            this.params.split_mode = SplitMode.VALUES;
        }
        if (this.params.split_mode.equals((Object)SplitMode.VALUES) && StringUtils.isBlank((CharSequence)this.params.value_split_column)) {
            creationMessages.add(new AIRecipeGenerationService.CreationMessage(AIRecipeGenerationService.CreationMessage.Level.WARNING, ts.translate(lang, "RIGHT_PANEL.TABS.GENERATE_RECIPE.SPLIT.UNABLE_TO_DETERMINE_COLUMN", "We were unable to determine which column should be use to split your dataset", new Object[0])));
        }
        if (this.params.split_mode.equals((Object)SplitMode.VALUES) && this.params.value_split_mode.equals((Object)ValueSplitMode.COLUMN_VALUES) && (this.params.split_dataset_values == null || this.params.split_dataset_values.isEmpty())) {
            creationMessages.add(new AIRecipeGenerationService.CreationMessage(AIRecipeGenerationService.CreationMessage.Level.WARNING, ts.translate(lang, "RIGHT_PANEL.TABS.GENERATE_RECIPE.SPLIT.UNABLE_TO_DETERMINE_DATA_VALUE", "We were unable to determine which data values we should use to split the dataset", new Object[0])));
        }
        if (this.params.split_mode.equals((Object)SplitMode.VALUES) && this.params.value_split_mode.equals((Object)ValueSplitMode.VALUE_RANGES) && (this.params.split_dataset_ranges == null || this.params.split_dataset_ranges.isEmpty())) {
            creationMessages.add(new AIRecipeGenerationService.CreationMessage(AIRecipeGenerationService.CreationMessage.Level.WARNING, ts.translate(lang, "RIGHT_PANEL.TABS.GENERATE_RECIPE.SPLIT.UNABLE_TO_DETERMINE_DATA_RANGE", "We were unable to determine which data ranges we should use to split the dataset", new Object[0])));
        }
        if (this.params.split_mode.equals((Object)SplitMode.RANDOM) && this.params.random_dispatch_mode.equals((Object)RandomDispatchMode.FULL_RANDOM) && (this.params.random_dataset_ratios == null || this.params.random_dataset_ratios.isEmpty())) {
            creationMessages.add(new AIRecipeGenerationService.CreationMessage(AIRecipeGenerationService.CreationMessage.Level.WARNING, ts.translate(lang, "RIGHT_PANEL.TABS.GENERATE_RECIPE.SPLIT.NO_PERCENTAGE_RATIO", "There is currently no percentage ratio defined to randomly dispatch the data", new Object[0])));
        }
        if (this.params.split_mode.equals((Object)SplitMode.RANDOM) && this.params.random_dispatch_mode.equals((Object)RandomDispatchMode.SUBSET_COLUMN_VALUES) && (this.params.random_dataset_ratios == null || this.params.random_dataset_ratios.isEmpty() || this.params.random_column_values == null || this.params.random_column_values.isEmpty())) {
            creationMessages.add(new AIRecipeGenerationService.CreationMessage(AIRecipeGenerationService.CreationMessage.Level.WARNING, ts.translate(lang, "RIGHT_PANEL.TABS.GENERATE_RECIPE.SPLIT.UNABLE_TO_DETERMINE_COLUMN_GKEY", "We were unable to determine which column(s) should be use as a grouping key(s) for splitting the dataset values", new Object[0])));
        }
        if (this.params.split_mode.equals((Object)SplitMode.CENTILE) && (this.params.centile_sorted_columns == null || this.params.centile_sorted_columns.isEmpty())) {
            creationMessages.add(new AIRecipeGenerationService.CreationMessage(AIRecipeGenerationService.CreationMessage.Level.WARNING, ts.translate(lang, "RIGHT_PANEL.TABS.GENERATE_RECIPE.SPLIT.UNABLE_TO_DETERMINE_COLUMN_SORT", "We were unable to determine which column(s) should be use to sort the dataset and compute percentiles on", new Object[0])));
        }
        if (this.params.split_mode.equals((Object)SplitMode.CENTILE) && (this.params.centile_dataset_ratios == null || this.params.centile_dataset_ratios.isEmpty())) {
            creationMessages.add(new AIRecipeGenerationService.CreationMessage(AIRecipeGenerationService.CreationMessage.Level.WARNING, ts.translate(lang, "RIGHT_PANEL.TABS.GENERATE_RECIPE.SPLIT.UNABLE_TO_DETERMINE_PERCENTILE", "We were unable to determine the percentiles over which the dataset should be distributed", new Object[0])));
        }
        if (this.params.split_mode.equals((Object)SplitMode.FILTERS) && (this.params.filters_dataset_conditions == null || this.params.filters_dataset_conditions.isEmpty())) {
            creationMessages.add(new AIRecipeGenerationService.CreationMessage(AIRecipeGenerationService.CreationMessage.Level.WARNING, ts.translate(lang, "RIGHT_PANEL.TABS.GENERATE_RECIPE.SPLIT.UNABLE_TO_SET_FILTER", "We were unable to set appropriate filter over which the dataset should be split", new Object[0])));
        }
        if (this.params.split_mode.equals((Object)SplitMode.FILTERS) && this.params.filters_dataset_conditions != null) {
            FilterOperatorValidator.validateFilterConditions(datasets, contextProjectKey, creationMessages, this.params.input_dataset, this.params.filters_dataset_conditions, lang);
        }
        return creationMessages;
    }

    @Override
    public AIRecipeGenerationService.AIMetaCreation generateRecipeMetaPayload(AIRecipeGenerationService.RecipeGenerationContext recipeGenerationContext) {
        AIRecipeGenerationService.AIMetaCreation metaCreation = new AIRecipeGenerationService.AIMetaCreation();
        metaCreation.messages = this.validate(recipeGenerationContext.datasets, recipeGenerationContext.contextProjectKey, recipeGenerationContext.lang);
        SplitRecipePayloadParams splitRecipePayloadParams = new SplitRecipePayloadParams();
        this.enrichParams(splitRecipePayloadParams, recipeGenerationContext.datasets, recipeGenerationContext.contextProjectKey);
        metaCreation.datasetInputNames = List.of(this.params.input_dataset);
        metaCreation.datasetOutputNames = this.params.output_datasets;
        metaCreation.payload = new Gson().toJson((Object)splitRecipePayloadParams);
        return metaCreation;
    }

    public void enrichParams(SplitRecipePayloadParams recipeParams, List<Dataset> datasets, String contextProjectKey) {
        Dataset dataset = AIRecipe.AIRecipeParams.getDataset(datasets, this.params.input_dataset, contextProjectKey);
        if (dataset == null) {
            return;
        }
        Set datasetColumnNames = dataset.getSchema().columns.stream().map(SchemaColumn::getName).collect(Collectors.toSet());
        HashMap<String, Integer> datasetNameToOutputIndex = new HashMap<String, Integer>();
        for (int i = 0; i < this.params.output_datasets.size(); ++i) {
            datasetNameToOutputIndex.put((String)this.params.output_datasets.get(i), i);
        }
        recipeParams.defaultOutputIndex = -1;
        if (this.params.split_mode.equals((Object)SplitMode.RANDOM)) {
            SplitRecipePayloadParams.Mode mode = recipeParams.mode = this.params.random_dispatch_mode.equals((Object)RandomDispatchMode.SUBSET_COLUMN_VALUES) ? SplitRecipePayloadParams.Mode.RANDOM_COLUMNS : SplitRecipePayloadParams.Mode.RANDOM;
            if (recipeParams.mode.equals((Object)SplitRecipePayloadParams.Mode.RANDOM_COLUMNS)) {
                recipeParams.randomColumns = this.params.random_column_values == null ? Collections.emptyList() : this.params.random_column_values.stream().filter(datasetColumnNames::contains).collect(Collectors.toList());
            }
            recipeParams.randomSplits = this.params.random_dataset_ratios == null ? Collections.emptyList() : this.params.random_dataset_ratios.stream().map(rdr -> {
                SplitRecipePayloadParams.ShareSplitDesc ret = new SplitRecipePayloadParams.ShareSplitDesc();
                ret.share = rdr.ratio;
                ret.outputIndex = datasetNameToOutputIndex.getOrDefault(rdr.output_dataset, -1);
                return ret;
            }).collect(Collectors.toList());
            recipeParams.randomColumnsSplits = recipeParams.randomSplits;
        } else if (this.params.split_mode.equals((Object)SplitMode.FILTERS)) {
            recipeParams.mode = SplitRecipePayloadParams.Mode.FILTERS;
            if (this.params.filters_dataset_conditions == null) {
                this.params.filters_dataset_conditions = Collections.emptyList();
            }
            recipeParams.filterSplits = new ArrayList<SplitRecipePayloadParams.FilterSplitDesc>();
            for (DatasetCondition filter : this.params.filters_dataset_conditions) {
                List<FilterDesc.FilterUiCondition> uiConditions = FilterOperatorValidator.getConditionsOperators(datasets, this.params.input_dataset, List.of(filter), contextProjectKey, logger);
                SplitRecipePayloadParams.FilterSplitDesc filterSplitDesc = SplitRecipePayloadParams.FilterSplitDesc.defaultSplit();
                filterSplitDesc.outputIndex = datasetNameToOutputIndex.getOrDefault(filter.output_dataset, -1);
                filterSplitDesc.filter.uiData.mode = "&&";
                filterSplitDesc.filter.uiData.conditions = uiConditions;
                recipeParams.filterSplits.add(filterSplitDesc);
            }
            recipeParams.defaultOutputIndex = -1;
        } else if (this.params.split_mode.equals((Object)SplitMode.CENTILE)) {
            recipeParams.mode = SplitRecipePayloadParams.Mode.CENTILE;
            recipeParams.centileSplits = this.params.centile_dataset_ratios == null ? Collections.emptyList() : this.params.centile_dataset_ratios.stream().map(cdr -> {
                SplitRecipePayloadParams.ShareSplitDesc shareSplitDesc = new SplitRecipePayloadParams.ShareSplitDesc();
                shareSplitDesc.outputIndex = datasetNameToOutputIndex.getOrDefault(cdr.output_dataset, -1);
                shareSplitDesc.share = cdr.ratio;
                return shareSplitDesc;
            }).collect(Collectors.toList());
            recipeParams.centileOrders = this.params.centile_sorted_columns == null ? Collections.emptyList() : this.params.centile_sorted_columns.stream().filter(csc -> datasetColumnNames.contains(csc.column)).map(csc -> {
                SplitRecipePayloadParams.Order order = new SplitRecipePayloadParams.Order();
                order.column = csc.column;
                order.desc = csc.asc == false;
                return order;
            }).collect(Collectors.toList());
        } else if (this.params.split_mode.equals((Object)SplitMode.VALUES)) {
            recipeParams.mode = this.params.value_split_mode.equals((Object)ValueSplitMode.COLUMN_VALUES) ? SplitRecipePayloadParams.Mode.VALUES : SplitRecipePayloadParams.Mode.RANGE;
            recipeParams.column = this.params.value_split_column;
            if (recipeParams.mode.equals((Object)SplitRecipePayloadParams.Mode.VALUES)) {
                recipeParams.valueSplits = this.params.split_dataset_values == null ? Collections.emptyList() : this.params.split_dataset_values.stream().map(sdv -> {
                    SplitRecipePayloadParams.ValueSplitDesc valueSplitDesc = new SplitRecipePayloadParams.ValueSplitDesc();
                    valueSplitDesc.outputIndex = datasetNameToOutputIndex.getOrDefault(sdv.output_dataset, -1);
                    valueSplitDesc.value = sdv.value;
                    return valueSplitDesc;
                }).collect(Collectors.toList());
            } else {
                recipeParams.rangeSplits = this.params.split_dataset_ranges == null ? Collections.emptyList() : this.params.split_dataset_ranges.stream().filter(sdr -> sdr.from != null).map(sdr -> {
                    SplitRecipePayloadParams.FilterSplitDesc filterSplitDesc = new SplitRecipePayloadParams.FilterSplitDesc();
                    filterSplitDesc.outputIndex = datasetNameToOutputIndex.getOrDefault(sdr.output_dataset, -1);
                    filterSplitDesc.filter = new FilterDesc();
                    filterSplitDesc.filter.uiData = new FilterDesc.FilterUiData();
                    filterSplitDesc.filter.uiData.mode = "&&";
                    filterSplitDesc.filter.uiData.conditions = new ArrayList();
                    FilterDesc.FilterUiCondition from = new FilterDesc.FilterUiCondition();
                    from.input = this.params.value_split_column;
                    from.num = sdr.from.intValue();
                    from.operator = ">= [number]";
                    filterSplitDesc.filter.uiData.conditions.add(from);
                    if (sdr.to != null) {
                        FilterDesc.FilterUiCondition to = new FilterDesc.FilterUiCondition();
                        to.input = this.params.value_split_column;
                        to.num = sdr.to.intValue();
                        to.operator = "<= [number]";
                        filterSplitDesc.filter.uiData.conditions.add(to);
                    }
                    return filterSplitDesc;
                }).collect(Collectors.toList());
            }
        }
    }

    public static class Params
    extends AIRecipe.AIRecipeParams {
        public SplitMode split_mode;
        public RandomDispatchMode random_dispatch_mode = RandomDispatchMode.FULL_RANDOM;
        public List<String> random_column_values;
        public List<RandomDatasetRatio> random_dataset_ratios;
        public String value_split_column;
        public ValueSplitMode value_split_mode = ValueSplitMode.COLUMN_VALUES;
        public List<DatasetValue> split_dataset_values;
        public List<DatasetRange> split_dataset_ranges;
        public List<AIRecipe.OrderingColumn> centile_sorted_columns;
        public List<CentileDatasetRatio> centile_dataset_ratios;
        public List<DatasetCondition> filters_dataset_conditions;
    }

    public static enum ValueSplitMode {
        COLUMN_VALUES,
        VALUE_RANGES;

    }

    public static enum SplitMode {
        RANDOM,
        VALUES,
        FILTERS,
        CENTILE,
        VALUE_RANGES;

    }

    public static enum RandomDispatchMode {
        FULL_RANDOM,
        SUBSET_COLUMN_VALUES;

    }

    public static class DatasetCondition
    extends AIRecipe.FilterCondition {
        public String output_dataset;

        public DatasetCondition(String column, String type, String value, String output_dataset) {
            super(column, type, value);
            this.output_dataset = output_dataset;
        }
    }

    public class DatasetRange {
        public String output_dataset;
        public Integer from;
        public Integer to;
    }

    public class DatasetValue {
        public String output_dataset;
        public String value;
    }

    public class CentileDatasetRatio {
        public String output_dataset;
        public Float ratio;
    }

    public class RandomDatasetRatio {
        public String output_dataset;
        public Float ratio;
    }
}

