/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.aigenerations.recipes;

import com.dataiku.dip.aigenerations.AIRecipeGenerationService;
import com.dataiku.dip.aigenerations.recipes.AIRecipe;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.exec.window.WindowRecipePayloadParams;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class AIWindow
extends AIRecipe {
    public static final String type = "window";
    public Params params;

    @Override
    public List<AIRecipeGenerationService.CreationMessage> validate(List<Dataset> datasets, String contextProjectKey, String lang) {
        ArrayList<AIRecipeGenerationService.CreationMessage> creationMessages = new ArrayList<AIRecipeGenerationService.CreationMessage>();
        this.params.checkSingleInputDataset(datasets, type, contextProjectKey);
        this.params.checkSingleOutputDataset(type);
        Dataset dataset = AIRecipe.AIRecipeParams.getDataset(datasets, this.params.input_dataset, contextProjectKey);
        if (this.params.window_type == null) {
            this.params.window_type = WindowType.DISABLED;
        }
        this.validateAggregationFunctions(creationMessages, this.params.window_aggregations, dataset, true, lang);
        return creationMessages;
    }

    @Override
    public AIRecipeGenerationService.AIMetaCreation generateRecipeMetaPayload(AIRecipeGenerationService.RecipeGenerationContext recipeGenerationContext) {
        AIRecipeGenerationService.AIMetaCreation metaCreation = new AIRecipeGenerationService.AIMetaCreation();
        metaCreation.messages = this.validate(recipeGenerationContext.datasets, recipeGenerationContext.contextProjectKey, recipeGenerationContext.lang);
        Dataset dataset = AIRecipe.AIRecipeParams.getDataset(recipeGenerationContext.datasets, this.params.input_dataset, recipeGenerationContext.contextProjectKey);
        WindowRecipePayloadParams windowRecipePayloadParams = new WindowRecipePayloadParams();
        WindowRecipePayloadParams.WindowDesc windowDesc = new WindowRecipePayloadParams.WindowDesc();
        windowDesc.partitioningColumns = (ArrayList)this.getValidPartitioningColumns(dataset);
        windowDesc.enablePartitioning = !windowDesc.partitioningColumns.isEmpty();
        windowDesc.orders = (ArrayList)this.getValidOrderingColumns(dataset);
        windowDesc.enableOrdering = !windowDesc.orders.isEmpty();
        boolean bl = windowDesc.enableLimits = !this.params.window_type.equals((Object)WindowType.DISABLED);
        if (this.params.window_type.equals((Object)WindowType.ROWS)) {
            windowDesc.limitPreceding = this.params.limit_previous_rows != null;
            windowDesc.precedingRows = this.params.limit_previous_rows != null ? this.params.limit_previous_rows : 0;
            windowDesc.limitFollowing = this.params.limit_following_rows != null;
            windowDesc.followingRows = this.params.limit_following_rows != null ? this.params.limit_following_rows : 0;
            windowDesc.windowLimitMode = WindowRecipePayloadParams.WindowLimitMode.ROWS;
        } else if (this.params.window_type.equals((Object)WindowType.RANGE)) {
            windowDesc.limitPreceding = this.params.range_lower_bound != null;
            windowDesc.windowLowerBound = this.params.range_lower_bound != null ? (double)this.params.range_lower_bound.intValue() : 0.0;
            windowDesc.limitFollowing = this.params.range_upper_bound != null;
            windowDesc.windowUpperBound = this.params.range_upper_bound != null ? (double)this.params.range_upper_bound.intValue() : 0.0;
            windowDesc.windowLimitMode = WindowRecipePayloadParams.WindowLimitMode.RANGE;
            windowDesc.windowDateRangeUnit = this.getDateRangeUnit();
        }
        windowRecipePayloadParams.windows.add(windowDesc);
        if (this.params.ranking_computations != null) {
            HashSet<Computation> computations = new HashSet<Computation>(this.params.ranking_computations);
            windowRecipePayloadParams.rank = computations.contains((Object)Computation.RANK);
            windowRecipePayloadParams.rowNumber = computations.contains((Object)Computation.ROW_NUMBER);
            windowRecipePayloadParams.denseRank = computations.contains((Object)Computation.DENSERANK);
            windowRecipePayloadParams.cumeDist = computations.contains((Object)Computation.CUMULATIVE_DISTRIBUTION);
        }
        windowRecipePayloadParams.values = (ArrayList)this.getWindowValues(dataset);
        metaCreation.datasetInputNames = List.of(this.params.input_dataset);
        metaCreation.datasetOutputNames = List.of(this.params.output_dataset);
        metaCreation.payload = new Gson().toJson((Object)windowRecipePayloadParams);
        return metaCreation;
    }

    public List<String> getValidPartitioningColumns(Dataset dataset) {
        if (this.params.partitioning_columns == null) {
            return new ArrayList<String>();
        }
        Set datasetColumnsName = dataset.getSchema().columns.stream().map(SchemaColumn::getName).collect(Collectors.toSet());
        return this.params.partitioning_columns.stream().filter(datasetColumnsName::contains).collect(Collectors.toCollection(ArrayList::new));
    }

    public List<WindowRecipePayloadParams.Order> getValidOrderingColumns(Dataset dataset) {
        if (this.params.ordering_columns == null) {
            return new ArrayList<WindowRecipePayloadParams.Order>();
        }
        Set datasetColumnsName = dataset.getSchema().columns.stream().map(SchemaColumn::getName).collect(Collectors.toSet());
        return this.params.ordering_columns.stream().filter(oc -> datasetColumnsName.contains(oc.column)).map(oc -> {
            WindowRecipePayloadParams.Order order = new WindowRecipePayloadParams.Order();
            order.column = oc.column;
            order.desc = oc.asc == null || oc.asc == false;
            return order;
        }).collect(Collectors.toCollection(ArrayList::new));
    }

    public List<WindowRecipePayloadParams.WindowValue> getWindowValues(Dataset dataset) {
        HashMap<String, Set> columnToComputationFunctionMap = new HashMap<String, Set>();
        for (AIRecipe.Aggregation agg : this.params.window_aggregations) {
            Set computationSet = columnToComputationFunctionMap.getOrDefault(agg.column, new HashSet());
            computationSet.add(agg.function);
            columnToComputationFunctionMap.put(agg.column, computationSet);
        }
        return dataset.getSchema().columns.stream().map(sc -> {
            WindowRecipePayloadParams.WindowValue wv = new WindowRecipePayloadParams.WindowValue();
            wv.column = sc.getName();
            Set computationSet = columnToComputationFunctionMap.getOrDefault(sc.getName(), new HashSet());
            wv.value = computationSet.contains("RETRIEVE");
            wv.lag = computationSet.contains("LAG");
            wv.max = computationSet.contains("MAX");
            wv.min = computationSet.contains("MIN");
            wv.avg = computationSet.contains("AVG");
            wv.concat = computationSet.contains("CONCAT");
            wv.concatDistinct = computationSet.contains("CONCAT_DISTINCT");
            wv.count = computationSet.contains("COUNT");
            wv.countDistinct = computationSet.contains("COUNT_DISTINCT");
            wv.stddev = computationSet.contains("STD_DEV");
            wv.sum = computationSet.contains("SUM");
            wv.first = computationSet.contains("FIRST");
            wv.last = computationSet.contains("LAST");
            wv.lead = computationSet.contains("LEAD");
            wv.leadDiff = computationSet.contains("LEAD_DIFF");
            wv.lagDiff = computationSet.contains("LAG_DIFF");
            return wv;
        }).collect(Collectors.toCollection(ArrayList::new));
    }

    public WindowRecipePayloadParams.DateDiffUnit getDateRangeUnit() {
        if (this.params.range_date_unit == null) {
            return WindowRecipePayloadParams.DateDiffUnit.WEEK;
        }
        if (this.params.range_date_unit.equals((Object)RangeDateUnit.YEARS)) {
            return WindowRecipePayloadParams.DateDiffUnit.YEAR;
        }
        if (this.params.range_date_unit.equals((Object)RangeDateUnit.SECONDS)) {
            return WindowRecipePayloadParams.DateDiffUnit.SECOND;
        }
        if (this.params.range_date_unit.equals((Object)RangeDateUnit.MINUTES)) {
            return WindowRecipePayloadParams.DateDiffUnit.MINUTE;
        }
        if (this.params.range_date_unit.equals((Object)RangeDateUnit.HOURS)) {
            return WindowRecipePayloadParams.DateDiffUnit.HOUR;
        }
        if (this.params.range_date_unit.equals((Object)RangeDateUnit.DAYS)) {
            return WindowRecipePayloadParams.DateDiffUnit.DAY;
        }
        if (this.params.range_date_unit.equals((Object)RangeDateUnit.MONTHS)) {
            return WindowRecipePayloadParams.DateDiffUnit.MONTH;
        }
        return WindowRecipePayloadParams.DateDiffUnit.WEEK;
    }

    public static class Params
    extends AIRecipe.AIRecipeParams {
        public List<String> partitioning_columns;
        public List<AIRecipe.OrderingColumn> ordering_columns;
        public WindowType window_type;
        public Integer limit_previous_rows;
        public Integer limit_following_rows;
        public Integer range_lower_bound;
        public Integer range_upper_bound;
        public RangeDateUnit range_date_unit;
        public List<Computation> ranking_computations;
        public List<AIRecipe.Aggregation> window_aggregations = new ArrayList<AIRecipe.Aggregation>();
    }

    public static enum WindowType {
        ROWS,
        RANGE,
        DISABLED;

    }

    public static enum Computation {
        RANK,
        DENSERANK,
        ROW_NUMBER,
        CUMULATIVE_DISTRIBUTION;

    }

    public static enum RangeDateUnit {
        SECONDS,
        MINUTES,
        HOURS,
        DAYS,
        WEEKS,
        MONTHS,
        YEARS;

    }
}

