/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.docgen.extractor;

import com.dataiku.dip.analysis.docgen.extractor.ModelExtractor;
import com.dataiku.dip.analysis.docgen.extractor.TimeseriesForecastHorizonExtractor;
import com.dataiku.dip.analysis.docgen.helpers.TimeSeriesUtil;
import com.dataiku.dip.analysis.model.ModelDetailsBase;
import com.dataiku.dip.analysis.model.prediction.TimeseriesForecastingModelDetails;
import com.dataiku.dip.analysis.model.prediction.TimestepParams;
import com.jayway.jsonpath.DocumentContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TimeseriesForecastingTableExtractor
implements ModelExtractor<List<List<String>>> {
    @Override
    public List<List<String>> extract(DocumentContext documentContext, ModelDetailsBase model) throws IOException {
        if (!(model instanceof TimeseriesForecastingModelDetails)) {
            throw new IOException(String.format("Extractor '%s' does not support model details of type '%s'", this.getClass().getSimpleName(), model.getClass().getSimpleName()));
        }
        TimeseriesForecastingModelDetails timeseriesModelDetails = (TimeseriesForecastingModelDetails)model;
        ArrayList<List<String>> output = new ArrayList<List<String>>();
        TimestepParams.Timeunit timeunit = timeseriesModelDetails.coreParams.timestepParams.timeunit;
        long numberOfTimeunits = timeseriesModelDetails.coreParams.timestepParams.numberOfTimeunits;
        String timeStep = TimeSeriesUtil.prettyTimeStep(numberOfTimeunits, timeunit);
        output.add(Arrays.asList("Time step", timeStep));
        if (timeunit == TimestepParams.Timeunit.WEEK) {
            output.add(Arrays.asList("Day of week", TimeSeriesUtil.prettyEndOfWeekDay(timeseriesModelDetails.coreParams.timestepParams)));
        }
        if (timeunit == TimestepParams.Timeunit.MONTH || timeunit == TimestepParams.Timeunit.QUARTER || timeunit == TimestepParams.Timeunit.HALF_YEAR || timeunit == TimestepParams.Timeunit.YEAR) {
            output.add(Arrays.asList("Selected day", TimeSeriesUtil.prettySelectedDate(timeseriesModelDetails.coreParams.timestepParams)));
        }
        String forecastHorizonInTimeUnits = new TimeseriesForecastHorizonExtractor().extract(documentContext, model);
        long forecastHorizonInTimeSteps = timeseriesModelDetails.coreParams.predictionLength;
        output.add(Arrays.asList("Forecast horizon", forecastHorizonInTimeUnits + " (" + this.plural(forecastHorizonInTimeSteps, "time step") + " of " + timeStep + ")"));
        long horizonsInEvaluation = timeseriesModelDetails.coreParams.evaluationParams.testSize / timeseriesModelDetails.coreParams.predictionLength;
        long evaluationLength = timeseriesModelDetails.coreParams.evaluationParams.testSize * numberOfTimeunits;
        output.add(Arrays.asList("Evaluation length", TimeSeriesUtil.prettyTimeStep(evaluationLength, timeunit) + " (" + this.plural(horizonsInEvaluation, "horizon") + " of " + forecastHorizonInTimeUnits + ")"));
        long numSkippedTimeSteps = timeseriesModelDetails.coreParams.evaluationParams.gapSize;
        long skippedTimeStepsInTimeUnits = numSkippedTimeSteps * numberOfTimeunits;
        if (skippedTimeStepsInTimeUnits == 0L) {
            output.add(Arrays.asList("Skipped time steps in each forecast horizon", "0 time steps"));
        } else {
            output.add(Arrays.asList("Skipped time steps in each forecast horizon", TimeSeriesUtil.prettyTimeStep(skippedTimeStepsInTimeUnits, timeunit) + " (" + this.plural(numSkippedTimeSteps, "time step") + " of " + timeStep + ")"));
        }
        return output;
    }

    private String plural(long numberOfItems, String word) {
        if (numberOfItems != 1L) {
            word = (String)word + "s";
        }
        return numberOfItems + " " + (String)word;
    }
}

