/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.docgen.validator;

import com.dataiku.dip.analysis.docgen.validator.ModelValidator;
import com.dataiku.dip.analysis.model.ModelDetailsBase;
import com.dataiku.dip.analysis.model.prediction.ClassicalPredictionModelDetails;
import com.dataiku.dip.analysis.model.prediction.PreTrainPredictionModelingParams;
import com.dataiku.dss.shadelib.com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Set;

public class DecisionTreeValidator
implements ModelValidator {
    public static final Set<PreTrainPredictionModelingParams.Algorithm> compatibleAlgorithms = Sets.newHashSet((Object[])new PreTrainPredictionModelingParams.Algorithm[]{PreTrainPredictionModelingParams.Algorithm.RANDOM_FOREST_CLASSIFICATION, PreTrainPredictionModelingParams.Algorithm.RANDOM_FOREST_REGRESSION, PreTrainPredictionModelingParams.Algorithm.GBT_CLASSIFICATION, PreTrainPredictionModelingParams.Algorithm.GBT_REGRESSION, PreTrainPredictionModelingParams.Algorithm.DECISION_TREE_CLASSIFICATION, PreTrainPredictionModelingParams.Algorithm.DECISION_TREE_REGRESSION, PreTrainPredictionModelingParams.Algorithm.MLLIB_RANDOM_FOREST, PreTrainPredictionModelingParams.Algorithm.MLLIB_DECISION_TREE, PreTrainPredictionModelingParams.Algorithm.MLLIB_GBT});

    @Override
    public void validate(ModelDetailsBase model) throws IOException {
        if (model instanceof ClassicalPredictionModelDetails && ((ClassicalPredictionModelDetails)model).modeling != null) {
            ClassicalPredictionModelDetails predictionModelDetails = (ClassicalPredictionModelDetails)model;
            if (!compatibleAlgorithms.contains((Object)predictionModelDetails.modeling.algorithm)) {
                throw new IOException("it is not supported with the algorithm " + predictionModelDetails.modeling.algorithm.name() + ".");
            }
        } else {
            throw new IOException("The model is invalid.");
        }
    }
}

