/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.clustering.guess;

import com.dataiku.dip.analysis.ml.clustering.guess.AnomalyDetectionGuesser;
import com.dataiku.dip.analysis.ml.clustering.guess.ClusteringGuesser;
import com.dataiku.dip.analysis.ml.clustering.guess.CustomClusteringGuesser;
import com.dataiku.dip.analysis.ml.clustering.guess.DefaultClusteringGuesser;
import com.dataiku.dip.analysis.ml.clustering.guess.InteractiveClusteringGuesser;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.clustering.ClusteringMLTask;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import java.util.Arrays;
import java.util.List;

public interface GuessPolicyMeta {
    public List<MLTask.BackendType> supportedBackends();

    public String analysisDefaultName();

    public String name();

    public String description();

    public String thumbnail();

    public String icon();

    public ClusteringGuesser getGuesser(ClusteringMLTask var1, MemTable var2);

    public static class CustomPolicyMeta
    implements GuessPolicyMeta {
        @Override
        public List<MLTask.BackendType> supportedBackends() {
            return Arrays.asList(MLTask.BackendType.PY_MEMORY, MLTask.BackendType.MLLIB);
        }

        @Override
        public String analysisDefaultName() {
            return "Write your own estimator for {dataset}";
        }

        @Override
        public String name() {
            return "Write Your Own Estimator";
        }

        @Override
        public String thumbnail() {
            return "predictors";
        }

        @Override
        public String icon() {
            return "dku-icon-keyboard";
        }

        @Override
        public String description() {
            return "Train your own Python or Scala models.";
        }

        @Override
        public ClusteringGuesser getGuesser(ClusteringMLTask task, MemTable table) {
            return new CustomClusteringGuesser(task, table);
        }
    }

    public static class AlgorithmsPolicyMeta
    implements GuessPolicyMeta {
        @Override
        public List<MLTask.BackendType> supportedBackends() {
            return Arrays.asList(MLTask.BackendType.PY_MEMORY, MLTask.BackendType.MLLIB, MLTask.BackendType.H2O);
        }

        @Override
        public String analysisDefaultName() {
            return "Choose Algorithms to use on {dataset}";
        }

        @Override
        public String name() {
            return "Choose Algorithms";
        }

        @Override
        public String thumbnail() {
            return "algorithms";
        }

        @Override
        public String icon() {
            return "dku-icon-menu-grid-dots";
        }

        @Override
        public String description() {
            return "Select the algorithms and the hyper parameters to use in cross-validation.";
        }

        @Override
        public ClusteringGuesser getGuesser(ClusteringMLTask task, MemTable table) {
            return new DefaultClusteringGuesser(task, table);
        }
    }

    public static class AnomalyDetectionGuessPolicyMeta
    implements GuessPolicyMeta {
        @Override
        public List<MLTask.BackendType> supportedBackends() {
            return Arrays.asList(MLTask.BackendType.PY_MEMORY, MLTask.BackendType.MLLIB);
        }

        @Override
        public String analysisDefaultName() {
            return "Anomaly detection on {dataset}";
        }

        @Override
        public String name() {
            return "Anomaly Detection";
        }

        @Override
        public String thumbnail() {
            return "anomaly";
        }

        @Override
        public String icon() {
            return "dku-icon-search";
        }

        @Override
        public String description() {
            return "Build a model to detect outliers (anomalies) in the data.";
        }

        @Override
        public ClusteringGuesser getGuesser(ClusteringMLTask task, MemTable table) {
            return new AnomalyDetectionGuesser(task, table);
        }
    }

    public static class InteractiveClusteringGuessPolicyMeta
    implements GuessPolicyMeta {
        @Override
        public List<MLTask.BackendType> supportedBackends() {
            return Arrays.asList(MLTask.BackendType.PY_MEMORY, MLTask.BackendType.MLLIB);
        }

        @Override
        public String analysisDefaultName() {
            return "Interactive Clustering on {dataset}";
        }

        @Override
        public String name() {
            return "Interactive Clustering";
        }

        @Override
        public String thumbnail() {
            return "interactive-clustering";
        }

        @Override
        public String icon() {
            return "dku-icon-hand-pointing-down";
        }

        @Override
        public String description() {
            return "Build a two-step clustering model which allows to manually modify the clustering after training.";
        }

        @Override
        public ClusteringGuesser getGuesser(ClusteringMLTask task, MemTable table) {
            return new InteractiveClusteringGuesser(task, table);
        }
    }

    public static class DefaultClusteringGuessPolicyMeta
    implements GuessPolicyMeta {
        @Override
        public List<MLTask.BackendType> supportedBackends() {
            return Arrays.asList(MLTask.BackendType.PY_MEMORY, MLTask.BackendType.MLLIB, MLTask.BackendType.H2O);
        }

        @Override
        public String analysisDefaultName() {
            return "Clustering on {dataset}";
        }

        @Override
        public String name() {
            return "K-Means";
        }

        @Override
        public String thumbnail() {
            return "kmeans";
        }

        @Override
        public String icon() {
            return "dku-icon-recipe-clustering-circle-fill";
        }

        @Override
        public String description() {
            return "Create a k-means clustering of the dataset";
        }

        @Override
        public ClusteringGuesser getGuesser(ClusteringMLTask task, MemTable data) {
            return new DefaultClusteringGuesser(task, data);
        }
    }
}

