/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.prediction;

import com.dataiku.dip.analysis.ml.prediction.ModelDataUtilsService;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.datalayer.memimpl.MemColumn;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.mec.FullModelEvaluationId;
import com.dataiku.dip.mec.LLMModelEvaluation;
import com.dataiku.dip.recipes.nlp.llm_evaluation.LLMEvaluationRecipePayloadParams;
import com.dataiku.dip.shaker.SampleBuilder;
import com.dataiku.dip.shaker.filter.FilterRequest;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.server.DataService;
import com.dataiku.dip.shaker.server.MemScriptRunner;
import com.dataiku.dip.shaker.services.TypeInferrer2;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.warnings.WarningsContext;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ModelComparisonSampleDataService {
    @Autowired
    private ModelDataUtilsService modelDataUtilsService;
    final TypeInferrer2 inferer = new TypeInferrer2();
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.modelcomparisons.sample");

    public static String getSampleId(List<FullModelEvaluationId> fmeIds, List<String> meNames, SerializedShakerScript.ShakerExplorationSampleSettings sampling) {
        Object sampleId = DigestUtils.md5Hex((String)fmeIds.stream().map(FullModelEvaluationId::toString).collect(Collectors.joining("-")));
        sampleId = (String)sampleId + DigestUtils.md5Hex((String)meNames.stream().sorted().collect(Collectors.joining("-")));
        logger.info((Object)("Compute sample id for " + (String)sampleId + " SAMPLING= " + JSON.json((Object)sampling)));
        sampleId = (String)sampleId + "-" + DigestUtils.md5Hex((String)JSON.json((Object)((Object)sampling.selection))) + sampling._refreshTrigger;
        return sampleId;
    }

    public synchronized MemScriptRunner.TableWithReport getUncachedFiltered_NT(String projectKey, String modelComparisonId, List<FullModelEvaluationId> fmeIds, SerializedShakerScript script, FilterRequest filters) throws Exception {
        return this.getUncachedFiltered_NT(projectKey, modelComparisonId, fmeIds, script.explorationSampling, filters, script.sorting);
    }

    public synchronized MemScriptRunner.TableWithReport getUncachedFiltered_NT(String projectKey, String modelComparisonId, List<FullModelEvaluationId> fmeIds, SerializedShakerScript.ShakerExplorationSampleSettings explorationSampling, FilterRequest filters, List<SerializedShakerScript.TableSorting> sorting) throws Exception {
        MemScriptRunner.TableWithReport twr = this.getUncachedUnfiltered_NT(projectKey, modelComparisonId, fmeIds, explorationSampling);
        this.modelDataUtilsService.applyFiltersAndSorts(twr, filters, sorting);
        return twr;
    }

    public synchronized MemScriptRunner.TableWithReport getUncachedUnfiltered_NT(String projectKey, String modelComparisonId, List<FullModelEvaluationId> fmeIds, SerializedShakerScript.ShakerExplorationSampleSettings sampling) throws Exception {
        try (FutureProgress.AutocloseableFutureProgressState state = FutureProgress.pushAutoCloseableState((String)"Computing", (double)4.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
            ArrayList<LLMModelEvaluation> llmModelEvaluations = new ArrayList<LLMModelEvaluation>();
            ArrayList<String> meNames = new ArrayList<String>();
            for (FullModelEvaluationId fmeId : fmeIds) {
                LLMModelEvaluation me = fmeId.getLLMModelEvaluation();
                llmModelEvaluations.add(me);
                meNames.add(me.userMeta.name);
            }
            String sampleId = ModelComparisonSampleDataService.getSampleId(fmeIds, meNames, sampling);
            logger.info((Object)("Model comparison sample disk sample id is " + sampleId));
            Schema schema = this.getSampleSchema(fmeIds);
            long before = System.currentTimeMillis();
            MemScriptRunner.TableWithReport ret = new MemScriptRunner.TableWithReport();
            SampleBuilder.SampleMeta sampleToRead = SampleBuilder.getModelComparisonsSampleMeta(projectKey, modelComparisonId, sampleId);
            FutureProgress.updateState((double)1.0);
            if (sampleToRead != null) {
                logger.info((Object)"Disk sample cache hit");
            } else {
                logger.info((Object)"Disk sample cache miss");
                SampleBuilder.clearModelComparisonSamples(projectKey, modelComparisonId);
                try (FutureProgress.AutocloseableFutureProgressState buildingState = FutureProgress.pushAutoCloseableState((String)"Building sample");){
                    SampleBuilder.buildModelComparisonSample(llmModelEvaluations, sampleId, schema, modelComparisonId, projectKey);
                }
                sampleToRead = SampleBuilder.getModelComparisonsSampleMeta(projectKey, modelComparisonId, sampleId);
            }
            assert (sampleToRead != null);
            FutureProgress.updateState((double)2.0);
            logger.info((Object)("Opening sample : " + sampleId));
            ret.usedSample = sampleToRead;
            try (FutureProgress.AutocloseableFutureProgressState readingState = FutureProgress.pushAutoCloseableState((String)"Reading sample");){
                MemTable table;
                try {
                    table = SampleBuilder.readModelComparisonSample(projectKey, modelComparisonId, sampleId);
                }
                catch (FileNotFoundException e) {
                    try (FutureProgress.AutocloseableFutureProgressState buildingState = FutureProgress.pushAutoCloseableState((String)"Rebuilding sample");){
                        SampleBuilder.buildModelComparisonSample(llmModelEvaluations, sampleId, schema, modelComparisonId, projectKey);
                    }
                    table = SampleBuilder.readModelComparisonSample(projectKey, modelComparisonId, sampleId);
                }
                ret.table = table;
                if (ret.table.nrows() == 0) {
                    throw new IllegalArgumentException("The intersection of the comparable input dataset samples is empty.");
                }
                for (MemColumn cd : ret.table.columnsList) {
                    cd.datasetSchemaColumn = schema.getColumn(cd.getName());
                }
                ret.initialRows = ret.table.nrows();
                ret.initialCols = ret.table.ncols();
                logger.info((Object)("Reading sample done, read " + ret.table.nrows() + " rows"));
            }
            FutureProgress.updateState((double)3.0);
            ret.table.compact();
            FutureProgress.updateState((double)4.0);
            ret.warnings = new WarningsContext.SerializedWarnings();
            try (FutureProgress.AutocloseableFutureProgressState inferringState = FutureProgress.pushAutoCloseableState((String)"Detecting types");){
                String infererCacheKey = modelComparisonId + JSON.json((Object)sampling);
                this.inferer.processFullAuto(infererCacheKey, ret.table);
            }
            FutureProgress.updateState((double)5.0);
            long inferDone = System.currentTimeMillis();
            logger.info((Object)("ModelComparisonSampleDataService done time = " + (inferDone - before)));
            MemScriptRunner.TableWithReport tableWithReport = ret;
            return tableWithReport;
        }
    }

    public Schema getSampleSchema(List<FullModelEvaluationId> fmeIds) throws IOException {
        Schema schema = new Schema();
        schema.addColumn("Input", Type.STRING);
        for (FullModelEvaluationId fmeId : fmeIds) {
            String contextColumnName;
            File sampleSchemaFile;
            LLMModelEvaluation me = fmeId.getLLMModelEvaluation();
            String meName = me.userMeta.name;
            if (!me.hasInput()) {
                throw new IllegalArgumentException(String.format("The comparable %s does not have an input column. We cannot provide a row by row comparison in this case.", meName));
            }
            if (me.hasOutput()) {
                schema.addColumn("Output for " + meName, Type.STRING);
            }
            if (me.hasContext()) {
                schema.addColumn("Context for " + meName, Type.STRING);
            }
            if (me.hasGroundTruth()) {
                schema.addColumn("Ground truth for " + meName, Type.STRING);
            }
            if (!(sampleSchemaFile = fmeId.getEvaluationFile("sample_with_metrics_schema.json")).exists()) {
                throw new UnsupportedOperationException("Missing model evaluation sample schema in evaluationId " + fmeId.evaluationId + ". Try to run a new evaluation.");
            }
            Schema sampleSchema = (Schema)JSON.parseFile((File)sampleSchemaFile, Schema.class);
            String inputColumnName = me.inputFormat == LLMEvaluationRecipePayloadParams.LLMEvalInputFormat.PROMPT_RECIPE ? "dkuReconstructedInput" : me.inputColumnName;
            String outputColumnName = me.inputFormat == LLMEvaluationRecipePayloadParams.LLMEvalInputFormat.PROMPT_RECIPE ? "dkuParsedOutput" : me.outputColumnName;
            String string = contextColumnName = me.inputFormat == LLMEvaluationRecipePayloadParams.LLMEvalInputFormat.PROMPT_RECIPE || me.inputFormat == LLMEvaluationRecipePayloadParams.LLMEvalInputFormat.DATAIKU_ANSWERS ? "dkuParsedContexts" : me.contextColumnName;
            if (inputColumnName != null) {
                sampleSchema.removeColumn(inputColumnName);
            }
            if (outputColumnName != null) {
                sampleSchema.removeColumn(outputColumnName);
            }
            if (contextColumnName != null) {
                sampleSchema.removeColumn(contextColumnName);
            }
            if (me.groundTruthColumnName != null) {
                sampleSchema.removeColumn(me.groundTruthColumnName);
            }
            sampleSchema.getColumns().forEach(column -> schema.addColumn(column.getName() + " for " + meName, Type.DOUBLE));
        }
        return schema;
    }

    public DataService.ColumnDetailedAnalysis getDetailedColumnAnalysis(String projectKey, String modelComparisonId, List<FullModelEvaluationId> fmeIds, SerializedShakerScript ss, String column, int alphanumMaxResults) throws Exception {
        MemTable table = this.getUncachedUnfiltered_NT((String)projectKey, (String)modelComparisonId, fmeIds, (SerializedShakerScript.ShakerExplorationSampleSettings)ss.explorationSampling).table;
        return this.modelDataUtilsService.getDetailedColumnAnalysis(table, ss, column, alphanumMaxResults);
    }

    public List<SampleBasicInfo> listSamples(String projectKey, boolean allProjects) {
        return SampleBuilder.listModelComparisonSamples(projectKey, allProjects).stream().map(file -> new SampleBasicInfo(file.getName(), file.lastModified(), file.length())).collect(Collectors.toList());
    }

    public int clearSamples(String projectKey, long minDays, boolean allProjects) {
        int nbSamplesDeleted = 0;
        Collection<File> samples = SampleBuilder.listModelComparisonSamples(projectKey, allProjects);
        LocalDate today = LocalDate.now();
        for (File sample : samples) {
            Instant lastModifiedInstant = Instant.ofEpochMilli(sample.lastModified());
            LocalDate lastModifiedDate = lastModifiedInstant.atZone(ZoneId.systemDefault()).toLocalDate();
            long daysBetween = ChronoUnit.DAYS.between(lastModifiedDate, today);
            if (daysBetween <= minDays) continue;
            try {
                logger.info((Object)String.format("Deleting model comparison sample :%s", sample.getName()));
                if (!sample.delete()) continue;
                ++nbSamplesDeleted;
            }
            catch (Exception e) {
                logger.warn((Object)String.format("Failed to delete the model comparison sample %s", sample.getName()), (Throwable)e);
            }
        }
        return nbSamplesDeleted;
    }

    public static class SampleBasicInfo {
        public String filename;
        public long created;
        public long size;

        public SampleBasicInfo(String filename, long created, long size) {
            this.filename = filename;
            this.created = created;
            this.size = size;
        }
    }
}

