/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.prediction;

import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.prediction.split.SplitDesc;
import com.dataiku.dip.analysis.ml.shared.ResultsReaderBase;
import com.dataiku.dip.analysis.model.core.SavedModelOriginInfo;
import com.dataiku.dip.analysis.model.prediction.ResolvedPredictionCoreParams;
import com.dataiku.dip.analysis.model.prediction.ResolvedTimeseriesForecastingCoreParams;
import com.dataiku.dip.analysis.model.prediction.TimeseriesForecastingModelPerf;
import com.dataiku.dip.analysis.model.prediction.TimeseriesPerFoldMetrics;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class PredictionKFoldMetricsReader {
    public static TimeseriesPerFoldMetrics getPerFoldMetrics(FullModelId fmi) throws IOException {
        if (fmi.isPartitionedBaseModel()) {
            throw new IllegalArgumentException("Partitioned models not supported");
        }
        ResolvedPredictionCoreParams pcp = (ResolvedPredictionCoreParams)fmi.getResolvedCoreParams();
        if (pcp instanceof ResolvedTimeseriesForecastingCoreParams) {
            boolean AreModelingParamsRelevant;
            boolean bl = AreModelingParamsRelevant = fmi.type.equals((Object)FullModelId.Type.ANALYSIS) || fmi.getSmOriginFile().exists() && fmi.getSmOrigin().origin.equals((Object)SavedModelOriginInfo.Origin.EXPORTED_FROM_ANALYSIS);
            if (AreModelingParamsRelevant && ((ResolvedTimeseriesForecastingCoreParams)pcp).customTrainTestSplit) {
                int numFolds = ((ResolvedTimeseriesForecastingCoreParams)pcp).customTrainTestIntervals.size();
                return TimeseriesPerFoldMetrics.computeTimeseriesPerFoldMetrics(fmi, PredictionKFoldMetricsReader.getTimeseriesPerFoldPerfs(fmi, numFolds));
            }
            SplitDesc splitDesc = ResultsReaderBase.readSplitDesc(fmi);
            int numFolds = splitDesc.params.nFolds;
            return TimeseriesPerFoldMetrics.computeTimeseriesPerFoldMetrics(fmi, PredictionKFoldMetricsReader.getTimeseriesPerFoldPerfs(fmi, numFolds));
        }
        throw new IllegalArgumentException("Unsupported core params: " + pcp.getClass().getSimpleName());
    }

    private static Map<String, TimeseriesForecastingModelPerf> getTimeseriesPerFoldPerfs(FullModelId fmi, int numFolds) throws IOException {
        HashMap<String, TimeseriesForecastingModelPerf> perFoldPerf = new HashMap<String, TimeseriesForecastingModelPerf>();
        for (int i = 0; i < numFolds; ++i) {
            perFoldPerf.put(String.valueOf(i + 1), fmi.getIndividualFoldTimeseriesForecastingPerf(i));
        }
        return perFoldPerf;
    }
}

