/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.prediction.guess;

import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.analysis.model.prediction.TimestepParams;
import com.dataiku.dip.datalayer.memimpl.MemRow;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.shaker.types.AnyTemporal;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SortedSetMultimap;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class TimestepParamsComputer {
    private static final int MAX_RECORDS = 10000;
    private static final String SINGLE_TIMESERIES_IDENTIFIER = "SINGLE_TIMESERIES";
    private static AnyTemporal anyTemporalMeaning = new AnyTemporal();

    private TimestepParamsComputer() {
    }

    private static String buildTimeseriesIdentifier(PredictionMLTask.TimeseriesForecastingMLTask task, MemRow row, MemTable table) {
        if (task.timeseriesIdentifiers.isEmpty()) {
            return SINGLE_TIMESERIES_IDENTIFIER;
        }
        StringBuilder timeseriesIdentifierBuilder = new StringBuilder();
        for (String timeseriesIdentifierColumn : task.timeseriesIdentifiers) {
            timeseriesIdentifierBuilder.append(timeseriesIdentifierColumn + "\t");
            timeseriesIdentifierBuilder.append(row.get(table.column(timeseriesIdentifierColumn)) + "\n");
        }
        return timeseriesIdentifierBuilder.toString();
    }

    private static Long parseDateTime(String v) {
        long ts = anyTemporalMeaning.longValue(v);
        if (ts == Long.MAX_VALUE) {
            return null;
        }
        return ts;
    }

    private static Map<String, Collection<Long>> collectTimestampsPerTimeseries(PredictionMLTask.TimeseriesForecastingMLTask task, MemTable table) {
        SortedSetMultimap timestampsPerTimeseries = MultimapBuilder.hashKeys().treeSetValues().build();
        int nRows = Math.min(10000, table.nrows());
        for (int i = 0; i < nRows; ++i) {
            MemRow row = table.rows.get(i);
            String timeseriesIdentifier = TimestepParamsComputer.buildTimeseriesIdentifier(task, row, table);
            Long rowTimestamp = TimestepParamsComputer.parseDateTime(row.get(table.column(task.timeVariable)));
            timestampsPerTimeseries.put((Object)timeseriesIdentifier, (Object)rowTimestamp);
        }
        return timestampsPerTimeseries.asMap();
    }

    public static void updateTimestepParams(PredictionMLTask.TimeseriesForecastingMLTask task, MemTable table) {
        Map<String, Collection<Long>> timestampsPerTimeseries;
        if (task.timestepParams == null) {
            task.timestepParams = new TimestepParams();
        }
        if ((timestampsPerTimeseries = TimestepParamsComputer.collectTimestampsPerTimeseries(task, table)).isEmpty()) {
            task.timestepParams.numberOfTimeunits = 0L;
            return;
        }
        ArrayList<Long> allTimeDiffs = new ArrayList<Long>();
        HashSet<Long> firstTimestamps = new HashSet<Long>();
        for (Collection<Long> datetimes : timestampsPerTimeseries.values()) {
            Long previous;
            if (datetimes.size() <= 1) continue;
            Iterator<Long> it = datetimes.iterator();
            Long firstTimestamp = previous = it.next();
            while (it.hasNext()) {
                Long next = it.next();
                allTimeDiffs.add(next - previous);
                if (next < firstTimestamp) {
                    firstTimestamp = next;
                }
                previous = next;
            }
            firstTimestamps.add(firstTimestamp);
        }
        Collections.sort(allTimeDiffs);
        Long medianTimestepInMillis = (Long)allTimeDiffs.get((allTimeDiffs.size() - 1) / 2);
        Duration medianTimestepDuration = Duration.ofMillis(medianTimestepInMillis);
        int endMonthIndex = 0;
        int dayOfMonthIndex = 31;
        if (firstTimestamps.size() == 1) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date((Long)firstTimestamps.iterator().next()));
            endMonthIndex = calendar.get(2) + 1;
            dayOfMonthIndex = calendar.get(5);
        }
        if (medianTimestepDuration.compareTo(Duration.of(990L, ChronoUnit.MILLIS)) < 0) {
            task.timestepParams.timeunit = TimestepParams.Timeunit.MILLISECOND;
            task.timestepParams.numberOfTimeunits = medianTimestepInMillis;
        } else if (medianTimestepDuration.compareTo(Duration.of(1010L, ChronoUnit.MILLIS)) < 0) {
            task.timestepParams.timeunit = TimestepParams.Timeunit.SECOND;
            task.timestepParams.numberOfTimeunits = 1L;
        } else if (medianTimestepDuration.compareTo(Duration.of(59L, ChronoUnit.SECONDS)) < 0) {
            task.timestepParams.timeunit = TimestepParams.Timeunit.SECOND;
            task.timestepParams.numberOfTimeunits = medianTimestepDuration.getSeconds();
        } else if (medianTimestepDuration.compareTo(Duration.of(61L, ChronoUnit.SECONDS)) < 0) {
            task.timestepParams.timeunit = TimestepParams.Timeunit.MINUTE;
            task.timestepParams.numberOfTimeunits = 1L;
        } else if (medianTimestepDuration.compareTo(Duration.of(59L, ChronoUnit.MINUTES)) < 0) {
            task.timestepParams.timeunit = TimestepParams.Timeunit.MINUTE;
            task.timestepParams.numberOfTimeunits = medianTimestepDuration.toMinutes();
        } else if (medianTimestepDuration.compareTo(Duration.of(61L, ChronoUnit.MINUTES)) < 0) {
            task.timestepParams.timeunit = TimestepParams.Timeunit.HOUR;
            task.timestepParams.numberOfTimeunits = 1L;
        } else if (medianTimestepDuration.compareTo(Duration.of(1430L, ChronoUnit.MINUTES)) < 0) {
            task.timestepParams.timeunit = TimestepParams.Timeunit.HOUR;
            task.timestepParams.numberOfTimeunits = medianTimestepDuration.toHours();
        } else if (medianTimestepDuration.compareTo(Duration.of(1450L, ChronoUnit.MINUTES)) < 0) {
            task.timestepParams.timeunit = TimestepParams.Timeunit.DAY;
            task.timestepParams.numberOfTimeunits = 1L;
        } else if (medianTimestepDuration.compareTo(Duration.of(167L, ChronoUnit.HOURS)) < 0) {
            task.timestepParams.timeunit = TimestepParams.Timeunit.DAY;
            task.timestepParams.numberOfTimeunits = medianTimestepDuration.toDays();
        } else if (medianTimestepDuration.compareTo(Duration.of(169L, ChronoUnit.HOURS)) < 0) {
            task.timestepParams.timeunit = TimestepParams.Timeunit.WEEK;
            task.timestepParams.numberOfTimeunits = 1L;
        } else if (medianTimestepDuration.compareTo(Duration.of(710L, ChronoUnit.HOURS)) < 0) {
            task.timestepParams.timeunit = TimestepParams.Timeunit.WEEK;
            task.timestepParams.numberOfTimeunits = (long)((double)medianTimestepDuration.toDays() / 7.0);
        } else if (medianTimestepDuration.compareTo(Duration.of(730L, ChronoUnit.HOURS)) < 0) {
            task.timestepParams.timeunit = TimestepParams.Timeunit.MONTH;
            task.timestepParams.numberOfTimeunits = 1L;
            task.timestepParams.monthlyAlignment = dayOfMonthIndex;
        } else if (medianTimestepDuration.compareTo(Duration.of(365L, ChronoUnit.DAYS)) < 0) {
            task.timestepParams.timeunit = TimestepParams.Timeunit.MONTH;
            task.timestepParams.numberOfTimeunits = (long)((double)medianTimestepDuration.toDays() / 30.0);
            task.timestepParams.monthlyAlignment = dayOfMonthIndex;
            if (task.timestepParams.numberOfTimeunits % 3L == 0L) {
                task.timestepParams.timeunit = TimestepParams.Timeunit.QUARTER;
                task.timestepParams.numberOfTimeunits /= 3L;
                task.timestepParams.unitAlignment = endMonthIndex % 3 == 1 ? 1 : (endMonthIndex % 3 == 2 ? 2 : 3);
            }
        } else {
            task.timestepParams.timeunit = TimestepParams.Timeunit.YEAR;
            task.timestepParams.numberOfTimeunits = (long)((double)medianTimestepDuration.toDays() / 365.0);
            task.timestepParams.monthlyAlignment = dayOfMonthIndex;
            if (endMonthIndex == 0) {
                endMonthIndex = 12;
            }
            task.timestepParams.unitAlignment = endMonthIndex;
        }
        TimestepParamsComputer.updateTimeAlignments(task, table);
    }

    public static void updateTimeAlignments(PredictionMLTask.TimeseriesForecastingMLTask task, MemTable table) {
        if (task.timestepParams == null) {
            return;
        }
        Map<String, Collection<Long>> timestampsPerTimeseries = TimestepParamsComputer.collectTimestampsPerTimeseries(task, table);
        if (timestampsPerTimeseries.isEmpty()) {
            return;
        }
        HashMap<Integer, Integer> dayOfMonthFrequency = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> monthFrequency = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> dayOfWeekFrequency = new HashMap<Integer, Integer>();
        for (Collection<Long> datetimes : timestampsPerTimeseries.values()) {
            if (datetimes.size() <= 1) continue;
            for (Long timestamp : datetimes) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(new Date(timestamp));
                int dayOfMonth = calendar.get(5);
                int month = calendar.get(2) + 1;
                int dayOfWeek = calendar.get(7);
                dayOfMonthFrequency.put(dayOfMonth, dayOfMonthFrequency.getOrDefault(dayOfMonth, 0) + 1);
                monthFrequency.put(month, monthFrequency.getOrDefault(month, 0) + 1);
                dayOfWeekFrequency.put(dayOfWeek, dayOfWeekFrequency.getOrDefault(dayOfWeek, 0) + 1);
            }
        }
        if (dayOfMonthFrequency.isEmpty() || monthFrequency.isEmpty() || dayOfWeekFrequency.isEmpty()) {
            return;
        }
        int mostFrequentDayOfMonth = (Integer)Collections.max(dayOfMonthFrequency.entrySet(), Map.Entry.comparingByValue()).getKey();
        int mostFrequentMonth = (Integer)Collections.max(monthFrequency.entrySet(), Map.Entry.comparingByValue()).getKey();
        int mostFrequentDayOfWeek = (Integer)Collections.max(dayOfWeekFrequency.entrySet(), Map.Entry.comparingByValue()).getKey();
        switch (task.timestepParams.timeunit) {
            case WEEK: {
                task.timestepParams.endOfWeekDay = mostFrequentDayOfWeek;
                break;
            }
            case MONTH: {
                task.timestepParams.monthlyAlignment = mostFrequentDayOfMonth;
                break;
            }
            case QUARTER: {
                task.timestepParams.monthlyAlignment = mostFrequentDayOfMonth;
                task.timestepParams.unitAlignment = mostFrequentMonth % 3;
                if (task.timestepParams.unitAlignment != 0) break;
                task.timestepParams.unitAlignment = 3;
                break;
            }
            case YEAR: {
                task.timestepParams.monthlyAlignment = mostFrequentDayOfMonth;
                task.timestepParams.unitAlignment = mostFrequentMonth;
                break;
            }
        }
    }
}

