/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model.prediction;

import com.dataiku.dip.analysis.model.prediction.PredictionModelIntrinsicPerf;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class TimeseriesForecastingModelIntrinsicPerf
extends PredictionModelIntrinsicPerf {
    public int minTimeseriesSizeForScoring;
    public int maxUsedTimestepsForScoring;
    public int totalNbOfTimeseries;
    public List<ModelCoefficients> modelCoefficients;
    public List<InformationCriterion> informationCriteria;

    public static class DoubleOrInfinityTypeAdapter
    extends TypeAdapter<DoubleOrInfinity> {
        public void write(JsonWriter out, DoubleOrInfinity value) throws IOException {
            String infinityString = value.getInfinityString();
            if (infinityString != null) {
                out.value(infinityString);
            } else {
                out.value((Number)value.value);
            }
        }

        public DoubleOrInfinity read(JsonReader in) throws IOException {
            DoubleOrInfinity result = new DoubleOrInfinity();
            double value = 0.0;
            boolean isInfinite = false;
            JsonToken token = in.peek();
            if (token == JsonToken.BEGIN_OBJECT) {
                in.beginObject();
                block16: while (in.hasNext()) {
                    String name;
                    switch (name = in.nextName()) {
                        case "value": {
                            value = in.nextDouble();
                            continue block16;
                        }
                        case "isInfinite": {
                            isInfinite = in.nextBoolean();
                            continue block16;
                        }
                    }
                    in.skipValue();
                }
                in.endObject();
            } else if (token == JsonToken.NUMBER) {
                value = in.nextDouble();
            } else if (token == JsonToken.STRING) {
                String special;
                switch (special = in.nextString()) {
                    case "Infinity": {
                        isInfinite = true;
                        value = 1.0;
                        break;
                    }
                    case "-Infinity": {
                        isInfinite = true;
                        value = -1.0;
                        break;
                    }
                    default: {
                        throw new JsonParseException("Expected number or string ['Infinity', '-Infinity'] for DoubleOrInfinity instance but got: " + special);
                    }
                }
            }
            if (isInfinite && value != 1.0 && value != -1.0) {
                throw new JsonParseException("Invalid value for infinity: expected 1.0 or -1.0, got " + value);
            }
            result.value = value;
            result.isInfinite = isInfinite;
            return result;
        }
    }

    @JsonAdapter(value=DoubleOrInfinityTypeAdapter.class)
    public static class DoubleOrInfinity {
        private Double value;
        private boolean isInfinite;

        public Double getValue() {
            return this.value;
        }

        public boolean isInfinite() {
            return this.isInfinite;
        }

        private String getInfinityString() {
            if (this.isInfinite) {
                if (this.value == 1.0) {
                    return "+\u221e";
                }
                if (this.value == -1.0) {
                    return "-\u221e";
                }
            }
            return null;
        }

        public String toString() {
            String infinityString = this.getInfinityString();
            return infinityString != null ? infinityString : String.format("%.4f", this.value);
        }
    }

    public static class InformationCriterion {
        public String displayName;
        public Map<String, DoubleOrInfinity> values;
    }

    public static class ModelCoefficients {
        public String displayName;
        public Map<String, Double> values;
        public Map<String, Double> pvalues;
        public Map<String, Double> tvalues;
        public Map<String, Double> stderrs;
        public boolean isExternalFeature;
    }
}

