/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model.preprocessing;

import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.preprocessing.CatFeaturePreprocessingParams;
import com.dataiku.dip.analysis.model.preprocessing.ImageFeaturePreprocessingParams;
import com.dataiku.dip.analysis.model.preprocessing.NumFeaturePreprocessingParams;
import com.dataiku.dip.analysis.model.preprocessing.TextFeaturePreprocessingParams;
import com.dataiku.dip.analysis.model.preprocessing.VectorFeaturePreprocessingParams;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class FeaturePreprocessingParams {
    public String name;
    public Role role;
    public FeatureType type;
    public FeatureState state;
    public FeatureHandlingReason autoReason;
    public String customHandlingCode = "";
    public boolean customProcessorWantsMatrix = false;
    public String sendToInput = "main";
    private static Logger logger;

    public abstract void check(String var1, MLTask var2) throws Exception;

    public Optional<String> getUsedConnection() {
        return Optional.empty();
    }

    public boolean replaceConnections(Map<String, String> connectionsReplacements) {
        return false;
    }

    public abstract boolean usesCustomHandling();

    static {
        JSON.registerAdapter(FeaturePreprocessingParams.class, (Object)new JSON.Adapter<FeaturePreprocessingParams>(){

            public FeaturePreprocessingParams deserialize(JsonElement jsonElement, Type scriptType, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
                JsonObject jsonObj = jsonElement.getAsJsonObject();
                if (jsonObj.get("type").getAsString().equals("CATEGORY")) {
                    return (FeaturePreprocessingParams)jsonDeserializationContext.deserialize(jsonElement, CatFeaturePreprocessingParams.class);
                }
                if (jsonObj.get("type").getAsString().equals("TEXT")) {
                    return (FeaturePreprocessingParams)jsonDeserializationContext.deserialize(jsonElement, TextFeaturePreprocessingParams.class);
                }
                if (jsonObj.get("type").getAsString().equals("VECTOR")) {
                    return (FeaturePreprocessingParams)jsonDeserializationContext.deserialize(jsonElement, VectorFeaturePreprocessingParams.class);
                }
                if (jsonObj.get("type").getAsString().equals("IMAGE")) {
                    return (FeaturePreprocessingParams)jsonDeserializationContext.deserialize(jsonElement, ImageFeaturePreprocessingParams.class);
                }
                try {
                    jsonObj.get("impute_constant_value").getAsDouble();
                }
                catch (Exception e) {
                    boolean constant;
                    boolean input = StringUtils.equals((String)"INPUT", (String)jsonObj.get("role").getAsString());
                    boolean impute = jsonObj.get("missing_handling") != null && StringUtils.equals((String)"IMPUTE", (String)jsonObj.get("missing_handling").getAsString());
                    boolean bl = constant = jsonObj.get("missing_impute_with") != null && StringUtils.equals((String)"CONSTANT", (String)jsonObj.get("missing_impute_with").getAsString());
                    if (!(input && impute && constant)) {
                        logger.info((Object)"Invalid numerical impute value (not used). Replace by 0.");
                        jsonObj.addProperty("impute_constant_value", (Number)0.0);
                    }
                    if (jsonObj.get("impute_constant_value") == null) {
                        throw ErrorContext.iae((String)"Unspecified impute value");
                    }
                    String str = jsonObj.get("impute_constant_value").getAsString();
                    throw ErrorContext.iaef((String)"Invalid impute value for a numeric feature: '%s'", (Object)str, (Object[])new Object[0]);
                }
                return (FeaturePreprocessingParams)jsonDeserializationContext.deserialize(jsonElement, NumFeaturePreprocessingParams.class);
            }

            public JsonElement serialize(FeaturePreprocessingParams modelingParams, Type type, JsonSerializationContext ctx) {
                return ctx.serialize((Object)modelingParams);
            }
        });
        logger = Logger.getLogger((String)"dku.analysis.preprocessing");
    }

    public static class FeatureState {
        public boolean userModified;
        public boolean autoModifiedByDSS;
        public FeaturePreprocessingParams previousSettings;
        public FeaturePreprocessingParams dssWantsToSet;
        public String recordedMeaning;
    }

    public static enum FeatureType {
        NUMERIC,
        CATEGORY,
        VECTOR,
        TEXT,
        IMAGE;

    }

    public static enum FeatureHandlingReason {
        REJECT_ZERO_VARIANCE,
        REJECT_MISSING,
        REJECT_IDENTIFIER,
        REJECT_DEFAULT_TEXT_HANDLING,
        REJECT_CARDINALITY;

    }

    public static enum Role {
        INPUT,
        REJECT,
        TARGET,
        WEIGHT,
        TIMESERIES_IDENTIFIER,
        TIME,
        INPUT_PAST_ONLY,
        TREATMENT,
        PROFILING;


        public boolean isInput() {
            return this == INPUT || this == INPUT_PAST_ONLY;
        }
    }
}

