/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.datamodel.actual.sagemaker;

import com.dataiku.dip.apideployer.datamodel.actual.AbstractFullyManagedDeploymentHeavyStatus;
import com.dataiku.dip.apideployer.datamodel.actual.DeploymentStatusReport;
import com.dataiku.dip.apideployer.datamodel.actual.sagemaker.SageMakerDeploymentStatusReporter;
import com.dataiku.dip.apideployer.datamodel.actual.sagemaker.SageMakerEndpoint;
import com.dataiku.dip.apideployer.deploymentinfo.SageMakerDeploymentInfo;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.EndpointSummary;
import com.dataiku.lambda.client.SageMakerLambdaAPIClient;
import com.dataiku.lambda.model.serverconfig.LambdaEndpointConfig;
import com.dataiku.lambda.model.studioconfig.ApiEndpointQuery;
import javax.annotation.Nullable;

public class SageMakerDeploymentHeavyStatus
extends AbstractFullyManagedDeploymentHeavyStatus {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.deployer.deployment.actual.sagemaker.heavy-status");

    public SageMakerDeploymentHeavyStatus() {
    }

    public SageMakerDeploymentHeavyStatus(String deploymentId, String infraId) {
        super(deploymentId, infraId);
    }

    public void checkEndpointHealth(@Nullable EndpointSummary endpointSummary, @Nullable SageMakerDeploymentInfo lastDeploymentInfo, boolean isDeploymentEnabled) {
        DeploymentStatusReport basicStatusReport = this.getDeploymentStatusReporter().computeBasicCheck(endpointSummary, lastDeploymentInfo, isDeploymentEnabled);
        this.mergeMessagesAndHealthWithSeverity(basicStatusReport.statusMessages, basicStatusReport.getHealth());
    }

    public void checkEndpointHealth(SageMakerEndpoint endpoint, boolean isDeploymentEnabled) {
        DeploymentStatusReport basicStatusReport = this.getDeploymentStatusReporter().computeBasicCheck(endpoint, isDeploymentEnabled);
        this.mergeMessagesAndHealthWithSeverity(basicStatusReport.statusMessages, basicStatusReport.getHealth());
    }

    @Override
    protected SageMakerDeploymentStatusReporter getDeploymentStatusReporter() {
        return new SageMakerDeploymentStatusReporter(this.deploymentId, this.infraId);
    }

    @Override
    public ApiEndpointQuery adaptQueryForInfraType(ApiEndpointQuery query, LambdaEndpointConfig.EndpointType endpointType) {
        return SageMakerLambdaAPIClient.updateQueryToSageMakerExpectedFormat(query, endpointType);
    }

    @Override
    protected DKULogger getLogger() {
        return logger;
    }
}

