/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.monitoring;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.apideployer.datamodel.actual.AbstractDeploymentBasicInfo;
import com.dataiku.dip.apideployer.datamodel.actual.AbstractInfraBasicInfo;
import com.dataiku.dip.apideployer.datamodel.config.AbstractAPIDeploymentInfra;
import com.dataiku.dip.apideployer.datamodel.config.AbstractDeployment;
import com.dataiku.dip.apideployer.deployments.APIServiceDeploymentsService;
import com.dataiku.dip.apideployer.deployments.AbstractDeploymentsService;
import com.dataiku.dip.apideployer.infra.ApiNodeInfrasService;
import com.dataiku.dip.apideployer.monitoring.AbstractApiEndpointUnifiedMonitoringActivityMetrics;
import com.dataiku.dip.apideployer.monitoring.ActivityMetric;
import com.dataiku.dip.apideployer.monitoring.ActivityMetricCodes;
import com.dataiku.dip.apideployer.monitoring.DeploymentAndEndpoint;
import com.dataiku.dip.apideployer.monitoring.ExternalApiEndpointUnifiedMonitoringActivityMetrics;
import com.dataiku.dip.apideployer.monitoring.ManagedApiEndpointUnifiedMonitoringActivityMetrics;
import com.dataiku.dip.apideployer.monitoring.MetricUtils;
import com.dataiku.dip.apideployer.monitoring.MetricsAggregation;
import com.dataiku.dip.apideployer.monitoring.RrdUtils;
import com.dataiku.dip.apideployer.monitoring.ScopeAndEndpoint;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.UnifiedMonitoringSettings;
import com.dataiku.dip.dao.UnifiedMonitoringSettingsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.IllegalConfigurationException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.maintainance.InterruptAndPrintStackTraceAfterTimeoutTask;
import com.dataiku.dip.maintainance.UnloggedJob;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ConnectionsService;
import com.dataiku.dip.server.services.NodesService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.unifiedmonitoring.externalendpoint.UnifiedMonitoringExternalEndpointsScope;
import com.dataiku.dip.unifiedmonitoring.externalendpoint.UnifiedMonitoringExternalEndpointsScopeManager;
import com.dataiku.dip.utils.AutoCloseableLock;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.NamedLock;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.FilenameUtils;
import com.dataiku.lambda.model.serverconfig.ActivityMonitoringSettings;
import java.io.File;
import java.io.IOException;
import java.time.Period;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import org.quartz.CronScheduleBuilder;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;
import org.rrd4j.ConsolFun;
import org.rrd4j.core.FetchData;
import org.rrd4j.core.RrdDb;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiEndpointActivityMonitoringService {
    private Scheduler scheduler;
    private final List<GraphiteLine> rrdPushBuffer = Collections.synchronizedList(new ArrayList());
    private static final int WRITE_PERIOD_MINUTES = 1;
    private static final int BUFFER_DELAY_SECONDS = 60;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private APIServiceDeploymentsService apiServiceDeploymentsService;
    @Autowired
    private ApiNodeInfrasService apiNodeInfrasService;
    @Autowired
    private NodesService nodesService;
    @Autowired
    private ConnectionsService connectionsService;
    @Autowired
    private UnifiedMonitoringSettingsDAO unifiedMonitoringSettingsDAO;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.unifiedmonitoring.activityMonitoringService");

    @PostConstruct
    public void init() throws SchedulerException, IOException {
        if (!this.nodesService.isOrHasLocalDeployer()) {
            return;
        }
        logger.infoV("Scheduling persisting activity metrics from activity metrics buffer to rrd files with %s minutes frequency", new Object[]{1});
        this.scheduler = StdSchedulerFactory.getDefaultScheduler();
        this.scheduler.start();
        JobDetail job = JobBuilder.newJob(FlushActivityBufferToRrdFilesTask.class).withIdentity(new JobKey("flush-activity-buffer-to-rrd-files")).build();
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity("FlushActivityBufferToRrdFiles-trigger").withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)String.format("20 */%s * * * ?", 1)).withMisfireHandlingInstructionFireAndProceed()).build();
        this.scheduler.scheduleJob(job, trigger);
        logger.info((Object)("Scheduled task successfully added : " + job.getKey().toString()));
    }

    public void saveGraphitePayloadFromPush_NT(AuthCtx user, @Nonnull String graphitePayload) {
        TransactionContext.assertNoAttachedTransaction();
        logger.info((Object)"Received activity metrics in graphite format.");
        List<GraphiteLine> graphiteLines = this.parseAndCheckGraphitePayload(user, graphitePayload, ActivityMonitoringSettings.Push.class);
        logger.info((Object)"Writing activity metrics to rrd buffer.");
        this.writePushedMetricsToBuffer(graphiteLines);
    }

    public void pullAndSaveInfraActivityMetricsIfNeeded_NT(AuthCtx user, @Nonnull String infrastructureId, int connectTimeout, int socketTimeout, String overridingConnectionName) throws Exception {
        TransactionContext.assertNoAttachedTransaction();
        logger.infoV("Fetching activity metrics from infrastructure: %s", new Object[]{infrastructureId});
        ActivityMetric.TimeAndMetricsByDeploymentAndEndpoint infraActivityMetrics = this.apiNodeInfrasService.getActivityMetricsIfNeeded(user, infrastructureId, connectTimeout, socketTimeout, overridingConnectionName);
        if (!infraActivityMetrics.isEmpty()) {
            logger.info((Object)"Writing pulled infra activity metrics to rrd files.");
            this.writeInfraMetricsToRrds_NT(infraActivityMetrics);
        }
    }

    public <T extends UnifiedMonitoringExternalEndpointsScope> void pullAndSaveScopeActivityMetrics_NT(AuthCtx user, @Nonnull String externalEndpointsScopeName, int connectTimeout, int socketTimeout) throws Exception {
        TransactionContext.assertNoAttachedTransaction();
        logger.infoV("Fetching activity metrics from scope: %s", new Object[]{externalEndpointsScopeName});
        UnifiedMonitoringExternalEndpointsScope externalEndpointsScope = this.getExternalEndpointsScopeByName(externalEndpointsScopeName);
        UnifiedMonitoringExternalEndpointsScopeManager<?> externalEndpointsScopeScopeManager = externalEndpointsScope.getScopeManager();
        ActivityMetric.TimeAndMetricsByEndpoint scopeActivityMetrics = externalEndpointsScopeScopeManager.getScopeActivityMetrics_NT(user, externalEndpointsScope, connectTimeout, socketTimeout);
        if (!scopeActivityMetrics.isEmpty()) {
            this.writeScopeMetricsToRrds_NT(externalEndpointsScopeName, scopeActivityMetrics);
        }
    }

    public List<ExternalApiEndpointUnifiedMonitoringActivityMetrics> getExternalActivityMetricsCounts_NT(AuthCtx user, Collection<ScopeAndEndpoint> endpoints) throws IOException, DKUSecurityException {
        Period period;
        Map<String, UnifiedMonitoringExternalEndpointsScope> externalEndpointsScopesByName;
        Set scopeNames = endpoints.stream().map(e -> e.externalEndpointsScopeName).collect(Collectors.toSet());
        try (Transaction t = this.transactionService.beginRead();){
            externalEndpointsScopesByName = this.unifiedMonitoringSettingsDAO.read().externalEndpointsScopes.stream().filter(monitoredExternalConnectionConfig -> scopeNames.contains(monitoredExternalConnectionConfig.name)).collect(Collectors.toMap(ees -> ees.name, ees -> ees));
            for (UnifiedMonitoringExternalEndpointsScope ees2 : externalEndpointsScopesByName.values()) {
                this.connectionsService.checkUserForConnection(user, ees2.connectionName);
            }
        }
        ArrayList<ExternalApiEndpointUnifiedMonitoringActivityMetrics> result = new ArrayList<ExternalApiEndpointUnifiedMonitoringActivityMetrics>();
        try (Transaction t = this.transactionService.beginRead();){
            period = this.unifiedMonitoringSettingsDAO.read().windowPeriod;
        }
        for (ScopeAndEndpoint endpoint : endpoints) {
            UnifiedMonitoringExternalEndpointsScope ees3 = externalEndpointsScopesByName.get(endpoint.externalEndpointsScopeName);
            if (ees3 == null) {
                logger.warnV("The external endpoint scope %s is not found", new Object[]{endpoint.externalEndpointsScopeName});
                continue;
            }
            result.add(this.getActivityMetrics(endpoint, period, ees3));
        }
        return result;
    }

    public ExternalApiEndpointUnifiedMonitoringActivityMetrics getExternalActivityMetricsCounts_NT(AuthCtx user, ScopeAndEndpoint endpoint) throws IOException, DKUSecurityException {
        UnifiedMonitoringExternalEndpointsScope externalEndpointsScope;
        Period period;
        try (Transaction t = this.transactionService.beginRead();){
            UnifiedMonitoringSettings unifiedMonitoringSettings = this.unifiedMonitoringSettingsDAO.read();
            period = unifiedMonitoringSettings.windowPeriod;
            externalEndpointsScope = unifiedMonitoringSettings.externalEndpointsScopes.stream().filter(scope -> scope.name.equals(endpoint.externalEndpointsScopeName)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("The external endpoint scope %s is not found", endpoint.externalEndpointsScopeName)));
            this.connectionsService.checkUserForConnection(user, externalEndpointsScope.connectionName);
        }
        return this.getActivityMetrics(endpoint, period, externalEndpointsScope);
    }

    public ManagedApiEndpointUnifiedMonitoringActivityMetrics getManagedActivityMetricsCounts_NT(AuthCtx user, DeploymentAndEndpoint endpoint) throws IOException, UnauthorizedException {
        Period period;
        AbstractInfraBasicInfo.AbstractAPIDeploymentInfraBasicInfo infraBasicInfo;
        TransactionContext.assertNoAttachedTransaction();
        try (Transaction t = this.transactionService.beginRead();){
            AbstractDeploymentBasicInfo deploymentBasicInfo = this.getDeploymentBasicInfo(user, endpoint.deploymentId);
            AbstractAPIDeploymentInfra infra = (AbstractAPIDeploymentInfra)this.apiNodeInfrasService.getSettingsMandatoryUnsafe_CheckAdmin(deploymentBasicInfo.infraId, user);
            infraBasicInfo = this.apiNodeInfrasService.basicInfoUnsafe(infra);
            period = this.unifiedMonitoringSettingsDAO.read().windowPeriod;
        }
        return this.getActivityMetrics(endpoint, infraBasicInfo, period);
    }

    private AbstractDeploymentBasicInfo getDeploymentBasicInfo(AuthCtx user, String deploymentId) throws IOException {
        return this.apiServiceDeploymentsService.listBasicInfoUnsafe_Check(user).stream().filter(deployment -> Objects.equals(deployment.id, deploymentId)).findAny().orElseThrow(() -> new IllegalArgumentException(String.format("The deployment %s is not found", deploymentId)));
    }

    private ExternalApiEndpointUnifiedMonitoringActivityMetrics getActivityMetrics(ScopeAndEndpoint endpoint, Period period, UnifiedMonitoringExternalEndpointsScope externalEndpointsScope) {
        logger.debugV("Reading activity metrics for %s", new Object[]{endpoint});
        if (!externalEndpointsScope.isActivityMonitoringSupported()) {
            ExternalApiEndpointUnifiedMonitoringActivityMetrics activityMetrics = new ExternalApiEndpointUnifiedMonitoringActivityMetrics(endpoint.externalEndpointsScopeName, endpoint.endpointName, period, Double.NaN, Double.NaN, Double.NaN, Double.NaN, new ArrayList<AbstractApiEndpointUnifiedMonitoringActivityMetrics.TimeAndCount>());
            activityMetrics.activityMetricMessages.withInfoV((InfoMessage.MessageCode)ActivityMetricCodes.INFO_ACTIVITY_METRICS_NOT_SUPPORTED, "Scope : %s", new Object[]{endpoint.externalEndpointsScopeName});
            return activityMetrics;
        }
        File rrdFile = ApiEndpointActivityMonitoringService.getExternalEndpointActivityRrd(endpoint.externalEndpointsScopeName, endpoint.endpointName);
        if (!rrdFile.exists()) {
            logger.warnV("The activity metrics for %s cannot be found", new Object[]{endpoint.toString()});
            ExternalApiEndpointUnifiedMonitoringActivityMetrics activityMetrics = new ExternalApiEndpointUnifiedMonitoringActivityMetrics(endpoint.externalEndpointsScopeName, endpoint.endpointName, period, Double.NaN, Double.NaN, Double.NaN, Double.NaN, new ArrayList<AbstractApiEndpointUnifiedMonitoringActivityMetrics.TimeAndCount>());
            activityMetrics.activityMetricMessages.withFatalV((InfoMessage.MessageCode)ActivityMetricCodes.ERR_ACTIVITY_METRICS_NO_FILE, "Can't read activity metrics file for %s.", new Object[]{endpoint.toString()});
            return activityMetrics;
        }
        try {
            UnifiedMonitoringRrdContent content = this.readRrd_NT(rrdFile, MetricsAggregation.FIVE_MINUTES_FOR_THREE_MONTH, period);
            ExternalApiEndpointUnifiedMonitoringActivityMetrics activityMetrics = new ExternalApiEndpointUnifiedMonitoringActivityMetrics(endpoint.externalEndpointsScopeName, endpoint.endpointName, period, Double.isNaN(content.periodAllCount) ? Double.NaN : content.periodAllCount, content.periodErrorRate, content.periodAverageResponseTime, content.periodP95ResponseTime, content.requestsCounts);
            this.addMessageIfNoData_NT(content, activityMetrics.activityMetricMessages, period, null, null);
            return activityMetrics;
        }
        catch (Exception e) {
            logger.errorV((Throwable)e, "Can't read activity metrics for %s. Ignoring.", new Object[]{endpoint.toString()});
            ExternalApiEndpointUnifiedMonitoringActivityMetrics activityMetrics = new ExternalApiEndpointUnifiedMonitoringActivityMetrics(endpoint.externalEndpointsScopeName, endpoint.endpointName, period, Double.NaN, Double.NaN, Double.NaN, Double.NaN, new ArrayList<AbstractApiEndpointUnifiedMonitoringActivityMetrics.TimeAndCount>());
            activityMetrics.activityMetricMessages.withFatalV((InfoMessage.MessageCode)ActivityMetricCodes.ERR_ACTIVITY_METRICS_UNKNOWN, "Can't read activity metrics file for %s.", new Object[]{endpoint.toString()});
            return activityMetrics;
        }
    }

    public List<ManagedApiEndpointUnifiedMonitoringActivityMetrics> getManagedActivityMetricsCounts_NT(AuthCtx user, Collection<DeploymentAndEndpoint> endpoints) throws IOException, UnauthorizedException {
        Period period;
        Map<String, AbstractInfraBasicInfo.AbstractAPIDeploymentInfraBasicInfo> infraBasicInfoById;
        Map<String, AbstractDeploymentBasicInfo> deploymentBasicInfoById;
        try (Transaction t = this.transactionService.beginRead();){
            deploymentBasicInfoById = this.apiServiceDeploymentsService.listBasicInfoUnsafe_Check(user).stream().collect(Collectors.toMap(i -> i.id, i -> i));
            infraBasicInfoById = this.apiNodeInfrasService.listBasicInfoUnsafe_Check(user).stream().collect(Collectors.toMap(i -> i.id, i -> i));
        }
        Set<String> allowedDeploymentIds = deploymentBasicInfoById.keySet();
        Set requiredDeploymentIds = endpoints.stream().map(de -> de.deploymentId).collect(Collectors.toSet());
        requiredDeploymentIds.removeAll(allowedDeploymentIds);
        if (!requiredDeploymentIds.isEmpty()) {
            throw new UnauthorizedException("User doesn't have access to following deployments: " + String.join((CharSequence)"; ", requiredDeploymentIds), "Unauthorized");
        }
        Set<String> allowedInfraIds = infraBasicInfoById.keySet();
        Set requiredInfraIds = endpoints.stream().map(de -> ((AbstractDeploymentBasicInfo)deploymentBasicInfoById.get((Object)de.deploymentId)).infraId).collect(Collectors.toSet());
        requiredInfraIds.removeAll(allowedInfraIds);
        if (!requiredInfraIds.isEmpty()) {
            throw new UnauthorizedException("User doesn't have access to following infrastructures: " + String.join((CharSequence)"; ", requiredInfraIds), "Unauthorized");
        }
        ArrayList<ManagedApiEndpointUnifiedMonitoringActivityMetrics> result = new ArrayList<ManagedApiEndpointUnifiedMonitoringActivityMetrics>();
        try (Transaction t = this.transactionService.beginRead();){
            period = this.unifiedMonitoringSettingsDAO.read().windowPeriod;
        }
        for (DeploymentAndEndpoint endpoint : endpoints) {
            AbstractDeploymentBasicInfo deploymentBasicInfo = deploymentBasicInfoById.get(endpoint.deploymentId);
            AbstractInfraBasicInfo.AbstractAPIDeploymentInfraBasicInfo infraBasicInfo = infraBasicInfoById.get(deploymentBasicInfo.infraId);
            result.add(this.getActivityMetrics(endpoint, infraBasicInfo, period));
        }
        return result;
    }

    private ManagedApiEndpointUnifiedMonitoringActivityMetrics getActivityMetrics(DeploymentAndEndpoint endpoint, AbstractInfraBasicInfo.AbstractAPIDeploymentInfraBasicInfo infraBasicInfo, Period period) {
        logger.debugV("Reading activity metrics for %s", new Object[]{endpoint});
        if (!infraBasicInfo.isActivityMonitoringSupported()) {
            ManagedApiEndpointUnifiedMonitoringActivityMetrics activityMetrics = new ManagedApiEndpointUnifiedMonitoringActivityMetrics(endpoint.deploymentId, endpoint.endpointId, period, Double.NaN, Double.NaN, Double.NaN, Double.NaN, new ArrayList<AbstractApiEndpointUnifiedMonitoringActivityMetrics.TimeAndCount>());
            activityMetrics.activityMetricMessages.withInfoV((InfoMessage.MessageCode)ActivityMetricCodes.INFO_ACTIVITY_METRICS_NOT_SUPPORTED, "Infrastructure : %s", new Object[]{infraBasicInfo.id});
            return activityMetrics;
        }
        if (!infraBasicInfo.activityMonitoringEnabled) {
            ManagedApiEndpointUnifiedMonitoringActivityMetrics activityMetrics = new ManagedApiEndpointUnifiedMonitoringActivityMetrics(endpoint.deploymentId, endpoint.endpointId, period, Double.NaN, Double.NaN, Double.NaN, Double.NaN, new ArrayList<AbstractApiEndpointUnifiedMonitoringActivityMetrics.TimeAndCount>());
            activityMetrics.activityMetricMessages.withInfoV((InfoMessage.MessageCode)ActivityMetricCodes.INFO_ACTIVITY_METRICS_NOT_ENABLED, "Infrastructure : %s", new Object[]{infraBasicInfo.id});
            return activityMetrics;
        }
        File rrdFile = AbstractDeploymentsService.getManagedApiEndpointActivityRrd(endpoint.deploymentId, endpoint.endpointId);
        if (!rrdFile.exists()) {
            logger.warnV("The activity metrics for %s cannot be found", new Object[]{endpoint.toString()});
            ManagedApiEndpointUnifiedMonitoringActivityMetrics activityMetrics = new ManagedApiEndpointUnifiedMonitoringActivityMetrics(endpoint.deploymentId, endpoint.endpointId, period, Double.NaN, Double.NaN, Double.NaN, Double.NaN, new ArrayList<AbstractApiEndpointUnifiedMonitoringActivityMetrics.TimeAndCount>());
            activityMetrics.activityMetricMessages.withFatalV((InfoMessage.MessageCode)ActivityMetricCodes.ERR_ACTIVITY_METRICS_NO_FILE, "Can't read activity metrics file for %s.", new Object[]{endpoint.toString()});
            return activityMetrics;
        }
        try {
            UnifiedMonitoringRrdContent content = this.readRrd_NT(rrdFile, MetricsAggregation.FIVE_MINUTES_FOR_THREE_MONTH, period);
            ManagedApiEndpointUnifiedMonitoringActivityMetrics activityMetrics = new ManagedApiEndpointUnifiedMonitoringActivityMetrics(endpoint.deploymentId, endpoint.endpointId, period, Double.isNaN(content.periodAllCount) ? Double.NaN : content.periodAllCount, content.periodErrorRate, content.periodAverageResponseTime, content.periodP95ResponseTime, content.requestsCounts);
            this.addMessageIfNoData_NT(content, activityMetrics.activityMetricMessages, period, endpoint, infraBasicInfo.id);
            return activityMetrics;
        }
        catch (Exception e) {
            logger.errorV((Throwable)e, "Can't read activity metrics for %s. Ignoring.", new Object[]{endpoint.toString()});
            ManagedApiEndpointUnifiedMonitoringActivityMetrics activityMetrics = new ManagedApiEndpointUnifiedMonitoringActivityMetrics(endpoint.deploymentId, endpoint.endpointId, period, Double.NaN, Double.NaN, Double.NaN, Double.NaN, new ArrayList<AbstractApiEndpointUnifiedMonitoringActivityMetrics.TimeAndCount>());
            activityMetrics.activityMetricMessages.withFatalV((InfoMessage.MessageCode)ActivityMetricCodes.ERR_ACTIVITY_METRICS_UNKNOWN, "Can't read activity metrics file for  %s.", new Object[]{endpoint.toString()});
            return activityMetrics;
        }
    }

    public Map<Long, Map<String, Double>> getApiEndpointDeploymentActivityMetrics(DeploymentAndEndpoint deploymentAndEndpoint, AbstractInfraBasicInfo.AbstractAPIDeploymentInfraBasicInfo infraBasicInfo, MetricsAggregation aggregation, Period period) {
        FetchData totalData;
        FetchData averageData;
        if (aggregation == MetricsAggregation.ONE_SECOND_FOR_A_DAY) {
            throw new IllegalArgumentException("Activity metrics do not support a resolution of one second for a full day");
        }
        logger.debugV("Reading activity metrics for %s", new Object[]{deploymentAndEndpoint});
        if (!infraBasicInfo.isActivityMonitoringSupported()) {
            return this.getEmptyActivityMetrics(period, aggregation);
        }
        if (!infraBasicInfo.activityMonitoringEnabled) {
            return this.getEmptyActivityMetrics(period, aggregation);
        }
        File rrdFile = AbstractDeploymentsService.getManagedApiEndpointActivityRrd(deploymentAndEndpoint.deploymentId, deploymentAndEndpoint.endpointId);
        if (!rrdFile.exists()) {
            logger.warnV("The activity metrics for %s cannot be found", new Object[]{deploymentAndEndpoint.toString()});
            return this.getEmptyActivityMetrics(period, aggregation);
        }
        try {
            averageData = MetricUtils.fetchRrdData(rrdFile, aggregation, ConsolFun.AVERAGE, period);
            totalData = MetricUtils.fetchRrdData(rrdFile, aggregation, ConsolFun.TOTAL, period);
        }
        catch (Exception e) {
            logger.errorV((Throwable)e, "Can't read activity metrics for %s. Ignoring.", new Object[]{deploymentAndEndpoint.toString()});
            return this.getEmptyActivityMetrics(period, aggregation);
        }
        long[] timestamps = averageData.getTimestamps();
        double[] requestCountsPerSecond = averageData.getValues(ActivityMetric.Type.ALL_REQUESTS_IN_COUNT_PER_S.getRrdFieldName());
        double[] totalP95ResponseTimeMs = totalData.getValues(ActivityMetric.Type.TOTAL_P95_PROCESSING_TIME_IN_MS.getRrdFieldName());
        double[] p95ResponseTimeMs = this.computeAverageFromTotal(totalP95ResponseTimeMs, requestCountsPerSecond, aggregation);
        HashMap<Long, Map<String, Double>> metrics = new HashMap<Long, Map<String, Double>>();
        for (int i = 0; i < timestamps.length; ++i) {
            HashMap<String, Double> metricsAtTimestamp = new HashMap<String, Double>();
            if (!Double.isNaN(requestCountsPerSecond[i])) {
                metricsAtTimestamp.put(ActivityMetric.Type.ALL_REQUESTS_IN_COUNT_PER_S.getRrdFieldName(), Double.valueOf(Math.round(requestCountsPerSecond[i] * (double)aggregation.getIntervalInSeconds())));
            } else {
                metricsAtTimestamp.put(ActivityMetric.Type.ALL_REQUESTS_IN_COUNT_PER_S.getRrdFieldName(), null);
            }
            if (!Double.isNaN(p95ResponseTimeMs[i])) {
                metricsAtTimestamp.put(ActivityMetric.Type.TOTAL_P95_PROCESSING_TIME_IN_MS.getRrdFieldName(), p95ResponseTimeMs[i]);
            } else {
                metricsAtTimestamp.put(ActivityMetric.Type.TOTAL_P95_PROCESSING_TIME_IN_MS.getRrdFieldName(), null);
            }
            metrics.put(timestamps[i] * 1000L, metricsAtTimestamp);
        }
        return metrics;
    }

    private double[] computeAverageFromTotal(double[] totalData, double[] averageRequestCountsPerSecond, MetricsAggregation aggregation) {
        double[] result = new double[averageRequestCountsPerSecond.length];
        if (totalData != null) {
            assert (totalData.length == averageRequestCountsPerSecond.length);
            for (int i = 0; i < averageRequestCountsPerSecond.length; ++i) {
                double volume = averageRequestCountsPerSecond[i] * (double)aggregation.getIntervalInSeconds();
                result[i] = volume < 1.0E-12 ? 0.0 : totalData[i] / volume;
            }
        } else {
            Arrays.fill(result, 0.0);
        }
        return result;
    }

    private Map<Long, Map<String, Double>> getEmptyActivityMetrics(Period period, MetricsAggregation aggregation) {
        HashMap<String, Object> emptyMetrics = new HashMap<String, Object>();
        emptyMetrics.put(ActivityMetric.Type.ALL_REQUESTS_IN_COUNT_PER_S.getRrdFieldName(), null);
        emptyMetrics.put(ActivityMetric.Type.TOTAL_P95_PROCESSING_TIME_IN_MS.getRrdFieldName(), null);
        return Arrays.stream(MetricUtils.getTimestampsInPeriod(period, aggregation)).boxed().collect(Collectors.toMap(timestamp -> timestamp, timestamp -> emptyMetrics));
    }

    private UnifiedMonitoringRrdContent readRrd_NT(File rrdFile, MetricsAggregation aggregation, Period period) throws Exception {
        double periodErrorsCount;
        FetchData averageData = MetricUtils.fetchRrdData(rrdFile, aggregation, ConsolFun.AVERAGE, period);
        FetchData totalData = MetricUtils.fetchRrdData(rrdFile, aggregation, ConsolFun.TOTAL, period);
        long[] times = averageData.getTimestamps();
        double[] allRequests = averageData.getValues(ActivityMetric.Type.ALL_REQUESTS_IN_COUNT_PER_S.getRrdFieldName());
        double periodAllCount = Arrays.stream(allRequests).filter(r -> !Double.isNaN(r)).reduce(Double::sum).orElse(Double.NaN) * (double)aggregation.getIntervalInSeconds();
        double[] errorRequests = averageData.getValues(ActivityMetric.Type.ERROR_REQUESTS_IN_COUNT_PER_S.getRrdFieldName());
        double d = periodErrorsCount = Double.isNaN(periodAllCount) ? Double.NaN : Arrays.stream(errorRequests).filter(r -> !Double.isNaN(r)).sum() * (double)aggregation.getIntervalInSeconds();
        double periodErrorRate = Double.isNaN(periodAllCount) ? Double.NaN : (periodAllCount == 0.0 ? 0.0 : periodErrorsCount / periodAllCount);
        double periodAverageResponseTime = 0.0;
        if (!Double.isNaN(periodAllCount)) {
            double[] totalResponseTimeMs = totalData.getValues(ActivityMetric.Type.TOTAL_PROCESSING_TIME_IN_MS.getRrdFieldName());
            double[] avgResponseTimes = this.computeAverageFromTotal(totalResponseTimeMs, allRequests, aggregation);
            periodAverageResponseTime = Arrays.stream(avgResponseTimes).filter(r -> !Double.isNaN(r) && r != 0.0).average().orElse(0.0);
        }
        double periodP95ResponseTime = 0.0;
        if (!Double.isNaN(periodAllCount)) {
            double[] totalP95ResponseTimeMs = totalData.getValues(ActivityMetric.Type.TOTAL_P95_PROCESSING_TIME_IN_MS.getRrdFieldName());
            double[] p95ResponseTimeMs = this.computeAverageFromTotal(totalP95ResponseTimeMs, allRequests, aggregation);
            periodP95ResponseTime = Arrays.stream(p95ResponseTimeMs).filter(r -> !Double.isNaN(r) && r != 0.0).average().orElse(0.0);
        }
        ArrayList<AbstractApiEndpointUnifiedMonitoringActivityMetrics.TimeAndCount> requestsCounts = new ArrayList<AbstractApiEndpointUnifiedMonitoringActivityMetrics.TimeAndCount>();
        for (int i = 0; i < times.length - 1; ++i) {
            double value = Double.isNaN(allRequests[i]) ? Double.NaN : (double)Math.round(allRequests[i] * (double)aggregation.getIntervalInSeconds());
            requestsCounts.add(new AbstractApiEndpointUnifiedMonitoringActivityMetrics.TimeAndCount(times[i] * 1000L, value));
        }
        return new UnifiedMonitoringRrdContent(periodAllCount, periodErrorRate, periodAverageResponseTime, periodP95ResponseTime, requestsCounts);
    }

    private void addMessageIfNoData_NT(UnifiedMonitoringRrdContent content, InfoMessage.InfoMessages activityMetrics, Period period, @Nullable DeploymentAndEndpoint endpoint, @Nullable String infraId) {
        if (Double.isNaN(content.periodAllCount)) {
            if (endpoint != null) {
                activityMetrics.withWarningV((InfoMessage.MessageCode)ActivityMetricCodes.WARN_ACTIVITY_METRICS_NO_DATA, "Check the infrastructure %s monitoring settings. Does the connection used have access rights to logging facility ?", new Object[]{infraId});
            } else {
                activityMetrics.withWarningV((InfoMessage.MessageCode)ActivityMetricCodes.WARN_ACTIVITY_METRICS_NO_DATA, "Check the scope connection rights", new Object[0]);
            }
        } else if (content.periodAllCount == 0.0) {
            activityMetrics.withInfoV((InfoMessage.MessageCode)ActivityMetricCodes.INFO_ACTIVITY_METRICS_NO_REQUESTS, "The endpoint did not receive queries over the last %sh", new Object[]{period.getDays() * 24});
        }
    }

    public ActivityMetric.TimeAndMetricsByDeploymentAndEndpoint mergeGraphiteLines(List<GraphiteLine> graphiteLines, ActivityMetric.TimeAndMetricsByDeploymentAndEndpoint mergeInto) {
        for (GraphiteLine graphiteLine : graphiteLines) {
            ActivityMetric.TimeAndMetricsForDeployment timeAndMetricsForDeployment = mergeInto.computeIfAbsent(graphiteLine.deploymentId, ActivityMetric.TimeAndMetricsForDeployment::new);
            ActivityMetric.TimeAndMetricsForEndpoint timeAndMetricsForEndpoint = timeAndMetricsForDeployment.timeAndMetricsForEndpoint.computeIfAbsent(graphiteLine.endpointId, ActivityMetric.TimeAndMetricsForEndpoint::new);
            ActivityMetric.TimeAndMetrics metrics = timeAndMetricsForEndpoint.timeAndMetricsOrderedByTime.computeIfAbsent(graphiteLine.timeInSeconds, ActivityMetric.TimeAndMetrics::new);
            metrics.activityMetricsByType.merge(graphiteLine.metricType, new ActivityMetric(graphiteLine.metricType, graphiteLine.metricValue), (am1, am2) -> new ActivityMetric(am1.getType(), am1.getValue() + am2.getValue()));
        }
        return mergeInto;
    }

    public static ActivityMetric.TimeAndMetricsByDeploymentAndEndpoint mapAverageToTotal(ActivityMetric.TimeAndMetricsByDeploymentAndEndpoint initial) {
        ActivityMetric.TimeAndMetricsByDeploymentAndEndpoint result = new ActivityMetric.TimeAndMetricsByDeploymentAndEndpoint();
        for (ActivityMetric.TimeAndMetricsForDeployment deployment : initial.values()) {
            ActivityMetric.TimeAndMetricsForDeployment newDeployment = new ActivityMetric.TimeAndMetricsForDeployment(deployment.deploymentId);
            result.put(deployment.deploymentId, newDeployment);
            for (ActivityMetric.TimeAndMetricsForEndpoint endpoint : deployment.timeAndMetricsForEndpoint.values()) {
                ActivityMetric.TimeAndMetricsForEndpoint newEndpoint = ApiEndpointActivityMonitoringService.replaceAverageByTotalForEndpoint(endpoint);
                newDeployment.timeAndMetricsForEndpoint.put(endpoint.endpointId, newEndpoint);
            }
        }
        return result;
    }

    public static ActivityMetric.TimeAndMetricsByEndpoint mapAverageToTotal(ActivityMetric.TimeAndMetricsByEndpoint initial) {
        ActivityMetric.TimeAndMetricsByEndpoint result = new ActivityMetric.TimeAndMetricsByEndpoint();
        for (ActivityMetric.TimeAndMetricsForEndpoint endpoint : initial.values()) {
            ActivityMetric.TimeAndMetricsForEndpoint newEndpoint = ApiEndpointActivityMonitoringService.replaceAverageByTotalForEndpoint(endpoint);
            result.put(endpoint.endpointId, newEndpoint);
        }
        return result;
    }

    private static ActivityMetric.TimeAndMetricsForEndpoint replaceAverageByTotalForEndpoint(ActivityMetric.TimeAndMetricsForEndpoint endpoint) {
        ActivityMetric.TimeAndMetricsForEndpoint newEndpoint = new ActivityMetric.TimeAndMetricsForEndpoint(endpoint.endpointId);
        for (ActivityMetric.TimeAndMetrics timeAndMetrics : endpoint.timeAndMetricsOrderedByTime.values()) {
            ActivityMetric.TimeAndMetrics newTimeAndMetrics = new ActivityMetric.TimeAndMetrics(timeAndMetrics.timestampInSeconds);
            newEndpoint.timeAndMetricsOrderedByTime.put(timeAndMetrics.timestampInSeconds, newTimeAndMetrics);
            double volumeOverAStep = timeAndMetrics.activityMetricsByType.computeIfAbsent(ActivityMetric.Type.ALL_REQUESTS_IN_COUNT_PER_S, t -> new ActivityMetric((ActivityMetric.Type)t, 0.0)).getValue() * 1.0;
            for (ActivityMetric metric : timeAndMetrics.activityMetricsByType.values()) {
                switch (metric.getType()) {
                    case ALL_REQUESTS_IN_COUNT_PER_S: 
                    case ERROR_REQUESTS_IN_COUNT_PER_S: {
                        newTimeAndMetrics.activityMetricsByType.put(metric.getType(), metric);
                        break;
                    }
                    case AVG_PROCESSING_TIME_IN_MS_PER_REQUEST: {
                        ActivityMetric latencyTotal = new ActivityMetric(ActivityMetric.Type.TOTAL_PROCESSING_TIME_IN_MS, volumeOverAStep * metric.getValue());
                        newTimeAndMetrics.activityMetricsByType.put(ActivityMetric.Type.TOTAL_PROCESSING_TIME_IN_MS, latencyTotal);
                        break;
                    }
                    case P95_PROCESSING_TIME_IN_MS_PER_REQUEST: {
                        ActivityMetric p95Total = new ActivityMetric(ActivityMetric.Type.TOTAL_P95_PROCESSING_TIME_IN_MS, volumeOverAStep * metric.getValue());
                        newTimeAndMetrics.activityMetricsByType.put(ActivityMetric.Type.TOTAL_P95_PROCESSING_TIME_IN_MS, p95Total);
                        break;
                    }
                }
            }
        }
        return newEndpoint;
    }

    public List<GraphiteLine> parseAndCheckGraphitePayload(AuthCtx user, @Nonnull String graphitePayload, Class<? extends ActivityMonitoringSettings> expectedMode) {
        ArrayList<GraphiteLine> result = new ArrayList<GraphiteLine>();
        HashSet<String> knownInfras = new HashSet<String>();
        HashSet<String> knownDeployments = new HashSet<String>();
        HashSet<Pair> knownFullyCharacterizedEndpoints = new HashSet<Pair>();
        long metricCount = 0L;
        HashSet<String> deploymentIdsInError = new HashSet<String>();
        String[] splitPayload = graphitePayload.split("\n");
        for (String line : splitPayload) {
            String deploymentId = "";
            String endpointId = "";
            try {
                GraphiteLine graphiteLine = new GraphiteLine();
                String[] fields = line.split(" ");
                if (fields.length != 3) {
                    throw new IllegalArgumentException("Expected 3 fields separated by spaces");
                }
                String[] metricIds = fields[0].split("\\.");
                if (metricIds.length != 3) {
                    throw new IllegalArgumentException("Expected metricId to be 3 fields separated by dot, e.g deploymentId.endpointId.metricType, got " + fields[0]);
                }
                deploymentId = metricIds[0];
                endpointId = metricIds[1];
                graphiteLine.deploymentId = deploymentId;
                graphiteLine.endpointId = endpointId;
                if (!ActivityMetric.Type.byRrdFieldName.containsKey(metricIds[2])) {
                    throw new IllegalArgumentException("metric type is not valid: " + metricIds[2]);
                }
                graphiteLine.metricType = ActivityMetric.Type.byRrdFieldName.get(metricIds[2]);
                graphiteLine.metricValue = Double.parseDouble(fields[1]);
                graphiteLine.timeInSeconds = Long.parseLong(fields[2]);
                logger.trace((Object)("Parsed graphite payload line: (deploymentId:" + deploymentId + " endpointId:" + endpointId + "type:" + String.valueOf(graphiteLine.metricType) + " value:" + graphiteLine.metricValue + " time:" + graphiteLine.timeInSeconds + ")"));
                Pair fullyCharacterizedEndpoint = new Pair((Object)deploymentId, (Object)endpointId);
                if (!knownDeployments.contains(deploymentId)) {
                    knownDeployments.add(deploymentId);
                    try (Transaction t = this.transactionService.beginRead();){
                        Object deployment = this.apiServiceDeploymentsService.getSettingsMandatoryUnsafe_Check(deploymentId, user);
                        if (!knownInfras.contains(((AbstractDeployment)deployment).infraId)) {
                            knownInfras.add(((AbstractDeployment)deployment).infraId);
                            AbstractAPIDeploymentInfra infra = (AbstractAPIDeploymentInfra)this.apiNodeInfrasService.getSettingsMandatoryUnsafe_CheckAdmin(((AbstractDeployment)deployment).infraId, user);
                            if (!expectedMode.isAssignableFrom(infra.activityMonitoringSettings.getClass())) {
                                throw new IllegalConfigurationException("Infra " + infra.id + " is configured to receive activity metrics in " + String.valueOf((Object)infra.activityMonitoringSettings.mode) + " mode, but we are currently doing a " + String.valueOf(expectedMode));
                            }
                        }
                    }
                }
                if (!knownFullyCharacterizedEndpoints.contains(fullyCharacterizedEndpoint)) {
                    knownFullyCharacterizedEndpoints.add(fullyCharacterizedEndpoint);
                    Set<String> endpoints = this.apiServiceDeploymentsService.getConfiguredEndpointIds_NT(deploymentId, user);
                    if (!endpoints.contains(endpointId)) {
                        throw new IllegalArgumentException("Endpoint " + endpointId + " does not exist in current version of deployment " + deploymentId);
                    }
                    File rrdFile = AbstractDeploymentsService.getManagedApiEndpointActivityRrd(deploymentId, endpointId);
                    if (!rrdFile.exists()) {
                        this.createEndpointsActivityMetricsRrds_NT(deploymentId, endpoints);
                    }
                }
                result.add(graphiteLine);
                ++metricCount;
            }
            catch (IllegalArgumentException e) {
                logger.trace((Object)("Ignoring activity payload line, it is not valid: " + line + ": " + e.getMessage()));
                deploymentIdsInError.add(deploymentId);
            }
            catch (DKUSecurityException | IllegalConfigurationException | IOException e) {
                logger.trace((Object)("Ignoring activity metrics for deployment " + deploymentId + " and endpoint " + endpointId + ": " + e.getMessage()));
                deploymentIdsInError.add(deploymentId);
            }
        }
        logger.debug((Object)("Parsed graphite payload, got " + metricCount + " valid metric lines out of " + splitPayload.length + " lines."));
        if (!deploymentIdsInError.isEmpty()) {
            logger.debugV("Some errors related to deployments %s occurred while processing payload. Format may be invalid, deployment no longer exist, etc.", new Object[]{String.join((CharSequence)",", deploymentIdsInError)});
        }
        for (GraphiteLine line : result) {
            if (line.metricType != ActivityMetric.Type.AVG_PROCESSING_TIME_IN_MS_PER_REQUEST && line.metricType != ActivityMetric.Type.P95_PROCESSING_TIME_IN_MS_PER_REQUEST) continue;
            double matchingRate = result.stream().filter(l -> l.metricType == ActivityMetric.Type.ALL_REQUESTS_IN_COUNT_PER_S && l.timeInSeconds == line.timeInSeconds && l.endpointId.equals(line.endpointId) && l.deploymentId.equals(line.deploymentId)).findFirst().map(l -> l.metricValue).orElse(0.0);
            double volumeOverAStep = matchingRate * 1.0;
            line.metricValue *= volumeOverAStep;
            if (line.metricType == ActivityMetric.Type.AVG_PROCESSING_TIME_IN_MS_PER_REQUEST) {
                line.metricType = ActivityMetric.Type.TOTAL_PROCESSING_TIME_IN_MS;
                continue;
            }
            if (line.metricType != ActivityMetric.Type.P95_PROCESSING_TIME_IN_MS_PER_REQUEST) continue;
            line.metricType = ActivityMetric.Type.TOTAL_P95_PROCESSING_TIME_IN_MS;
        }
        return result;
    }

    private void writePushedMetricsToBuffer(List<GraphiteLine> graphiteLines) {
        this.rrdPushBuffer.addAll(graphiteLines);
        logger.info((Object)("Wrote " + graphiteLines.size() + " activity metrics to buffer"));
    }

    private void writeInfraMetricsToRrds_NT(ActivityMetric.TimeAndMetricsByDeploymentAndEndpoint timeAndMetricsByDeploymentAndEndpoint) throws DKUSecurityException {
        for (ActivityMetric.TimeAndMetricsForDeployment timeAndMetricsForDeployment : timeAndMetricsByDeploymentAndEndpoint.values()) {
            String deploymentId = timeAndMetricsForDeployment.deploymentId;
            for (ActivityMetric.TimeAndMetricsForEndpoint timeAndMetricsForEndpoint : timeAndMetricsForDeployment.timeAndMetricsForEndpoint.values()) {
                File rrdFile = AbstractDeploymentsService.getManagedApiEndpointActivityRrd(deploymentId, timeAndMetricsForEndpoint.endpointId);
                ActivityMetric.TimeAndMetricsByTime metricsToWrite = timeAndMetricsForEndpoint.timeAndMetricsOrderedByTime;
                try {
                    this.writeToRrd_NT(metricsToWrite, rrdFile);
                }
                catch (IOException e) {
                    logger.errorV((Throwable)e, "Failed to write activity metrics to RRD for DSS endpoint with deploymentId '%s' and endpointId '%s'", new Object[]{deploymentId, timeAndMetricsForEndpoint.endpointId});
                }
            }
        }
    }

    private void writeScopeMetricsToRrds_NT(String externalEndpointsScopeName, ActivityMetric.TimeAndMetricsByEndpoint timeAndMetricsByEndpoint) throws DKUSecurityException {
        logger.info((Object)"Writing scope activity metrics to rrd files.");
        for (ActivityMetric.TimeAndMetricsForEndpoint timeAndMetricsForEndpoint : timeAndMetricsByEndpoint.values()) {
            File rrdFile = ApiEndpointActivityMonitoringService.getExternalEndpointActivityRrd(externalEndpointsScopeName, timeAndMetricsForEndpoint.endpointId);
            try {
                this.writeToRrd_NT(timeAndMetricsForEndpoint.timeAndMetricsOrderedByTime, rrdFile);
            }
            catch (IOException e) {
                logger.errorV((Throwable)e, "Failed to write activity metrics to RRD for external endpoint '%s' of scope '%s'", new Object[]{timeAndMetricsForEndpoint.endpointId, externalEndpointsScopeName});
            }
        }
    }

    private void writeToRrd_NT(ActivityMetric.TimeAndMetricsByTime metricsOrderedByTime, File rrdFile) throws DKUSecurityException, IOException {
        TransactionContext.assertNoAttachedTransaction();
        if (!rrdFile.exists()) {
            RrdUtils.createActivityMetricsRrdFile(rrdFile, false);
        }
        long readCount = 0L;
        long writtenCount = 0L;
        try (AutoCloseableLock lock = NamedLock.acquire((String)rrdFile.getAbsolutePath());
             RrdDb rrdDb = RrdDb.of((String)rrdFile.getAbsolutePath());){
            for (ActivityMetric.TimeAndMetrics timeAndMetrics : metricsOrderedByTime.values()) {
                long lastUpdate = rrdDb.getLastUpdateTime();
                long currentTime = timeAndMetrics.timestampInSeconds;
                for (long timestampToUpdate = lastUpdate + 60L - lastUpdate % 60L; timestampToUpdate <= currentTime; timestampToUpdate += 60L) {
                    try {
                        MetricUtils.writeRrdSample(rrdDb, timestampToUpdate, timeAndMetrics.activityMetricsByType);
                        ++writtenCount;
                        continue;
                    }
                    catch (Exception e) {
                        logger.warnV("Couldn't write activity metrics to file %s for time %d", new Object[]{rrdFile.getAbsolutePath(), timestampToUpdate});
                    }
                }
                ++readCount;
            }
        }
        catch (Exception e) {
            logger.errorV("Couldn't write activity metrics to file %s", new Object[]{rrdFile.getAbsolutePath()});
        }
        logger.infoV("Parsed %d activity metrics, writing %s data points to file: %s", new Object[]{readCount, writtenCount, rrdFile.getAbsolutePath()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushPushBufferToRrds_NT() throws DKUSecurityException {
        List<GraphiteLine> graphiteLinesToWrite;
        long nowSeconds = System.currentTimeMillis() / 1000L - 60L;
        List<GraphiteLine> list = this.rrdPushBuffer;
        synchronized (list) {
            graphiteLinesToWrite = this.rrdPushBuffer.stream().filter(gl -> gl.timeInSeconds <= nowSeconds).collect(Collectors.toList());
        }
        this.rrdPushBuffer.removeAll(graphiteLinesToWrite);
        ActivityMetric.TimeAndMetricsByDeploymentAndEndpoint metricsToWrite = this.mergeGraphiteLines(graphiteLinesToWrite, new ActivityMetric.TimeAndMetricsByDeploymentAndEndpoint());
        if (!metricsToWrite.isEmpty()) {
            logger.info((Object)("Writing " + metricsToWrite.size() + " activity metrics buffered in the last 60 seconds to rrd files."));
        }
        this.writeInfraMetricsToRrds_NT(metricsToWrite);
    }

    public void deleteUnusedActivityRrds(String deploymentId, Set<String> endpointsToKeep) {
        logger.infoV("Deleting unused activity files for deployment %s", new Object[]{deploymentId});
        List<File> existingRrds = AbstractDeploymentsService.listApiEndpointsActivityRrds(deploymentId);
        for (File rrd : existingRrds) {
            String endpoint = FilenameUtils.removeExtension((String)rrd.getName());
            if (endpointsToKeep.contains(endpoint)) continue;
            logger.infoV("Deleting activity file %s", new Object[]{rrd.getAbsolutePath()});
            try {
                FileUtils.forceDelete((File)rrd);
            }
            catch (IOException e) {
                logger.errorV((Throwable)e, "Can't delete activity file: %s", new Object[]{rrd.getAbsolutePath()});
            }
        }
    }

    public void deleteActivityRrds(String deploymentId) {
        this.deleteUnusedActivityRrds(deploymentId, new HashSet<String>());
    }

    public void createEndpointsActivityMetricsRrds_NT(String deploymentId, Set<String> endpointIds) throws DKUSecurityException, IOException {
        TransactionContext.assertNoAttachedTransaction();
        logger.debugV("Preparing activity files for deployment %s", new Object[]{deploymentId});
        for (String endpointId : endpointIds) {
            logger.debugV("Preparing activity files for deployment %s and endpoint %s", new Object[]{deploymentId, endpointId});
            File rrdFile = AbstractDeploymentsService.getManagedApiEndpointActivityRrd(deploymentId, endpointId);
            if (!rrdFile.exists()) {
                RrdUtils.createActivityMetricsRrdFile(rrdFile, false);
                continue;
            }
            logger.debugV("%s already exists, skipping.", new Object[]{rrdFile.getAbsolutePath()});
        }
    }

    public void deleteRrdFiles(String externalEndpointScopeName) throws IOException {
        File externalEndpointScopeFolder = ApiEndpointActivityMonitoringService.getExternalEndpointActivityBaseDir(externalEndpointScopeName);
        if (externalEndpointScopeFolder.exists() && externalEndpointScopeFolder.isDirectory()) {
            logger.infoV("Deleting external endpoint scope rrd files of %s", new Object[]{externalEndpointScopeName});
            FileUtils.deleteDirectory((File)externalEndpointScopeFolder);
        } else {
            logger.warnV("The external endpoint scope directory %s is not found. Cannot perform deletion of rrd files", new Object[]{externalEndpointScopeName});
        }
    }

    private UnifiedMonitoringExternalEndpointsScope getExternalEndpointsScopeByName(String externalEndpointsScopeName) throws IOException {
        UnifiedMonitoringSettings unifiedMonitoringSettings;
        try (Transaction t = this.transactionService.beginRead();){
            unifiedMonitoringSettings = this.unifiedMonitoringSettingsDAO.read();
        }
        return unifiedMonitoringSettings.externalEndpointsScopes.stream().filter(s -> s.name.equals(externalEndpointsScopeName)).findFirst().orElseThrow(() -> new IllegalArgumentException("No cloud endpoint scope with name " + externalEndpointsScopeName));
    }

    public static File getExternalEndpointActivityRrd(String externalEndpointsScopeName, String endpointName) {
        return DKUFileUtils.getWithin((File)ApiEndpointActivityMonitoringService.getExternalEndpointActivityBaseDir(externalEndpointsScopeName), (String[])new String[]{endpointName + ".rrd"});
    }

    public static File getExternalEndpointActivityBaseDir(String externalEndpointsScopeName) {
        return DKUFileUtils.getWithin((File)DKUApp.getFile((String)"run/endpoint-activity-metrics/scopes"), (String[])new String[]{externalEndpointsScopeName});
    }

    @DisallowConcurrentExecution
    public static class FlushActivityBufferToRrdFilesTask
    extends InterruptAndPrintStackTraceAfterTimeoutTask
    implements UnloggedJob {
        @Autowired
        ApiEndpointActivityMonitoringService apiNodeInfraActivityMonitoringService;

        public FlushActivityBufferToRrdFilesTask() {
            SpringUtils.getInstance().autowire((Object)this);
        }

        public void executeWithTimeout(JobExecutionContext jec) throws JobExecutionException {
            try {
                this.apiNodeInfraActivityMonitoringService.flushPushBufferToRrds_NT();
            }
            catch (DKUSecurityException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class UnifiedMonitoringRrdContent {
        double periodAllCount;
        double periodErrorRate;
        double periodAverageResponseTime;
        double periodP95ResponseTime;
        List<AbstractApiEndpointUnifiedMonitoringActivityMetrics.TimeAndCount> requestsCounts;

        public UnifiedMonitoringRrdContent(double periodAllCount, double periodErrorRate, double periodAverageResponseTime, double periodP95ResponseTime, List<AbstractApiEndpointUnifiedMonitoringActivityMetrics.TimeAndCount> requestsCounts) {
            this.periodAllCount = periodAllCount;
            this.periodErrorRate = periodErrorRate;
            this.periodAverageResponseTime = periodAverageResponseTime;
            this.periodP95ResponseTime = periodP95ResponseTime;
            this.requestsCounts = requestsCounts;
        }
    }

    public static class GraphiteLine {
        String endpointId = "";
        String deploymentId = "";
        ActivityMetric.Type metricType;
        double metricValue;
        long timeInSeconds;
    }
}

