/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.published;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.apideployer.datamodel.actual.AbstractDeploymentBasicInfo;
import com.dataiku.dip.apideployer.datamodel.actual.AbstractInfraBasicInfo;
import com.dataiku.dip.apideployer.datamodel.actual.AbstractPublishedItemBasicInfo;
import com.dataiku.dip.apideployer.datamodel.actual.AbstractPublishedItemLightStatus;
import com.dataiku.dip.apideployer.datamodel.actual.PublishedPackageInfo;
import com.dataiku.dip.apideployer.datamodel.config.AbstractDeployment;
import com.dataiku.dip.apideployer.datamodel.config.AbstractDeploymentInfra;
import com.dataiku.dip.apideployer.datamodel.config.PublishedItem;
import com.dataiku.dip.apideployer.deployments.AbstractDeploymentsService;
import com.dataiku.dip.apideployer.deployments.AbstractPublishedPackageInfoForGovernIdentification;
import com.dataiku.dip.apideployer.infra.AbstractInfrasService;
import com.dataiku.dip.apideployer.published.FileBasedPublishedItemsDAO;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.com.google.common.cache.Cache;
import com.dataiku.dss.shadelib.com.google.common.cache.CacheBuilder;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractPublishedItemsService<D extends AbstractDeployment, I extends AbstractPublishedItemBasicInfo, N extends AbstractDeploymentInfra> {
    String DEFAULT_PUBLISHED_ITEM_PACKAGE_INFO_CACHE_MAX_SIZE_CONFIG_KEY = "dku.deployer.publisheditems.maxPublishedItemsPackageInfoMaxSize";
    String DEFAULT_PUBLISHED_ITEM_PACKAGE_INFO_CACHE_EXPIRATION_CONFIG_KEY = "dku.deployer.publisheditems.maxPublishedItemsPackageInfoExpirationMn";
    int DEFAULT_PUBLISHED_ITEM_PACKAGE_INFO_CACHE_MAX_SIZE = 10000;
    int DEFAULT_PUBLISHED_ITEM_PACKAGE_INFO_CACHE_EXPIRATION_MN = 60;
    Cache<String, PublishedPackageInfo> publishedItemPackageCache;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    protected UsersService usersService;

    public AbstractPublishedItemsService() {
        int maximumSize = DKUApp.getParams().getIntParam(this.DEFAULT_PUBLISHED_ITEM_PACKAGE_INFO_CACHE_MAX_SIZE_CONFIG_KEY, Integer.valueOf(this.DEFAULT_PUBLISHED_ITEM_PACKAGE_INFO_CACHE_MAX_SIZE));
        int expirationMn = DKUApp.getParams().getIntParam(this.DEFAULT_PUBLISHED_ITEM_PACKAGE_INFO_CACHE_EXPIRATION_CONFIG_KEY, Integer.valueOf(this.DEFAULT_PUBLISHED_ITEM_PACKAGE_INFO_CACHE_EXPIRATION_MN));
        this.getLogger().info((Object)String.format("Initializing published package item cache with max size %d and expiration %d minutes", maximumSize, expirationMn));
        this.publishedItemPackageCache = CacheBuilder.newBuilder().maximumSize((long)maximumSize).expireAfterAccess((long)expirationMn, TimeUnit.MINUTES).build();
    }

    protected abstract AbstractDeploymentsService<D, I, N> getDeploymentsService();

    protected abstract FileBasedPublishedItemsDAO getPublishedItemsDAO();

    protected abstract AbstractInfrasService<D, I, N> getInfrasService();

    public List<PublishedItem> listAllPublishedItems_Uncheck() throws IOException {
        return this.getPublishedItemsDAO().list();
    }

    public void savePublishedItem_Uncheck(PublishedItem publishedItem) throws IOException {
        this.getPublishedItemsDAO().save(publishedItem);
    }

    protected abstract PublishedItem newPublishedItem();

    public List<I> listPublishedItemBasicInfoUnsafe_Check(AuthCtx authCtx) throws IOException {
        ArrayList<I> ret = new ArrayList<I>();
        for (PublishedItem item : this.getPublishedItemsDAO().listUnsafe()) {
            if (!AbstractPublishedItemsService.hasReadPermission(item, authCtx)) continue;
            ret.add(this.basicInfoUnsafe(item));
        }
        return ret;
    }

    public abstract AbstractPublishedItemBasicInfo.PublishedItemBasicInfoList<I> createItemBasicInfoList();

    public List<AbstractPublishedItemLightStatus> listLightStatusUnsafe_NT_Check(AuthCtx authCtx) throws IOException {
        List retrievedItem;
        ArrayList<AbstractPublishedItemLightStatus> ret = new ArrayList<AbstractPublishedItemLightStatus>();
        try (Transaction t = this.transactionService.beginRead();){
            retrievedItem = this.getPublishedItemsDAO().listUnsafe();
        }
        for (PublishedItem item : retrievedItem) {
            if (!AbstractPublishedItemsService.hasReadPermission(item, authCtx)) continue;
            ret.add(this.getLightStatus(authCtx, item));
        }
        return ret;
    }

    public AbstractPublishedItemLightStatus getPublishedItemLightStatusUnsafe_NT_Check(String itemId, AuthCtx authCtx) throws UnauthorizedException, IOException {
        PublishedItem item;
        try (Transaction t = this.transactionService.beginRead();){
            item = this.getPublishedItemWithReadPermissionCheck_T(itemId, authCtx);
        }
        return this.getLightStatus(authCtx, item);
    }

    abstract AbstractPublishedItemLightStatus createItemLightStatus(List<PublishedPackageInfo> var1, List<? extends AbstractDeploymentBasicInfo> var2, List<AbstractInfraBasicInfo> var3, PublishedItem var4, boolean var5, boolean var6, boolean var7) throws IOException;

    private AbstractPublishedItemLightStatus getLightStatus(AuthCtx authCtx, PublishedItem item) throws IOException {
        List<AbstractDeploymentBasicInfo> deployments;
        List<PublishedPackageInfo> packages = this.listPublishedPackages_Check_Unsafe_NT(item.id, authCtx);
        ArrayList<AbstractInfraBasicInfo> infras = new ArrayList<AbstractInfraBasicInfo>();
        try (Transaction t = this.transactionService.beginRead();){
            deployments = this.getDeploymentsService().listBasicInfoForItemUnsafe_Check(item.id, authCtx);
            HashSet<String> infraIds = new HashSet<String>();
            for (AbstractDeploymentBasicInfo deplBI : deployments) {
                infraIds.add(deplBI.infraId);
            }
            for (AbstractInfraBasicInfo infraBI : this.getInfrasService().listBasicInfoUnsafe_Check(authCtx)) {
                if (!infraIds.contains(infraBI.id)) continue;
                infras.add(infraBI);
            }
        }
        return this.createItemLightStatus(packages, deployments, infras, item, AbstractPublishedItemsService.hasAdminPermission(item, authCtx), AbstractPublishedItemsService.hasDeployPermission(item, authCtx), AbstractPublishedItemsService.hasWritePermission(item, authCtx));
    }

    public PublishedItem getPublishedItemSettingsMandatoryUnsafe_Check(String itemId, AuthCtx authCtx) throws UnauthorizedException, IOException {
        PublishedItem item = (PublishedItem)this.getPublishedItemsDAO().getMandatoryUnsafe(itemId);
        this.checkAdminPermission(item, authCtx);
        return item;
    }

    public abstract boolean hasCreatePermission(AuthCtx var1);

    public void checkCreatePermission(AuthCtx authCtx) throws UnauthorizedException {
        if (!this.hasCreatePermission(authCtx)) {
            throw new UnauthorizedException("You cannot create a published " + this.getType(), this.getExceptionTypePrefix() + "action-denied");
        }
    }

    public void createPublishedItem_Check(String publishedItemId, String publishedItemLabel, AuthCtx authCtx) throws UnauthorizedException, IOException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        this.checkCreatePermission(authCtx);
        AbstractPublishedItemsService.checkIdValidity(publishedItemId);
        if (StringUtils.isBlank((String)publishedItemLabel)) {
            throw ErrorContext.iae((String)("Published " + this.getType() + " label cannot be empty"));
        }
        if (this.getPublishedItemsDAO().getOrNullUnsafe(publishedItemId) != null) {
            throw ErrorContext.iaef((String)"Duplicate published %s id: %s", (Object)this.getType(), (Object[])new Object[]{publishedItemId});
        }
        PublishedItem item = this.newPublishedItem();
        item.id = publishedItemId;
        item.name = publishedItemLabel;
        item.owner = authCtx.getIdentifier();
        item.versionTag = item.creationTag = new VersionTag(t.getUser().getIdentifier());
        this.getPublishedItemsDAO().save(item);
    }

    public void savePublishedItem_Check(PublishedItem item, AuthCtx authCtx) throws UnauthorizedException, IOException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        PublishedItem retrievedItem = (PublishedItem)this.getPublishedItemsDAO().getMandatoryUnsafe(item.id);
        this.checkAdminPermission(retrievedItem, authCtx);
        item.creationTag = retrievedItem.creationTag;
        item.versionTag = VersionTag.increment(item.versionTag, t.getUser().getIdentifier());
        this.getPublishedItemsDAO().save(item);
    }

    public void deletePublishedItem_NT_Check(String publishedItemId, AuthCtx authCtx) throws UnauthorizedException, IOException {
        boolean hasDeployments;
        try (Transaction t = this.transactionService.beginRead();){
            PublishedItem retrievedItem = (PublishedItem)this.getPublishedItemsDAO().getMandatoryUnsafe(publishedItemId);
            this.checkAdminPermission(retrievedItem, authCtx);
            hasDeployments = this.getDeploymentsService().hasDeploymentForItem(retrievedItem.id);
        }
        if (hasDeployments) {
            throw ErrorContext.iae((String)("Cannot delete published " + this.getType() + " that still has deployments"));
        }
        DKUFileUtils.deleteDirectory((File)this.publishedItemsDir(publishedItemId));
        t = this.transactionService.beginWriteAsLoggedInUser(authCtx);
        try {
            this.getPublishedItemsDAO().delete(publishedItemId);
            t.commitV("Deleted published %s: %s", new Object[]{this.getType(), publishedItemId});
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    public abstract I basicInfoUnsafe(PublishedItem var1) throws IOException;

    public void removeGroupFromPermissions_Uncheck(String groupName) throws IOException {
        for (PublishedItem item : this.listAllPublishedItems_Uncheck()) {
            boolean changed = false;
            ListIterator<PublishedItem.PermissionItem> it = item.permissions.listIterator();
            while (it.hasNext()) {
                PublishedItem.PermissionItem pi = it.next();
                if (!pi.group.equals(groupName)) continue;
                it.remove();
                changed = true;
            }
            if (!changed) continue;
            this.getLogger().info((Object)("Changed permissions of published " + this.getType() + " " + item.id));
            this.savePublishedItem_Uncheck(item);
        }
    }

    private boolean createIfNecessary_NT_Check(String publishedItemId, AuthCtx authCtx) throws IOException, UnauthorizedException {
        PublishedItem item;
        boolean created = false;
        try (Transaction t = this.transactionService.beginRead();){
            item = (PublishedItem)this.getPublishedItemsDAO().getOrNullUnsafe(publishedItemId);
        }
        if (item == null) {
            created = true;
            t = this.transactionService.beginWriteAsLoggedInUser(authCtx);
            try {
                this.createPublishedItem_Check(publishedItemId, publishedItemId, authCtx);
                t.commitV("Automatically created published %s: %s", new Object[]{this.getType(), publishedItemId});
            }
            finally {
                if (t != null) {
                    t.close();
                }
            }
            t = this.transactionService.beginRead();
            try {
                item = (PublishedItem)this.getPublishedItemsDAO().getMandatoryUnsafe(publishedItemId);
            }
            finally {
                if (t != null) {
                    t.close();
                }
            }
        }
        if (!AbstractPublishedItemsService.hasWritePermission(item, authCtx)) {
            throw new UnauthorizedException("You cannot edit this published " + this.getType(), this.getExceptionTypePrefix() + "access-denied");
        }
        return created;
    }

    public static boolean hasReadPermission(PublishedItem publishedItem, AuthCtx authCtx) {
        if (authCtx.isAdmin()) {
            return true;
        }
        if (authCtx.getIdentifier().equals(publishedItem.owner)) {
            return true;
        }
        for (PublishedItem.PermissionItem pi : publishedItem.permissions) {
            if (!pi.read && !pi.write && !pi.deploy && !pi.admin || !authCtx.getGroupsIfRelevant().contains(pi.group)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasWritePermission(PublishedItem publishedItem, AuthCtx authCtx) {
        if (authCtx.isAdmin()) {
            return true;
        }
        if (authCtx.getIdentifier().equals(publishedItem.owner)) {
            return true;
        }
        for (PublishedItem.PermissionItem pi : publishedItem.permissions) {
            if (!pi.write && !pi.admin || !authCtx.getGroupsIfRelevant().contains(pi.group)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasDeployPermission(PublishedItem publishedItem, AuthCtx authCtx) {
        if (authCtx.isAdmin()) {
            return true;
        }
        if (authCtx.getIdentifier().equals(publishedItem.owner)) {
            return true;
        }
        for (PublishedItem.PermissionItem pi : publishedItem.permissions) {
            if (!pi.deploy && !pi.admin || !authCtx.getGroupsIfRelevant().contains(pi.group)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasAdminPermission(PublishedItem item, AuthCtx authCtx) {
        if (authCtx.isAdmin()) {
            return true;
        }
        if (authCtx.getIdentifier().equals(item.owner)) {
            return true;
        }
        for (PublishedItem.PermissionItem pi : item.permissions) {
            if (!pi.admin || !authCtx.getGroupsIfRelevant().contains(pi.group)) continue;
            return true;
        }
        return false;
    }

    public PublishedItem getPublishedItemWithWritePermissionCheck_T(String itemId, AuthCtx authCtx) throws UnauthorizedException, IOException {
        PublishedItem item = (PublishedItem)this.getPublishedItemsDAO().getMandatoryUnsafe(itemId);
        if (!AbstractPublishedItemsService.hasWritePermission(item, authCtx)) {
            throw new UnauthorizedException("You cannot edit this published " + this.getType(), this.getExceptionTypePrefix() + "-action-denied");
        }
        return item;
    }

    public PublishedItem getPublishedItemWithReadPermissionCheck_T(String itemId, AuthCtx authCtx) throws UnauthorizedException, IOException {
        PublishedItem item = (PublishedItem)this.getPublishedItemsDAO().getMandatoryUnsafe(itemId);
        if (!AbstractPublishedItemsService.hasReadPermission(item, authCtx)) {
            throw new UnauthorizedException("You cannot read this published " + this.getType(), this.getExceptionTypePrefix() + "-action-denied");
        }
        return item;
    }

    protected List<PublishedItem.PermissionItem> computeInitialPermissionsFromCoreGroupPermissions(@Nullable List<SerializedProject.PermissionItem> corePermissions) {
        if (CollectionUtils.isEmpty(corePermissions)) {
            return List.of();
        }
        ArrayList<PublishedItem.PermissionItem> permissions = new ArrayList<PublishedItem.PermissionItem>();
        for (SerializedProject.PermissionItem corePermission : corePermissions) {
            if (corePermission == null) continue;
            String permissionJSON = JSON.json((Object)corePermission);
            if (StringUtils.isEmpty((String)corePermission.group)) {
                this.getLogger().debugV("Not propagating permission item %s because group is empty.", new Object[]{permissionJSON});
                continue;
            }
            if (!(corePermission.readProjectContent || corePermission.writeProjectContent || corePermission.admin)) {
                this.getLogger().debugV("No useful permission to propagate in permission item %s.", new Object[]{permissionJSON});
                continue;
            }
            try {
                if (null == this.usersService.getGroup(corePermission.group)) {
                    this.getLogger().warn((Object)("Group " + corePermission.group + " not found. Not considering permission " + permissionJSON + "."));
                    continue;
                }
            }
            catch (IOException ioe) {
                this.getLogger().error((Object)("Could not retrieve group " + corePermission.group + ". Not considering permission " + permissionJSON + "."), (Throwable)ioe);
            }
            PublishedItem.PermissionItem newItem = new PublishedItem.PermissionItem();
            newItem.group = corePermission.group;
            newItem.read = corePermission.readProjectContent || corePermission.writeProjectContent || corePermission.admin;
            newItem.write = corePermission.writeProjectContent || corePermission.admin;
            newItem.deploy = corePermission.admin;
            newItem.admin = corePermission.admin;
            String publishedPermissionJSON = JSON.json((Object)newItem);
            this.getLogger().debugV("Propagating permission item %s as %s.", new Object[]{permissionJSON, publishedPermissionJSON});
            permissions.add(newItem);
        }
        return permissions;
    }

    boolean publishPackageFromTempArchive_NT_Check(String publishedItemId, String packageId, File tempPackageArchive, AuthCtx authCtx) throws UnauthorizedException, IOException {
        boolean ret = this.createIfNecessary_NT_Check(publishedItemId, authCtx);
        File publishedPackageArchive = this.publishedPackageFile_MustNotExist(publishedItemId, packageId);
        FileUtils.moveFile((File)tempPackageArchive, (File)publishedPackageArchive);
        if (!publishedPackageArchive.setLastModified(System.currentTimeMillis())) {
            this.getLogger().warnV("Could not change last modified date of %s %s", new Object[]{this.getPackageType(), publishedPackageArchive.getAbsolutePath()});
        }
        String cacheKey = this.publishedItemPackageInfoKey(publishedItemId, packageId);
        this.publishedItemPackageCache.invalidate((Object)cacheKey);
        return ret;
    }

    public void deletePackage_NT_Check(String publishedItemId, String packageId, AuthCtx authCtx) throws UnauthorizedException, IOException {
        try (Transaction t = this.transactionService.beginRead();){
            this.getPublishedItemWithWritePermissionCheck_T(publishedItemId, authCtx);
        }
        File publishedPckFile = this.publishedPackageFile(publishedItemId, packageId);
        if (!publishedPckFile.exists()) {
            throw ErrorContext.iaef((String)"%s %s does not exist for this published %s %s", (Object)this.getPackageType(), (Object[])new Object[]{packageId, this.getType(), publishedItemId});
        }
        try (Transaction t = this.transactionService.beginRead();){
            if (this.getDeploymentsService().hasDeploymentForItemAndPackageVersion(publishedItemId, packageId)) {
                throw ErrorContext.iaef((String)"Cannot delete a %s that is used in a deployment", (Object)this.getPackageType(), (Object[])new Object[0]);
            }
        }
        DKUFileUtils.forceDelete((File)publishedPckFile);
        String cacheKey = this.publishedItemPackageInfoKey(publishedItemId, packageId);
        this.publishedItemPackageCache.invalidate((Object)cacheKey);
    }

    private String publishedItemPackageInfoKey(String publishedItemId, String packageId) {
        return String.format("%s__cache__%s", publishedItemId, packageId);
    }

    public List<PublishedPackageInfo> listPublishedPackages_Check_Unsafe_NT(String publishedItemId, AuthCtx authCtx) {
        File pckFolder = this.publishedPackagesDir(publishedItemId);
        ArrayList<PublishedPackageInfo> ret = new ArrayList<PublishedPackageInfo>();
        if (!pckFolder.isDirectory()) {
            return ret;
        }
        for (File zipFile : pckFolder.listFiles()) {
            String fileName = zipFile.getName();
            if (!fileName.endsWith(".zip")) continue;
            String packageId = fileName.replace(this.packageFilenamePrefix(), "").replace(".zip", "");
            String cacheKey = this.publishedItemPackageInfoKey(publishedItemId, packageId);
            PublishedPackageInfo pkg = (PublishedPackageInfo)this.publishedItemPackageCache.getIfPresent((Object)cacheKey);
            if (null == pkg) {
                try {
                    pkg = this.getPublishedPackageOrNull_Check_NT(publishedItemId, packageId, authCtx);
                    this.publishedItemPackageCache.put((Object)cacheKey, (Object)pkg);
                }
                catch (Exception e) {
                    this.getLogger().warn((Object)String.format("Published package %s %s could not be retrieved", publishedItemId, packageId), (Throwable)e);
                }
            }
            if (pkg == null) continue;
            ret.add(pkg);
        }
        ret.sort(Comparator.comparingLong(pp -> pp.publishedOn));
        return ret;
    }

    public File getPublishedPackageFileMandatory(String publishedItemId, String packageId) throws NotFoundException {
        File f = this.publishedPackageFile(publishedItemId, packageId);
        if (!f.isFile()) {
            throw new NotFoundException("Package " + String.valueOf(f) + " does not exist");
        }
        return f;
    }

    private void checkAdminPermission(PublishedItem item, AuthCtx authCtx) throws UnauthorizedException {
        if (!AbstractPublishedItemsService.hasAdminPermission(item, authCtx)) {
            throw new UnauthorizedException("You cannot manage this published " + this.getType(), this.getExceptionTypePrefix() + "-action-denied");
        }
    }

    private static void checkIdValidity(String id) {
        if (StringUtils.isBlank((String)id)) {
            throw ErrorContext.iae((String)"Published item id cannot be empty");
        }
        if (!id.matches("^[A-Za-z0-9_ -]+$")) {
            throw ErrorContext.iaef((String)"Published item id is invalid: %s", (Object)id, (Object[])new Object[0]);
        }
    }

    public File getPublishedPackageFileMandatory_Check(String publishedItemId, String packageId, AuthCtx authCtx) throws UnauthorizedException, IOException {
        try (Transaction t = this.transactionService.retrieveOrBeginRead();){
            this.getPublishedItemWithReadPermissionCheck_T(publishedItemId, authCtx);
        }
        return this.getPublishedPackageFileMandatory(publishedItemId, packageId);
    }

    public abstract PublishedPackageInfo getPublishedPackageOrNull_Check_NT(String var1, String var2, AuthCtx var3) throws UnauthorizedException, IOException;

    File getPublishedPackageFileOrNull_Check_NT(String publishedItemId, String packageId, AuthCtx authCtx) throws UnauthorizedException, IOException {
        try (Transaction t = this.transactionService.beginRead();){
            this.getPublishedItemWithReadPermissionCheck_T(publishedItemId, authCtx);
        }
        File file = this.publishedPackageFile(publishedItemId, packageId);
        if (!file.exists()) {
            return null;
        }
        return file;
    }

    File getPublishedPackageFileOrNull(String publishedItemId, String packageId) {
        File file = this.publishedPackageFile(publishedItemId, packageId);
        if (!file.exists()) {
            return null;
        }
        return file;
    }

    public abstract AbstractPublishedPackageInfoForGovernIdentification getPublishedPackageInfoForGovernIdentification_NT(String var1, String var2) throws CodedException, IOException;

    public abstract String getType();

    public abstract String getPackageType();

    protected abstract String packageFilenamePrefix();

    private File publishedItemsDir(String publishedItemId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)publishedItemId), (Object)("Published " + this.getType() + " id is not specified"));
        return DKUApp.getFile((String[])new String[]{this.getPublishedItemsDAO().getDeployerDirectoryString(), this.getPublishedItemsDAO().getTypeSubdirectoryString(), publishedItemId});
    }

    File publishedPackagesDir(String publishedItemId) {
        return DKUApp.getFile((File)this.publishedItemsDir(publishedItemId), (String[])new String[]{"packages"});
    }

    private String packageFilename(String id) {
        return this.packageFilenamePrefix() + id + ".zip";
    }

    private File publishedPackageFile_MustNotExist(String publishedItemId, String packageId) {
        File file = this.publishedPackageFile(publishedItemId, packageId);
        if (file.exists()) {
            throw ErrorContext.iaef((String)"%s %s already exists for this published %s %s", (Object)this.getPackageType(), (Object[])new Object[]{packageId, this.getType(), publishedItemId});
        }
        return file;
    }

    public File publishedPackageFile(String publishedItemId, String id) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)id), (Object)"Id is not specified");
        return DKUApp.getFile((File)this.publishedPackagesDir(publishedItemId), (String[])new String[]{this.packageFilename(id)});
    }

    protected abstract String getExceptionTypePrefix();

    protected abstract DKULogger getLogger();
}

