/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.cli.internalcmd;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.agents.tools.FilesBasedAgentsToolsDAO;
import com.dataiku.dip.agents.tools.custom.CustomAgentToolsService;
import com.dataiku.dip.analysis.ml.prediction.CustomPythonPredictionAlgoService;
import com.dataiku.dip.analysis.ml.prediction.flow.AbstractPredictionScoringRecipePayloadParams;
import com.dataiku.dip.analysis.ml.prediction.flow.AbstractPredictionTrainingRecipePayloadParams;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.clustering.ClustersFacts;
import com.dataiku.dip.analysis.model.core.CustomMetricResult;
import com.dataiku.dip.analysis.model.core.PostTrainModelingParams;
import com.dataiku.dip.analysis.model.core.PreTrainModelingParams;
import com.dataiku.dip.analysis.model.core.ResolvedCoreParams;
import com.dataiku.dip.analysis.model.core.ResolvedPreprocessingParams;
import com.dataiku.dip.analysis.model.prediction.DeepHubPreTrainModelingParams;
import com.dataiku.dip.analysis.model.preprocessing.FeaturePreprocessingParams;
import com.dataiku.dip.apideployer.datamodel.config.AbstractDeploymentInfra;
import com.dataiku.dip.badges.ApiServiceTypeBadgesService;
import com.dataiku.dip.badges.ProjectTypeBadgesService;
import com.dataiku.dip.badges.TypeBadgesSyncResult;
import com.dataiku.dip.cli.CLICommand;
import com.dataiku.dip.cli.DKU;
import com.dataiku.dip.cluster.PythonPluginClustersService;
import com.dataiku.dip.codestudio.blocks.component.PythonPluginCodeStudioBlockService;
import com.dataiku.dip.codestudio.component.PythonPluginCodeStudioTemplateService;
import com.dataiku.dip.coremodel.FormatParams;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.cuspol.CustomFieldsService;
import com.dataiku.dip.cuspol.CustomJavaPolicyHooksService;
import com.dataiku.dip.cuspol.CustomPolicyHooksRegistry;
import com.dataiku.dip.dao.ProjectBadgesDAO;
import com.dataiku.dip.dao.SQLNotebooksDAO;
import com.dataiku.dip.dao.SearchNotebooksDAO;
import com.dataiku.dip.dao.impl.FilesBasedAnalysisCoreDAO;
import com.dataiku.dip.dao.impl.FilesBasedCodeStudioObjectsDAO;
import com.dataiku.dip.dao.impl.FilesBasedDatasetsDAO;
import com.dataiku.dip.dao.impl.FilesBasedModelComparisonsDAO;
import com.dataiku.dip.dao.impl.FilesBasedModelEvaluationStoresDAO;
import com.dataiku.dip.dao.impl.FilesBasedProjectVersionTagsDAO;
import com.dataiku.dip.dao.impl.FilesBasedRecipesDAO;
import com.dataiku.dip.dao.impl.FilesBasedSavedModelsDAO;
import com.dataiku.dip.dao.impl.FilesBasedStreamingEndpointsDAO;
import com.dataiku.dip.dao.impl.FilesBasedZonesDAO;
import com.dataiku.dip.dashboards.FilesBasedDashboardsDAO;
import com.dataiku.dip.dashboards.TileDeserializer;
import com.dataiku.dip.dashboards.insights.FilesBasedInsightsDAO;
import com.dataiku.dip.dashboards.insights.InsightDeserializer;
import com.dataiku.dip.datacollections.FilesBasedDataCollectionsDAO;
import com.dataiku.dip.dataflow.FlowGraphService;
import com.dataiku.dip.datasets.fs.FSLikeDatasetTestHandler;
import com.dataiku.dip.datasets.fs.plugin.CustomJavaFSProvidersService;
import com.dataiku.dip.datasets.fs.plugin.CustomPythonFSProvidersService;
import com.dataiku.dip.datasets.sample.SampleDatasetsService;
import com.dataiku.dip.eda.worksheets.WorksheetsDAO;
import com.dataiku.dip.export.CustomJavaExportersService;
import com.dataiku.dip.export.CustomPythonExportersService;
import com.dataiku.dip.export.input.RemotableExportInput;
import com.dataiku.dip.exposition.custom.CustomExpositionsService;
import com.dataiku.dip.formats.custom.CustomJavaFormatsService;
import com.dataiku.dip.formats.custom.CustomPythonFormatsService;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.NoopFutureKernelsManager;
import com.dataiku.dip.git.ProjectCommitModeService;
import com.dataiku.dip.labeling.FilesBasedLabelingTasksDAO;
import com.dataiku.dip.labeling.LabelingTask;
import com.dataiku.dip.lambda.mgmt.FilesBasedLambdaServicesDAO;
import com.dataiku.dip.llm.custom.CustomJavaLLMsService;
import com.dataiku.dip.llm.custom.CustomPythonLLMsService;
import com.dataiku.dip.llm.governance.custom.CustomGuardrailsService;
import com.dataiku.dip.llm.promptstudio.FilesBasedPromptStudiosDAO;
import com.dataiku.dip.llm.retrieval.FilesBasedRetrievableKnowledgeDAO;
import com.dataiku.dip.logging.MainLoggingConfigurator;
import com.dataiku.dip.managedfolder.FilesBasedManagedFolderDAO;
import com.dataiku.dip.metrics.checks.CustomPythonChecksService;
import com.dataiku.dip.metrics.probes.CustomPythonProbesService;
import com.dataiku.dip.metrics.probes.CustomSQLProbesService;
import com.dataiku.dip.notebooks.NotebooksTemplatesService;
import com.dataiku.dip.pivot.backend.model.PivotTableRequest;
import com.dataiku.dip.pivot.backend.model.PivotTableResponse;
import com.dataiku.dip.plugins.CustomJavaDatasetsService;
import com.dataiku.dip.plugins.CustomPythonDatasetsService;
import com.dataiku.dip.plugins.PluginRequirementService;
import com.dataiku.dip.plugins.PluginsLoadService;
import com.dataiku.dip.plugins.RegularPluginsRegistryService;
import com.dataiku.dip.plugins.presets.PluginParameterSetsService;
import com.dataiku.dip.projects.apps.CustomAppTemplatesService;
import com.dataiku.dip.projectstandards.ProjectStandardsKernelPool;
import com.dataiku.dip.projectstandards.component.PythonPluginProjectStandardsService;
import com.dataiku.dip.recipes.RecipeDeserializer;
import com.dataiku.dip.recipes.customcode.CustomCodeRecipesService;
import com.dataiku.dip.reports.FilesBasedReportsDAO;
import com.dataiku.dip.reports.ReportsTemplateService;
import com.dataiku.dip.savedmodels.agents.CustomAgentsService;
import com.dataiku.dip.scheduler.FilesBasedScenariosDAO;
import com.dataiku.dip.scheduler.runnables.CustomJavaRunnablesService;
import com.dataiku.dip.scheduler.runnables.CustomPythonRunnablesService;
import com.dataiku.dip.scheduler.scenarios.ScenarioRunContext;
import com.dataiku.dip.scheduler.steps.PythonPluginStepsService;
import com.dataiku.dip.scheduler.triggers.PythonPluginTriggersService;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.RegularPasswordEncryptionService;
import com.dataiku.dip.security.auth.UserQueryFilter;
import com.dataiku.dip.security.auth.custom.CustomJavaUserAuthenticatorAndSupplierService;
import com.dataiku.dip.security.auth.custom.CustomJavaUserAuthenticatorService;
import com.dataiku.dip.security.auth.custom.CustomJavaUserSupplierService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.DKUTransactionService;
import com.dataiku.dip.server.services.GitReferencesService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.JupyterCRUDService;
import com.dataiku.dip.server.services.NoopExposedObjectsService;
import com.dataiku.dip.server.services.ProjectsDAO;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TaggableObjectsReadService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.shaker.model.ScriptStep;
import com.dataiku.dip.shaker.processors.udf.CustomJythonProcessorsService;
import com.dataiku.dip.sql.CustomJavaDialectsService;
import com.dataiku.dip.sql.queries.ExprDeserializer;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.variables.BackendVariablesService;
import com.dataiku.dip.webapps.FilesBasedWebAppsDAO;
import com.dataiku.dip.webapps.WebAppsTemplatesService;
import com.dataiku.dip.webapps.plugins.CustomWebAppsService;
import com.dataiku.dip.wikis.ArticlesCacheService;
import com.dataiku.dip.wikis.FilesBasedArticlesDAO;
import com.dataiku.dip.workspaces.FilesBasedWorkspacesDAO;
import com.dataiku.lambda.model.serverconfig.LambdaEndpointConfig;
import com.dataiku.lambda.model.studioconfig.DSSLambdaEndpointConfig;
import com.dataiku.lambda.model.studioconfig.LambdaService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class SynchronizeTypeBadgesCommand
extends CLICommand {
    private static final String command = "__synchronize_type_badges";
    private static final DKULogger logger;

    @Override
    public String usageString() {
        return String.format("%s [--dry-run]", command);
    }

    @Override
    public String description() {
        return "Synchronize the Type Badges of projects and API services.  For each project on the instance, will compute the ML, LLM and AGENT badges, storing them in the badges.json project config file. Will also compute the Type Badges of every API service, storing them in the service's configuration file. Might take a while depending on the number of projects and their size.";
    }

    @Override
    public Options opts() {
        Options options = new Options();
        DKU.addGlobalOptions(options);
        options.addOption("n", "dry-run", false, "Dry run. Only lists the projects and API services for which Type Badges would be computed.");
        return options;
    }

    @Override
    public int execute(String[] args) throws Exception {
        CommandLine cmdLine = this.parseAndMiniSetup(args, command, true);
        boolean dryRun = cmdLine.hasOption("dry-run");
        ApplicationConfigurator.setProcessType((MainLoggingConfigurator.ProcessType)MainLoggingConfigurator.ProcessType.DKU);
        try (AnnotationConfigApplicationContext appContext = new AnnotationConfigApplicationContext();){
            List<SerializedProject> projects;
            this.registerDependencies(appContext);
            TransactionService transactionService = (TransactionService)SpringUtils.getBean(TransactionService.class);
            ProjectsDAO projectsDAO = (ProjectsDAO)SpringUtils.getBean(ProjectsDAO.class);
            FilesBasedLambdaServicesDAO lambdaServicesDAO = (FilesBasedLambdaServicesDAO)SpringUtils.getBean(FilesBasedLambdaServicesDAO.class);
            ApiServiceTypeBadgesService apiServiceTypeBadgesService = (ApiServiceTypeBadgesService)SpringUtils.getBean(ApiServiceTypeBadgesService.class);
            ProjectTypeBadgesService projectTypeBadgesService = (ProjectTypeBadgesService)SpringUtils.getBean(ProjectTypeBadgesService.class);
            logger.infoV("Starting the synchronization of Type badges %s", new Object[]{dryRun ? " (dry run)" : ""});
            try (Transaction t = transactionService.beginRead();){
                projects = projectsDAO.listAll();
            }
            List<String> projectKeys = projects.stream().map(SerializedProject::getProjectKey).toList();
            HashMap<String, List<String>> projectToApiServices = new HashMap<String, List<String>>();
            for (String projectKey2 : projectKeys) {
                try {
                    Transaction t = transactionService.beginRead();
                    try {
                        List<String> apiServices = lambdaServicesDAO.list_noTag(projectKey2, false).stream().map(LambdaService::getId).toList();
                        projectToApiServices.put(projectKey2, apiServices);
                    }
                    finally {
                        if (t == null) continue;
                        t.close();
                    }
                }
                catch (Exception e) {
                    logger.debugV((Throwable)e, "Failed to list the API services of project %s, skipping it", new Object[]{projectKey2});
                }
            }
            int nApiServices = projectToApiServices.values().stream().mapToInt(List::size).sum();
            logger.infoV("Found %d projects, with a total of %d API services. Starting to compute their Type Badges, this might take some time.", new Object[]{projectKeys.size(), nApiServices});
            if (dryRun) {
                logger.infoV("Dry run. Would have computed the Type Badges of the following %d projects, and their %d API services: %s", new Object[]{projectKeys.size(), nApiServices, projectKeys});
                int projectKey2 = 0;
                return projectKey2;
            }
            HashMap exposedObjectsByTargetProject = new HashMap();
            try (Transaction t = transactionService.beginRead();){
                for (ITaggingService.TaggableType type : List.of(ITaggingService.TaggableType.WEB_APP, ITaggingService.TaggableType.RECIPE, ITaggingService.TaggableType.SAVED_MODEL)) {
                    Map<String, List<ProjectsService.AnyLocWithType>> map = projectsDAO.getAllExposedObjectsByTargetProject(type);
                    map.forEach((projectKey, list) -> exposedObjectsByTargetProject.computeIfAbsent(projectKey, k -> new ArrayList()).addAll(list));
                }
            }
            int nSynchronizedProjects = 0;
            int nSynchronizedApiServices = 0;
            for (String projectKey3 : projectKeys) {
                try {
                    projectTypeBadgesService.synchronizeBadges_NT(projectKey3, exposedObjectsByTargetProject.getOrDefault(projectKey3, Collections.emptyList()));
                    ++nSynchronizedProjects;
                }
                catch (Exception e) {
                    logger.errorV((Throwable)e, "Failed to synchronize Type Badges for project %s: %s. You may trigger this operation manually in the project settings", new Object[]{projectKey3, e.getMessage()});
                }
                try {
                    TypeBadgesSyncResult syncResult = apiServiceTypeBadgesService.synchronizeBadges_NT(projectKey3);
                    nSynchronizedApiServices += syncResult.successes();
                    if (syncResult.failures() > 0) {
                        logger.errorV("Failed to synchronize the Type Badges of %d API services of project %s. You may trigger this operation manually in the project settings", new Object[]{syncResult.failures(), projectKey3});
                    }
                }
                catch (Exception e) {
                    logger.errorV((Throwable)e, "Failed to synchronize Type Badges for the API services of project %s: %s. You may trigger this operation manually in the project settings", new Object[]{projectKey3, e.getMessage()});
                }
                transactionService.clearCache();
            }
            logger.infoV("Finished synchronizing Type badges. %d projects and %d API services were successfully processed.", new Object[]{nSynchronizedProjects, nSynchronizedApiServices});
        }
        return 0;
    }

    private void registerDependencies(@Nonnull AnnotationConfigApplicationContext appContext) {
        appContext.register(new Class[]{SpringUtils.class});
        appContext.register(new Class[]{FilesBasedProjectVersionTagsDAO.class});
        appContext.register(new Class[]{ProjectsDAO.class});
        appContext.register(new Class[]{DKUTransactionService.class});
        appContext.register(new Class[]{NoopFutureKernelsManager.class});
        appContext.register(new Class[]{GitReferencesService.class});
        appContext.register(new Class[]{ScenarioRunContext.class});
        appContext.register(new Class[]{FutureService.class});
        appContext.register(new Class[]{JupyterCRUDService.class});
        appContext.register(new Class[]{FilesBasedDatasetsDAO.class});
        appContext.register(new Class[]{FilesBasedSavedModelsDAO.class});
        appContext.register(new Class[]{FlowGraphService.class});
        appContext.register(new Class[]{FilesBasedModelEvaluationStoresDAO.class});
        appContext.register(new Class[]{FilesBasedInsightsDAO.class});
        appContext.register(new Class[]{FilesBasedDashboardsDAO.class});
        appContext.register(new Class[]{RegularPasswordEncryptionService.class});
        appContext.register(new Class[]{FilesBasedWebAppsDAO.class});
        appContext.register(new Class[]{FilesBasedCodeStudioObjectsDAO.class});
        appContext.register(new Class[]{FilesBasedReportsDAO.class});
        appContext.register(new Class[]{FilesBasedScenariosDAO.class});
        appContext.register(new Class[]{FilesBasedManagedFolderDAO.class});
        appContext.register(new Class[]{FilesBasedLabelingTasksDAO.class});
        appContext.register(new Class[]{FilesBasedStreamingEndpointsDAO.class});
        appContext.register(new Class[]{FilesBasedZonesDAO.class});
        appContext.register(new Class[]{FilesBasedRecipesDAO.class});
        appContext.register(new Class[]{SQLNotebooksDAO.class});
        appContext.register(new Class[]{SearchNotebooksDAO.class});
        appContext.register(new Class[]{FilesBasedLambdaServicesDAO.class});
        appContext.register(new Class[]{PubSubService.class});
        appContext.register(new Class[]{ArticlesCacheService.class});
        appContext.register(new Class[]{FilesBasedArticlesDAO.class});
        appContext.register(new Class[]{FilesBasedModelComparisonsDAO.class});
        appContext.register(new Class[]{FilesBasedPromptStudiosDAO.class});
        appContext.register(new Class[]{ScenarioRunContext.class});
        appContext.register(new Class[]{BackendVariablesService.class});
        appContext.register(new Class[]{FilesBasedRetrievableKnowledgeDAO.class});
        appContext.register(new Class[]{FilesBasedAgentsToolsDAO.class});
        appContext.register(new Class[]{FilesBasedAnalysisCoreDAO.class});
        appContext.register(new Class[]{WorksheetsDAO.class});
        appContext.register(new Class[]{FilesBasedWorkspacesDAO.class});
        appContext.register(new Class[]{FilesBasedDataCollectionsDAO.class});
        appContext.register(new Class[]{TaggableObjectsReadService.class});
        appContext.register(new Class[]{NoopExposedObjectsService.class});
        appContext.register(new Class[]{ProjectBadgesDAO.class});
        appContext.register(new Class[]{PubSubService.class});
        appContext.register(new Class[]{ProjectTypeBadgesService.class});
        appContext.register(new Class[]{FilesBasedLambdaServicesDAO.class});
        appContext.register(new Class[]{ApiServiceTypeBadgesService.class});
        appContext.register(new Class[]{ProjectCommitModeService.class});
        appContext.register(new Class[]{RegularPluginsRegistryService.class});
        appContext.register(new Class[]{NotebooksTemplatesService.class});
        appContext.register(new Class[]{WebAppsTemplatesService.class});
        appContext.register(new Class[]{ReportsTemplateService.class});
        appContext.register(new Class[]{CustomCodeRecipesService.class});
        appContext.register(new Class[]{CustomPythonDatasetsService.class});
        appContext.register(new Class[]{CustomJavaDatasetsService.class});
        appContext.register(new Class[]{CustomPythonProbesService.class});
        appContext.register(new Class[]{CustomPythonExportersService.class});
        appContext.register(new Class[]{CustomJavaExportersService.class});
        appContext.register(new Class[]{CustomPythonChecksService.class});
        appContext.register(new Class[]{CustomSQLProbesService.class});
        appContext.register(new Class[]{CustomPythonFormatsService.class});
        appContext.register(new Class[]{CustomJavaFormatsService.class});
        appContext.register(new Class[]{PythonPluginStepsService.class});
        appContext.register(new Class[]{PythonPluginTriggersService.class});
        appContext.register(new Class[]{CustomPythonRunnablesService.class});
        appContext.register(new Class[]{CustomWebAppsService.class});
        appContext.register(new Class[]{CustomAgentsService.class});
        appContext.register(new Class[]{CustomAgentToolsService.class});
        appContext.register(new Class[]{CustomGuardrailsService.class});
        appContext.register(new Class[]{CustomJavaRunnablesService.class});
        appContext.register(new Class[]{CustomPythonFSProvidersService.class});
        appContext.register(new Class[]{CustomJavaFSProvidersService.class});
        appContext.register(new Class[]{CustomJavaDialectsService.class});
        appContext.register(new Class[]{CustomJythonProcessorsService.class});
        appContext.register(new Class[]{PythonPluginClustersService.class});
        appContext.register(new Class[]{PluginParameterSetsService.class});
        appContext.register(new Class[]{CustomFieldsService.class});
        appContext.register(new Class[]{CustomPythonPredictionAlgoService.class});
        appContext.register(new Class[]{CustomPolicyHooksRegistry.class});
        appContext.register(new Class[]{CustomJavaPolicyHooksService.class});
        appContext.register(new Class[]{CustomJavaUserSupplierService.class});
        appContext.register(new Class[]{CustomJavaUserAuthenticatorService.class});
        appContext.register(new Class[]{CustomJavaUserAuthenticatorAndSupplierService.class});
        appContext.register(new Class[]{CustomAppTemplatesService.class});
        appContext.register(new Class[]{CustomExpositionsService.class});
        appContext.register(new Class[]{CustomJavaLLMsService.class});
        appContext.register(new Class[]{CustomPythonLLMsService.class});
        appContext.register(new Class[]{PythonPluginCodeStudioTemplateService.class});
        appContext.register(new Class[]{PythonPluginCodeStudioBlockService.class});
        appContext.register(new Class[]{ProjectStandardsKernelPool.class});
        appContext.register(new Class[]{PythonPluginProjectStandardsService.class});
        appContext.register(new Class[]{SampleDatasetsService.class});
        appContext.register(new Class[]{RegularPluginsRegistryService.class});
        appContext.register(new Class[]{PluginsLoadService.class});
        appContext.register(new Class[]{PluginRequirementService.class});
        appContext.refresh();
    }

    static {
        DKUtils.forceInit(LambdaEndpointConfig.class);
        DKUtils.forceInit(DSSLambdaEndpointConfig.class);
        DKUtils.forceInit(FormatParams.class);
        DKUtils.forceInit(ResolvedCoreParams.class);
        DKUtils.forceInit(ExprDeserializer.class);
        DKUtils.forceInit(DSSAuthCtx.class);
        DKUtils.forceInit(PivotTableRequest.class);
        DKUtils.forceInit(PivotTableResponse.class);
        DKUtils.forceInit(DeepHubPreTrainModelingParams.class);
        DKUtils.forceInit(MLTask.class);
        DKUtils.forceInit(StreamingEndpoint.class);
        DKUtils.forceInit(InsightDeserializer.class);
        DKUtils.forceInit(TileDeserializer.class);
        DKUtils.forceInit(ExprDeserializer.class);
        DKUtils.forceInit(CustomMetricResult.class);
        DKUtils.forceInit(SerializedDataset.class);
        DKUtils.forceInit(LabelingTask.class);
        DKUtils.forceInit(RecipeDeserializer.class);
        DKUtils.forceInit(ScriptStep.class);
        DKUtils.forceInit(FeaturePreprocessingParams.class);
        DKUtils.forceInit(AbstractPredictionTrainingRecipePayloadParams.class);
        DKUtils.forceInit(AbstractPredictionScoringRecipePayloadParams.class);
        DKUtils.forceInit(PreTrainModelingParams.JsonAdapterInit.class);
        DKUtils.forceInit(PostTrainModelingParams.JsonAdapterInit.class);
        DKUtils.forceInit(ClustersFacts.ClusterFact.class);
        DKUtils.forceInit(ResolvedPreprocessingParams.class);
        DKUtils.forceInit(FSLikeDatasetTestHandler.DetectedFormat.class);
        DKUtils.forceInit(UserQueryFilter.class);
        DKUtils.forceInit(RemotableExportInput.class);
        DKUtils.forceInit(AbstractDeploymentInfra.class);
        logger = DKULogger.getLogger((String)"dku.cli.migration.synchronize-type-badges");
    }
}

