/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.code;

import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class CodeEnvSelection
implements Serializable {
    public static final String BUILTIN_ENV_NAME = "__BUILTIN_ENV__";
    private static final long serialVersionUID = 1L;
    public EnvMode envMode = EnvMode.INHERIT;
    @Nullable
    public String envName;

    public CodeEnvSelection() {
    }

    public CodeEnvSelection(CodeEnvSelection other) {
        this.envMode = other.envMode;
        this.envName = other.envName;
    }

    public boolean equals(Object other) {
        if (!(other instanceof CodeEnvSelection)) {
            return false;
        }
        CodeEnvSelection env = (CodeEnvSelection)other;
        return StringUtils.equals((String)this.envName, (String)env.envName) && this.envMode == env.envMode;
    }

    public int hashCode() {
        return Objects.hash(this.envName, this.envMode);
    }

    public static CodeEnvSelection builtInEnvSelection() {
        CodeEnvSelection ret = new CodeEnvSelection();
        ret.envMode = EnvMode.USE_BUILTIN_MODE;
        return ret;
    }

    public static CodeEnvSelection inherit() {
        CodeEnvSelection ret = new CodeEnvSelection();
        ret.envMode = EnvMode.INHERIT;
        return ret;
    }

    public static CodeEnvSelection explicitEnv(String envName) {
        CodeEnvSelection ret = new CodeEnvSelection();
        ret.envMode = EnvMode.EXPLICIT_ENV;
        ret.envName = envName;
        return ret;
    }

    public static enum EnvMode implements Serializable
    {
        USE_BUILTIN_MODE,
        INHERIT,
        EXPLICIT_ENV;

    }
}

