/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.code;

import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class CondaEnvUtils {
    private static Logger logger = Logger.getLogger((String)"dip.conda");

    private CondaEnvUtils() {
    }

    public static String getEnvPrefix(String envName) throws IOException {
        byte[] out;
        ArrayList cmd = Lists.newArrayList();
        cmd.add("conda");
        cmd.add("env");
        cmd.add("list");
        cmd.add("--json");
        ProcessBuilder pb = new ProcessBuilder(cmd);
        try {
            out = DKUtils.execAndGetOutput((ProcessBuilder)pb);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Failed to retrieve conda env list", e);
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(out);
        logger.info((Object)("Looking for " + envName + " in " + new String(out, StandardCharsets.UTF_8)));
        CondaEnvListResponse listing = (CondaEnvListResponse)JSON.parse((InputStream)bais, CondaEnvListResponse.class);
        for (String prefix : listing.envs) {
            String name = new File(prefix).getName();
            if (!name.equals(envName)) continue;
            return prefix;
        }
        throw new IOException("Could not find environment");
    }

    public static void linkToCondaEnv(String envName, File targetFolder) throws IOException {
        DKUFileUtils.mkdirsParent((File)targetFolder);
        String prefix = CondaEnvUtils.getEnvPrefix(envName);
        if (targetFolder.exists() && !targetFolder.delete()) {
            throw new IOException("Failed to remove old link");
        }
        Files.createSymbolicLink(targetFolder.toPath(), new File(prefix).toPath(), new FileAttribute[0]);
    }

    private static class CondaEnvListResponse {
        List<String> envs = Lists.newArrayList();

        private CondaEnvListResponse() {
        }
    }
}

