/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.codestudio;

import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.codestudio.object.CodeStudioObject;
import com.dataiku.dip.codestudio.template.CodeStudioTemplate;
import com.dataiku.dip.codestudio.template.CodeStudioTemplateParams;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exposition.Exposition;
import com.dataiku.dip.exposition.PortForwardExposition;
import com.dataiku.dip.exposition.PortForwardToServiceExposition;
import com.dataiku.dip.projects.importexport.model.ProjectRemappingSettings;
import com.dataiku.dip.security.AuthCtx;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public interface CodeStudioMeta {
    public String getType();

    public boolean isPublic();

    public Class<? extends CodeStudioTemplateParams> templateParamsClass();

    public List<CodeEnvModel.CodeEnvUsage> collectUsages(CodeStudioTemplate var1);

    public CodeStudioTemplate.CodeStudioTemplateType getTemplateType();

    public CodeStudioObject.CodeStudioObjectType getCodeStudioType(CodeStudioTemplate var1);

    public CreationSpec getCreationSpec(AuthCtx var1, CodeStudioTemplate var2, CreationEnv var3) throws Exception;

    public ImageBuildSpec getBuildSpec(AuthCtx var1, CodeStudioTemplate var2, ImageBuildEnv var3) throws Exception;

    public CodeStudioLaunchSpec getLaunchSpec(AuthCtx var1, CodeStudioTemplate var2, CodeStudioLaunchEnv var3) throws Exception;

    public TemplateExportSpec exportTemplate(AuthCtx var1, CodeStudioTemplate var2) throws Exception;

    public CodeStudioTemplate importTemplate(AuthCtx var1, CodeStudioTemplate var2, TemplateExportSpec var3, TemplateImportSpec var4) throws Exception;

    public static class TemplateImportSpec {
        public boolean importToPlugin;
        public List<ProjectRemappingSettings.CodeEnvRemapping> codeEnvs = new ArrayList<ProjectRemappingSettings.CodeEnvRemapping>();
    }

    public static class TemplateExportSpec {
        public Map<String, TemplateExportResource> resourcesMap = Maps.newHashMap();
        public List<CodeEnvModel.UsedCodeEnvRef> usedCodeEnvRefs = new ArrayList<CodeEnvModel.UsedCodeEnvRef>();
    }

    public static class TemplateExportResource {
        public String localPath;
        public String exportedPath;
    }

    public static class CodeStudioLaunchSpec {
        public String yaml;
        public String k8sHeadObjectType = "deployment";
        public String k8sHeadObjectName;
        public List<String> selector = Lists.newArrayList();
        public List<ExposedCodeStudioPort> exposedPorts = Lists.newArrayList();
        public List<ExposedCodeStudioService> exposedServices = Lists.newArrayList();
        public String readinessProbeUrl;
        public List<SimpleKeyValue> readinessProbeHeaders = Lists.newArrayList();
        public boolean useTcpReadiness;
        public Integer initialSyncTimeoutInMinutes;
        public List<String> entrypoints = Lists.newArrayList();
        public List<SyncZoneInstance> syncedZones = Lists.newArrayList();
        public List<String> excludedFromSync = Lists.newArrayList();
        public String fileAdjustmentScript;
        public List<CodeStudioCustomCommand> customCommands = Lists.newArrayList();
        public Map<String, String> extraAnnotations = Maps.newHashMap();
        public Map<String, String> extraLabels = Maps.newHashMap();
    }

    public static class CodeStudioCustomCommand {
        public String name;
        public String label;
        public String command;
        public String icon;
        public String description;
        public CodeStudioCommandBehavior behavior = CodeStudioCommandBehavior.FIRE_AND_FORGET;
    }

    public static enum CodeStudioCommandBehavior {
        FIRE_AND_FORGET(false),
        WAIT_FOR_RETURN_VALUE(true),
        WAIT_FOR_RETURN_VALUE_AND_REFRESH_VIEW(true),
        WAIT_FOR_RETURN_VALUE_IN_BACKGROUND(true);

        private boolean wait;

        private CodeStudioCommandBehavior(boolean wait) {
            this.wait = wait;
        }

        public boolean shouldWait() {
            return this.wait;
        }
    }

    public static class ExposedCodeStudioService {
        public String label;
        public int port;
        public String service;
        public int localPort;
        public Exposition exposition = new Exposition().withType(PortForwardToServiceExposition.META.getType()).withParams(new PortForwardToServiceExposition.PortForwardToServiceExpositionParams());
        public boolean allowExpositionOverride = false;
    }

    public static class ExposedCodeStudioPort {
        public String label;
        public int port;
        public String proxiedUrlSuffix;
        public String proxyPrefixHeaderName;
        public boolean exposeHtml;
        public Exposition exposition = new Exposition().withType(PortForwardExposition.META.getType()).withParams(new PortForwardExposition.PortForwardExpositionParams());
        public boolean allowExpositionOverride = false;
        public Integer containerPort;
        public String readinessProbeUrl;
    }

    public static class CodeStudioWebAppLaunchEnv
    extends CodeStudioLaunchEnv {
        public Integer exposedPortToDisplay;
    }

    public static class CodeStudioLaunchEnv {
        public String projectKey;
        public String executionId;
        public String apiTicket;
        public String workingDir;
        public ContainerExecRuntimeConfig containerConfig;
        public String baseUrlLNT;
        public String baseUrlLNTPerPort;
        public String templateImage;
        public Map<String, String> labels = Maps.newHashMap();
        public Map<String, String> annotations = Maps.newHashMap();
        public CodeStudioLaunchedFrom launchedFrom;
        public boolean publiclyExposed = false;
    }

    public static enum CodeStudioLaunchedFrom {
        CODE_STUDIO,
        WEBAPP;

    }

    public static class ImageBuildEnv {
        public String buildDir;
        public String workingDir;
        public GeneralSettingsDAO.GlobalCodeEnvsExtraSettings globalCodeEnvsExtraSettings;
    }

    public static class ImageBuildSpec {
        public String dockerfile;
        public List<SyncZoneInstance> syncedZones = Lists.newArrayList();
    }

    public static class SyncZoneInstance {
        public String zone;
        public String pathInZone;
        public String pathInContainer;
        public boolean oneWay;
        public String id;

        public SyncZoneInstance withZone(String zone) {
            this.zone = zone;
            return this;
        }

        public SyncZoneInstance withPathInContainer(String pathInContainer) {
            this.pathInContainer = pathInContainer;
            return this;
        }
    }

    public static class CreationEnv {
        public CodeStudioObject codeStudio;
        public String tmpDir;
    }

    public static class CreationSpec {
        public List<SimpleKeyValue> codeStudioVersionedFiles = Lists.newArrayList();
        public List<SimpleKeyValue> codeStudioResourcesFiles = Lists.newArrayList();
        public List<SimpleKeyValue> userVersionedFiles = Lists.newArrayList();
        public List<SimpleKeyValue> userResourcesFiles = Lists.newArrayList();
    }
}

