/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.codestudio.blocks;

import com.dataiku.dip.codestudio.CodeStudioMeta;
import com.dataiku.dip.codestudio.blocks.CodeStudioBlock;
import com.dataiku.dip.codestudio.blocks.CodeStudioBlockMeta;
import com.dataiku.dip.codestudio.blocks.CodeStudioBlockRegistry;
import com.dataiku.dip.codestudio.blocks.EntrypointCodeStudioBlockMeta;
import com.dataiku.dip.codestudio.blocks.SimpleDeploymentCodeStudioBlockMeta;
import com.dataiku.dip.codestudio.blocks.component.PythonPluginCodeStudioBlockParams;
import com.dataiku.dip.codestudio.template.CodeStudioTemplateParams;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.variables.VariablesContext;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class BlockBasedCodeStudioTemplateParams
extends CodeStudioTemplateParams {
    public List<CodeStudioBlock> blocks = Lists.newArrayList();
    private static Logger logger = Logger.getLogger((String)"dip.codestudio.blockBased");

    @Override
    public void checkParamsValid(VariablesContext templateVariablesContext) throws Exception {
        for (CodeStudioBlock block : this.blocks) {
            block.params.checkValid(templateVariablesContext);
        }
        HashSet<Integer> exposedPorts = new HashSet<Integer>();
        for (CodeStudioBlock block : this.blocks) {
            JsonPrimitive port;
            JsonObject config;
            if (block.params instanceof SimpleDeploymentCodeStudioBlockMeta.SimpleDeploymentCodeStudioBlockParams) {
                for (CodeStudioMeta.ExposedCodeStudioPort blockPort : ((SimpleDeploymentCodeStudioBlockMeta.SimpleDeploymentCodeStudioBlockParams)block.params).exposedPorts) {
                    this.checkDupe(exposedPorts, blockPort);
                }
            }
            if (block.params instanceof EntrypointCodeStudioBlockMeta.EntrypointCodeStudioBlockParams) {
                this.checkDupe(exposedPorts, ((EntrypointCodeStudioBlockMeta.EntrypointCodeStudioBlockParams)block.params).exposedPort);
            }
            if (!(block.params instanceof PythonPluginCodeStudioBlockParams) || (config = ((PythonPluginCodeStudioBlockParams)block.params).config) == null || !config.has("port") || !(port = config.getAsJsonPrimitive("port")).isNumber()) continue;
            this.checkDupe(exposedPorts, port.getAsInt());
        }
    }

    private void checkDupe(Set<Integer> exposedPorts, int port) {
        if (exposedPorts.contains(port)) {
            throw ErrorContext.ice((String)("Your template exposes the same port twice: " + port));
        }
        exposedPorts.add(port);
    }

    private void checkDupe(Set<Integer> exposedPorts, CodeStudioMeta.ExposedCodeStudioPort blockPort) {
        if (blockPort != null) {
            this.checkDupe(exposedPorts, blockPort.port);
        }
    }

    @Override
    public void newTemplateInitialization() {
        for (CodeStudioBlockMeta meta : CodeStudioBlockRegistry.getAllMeta()) {
            CodeStudioBlock.CodeStudioBlockType blockType = meta.getBlockType();
            if (blockType.isLocked == null || !blockType.isLocked.booleanValue()) continue;
            CodeStudioBlock block = new CodeStudioBlock();
            block.type = blockType.type;
            try {
                block.params = meta.blockParamsClass().newInstance();
            }
            catch (Exception e) {
                block.params = null;
                logger.warn((Object)("Can't apply block params of type : " + block.type), (Throwable)e);
            }
            meta.newTemplateInitialization(block);
            this.blocks.add(block);
        }
    }
}

