/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.codestudio.blocks.component;

import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.codestudio.CodeStudioMeta;
import com.dataiku.dip.codestudio.PythonPluginCodeStudioCommonUtils;
import com.dataiku.dip.codestudio.blocks.CodeStudioBlock;
import com.dataiku.dip.codestudio.blocks.CodeStudioBlockMeta;
import com.dataiku.dip.codestudio.blocks.CodeStudioBlockParams;
import com.dataiku.dip.codestudio.blocks.component.LoadedPythonPluginCodeStudioBlock;
import com.dataiku.dip.codestudio.blocks.component.PythonPluginCodeStudioBlockParams;
import com.dataiku.dip.codestudio.blocks.component.PythonPluginCodeStudioBlockService;
import com.dataiku.dip.codestudio.template.CodeStudioTemplate;
import com.dataiku.dip.custom.CustomPythonElementService;
import com.dataiku.dip.custom.IElementLoadedDesc;
import com.dataiku.dip.custom.IPluginifiedMeta;
import com.dataiku.dip.custom.PluginSettingsResolver;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.io.SingleCommandKernelLink;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.SpringUtils;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class PythonPluginCodeStudioBlockMeta
implements CodeStudioBlockMeta,
IPluginifiedMeta {
    private final LoadedPythonPluginCodeStudioBlock loadedDesc;
    private final String pluginId;

    public PythonPluginCodeStudioBlockMeta(String pluginId, LoadedPythonPluginCodeStudioBlock loadedDesc) {
        this.pluginId = pluginId;
        this.loadedDesc = loadedDesc;
    }

    public LoadedPythonPluginCodeStudioBlock getDesc() {
        return this.loadedDesc;
    }

    @Override
    public String getType() {
        return this.loadedDesc.elementType;
    }

    @Override
    public IElementLoadedDesc getLoadedDesc() {
        return this.loadedDesc;
    }

    @Override
    public void newTemplateInitialization(CodeStudioBlock block) {
    }

    @Override
    public Class<? extends CodeStudioBlockParams> blockParamsClass() {
        return PythonPluginCodeStudioBlockParams.class;
    }

    @Override
    public CodeStudioBlock.CodeStudioBlockType getBlockType() {
        CodeStudioBlock.CodeStudioBlockType ret = new CodeStudioBlock.CodeStudioBlockType();
        ret.type = this.getType();
        ret.label = this.loadedDesc.desc.meta.label;
        ret.description = this.loadedDesc.desc.meta.description;
        ret.icon = this.loadedDesc.desc.meta.icon;
        ret.isUnique = this.loadedDesc.desc.isUnique;
        ret.isLocked = this.loadedDesc.desc.isLocked;
        ret.isAdvanced = this.loadedDesc.desc.isAdvanced;
        ret.uiDisplayPriority = this.loadedDesc.desc.uiDisplayPriority;
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CodeStudioMeta.ImageBuildSpec apply(AuthCtx authCtx, CodeStudioBlock block, final CodeStudioMeta.ImageBuildSpec buildSpec, final CodeStudioMeta.ImageBuildEnv buildEnv, final CodeStudioTemplate template) throws IOException {
        String projectKey = "__DKU_ANY_PROJECT__";
        File tmpDir = new File(buildEnv.workingDir);
        JsonObject config = block.getParamsAs(PythonPluginCodeStudioBlockParams.class).config;
        PythonPluginCodeStudioCommonUtils.CodeStudioKernelCommand<CodeStudioMeta.ImageBuildSpec> command = new PythonPluginCodeStudioCommonUtils.CodeStudioKernelCommand<CodeStudioMeta.ImageBuildSpec>(){

            @Override
            public CodeStudioMeta.ImageBuildSpec run(PluginSettingsResolver.ResolvedSettings resolvedSettings, String code, SingleCommandKernelLink link) throws IOException {
                PythonPluginCodeStudioCommonUtils.ImageBuildSpecReq req = new PythonPluginCodeStudioCommonUtils.ImageBuildSpecReq();
                req.code = code;
                req.codeDefinesBlock = true;
                req.config = resolvedSettings.config;
                req.pluginConfig = resolvedSettings.pluginConfig;
                req.env = buildEnv;
                req.in = buildSpec;
                req.template = template;
                return (CodeStudioMeta.ImageBuildSpec)link.execute((Object)req, CodeStudioMeta.ImageBuildSpec.class, "Failed to apply block");
            }
        };
        APITicketService apiTicketService = (APITicketService)SpringUtils.getBean(APITicketService.class);
        APITicketService.Ticket ticket = apiTicketService.createTicket(authCtx, "dss_code_studio_block:" + this.getType(), (Object)this);
        try {
            PythonPluginCodeStudioCommonUtils utils = new PythonPluginCodeStudioCommonUtils(this.pluginId, this.getType(), (CustomPythonElementService)SpringUtils.getBean(PythonPluginCodeStudioBlockService.class));
            CodeStudioMeta.ImageBuildSpec imageBuildSpec = utils.run(authCtx, projectKey, tmpDir, ticket.getSecret(), config, command);
            return imageBuildSpec;
        }
        finally {
            apiTicketService.expireTicket(ticket);
        }
    }

    @Override
    public CodeStudioMeta.CodeStudioLaunchSpec apply(AuthCtx authCtx, CodeStudioBlock block, final CodeStudioMeta.CodeStudioLaunchSpec launchSpec, final CodeStudioMeta.CodeStudioLaunchEnv launchEnv) throws IOException {
        String projectKey = launchEnv.projectKey;
        File tmpDir = new File(launchEnv.workingDir);
        JsonObject config = block.getParamsAs(PythonPluginCodeStudioBlockParams.class).config;
        PythonPluginCodeStudioCommonUtils.CodeStudioKernelCommand<CodeStudioMeta.CodeStudioLaunchSpec> command = new PythonPluginCodeStudioCommonUtils.CodeStudioKernelCommand<CodeStudioMeta.CodeStudioLaunchSpec>(){

            @Override
            public CodeStudioMeta.CodeStudioLaunchSpec run(PluginSettingsResolver.ResolvedSettings resolvedSettings, String code, SingleCommandKernelLink link) throws IOException {
                PythonPluginCodeStudioCommonUtils.CodeStudioLaunchSpecReq req = new PythonPluginCodeStudioCommonUtils.CodeStudioLaunchSpecReq();
                req.code = code;
                req.codeDefinesBlock = true;
                req.config = resolvedSettings.config;
                req.pluginConfig = resolvedSettings.pluginConfig;
                req.env = launchEnv;
                req.in = launchSpec;
                return (CodeStudioMeta.CodeStudioLaunchSpec)link.execute((Object)req, CodeStudioMeta.CodeStudioLaunchSpec.class, "Failed to apply block");
            }
        };
        PythonPluginCodeStudioCommonUtils utils = new PythonPluginCodeStudioCommonUtils(this.pluginId, this.getType(), (CustomPythonElementService)SpringUtils.getBean(PythonPluginCodeStudioBlockService.class));
        return utils.run(authCtx, projectKey, tmpDir, launchEnv.apiTicket, config, command);
    }

    @Override
    public CodeStudioMeta.CodeStudioLaunchSpec postProcess(AuthCtx authCtx, CodeStudioBlock block, final CodeStudioMeta.CodeStudioLaunchSpec launchSpec, final CodeStudioMeta.CodeStudioLaunchEnv launchEnv) throws IOException, DKUSecurityException {
        String projectKey = launchEnv.projectKey;
        File tmpDir = new File(launchEnv.workingDir);
        JsonObject config = block.getParamsAs(PythonPluginCodeStudioBlockParams.class).config;
        PythonPluginCodeStudioCommonUtils.CodeStudioKernelCommand<CodeStudioMeta.CodeStudioLaunchSpec> command = new PythonPluginCodeStudioCommonUtils.CodeStudioKernelCommand<CodeStudioMeta.CodeStudioLaunchSpec>(){

            @Override
            public CodeStudioMeta.CodeStudioLaunchSpec run(PluginSettingsResolver.ResolvedSettings resolvedSettings, String code, SingleCommandKernelLink link) throws IOException {
                PythonPluginCodeStudioCommonUtils.CodeStudioPostProcessSpecReq req = new PythonPluginCodeStudioCommonUtils.CodeStudioPostProcessSpecReq();
                req.code = code;
                req.codeDefinesBlock = true;
                req.config = resolvedSettings.config;
                req.pluginConfig = resolvedSettings.pluginConfig;
                req.env = launchEnv;
                req.in = launchSpec;
                return (CodeStudioMeta.CodeStudioLaunchSpec)link.execute((Object)req, CodeStudioMeta.CodeStudioLaunchSpec.class, "Failed to apply block");
            }
        };
        PythonPluginCodeStudioCommonUtils utils = new PythonPluginCodeStudioCommonUtils(this.pluginId, this.getType(), (CustomPythonElementService)SpringUtils.getBean(PythonPluginCodeStudioBlockService.class));
        return utils.run(authCtx, projectKey, tmpDir, launchEnv.apiTicket, config, command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CodeStudioMeta.CreationSpec apply(AuthCtx authCtx, CodeStudioBlock block, final CodeStudioMeta.CreationSpec creationSpec, final CodeStudioMeta.CreationEnv creationEnv) throws IOException, DKUSecurityException {
        String projectKey = "__DKU_ANY_PROJECT__";
        File tmpDir = new File(creationEnv.tmpDir);
        JsonObject config = block.getParamsAs(PythonPluginCodeStudioBlockParams.class).config;
        PythonPluginCodeStudioCommonUtils.CodeStudioKernelCommand<CodeStudioMeta.CreationSpec> command = new PythonPluginCodeStudioCommonUtils.CodeStudioKernelCommand<CodeStudioMeta.CreationSpec>(){

            @Override
            public CodeStudioMeta.CreationSpec run(PluginSettingsResolver.ResolvedSettings resolvedSettings, String code, SingleCommandKernelLink link) throws IOException {
                PythonPluginCodeStudioCommonUtils.CreationSpecReq req = new PythonPluginCodeStudioCommonUtils.CreationSpecReq();
                req.code = code;
                req.codeDefinesBlock = true;
                req.config = resolvedSettings.config;
                req.pluginConfig = resolvedSettings.pluginConfig;
                req.env = creationEnv;
                req.in = creationSpec;
                return (CodeStudioMeta.CreationSpec)link.execute((Object)req, CodeStudioMeta.CreationSpec.class, "Failed to apply block");
            }
        };
        APITicketService apiTicketService = (APITicketService)SpringUtils.getBean(APITicketService.class);
        APITicketService.Ticket ticket = apiTicketService.createTicket(authCtx, "dss_code_studio_block:" + this.getType(), (Object)this);
        try {
            PythonPluginCodeStudioCommonUtils utils = new PythonPluginCodeStudioCommonUtils(this.pluginId, this.getType(), (CustomPythonElementService)SpringUtils.getBean(PythonPluginCodeStudioBlockService.class));
            CodeStudioMeta.CreationSpec creationSpec2 = utils.run(authCtx, projectKey, tmpDir, ticket.getSecret(), config, command);
            return creationSpec2;
        }
        finally {
            apiTicketService.expireTicket(ticket);
        }
    }

    @Override
    public CodeStudioMeta.TemplateExportSpec exportBlock(AuthCtx authCtx, CodeStudioBlock block, CodeStudioMeta.TemplateExportSpec exportSpec) {
        return exportSpec;
    }

    @Override
    public CodeStudioBlock importBlock(AuthCtx authCtx, CodeStudioBlock srcBlock, CodeStudioMeta.TemplateExportSpec exportSpec, CodeStudioMeta.TemplateImportSpec importSpec) {
        return srcBlock;
    }

    @Override
    public List<CodeEnvModel.CodeEnvUsage> collectUsages(CodeStudioBlock block, CodeStudioTemplate template) {
        return Lists.newArrayList();
    }
}

