/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections.bigquery.simba;

import com.dataiku.dip.connections.bigquery.simba.SQLExceptionHelper;
import com.dataiku.dip.connections.helpers.AbstractRetryPolicyExecutor;
import com.dataiku.dip.connections.helpers.RetryExceptionPolicyExecutor;
import com.dataiku.dip.connections.helpers.RetryPolicyExecutor;
import com.dataiku.dip.connections.helpers.RetryPolicyExecutorFactory;
import com.dataiku.dip.sql.bigquery.BigQueryException;
import com.dataiku.dip.sql.bigquery.JobResource;
import com.dataiku.dss.shadelib.com.google.common.base.Predicate;
import com.dataiku.dss.shadelib.com.google.common.collect.ImmutableMap;
import java.sql.SQLException;
import java.util.Map;

public class BigQueryRetryPolicyExecutorFactory
extends RetryPolicyExecutorFactory {
    private static final Map<BigQueryClientMode, Predicate<Exception>> BIGQUERY_EXCEPTION_RATE_LIMIT_PREDICATE_MAP = ImmutableMap.of((Object)((Object)BigQueryClientMode.SQL), e -> e instanceof SQLException && SQLExceptionHelper.containsRateLimitError((SQLException)e), (Object)((Object)BigQueryClientMode.REST), e -> e instanceof BigQueryException && ((BigQueryException)e).containsRateLimitError());

    public static BigQueryRetryExceptionPolicyExecutor createRetryRateLimitExceptionPolicyExecutor(BigQueryClientMode bigQueryMode) {
        if (!BIGQUERY_EXCEPTION_RATE_LIMIT_PREDICATE_MAP.containsKey((Object)bigQueryMode)) {
            throw new IllegalArgumentException("Invalid BigQueryClientMode value: " + String.valueOf((Object)bigQueryMode));
        }
        return (BigQueryRetryExceptionPolicyExecutor)((AbstractRetryPolicyExecutor)new BigQueryRetryExceptionPolicyExecutor().retryOn((Predicate)BIGQUERY_EXCEPTION_RATE_LIMIT_PREDICATE_MAP.get((Object)bigQueryMode))).withDelay(2000);
    }

    public static class BigQueryRetryExceptionPolicyExecutor
    extends RetryExceptionPolicyExecutor {
        public JobResource run(RetryPolicyExecutor.Callable<JobResource, BigQueryException> runnable) throws BigQueryException, InterruptedException {
            return this.execute(runnable);
        }
    }

    public static enum BigQueryClientMode {
        SQL,
        REST;

    }
}

