/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.coremodel;

import com.dataiku.dip.coremodel.InheritableConfig;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class RecipeEnginesPreferenceConfig
implements InheritableConfig<RecipeEnginesPreferenceConfig> {
    public List<String> forbiddenEngines = new ArrayList<String>();
    public List<String> enginesPreferenceOrder = new ArrayList<String>();
    public Map<String, List<String>> forbiddenByRecipeType = new HashMap<String, List<String>>();
    public Map<String, List<String>> preferenceByRecipeType = new HashMap<String, List<String>>();

    private List<String> cleanEmptyFromList(List<String> list) {
        if (list == null) {
            return null;
        }
        ArrayList cleanList = Lists.newArrayList();
        for (String engine : list) {
            if (!StringUtils.isNotBlank((String)engine)) continue;
            cleanList.add(engine.trim());
        }
        return cleanList;
    }

    public List<String> getEffectiveForbidden(String recipeType) {
        if (this.forbiddenByRecipeType.get(recipeType) != null) {
            return this.cleanEmptyFromList(this.forbiddenByRecipeType.get(recipeType));
        }
        return this.cleanEmptyFromList(this.forbiddenEngines);
    }

    public List<String> getEffectivePreference(String recipeType) {
        if (this.preferenceByRecipeType.get(recipeType) != null) {
            return this.cleanEmptyFromList(this.preferenceByRecipeType.get(recipeType));
        }
        return this.cleanEmptyFromList(this.enginesPreferenceOrder);
    }

    @Override
    public RecipeEnginesPreferenceConfig mergeWithParent(RecipeEnginesPreferenceConfig parent) {
        RecipeEnginesPreferenceConfig merged = new RecipeEnginesPreferenceConfig();
        merged.forbiddenEngines = this.forbiddenEngines.size() == 0 ? (List)JSON.deepCopy(parent.forbiddenEngines) : (List)JSON.deepCopy(this.forbiddenEngines);
        merged.forbiddenByRecipeType = this.forbiddenByRecipeType.size() == 0 ? (Map)JSON.deepCopy(parent.forbiddenByRecipeType) : (Map)JSON.deepCopy(this.forbiddenByRecipeType);
        merged.enginesPreferenceOrder = this.enginesPreferenceOrder.size() == 0 ? (List)JSON.deepCopy(parent.enginesPreferenceOrder) : (List)JSON.deepCopy(this.enginesPreferenceOrder);
        merged.preferenceByRecipeType = this.preferenceByRecipeType.size() == 0 ? (Map)JSON.deepCopy(parent.preferenceByRecipeType) : (Map)JSON.deepCopy(this.preferenceByRecipeType);
        return merged;
    }
}

