/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dao.impl;

import com.dataiku.dip.cluster.Cluster;
import com.dataiku.dip.custom.PluginUsagesInspector;
import com.dataiku.dip.dao.ClustersDAO;
import com.dataiku.dip.exceptions.UnavailableDSSObjectException;
import com.dataiku.dip.exceptions.UnavailableTypeException;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.utils.ExtensionFilter;
import com.dataiku.dip.transactions.fs.utils.FileFilter;
import com.dataiku.dip.transactions.fs.utils.RelFileFilter;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.utils.DKULogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class FilesBasedClustersDAO
implements ClustersDAO {
    static DKULogger logger = DKULogger.getLogger((String)"dku.clusters.dao");

    private RelFile getClusterFolder() {
        return new RelFile(new String[]{"clusters"});
    }

    private RelFile getClusterFile(String id) {
        return new RelFile(new String[]{"clusters", id + ".json"});
    }

    @Override
    public Cluster getOrNull(String id) throws IOException {
        return this.getOrNull(id, false);
    }

    @Override
    public Cluster getOrNullUnsafe(String id) throws IOException {
        return this.getOrNull(id, true);
    }

    @Override
    public Cluster getMandatory(String id) throws IOException {
        return this.getMandatory(id, false);
    }

    @Override
    public Cluster getMandatoryUnsafe(String id) throws IOException {
        return this.getMandatory(id, true);
    }

    private Cluster getMandatory(String id, boolean unsafe) throws IOException {
        Cluster obj = this.getOrNull(id, unsafe);
        if (obj == null) {
            throw new NotFoundException("Cluster does not exist: " + id);
        }
        return obj;
    }

    private Cluster getOrNull(String id, boolean unsafe) throws IOException {
        RelFile clusterFile;
        TransactionRef t = TransactionContext.retrieveRead();
        if (!t.isFile(clusterFile = this.getClusterFile(id))) {
            return null;
        }
        Cluster cluster = unsafe ? (Cluster)t.readObjectUnsafe(clusterFile, Cluster.class) : (Cluster)t.readObject(clusterFile, Cluster.class);
        cluster.id = id;
        return cluster;
    }

    @Override
    public void delete(String id) throws IOException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        RelFile clusterFile = this.getClusterFile(id);
        t.deleteFile(clusterFile);
    }

    @Override
    public List<Cluster> list() throws IOException {
        return this.list(false);
    }

    @Override
    public List<Cluster> listUnsafe() throws IOException {
        return this.list(true);
    }

    private List<Cluster> list(boolean unsafe) throws IOException {
        TransactionRef t = TransactionContext.retrieveRead();
        RelFile clusterFolder = this.getClusterFolder();
        ArrayList<Cluster> ret = new ArrayList<Cluster>();
        if (t.exists(clusterFolder)) {
            for (RelFile f : t.listFiles(clusterFolder, (RelFileFilter)ExtensionFilter.json())) {
                try {
                    String id = StringUtils.removeEnd((String)f.getLeafName(), (String)".json");
                    ret.add(this.getMandatory(id, unsafe));
                }
                catch (Exception e) {
                    logger.error((Object)("Failed to read cluster file: " + String.valueOf(f)), (Throwable)e);
                }
            }
        }
        return ret;
    }

    @Override
    public List<PluginUsagesInspector.MissingType> listMissingTypes() throws IOException {
        TransactionRef t = TransactionContext.retrieveRead();
        RelFile clusterFolder = this.getClusterFolder();
        ArrayList<PluginUsagesInspector.MissingType> ret = new ArrayList<PluginUsagesInspector.MissingType>();
        if (t.exists(clusterFolder)) {
            for (RelFile f : t.listFiles(clusterFolder, (RelFileFilter)ExtensionFilter.json())) {
                try {
                    String id = StringUtils.removeEnd((String)f.getLeafName(), (String)".json");
                    this.getMandatory(id, true);
                }
                catch (UnavailableTypeException ute) {
                    ret.add(new PluginUsagesInspector.MissingType(ute.missingType, "cluster", null, null, ute.missingPluginId));
                }
                catch (UnavailableDSSObjectException udoe) {
                    ret.add(new PluginUsagesInspector.MissingType(udoe.unavailableStepInfo.elementId, "cluster", null, null, udoe.unavailableStepInfo.pluginId));
                }
            }
        }
        return ret;
    }

    @Override
    public int approximateCount() throws IOException {
        RelFile clusterFolder;
        TransactionRef t = TransactionContext.retrieveRead();
        if (!t.exists(clusterFolder = this.getClusterFolder())) {
            return 0;
        }
        return t.listFiles(clusterFolder, (RelFileFilter)FileFilter.json()).size();
    }

    @Override
    public void save(Cluster cluster) throws IOException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        RelFile clusterFile = this.getClusterFile(cluster.id);
        t.writeObject(clusterFile, (Object)cluster);
    }

    @Override
    public long getLastModifiedOrZero(String id) throws IOException {
        RelFile clusterFile;
        TransactionRef t = TransactionContext.retrieveRead();
        if (!t.isFile(clusterFile = this.getClusterFile(id))) {
            return 0L;
        }
        return t.getLastModified(clusterFile);
    }
}

