/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow;

import com.dataiku.dip.coremodel.JobDef;
import com.dataiku.dip.coremodel.Partitionable;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.HashesModel;
import com.dataiku.dip.dataflow.ComputableHashComputer;
import com.dataiku.dip.dataflow.ComputeRequiredRefreshOfSubgraphs;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.RecipeHashComputer;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowPartitionable;
import com.dataiku.dip.dataflow.graph.GeneratorEvaluator;
import com.dataiku.dip.datasets.DatasetReadiness;
import com.dataiku.dip.db.DSSDBConnection;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.warnings.WarningsContext;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class ComputeRequiredRefreshRecursiveForcedBuild
extends ComputeRequiredRefreshOfSubgraphs {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.flow.compute.prune");

    public ComputeRequiredRefreshRecursiveForcedBuild(ComputableHashComputer dtComputer, RecipeHashComputer ttComputer, JobDef jobDef, JobActivity topLevelActivity) {
        super(dtComputer, ttComputer, jobDef, topLevelActivity);
    }

    @Override
    public void pruneInternal(DSSDBConnection conn) throws Exception {
        HashSet<String> currentlyVisitingStack = new HashSet<String>();
        this.checkRec(conn, this.topLevelActivity, 0, currentlyVisitingStack);
        assert (currentlyVisitingStack.isEmpty());
    }

    private boolean checkRec(DSSDBConnection conn, JobActivity item, int indentLevel, Set<String> currentlyVisitingStack) throws Exception {
        assert (!item.pruned);
        if (this.requiredActivityCache.containsKey(item)) {
            return (Boolean)this.requiredActivityCache.get(item);
        }
        this.infoV(item, indentLevel, "Checking " + item.id(), new Object[0]);
        if (item.getSubgraph() != null) {
            for (FlowComputable flowComputable : item.getSubgraph().getTargets()) {
                SerializedDataset.RebuildBehavior rebuildBehavior = flowComputable.getRebuildBehavior();
                boolean bl = rebuildBehavior == SerializedDataset.RebuildBehavior.WRITE_PROTECT || rebuildBehavior == SerializedDataset.RebuildBehavior.EXPLICIT && !item.topLevelActivity;
                if (!bl) continue;
                this.infoV(item, indentLevel, "Target %s is write-protected: checking if target partition exists", flowComputable.getFullId());
                if (!this.dtComputer.partitionExists(flowComputable, item.getSubgraph().getTargetPartition(flowComputable))) continue;
                this.infoV(item, indentLevel, "Target %s is write-protected: not writing target %s", flowComputable.getFullId(), item.getSubgraph().getTargetPartition(flowComputable));
                return this.cacheAndReturnIsActivityRequired(item, false);
            }
        }
        if (item.dependencies.size() > 0) {
            ArrayList<JobActivity> requiredDeps = new ArrayList<JobActivity>();
            for (JobActivity jobActivity : item.dependencies) {
                this.infoV(item, indentLevel, "Recursing on dependency: %s", jobActivity.id());
                if (currentlyVisitingStack.contains(jobActivity.id())) {
                    this.infoV(item, indentLevel, "%s is already in the currently visiting set. Loop in Flow likely", jobActivity.id());
                    continue;
                }
                currentlyVisitingStack.add(jobActivity.id());
                boolean bl = this.checkRec(conn, jobActivity, indentLevel + 1, currentlyVisitingStack);
                currentlyVisitingStack.remove(jobActivity.id());
                if (!bl) continue;
                requiredDeps.add(jobActivity);
            }
            item.dependencies = requiredDeps;
            if (item.dependencies.size() > 0) {
                item.setRequiredForDeps();
            }
        } else {
            SerializedRecipe.RecipeHashPropagationBehavior hashPropagationBehavior;
            if (item.getSubgraph() == null) {
                return this.cacheAndReturnIsActivityRequired(item, true);
            }
            this.infoV(item, indentLevel, "Item has no dependencies, checking its sources", new Object[0]);
            if (item.getSubgraph() instanceof RecipeRunnableSubgraph && ((RecipeRunnableSubgraph)item.getSubgraph()).getRecipe().isGenerator()) {
                RecipeRunnableSubgraph subgraph = (RecipeRunnableSubgraph)item.getSubgraph();
                this.infoV(item, indentLevel, "Checking a generator recipe", new Object[0]);
                GeneratorEvaluator generatorEvaluator = subgraph.getRecipe().getGeneratorEvaluator();
                for (FlowComputable flowComputable : item.getSubgraph().getTargets()) {
                    Partition targetP = item.getSubgraph().getTargetPartition(flowComputable);
                    HashesModel.GeneratorHashInfo recordedHash = this.flowStateInternalDB.getPropagatedGeneratorTaskHash(conn, flowComputable.getFullId(), targetP.id(), item.getSubgraph().getName());
                    if (recordedHash == null) {
                        this.infoV(item, indentLevel, "generator task never propagated to %s, so item is required", this.prettyDSP(flowComputable, targetP));
                    } else {
                        this.cachedIsGeneratorExecutionNeeded(generatorEvaluator, flowComputable, targetP);
                    }
                    this.infoV(item, indentLevel, " gtask:" + item.getSubgraph().getName() + " required by nobody", new Object[0]);
                }
                item.setRequiredRecursiveForcedBuild();
            }
            if ((hashPropagationBehavior = SerializedRecipe.RecipeHashPropagationBehavior.getEffectivePropagationBehavior(this.getProjectUnsafe(), item)) == SerializedRecipe.RecipeHashPropagationBehavior.DISABLED) {
                this.infoV(item, indentLevel, "Not checking readiness of sources, disabled", new Object[0]);
            } else {
                for (FlowComputable flowComputable : item.getSubgraph().getSources()) {
                    for (Partition sourceP : item.getSubgraph().getSourcePartitions(flowComputable)) {
                        this.infoV(item, indentLevel, "Checking readiness of %s", this.prettyDSP(flowComputable, sourceP));
                        DatasetReadiness sourcePartitionHash = this.dtComputer.getCurrentContentHash(conn, flowComputable, sourceP);
                        this.infoV(item, indentLevel, "Readiness of %s: %s", new Object[]{this.prettyDSP(flowComputable, sourceP), sourcePartitionHash.status});
                        if (sourcePartitionHash.isReady()) continue;
                        if (hashPropagationBehavior == SerializedRecipe.RecipeHashPropagationBehavior.ENABLED_BUT_IGNORE_NON_READY_SOURCES) {
                            this.infoV(item, indentLevel, "%s is not ready but non-ready-sources allowed --> skipping", this.prettyDSP(flowComputable, sourceP));
                            continue;
                        }
                        if (flowComputable instanceof FlowPartitionable) {
                            Partitionable sourceDataset = ((FlowPartitionable)((Object)flowComputable)).getPartitioned(this.dao);
                            if (sourceDataset.getPartitioningSchema().considerMissingRequestedPartitionsAsEmpty) {
                                item.warnContext.addWarning(WarningsContext.WarningType.MISSING_SOURCE_PARTITION, String.format("Partition %s of source %s was missing, considering it as empty", sourceP.id(), flowComputable.getFullId()), logger);
                                continue;
                            }
                        }
                        this.throwSourceNotReady(flowComputable, sourceP, sourcePartitionHash.error);
                    }
                }
            }
        }
        item.setRequiredRecursiveForcedBuild();
        return this.cacheAndReturnIsActivityRequired(item, true);
    }
}

