/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow;

import com.dataiku.dip.SmartObjectRef;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.coremodel.Zone;
import com.dataiku.dip.dao.IStandardDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.ZonesDAO;
import com.dataiku.dip.dataflow.FlowGraph;
import com.dataiku.dip.dataflow.FlowZone;
import com.dataiku.dip.labeling.LabelingTask;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledge;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.mec.ModelEvaluationStore;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class ProjectFlowGraph
extends FlowGraph {
    @Autowired
    protected ZonesDAO zonesDAO;
    private Map<String, FlowZone> flowZones = new HashMap<String, FlowZone>();
    List<SerializedDataset> allDatasets;
    List<SerializedRecipe> allRecipes;
    List<LabelingTask> allLabelingTasks;
    List<SavedModel> allSavedModels;
    List<ModelEvaluationStore> allModelEvaluationStores;
    List<RetrievableKnowledge> allRetrievableKnowledge;
    List<ManagedFolder> allManagedFolders;
    List<StreamingEndpoint> allStreamingEndpoints;
    private Map<SmartObjectRef, Zone> zoneByObjects = new HashMap<SmartObjectRef, Zone>();
    private Map<String, Zone> zoneByIds = new HashMap<String, Zone>();
    public boolean hasZones = false;
    private String projectKey;

    @Override
    public void buildForProject(String projectKey, boolean includeOrphans, boolean drawZones) throws IOException {
        this.buildForProject_(projectKey, includeOrphans, drawZones);
    }

    @Override
    public void buildForProjectUnsafe(String projectKey, boolean includeOrphans, boolean drawZones) throws IOException {
        this.unsafe = true;
        this.buildForProject_(projectKey, includeOrphans, drawZones);
    }

    private void buildForProject_(String projectKey, boolean includeOrphans, boolean drawZones) throws IOException {
        this.projectKey = projectKey;
        List<Zone> zones = this.zonesDAO.listUnsafe(projectKey);
        this.hasZones = !zones.isEmpty();
        this.indexObjectForZones(zones);
        if (!zones.isEmpty() && drawZones) {
            this.allDatasets = this.list(this.datasetsDAO, projectKey);
            this.allRecipes = this.list(this.recipesDAO, projectKey);
            this.allLabelingTasks = this.list(this.labelingTaskDAO, projectKey);
            this.allSavedModels = this.list(this.smDAO, projectKey);
            this.allModelEvaluationStores = this.list(this.modelEvaluationStoresDAO, projectKey);
            this.allManagedFolders = this.list(this.odbDAO, projectKey);
            this.allStreamingEndpoints = this.list(this.seDAO, projectKey);
            this.allRetrievableKnowledge = this.list(this.retrievableKnowledgeDAO, projectKey);
            Zone defaultZone = null;
            for (Zone zone : zones) {
                if (Zone.DEFAULT_ZONE.getId().equals(zone.getId())) {
                    defaultZone = zone;
                    continue;
                }
                try {
                    this.addZone(zone, projectKey, includeOrphans, drawZones);
                }
                catch (IOException e) {
                    logger.errorV((Throwable)e, "Zone '%s' cannot be include in the flow", new Object[]{zone.getName()});
                }
            }
            if (defaultZone != null) {
                this.addZone(defaultZone, projectKey, includeOrphans, drawZones);
            } else {
                logger.warnV("default zone for %s is not there, flow will be incomplete", new Object[]{projectKey});
            }
        } else {
            super.buildForProject(projectKey, includeOrphans, drawZones);
        }
    }

    private void indexObjectForZones(List<Zone> zones) {
        for (Zone zone : zones) {
            for (SmartObjectRef objectRef : zone.getItems()) {
                this.zoneByObjects.put(objectRef, zone);
            }
        }
    }

    private <T> List<T> list(IStandardDAO<T> dao, String projectKey) throws IOException {
        return this.unsafe ? dao.listUnsafe(projectKey) : dao.list(projectKey);
    }

    private FlowZone addZone(Zone zone, String projectKey, boolean includeOrphans, boolean drawZones) throws IOException {
        FlowZone flowZone = new FlowZone(this, zone, this.allDatasets, this.allRecipes, this.allLabelingTasks, this.allSavedModels, this.allModelEvaluationStores, this.allManagedFolders, this.allStreamingEndpoints, this.allRetrievableKnowledge);
        flowZone.buildForProject(projectKey, includeOrphans, drawZones);
        this.flowZones.put(zone.getId(), flowZone);
        this.zoneByIds.put(zone.getId(), zone);
        return flowZone;
    }

    public Collection<FlowZone> getFlowZones() {
        return this.flowZones.values();
    }

    public FlowZone getFlowZone(String zoneId) {
        return this.flowZones.get(zoneId);
    }

    @Override
    public Map<String, TaggableObjectsService.TaggableObject> getGraphElements() throws IOException {
        return this.getGraphElements("");
    }

    public Map<String, TaggableObjectsService.TaggableObject> getGraphElements(String zoneId) throws IOException {
        Map<String, TaggableObjectsService.TaggableObject> graphElements = new HashMap<String, TaggableObjectsService.TaggableObject>();
        for (FlowZone zone : this.getFlowZones()) {
            if (!StringUtils.isBlank((String)zoneId) && !Objects.equals(zone.getZone().getId(), zoneId)) continue;
            graphElements.putAll(zone.getGraphElements());
            graphElements.put("zone_" + zone.getZone().getId(), zone.getZone());
        }
        if (graphElements.isEmpty()) {
            graphElements = super.getGraphElements();
        }
        return graphElements;
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public Zone getZone(String zoneId) {
        return this.zoneByIds.get(zoneId);
    }

    public Zone getZone(TaggableObjectsService.TaggableObject taggableObject) {
        if (taggableObject == null) {
            return null;
        }
        return this.getZone(SmartObjectRef.fromResolved(taggableObject.getTaggableType(), taggableObject.getProjectKey(), taggableObject.getId(), this.projectKey));
    }

    public Zone getZone(SmartObjectRef smRef) {
        return this.zoneByObjects.get(smRef);
    }
}

