/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.cde;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.BuiltinsLoader;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.cli.CLISetup;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.HadoopSettings;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dataflow.Job;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.JobKernelUtils;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.cde.CDEActivityThreadsRunner;
import com.dataiku.dip.dataflow.cde.CDEHeartbeatThread;
import com.dataiku.dip.dataflow.cde.CDEProcessUtils;
import com.dataiku.dip.dataflow.cde.CDEResourceMonitor;
import com.dataiku.dip.dataflow.cde.ContainerizedDSSEngineAble;
import com.dataiku.dip.dataflow.cde.ContainerizedDSSEngineDef;
import com.dataiku.dip.dataflow.cde.ContainerizedDSSLicenseStatusService;
import com.dataiku.dip.dataflow.exec.FlowRunnable;
import com.dataiku.dip.dataflow.exec.RecipeRunnerWithPayload;
import com.dataiku.dip.dataflow.exec.WithAdditionalRunnables;
import com.dataiku.dip.dataflow.exec.dataquality.ExtractFailedRowsRecipeRunner;
import com.dataiku.dip.dataflow.exec.distinct.DistinctRecipeMeta;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.FuzzyJoinRecipeRunner;
import com.dataiku.dip.dataflow.exec.geojoin.GeoJoinRecipeRunner;
import com.dataiku.dip.dataflow.exec.grouping.GroupingRecipeRunner;
import com.dataiku.dip.dataflow.exec.join.ContainerizedJoinExecutor;
import com.dataiku.dip.dataflow.exec.join.JoinRecipeSingleOutputRunner;
import com.dataiku.dip.dataflow.exec.lsfolder.ListFolderContentsRecipeRunner;
import com.dataiku.dip.dataflow.exec.pivot.PivotRecipeRunner;
import com.dataiku.dip.dataflow.exec.sampling.SamplingRecipeRunner;
import com.dataiku.dip.dataflow.exec.sort.SortRecipeRunner;
import com.dataiku.dip.dataflow.exec.split.SplitRecipeRunner;
import com.dataiku.dip.dataflow.exec.sync.SyncRecipeRunner;
import com.dataiku.dip.dataflow.exec.topn.TopNRecipeRunner;
import com.dataiku.dip.dataflow.exec.upsert.UpsertRecipeRunner;
import com.dataiku.dip.dataflow.exec.vstack.VStackRecipeRunner;
import com.dataiku.dip.dataflow.exec.window.WindowRecipeRunner;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.jobrunner.ActivityRunner;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.dataflow.jobrunner.PerJobLoggingAppender;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.hadoop.HadoopLoader;
import com.dataiku.dip.io.DockerSimplePythonKernel;
import com.dataiku.dip.io.KubernetesSimplePythonKernel;
import com.dataiku.dip.io.LocalSimplePythonKernel;
import com.dataiku.dip.license.LicenseStatusService;
import com.dataiku.dip.logging.MainLoggingConfigurator;
import com.dataiku.dip.meanings.IBasicMeaningsService;
import com.dataiku.dip.recipes.RecipeRunner;
import com.dataiku.dip.recipes.export.ExportRecipeRunner;
import com.dataiku.dip.recipes.merge_folder.MergeFolderRecipeRunner;
import com.dataiku.dip.recipes.shaker.ShakerRecipeRunner;
import com.dataiku.dip.remoterun.RemoteRunFileExchangeClient;
import com.dataiku.dip.remoterun.RemoteRunFileExchangeService;
import com.dataiku.dip.remoterun.RemoteRunsRegistry;
import com.dataiku.dip.resourceusage.ComputeResourceUsageContext;
import com.dataiku.dip.resourceusage.CurrentComputeResourceUsageContext;
import com.dataiku.dip.rpc.TicketBasedIntercomAPIClient;
import com.dataiku.dip.scheduler.scenarios.ScenarioRunContext;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.RegularPasswordEncryptionService;
import com.dataiku.dip.security.impersonation.ImpersonationConfig;
import com.dataiku.dip.security.impersonation.ImpersonationResolverService;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.security.tickets.FixedTicketService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.SingleWriteTransactionTransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.ifaces.RelFileInputStream;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.util.PoiUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class ContainerizedDSSEngineMain {
    public static final String CDE_OVERRIDE_PREFIX = "dku.cde.override.";
    private static final Logger logger = Logger.getLogger((String)"dku.cde");

    private static void setupJobLogging() {
        PerJobLoggingAppender appender = new PerJobLoggingAppender(false);
        String pattern = "%-4r [%t] %-5p %c %x - %m%n";
        Enumeration enumeration = Logger.getRootLogger().getAllAppenders();
        while (enumeration.hasMoreElements()) {
            Appender a = (Appender)enumeration.nextElement();
            if (a.getLayout() == null || !(a.getLayout() instanceof PatternLayout)) continue;
            PatternLayout pl = (PatternLayout)a.getLayout();
            pattern = pl.getConversionPattern();
        }
        appender.setLayout((Layout)new PatternLayout(pattern));
        Logger.getRootLogger().addAppender((Appender)appender);
        LocalSimplePythonKernel.loggerNotAdditive.addAppender((Appender)appender);
        DockerSimplePythonKernel.loggerNotAdditive.addAppender((Appender)appender);
        KubernetesSimplePythonKernel.loggerNotAdditive.addAppender((Appender)appender);
    }

    public static void main(String[] args) {
        logger.info((Object)"Begin CDE run");
        AnnotationConfigApplicationContext appContext = null;
        try {
            appContext = ContainerizedDSSEngineMain.initAppContext();
        }
        catch (IOException e) {
            logger.error((Object)"Could not init CDE context", (Throwable)e);
            System.exit(1);
        }
        try {
            ContainerizedDSSEngineMain.runActivity();
        }
        catch (Throwable t) {
            SerializedError error = new SerializedError(t, true);
            String executionId = System.getenv("DKU_EXECUTION_ID");
            try (TicketBasedIntercomAPIClient apiClient = CDEProcessUtils.newIntercomAPIClient();){
                RemoteRunFileExchangeClient rrfec = new RemoteRunFileExchangeClient(apiClient, "tintercom", executionId);
                rrfec.uploadSingleFile(new ByteArrayInputStream(JSON.prettyToBytesAsFile((Object)error)), "error.json", RemoteRunFileExchangeService.FileKind.EXECUTION_DIR, "error.json");
                logger.info((Object)"Error sent to JEK");
            }
            catch (Exception e) {
                logger.error((Object)"Failed to send error to JEK", (Throwable)e);
            }
            appContext.close();
            System.exit(1);
        }
        appContext.close();
        logger.info((Object)"Finish CDE run");
        System.exit(0);
    }

    public static AnnotationConfigApplicationContext initAppContext() throws IOException {
        System.setProperty("DIP_HOME", System.getenv("DIP_HOME"));
        ApplicationConfigurator.autoconfigure();
        ApplicationConfigurator.setProcessType((MainLoggingConfigurator.ProcessType)MainLoggingConfigurator.ProcessType.CDE);
        MainLoggingConfigurator.configure((MainLoggingConfigurator.ProcessType)MainLoggingConfigurator.ProcessType.CDE);
        ClusterSelector.setContext(MainLoggingConfigurator.ProcessType.CDE);
        System.setProperty("h2.bindAddress", "127.0.0.1");
        logger.info((Object)("CDE kernel starting, process: " + ManagementFactory.getRuntimeMXBean().getName()));
        logger.info((Object)("CDE process Xmx set to: " + Runtime.getRuntime().maxMemory()));
        CDEProcessUtils.setupFromEnvironmentVariables();
        BuiltinsLoader.load();
        ContainerizedDSSEngineMain.setupJobLogging();
        return CLISetup.doCDESetup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runActivity() throws Exception {
        RemoteRunsRegistry.Execution execution;
        logger.info((Object)"Classes loaded, starting server");
        MainLoggingConfigurator.configureLimits();
        HadoopSettings hadoopSettings = new ClusterSelector().selectGlobal().getHadoopSettings();
        hadoopSettings.kerberosLoginEnabled = false;
        HadoopLoader.initializeSecurity(hadoopSettings, true, false);
        if (BuiltinsLoader.apachePoiAvailable()) {
            PoiUtils.initializePoi();
        }
        JobKernelUtils.preloadStuffWithExpensiveInitsAfterServerIsReady();
        logger.info((Object)"Getting execution specs");
        String executionId = System.getenv("DKU_EXECUTION_ID");
        try (TicketBasedIntercomAPIClient apiClient = CDEProcessUtils.newIntercomAPIClient();){
            execution = (RemoteRunsRegistry.Execution)apiClient.getForm("/tintercom/containers/get-execution", RemoteRunsRegistry.Execution.class, new Object[]{"executionId", executionId, "version", DKUApp.getDSSVersion().product_version});
        }
        ContainerizedDSSEngineDef cdeDef = (ContainerizedDSSEngineDef)JSON.parse((String)execution.payload, ContainerizedDSSEngineDef.class);
        FixedTicketService ticketService = new FixedTicketService((AuthCtx)cdeDef.authCtx, CDEProcessUtils.getAPITicket(), "mother_api_ticket");
        SpringUtils.getInstance().registerSingletonBean(APITicketService.class, (Object)ticketService);
        File localConfigZipFile = ApplicationConfigurator.getFile((String)FlowJobUtils.LOCALCONFIG_ARCHIVE_NAME);
        if (localConfigZipFile.exists()) {
            DKUFileUtils.delete((File)localConfigZipFile);
        }
        try (TicketBasedIntercomAPIClient apiClient = CDEProcessUtils.newIntercomAPIClient();
             InputStream is = apiClient.getFormToInputStream("/tintercom/containers/download-local-config", new Object[]{"executionId", executionId});){
            FileUtils.copyInputStreamToFile((InputStream)is, (File)localConfigZipFile);
        }
        JSON.prettyToFile((Object)execution.envResource, (File)new File("remote-run-env-def.json"));
        SingleWriteTransactionTransactionService transactionService = (SingleWriteTransactionTransactionService)SpringUtils.getBean(SingleWriteTransactionTransactionService.class);
        RWTransaction t = transactionService.beginTheSingleTransactionOnArchive(localConfigZipFile, FlowJobUtils.LOCALCONFIG_FOLDER_NAME, cdeDef.authCtx);
        GeneralSettingsDAO generalSettingsDAO = (GeneralSettingsDAO)SpringUtils.getBean(GeneralSettingsDAO.class);
        GeneralSettingsDAO.GeneralSettings generalSettings = generalSettingsDAO.getUnsafeAutoTXN();
        generalSettings.impersonation = new ImpersonationConfig();
        generalSettings.containerSettings.defaultExecutionConfigForExporters = null;
        generalSettings.cgroupSettings.enabled = false;
        generalSettingsDAO.save(generalSettings);
        ContainerizedDSSEngineMain.overwriteDipPropertiesWithDownloadedConfig(t);
        logger.info((Object)"Starting heartbeat thread");
        CDEHeartbeatThread thread = new CDEHeartbeatThread(DKUApp.getParams().getIntParam("dku.cde.heartbeat.maxFailures", Integer.valueOf(6)), DKUApp.getParams().getIntParam("dku.cde.heartbeat.delayMS", Integer.valueOf(10000)));
        thread.setDaemon(true);
        thread.start();
        ((IBasicMeaningsService)SpringUtils.getBean(IBasicMeaningsService.class)).invalidateCache();
        RegularPasswordEncryptionService symetricCryptoService = (RegularPasswordEncryptionService)SpringUtils.getBean(RegularPasswordEncryptionService.class);
        symetricCryptoService.reinit();
        TransactionContext.attach((TransactionRef)t);
        try {
            ConnectionsDAO connectionsDAO = ConnectionsDAO.get();
            Map<String, DSSConnection> connections = connectionsDAO.list();
            boolean changed = false;
            for (DSSConnection connection : connections.values()) {
                if (!(connection instanceof AbstractSQLConnection)) continue;
                Object params = ((AbstractSQLConnection)connection).getParams();
                if (!StringUtils.isNotBlank((String)((AbstractSQLConnection.AbstractSQLParams)params).jarsDirectory)) continue;
                changed = true;
                String jarsDirectoryHash = DigestUtils.md5Hex((byte[])((AbstractSQLConnection.AbstractSQLParams)params).jarsDirectory.getBytes(StandardCharsets.UTF_8));
                ((AbstractSQLConnection.AbstractSQLParams)params).jarsDirectory = "/home/dataiku/drivers/jdbc-" + jarsDirectoryHash;
            }
            if (changed) {
                logger.info((Object)"Write connection with updated jars directories");
                connectionsDAO.writeList(connections);
            }
        }
        finally {
            TransactionContext.detach((TransactionRef)t);
        }
        JobActivity activityObj = new JobActivity(new RecipeRunnableSubgraph(new FlowRecipe(null)));
        TransactionContext.attach((TransactionRef)t);
        try {
            cdeDef.activityObj.toNative(activityObj);
        }
        finally {
            TransactionContext.detach((TransactionRef)t);
        }
        cdeDef.def.autoUpdateSchemaBeforeEachRecipeRun = false;
        Job jobObj = new Job(cdeDef.def, activityObj);
        JobContext.setJob(cdeDef.projectKey, cdeDef.jobId, jobObj);
        JobContext.setCurrentActivityInThread(activityObj);
        if (cdeDef.scenarioRun != null) {
            ((ScenarioRunContext)SpringUtils.getBean(ScenarioRunContext.class)).setScenarioRun(cdeDef.scenarioRun);
        }
        CurrentComputeResourceUsageContext.setInCurrentThreadIfNull((ComputeResourceUsageContext)ComputeResourceUsageContext.forCDE((AuthCtx)cdeDef.authCtx, (String)cdeDef.projectKey, (String)cdeDef.jobId, (String)activityObj.id()));
        logger.info((Object)"Start self-monitoring");
        try (CDEResourceMonitor monitor = new CDEResourceMonitor(cdeDef, activityObj);){
            ((ImpersonationResolverService)SpringUtils.getBean(ImpersonationResolverService.class)).setImpersonationConfig(generalSettingsDAO.getUnsafeAutoTXN().impersonation);
            ((ContainerizedDSSLicenseStatusService)SpringUtils.getBean(LicenseStatusService.class)).setLicensingStatus(cdeDef.licensingStatus != null ? cdeDef.licensingStatus : new LicenseStatusService.LicensingStatus());
            File activityFolder = DKUFileUtils.getWithin((File)FlowJobUtils.getCurrentJobFolder(), (String[])new String[]{cdeDef.activity});
            DKUFileUtils.mkdirs((File)activityFolder);
            logger.info((Object)"Run recipe");
            RecipeRunner runner = switch (cdeDef.activityObj.subgraph.recipe.type) {
                case "sampling" -> new SamplingRecipeRunner(activityObj);
                case "sync" -> new SyncRecipeRunner(activityObj);
                case "shaker" -> new ShakerRecipeRunner(activityObj);
                case "topn" -> new TopNRecipeRunner(activityObj);
                case "split" -> new SplitRecipeRunner(activityObj);
                case "pivot" -> new PivotRecipeRunner(activityObj);
                case "list_folder_contents" -> new ListFolderContentsRecipeRunner(activityObj);
                case "merge_folder" -> new MergeFolderRecipeRunner(activityObj);
                case "join" -> {
                    ContainerizedJoinExecutor.ContainerizedJoinExtraDef extraDef = (ContainerizedJoinExecutor.ContainerizedJoinExtraDef)JSON.parse((JsonElement)cdeDef.extraDef, ContainerizedJoinExecutor.ContainerizedJoinExtraDef.class);
                    yield new JoinRecipeSingleOutputRunner(activityObj, extraDef.role);
                }
                case "grouping" -> new GroupingRecipeRunner(activityObj);
                case "extract_failed_rows" -> new ExtractFailedRowsRecipeRunner(activityObj);
                case "upsert" -> new UpsertRecipeRunner(activityObj);
                case "distinct" -> DistinctRecipeMeta.META.buildRunner(activityObj);
                case "sort" -> new SortRecipeRunner(activityObj);
                case "window" -> new WindowRecipeRunner(activityObj);
                case "vstack" -> new VStackRecipeRunner(activityObj);
                case "geojoin" -> new GeoJoinRecipeRunner(activityObj);
                case "fuzzyjoin" -> new FuzzyJoinRecipeRunner(activityObj);
                case "export" -> new ExportRecipeRunner(activityObj);
                default -> throw new Exception("Recipe type can't run in container: " + cdeDef.activityObj.subgraph.recipe.type);
            };
            TransactionContext.attach((TransactionRef)t);
            try {
                SpringUtils.getInstance().autowire((Object)runner);
                ((ContainerizedDSSEngineAble)((Object)runner)).setIsRunningInContainer();
                if (runner instanceof RecipeRunnerWithPayload) {
                    RecipesDAO dao = (RecipesDAO)SpringUtils.getBean(RecipesDAO.class);
                    RecipeRunnableSubgraph rsubgraph = (RecipeRunnableSubgraph)activityObj.getSubgraph();
                    FlowRecipe recipe = rsubgraph.getRecipe();
                    ((RecipeRunnerWithPayload)((Object)runner)).setPayload(dao.getPayloadOrNull(recipe.getProjectKey(), recipe.getName()));
                }
                runner.init();
                ArrayList runnables = Lists.newArrayList();
                if (runner instanceof WithAdditionalRunnables) {
                    runnables.addAll(((WithAdditionalRunnables)((Object)runner)).getRunnables());
                }
                if (runner instanceof FlowRunnable) {
                    runnables.add((FlowRunnable)((Object)runner));
                }
                CDEActivityThreadsRunner arunner = new CDEActivityThreadsRunner();
                for (FlowRunnable runnable : runnables) {
                    logger.info((Object)("Prepare thread for " + String.valueOf(runnable)));
                    ActivityRunner.FlowRunnableThread flowRunnableThread = new ActivityRunner.FlowRunnableThread((TransactionRef)t, runnable, activityObj);
                    flowRunnableThread.setComputeResourceUsageContext(ComputeResourceUsageContext.forCDE((AuthCtx)cdeDef.authCtx, (String)cdeDef.projectKey, (String)cdeDef.jobId, (String)activityObj.id()));
                    arunner.addRunnableThreads(flowRunnableThread);
                }
                CDEActivityThreadsRunner.setCurrentActivityRunnableThreadsHolder(arunner);
                try {
                    arunner.run();
                }
                finally {
                    try (TicketBasedIntercomAPIClient apiClient = CDEProcessUtils.newIntercomAPIClient();){
                        RemoteRunFileExchangeClient rrfec = new RemoteRunFileExchangeClient(apiClient, "tintercom", executionId);
                        rrfec.uploadSingleFile(new ByteArrayInputStream(JSON.prettyToBytesAsFile((Object)activityObj.warnContext.getOutput())), "cde-warnings.json", RemoteRunFileExchangeService.FileKind.EXECUTION_DIR, "cde-warnings.json");
                        logger.info((Object)"Warnings sent to JEK");
                    }
                    catch (Exception e) {
                        logger.warn((Object)"Failed to send warnings to JEK", (Throwable)e);
                    }
                }
            }
            finally {
                TransactionContext.detach((TransactionRef)t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void overwriteDipPropertiesWithDownloadedConfig(RWTransaction t) throws IOException {
        TransactionContext.attach((TransactionRef)t);
        try (RelFileInputStream is = t.readStream("dip.properties");
             OutputStream os = Files.newOutputStream(Paths.get(ApplicationConfigurator.getBaseFolder() + "/config/dip.properties", new String[0]), new OpenOption[0]);){
            Map<String, String> properties = ContainerizedDSSEngineMain.overrideDipPropertiesWithCDEKeys((InputStream)is);
            logger.info((Object)"Overriding dip.properties from downloaded local config");
            PrintWriter writer = new PrintWriter((Writer)new OutputStreamWriter(os), true);
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                writer.println(String.format("%s=%s", entry.getKey(), entry.getValue()));
            }
        }
        finally {
            TransactionContext.detach((TransactionRef)t);
        }
    }

    static Map<String, String> overrideDipPropertiesWithCDEKeys(InputStream is) throws IOException {
        Properties config = new Properties();
        config.load(is);
        HashMap<String, String> properties = new HashMap<String, String>((Map<String, String>)Maps.fromProperties((Properties)config));
        HashMap<String, String> overridenProperties = new HashMap<String, String>();
        for (Map.Entry entry : properties.entrySet()) {
            if (!((String)entry.getKey()).startsWith(CDE_OVERRIDE_PREFIX)) continue;
            String keyToOverride = ((String)entry.getKey()).replace(CDE_OVERRIDE_PREFIX, "");
            logger.info((Object)String.format("Will override dip.properties '%s' with '%s'", keyToOverride, entry.getValue()));
            overridenProperties.put(keyToOverride, (String)entry.getValue());
        }
        properties.putAll(overridenProperties);
        return properties;
    }
}

