/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.io;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.FuzzyJoinRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.TextNormaliser;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.io.Record;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.io.Writer;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.NotImplementedException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class FuzzyJoinRecords
implements Iterable<Record> {
    public final int table;
    private final Writer writer;
    private final ColumnFactory cf;
    private final List<FuzzyJoinRecipePayloadParams.MatchingCondition> matchingConditions;
    private final List<TextNormaliser> normalisers;
    private final Map<String, Type> schema;
    private final String indexName;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.fuzzyjoin.FuzzyJoinRecords");

    public FuzzyJoinRecords(int table, Writer h2Writer, ColumnFactory cf, Schema schema, List<FuzzyJoinRecipePayloadParams.MatchingCondition> matchingConditions) {
        this.table = table;
        this.writer = h2Writer;
        this.cf = cf;
        this.schema = schema.columns.stream().collect(Collectors.toMap(SchemaColumn::getName, SchemaColumn::getType));
        this.matchingConditions = matchingConditions;
        this.normalisers = new ArrayList<TextNormaliser>();
        for (FuzzyJoinRecipePayloadParams.MatchingCondition condition : matchingConditions) {
            this.normalisers.add(new TextNormaliser(condition.normaliseDesc));
        }
        this.indexName = "INDEX_ROW_" + table;
    }

    public RecordsIterator iterator() {
        return new RecordsIterator();
    }

    public class RecordsIterator
    implements Iterator<Record>,
    AutoCloseable {
        private Statement sqlStatement;
        private ResultSet h2ResultSet;
        private ResultSetMetaData h2Metadata;
        @Nullable
        private Map<String, String> nextRow = new HashMap<String, String>();

        public RecordsIterator() {
            try {
                this.sqlStatement = FuzzyJoinRecords.this.writer.rowsDAO.createStatement();
            }
            catch (SQLException statementException) {
                logger.error((Object)"Failed to create SQL statement with h2", (Throwable)statementException);
                throw new RuntimeException("Failed to select the rows from h2", statementException);
            }
            try {
                this.h2ResultSet = FuzzyJoinRecords.this.writer.rowsDAO.selectAllRows(FuzzyJoinRecords.this.table, this.sqlStatement);
            }
            catch (SQLException resultSetException) {
                logger.error((Object)"Failed to select the rows from h2", (Throwable)resultSetException);
                try {
                    this.sqlStatement.close();
                }
                catch (SQLException closeStatementException) {
                    logger.error((Object)"Failed to close the SQL statement", (Throwable)closeStatementException);
                }
                throw new RuntimeException("Failed to select the rows from h2", resultSetException);
            }
            try {
                this.h2Metadata = this.h2ResultSet.getMetaData();
            }
            catch (SQLException metaDataException) {
                logger.error((Object)"Failed to retrieve the metadata of the result set", (Throwable)metaDataException);
                try {
                    this.close();
                }
                catch (SQLException closeResourcesException) {
                    logger.error((Object)"Failed to close the resources", (Throwable)closeResourcesException);
                }
                throw new RuntimeException("Failed to select the rows from h2", metaDataException);
            }
            this.prepareNextRow();
        }

        @Override
        public boolean hasNext() {
            return this.nextRow != null;
        }

        @Override
        public Record next() {
            if (this.nextRow == null) {
                throw new NoSuchElementException();
            }
            Record result = this.makeRecord(this.nextRow);
            this.prepareNextRow();
            return result;
        }

        private void prepareNextRow() {
            try {
                if (this.h2ResultSet.next()) {
                    FuzzyJoinRecords.this.writer.rowsDAO.fillRow(FuzzyJoinRecords.this.table, this.h2ResultSet, this.h2Metadata, this.nextRow);
                } else {
                    this.nextRow = null;
                }
            }
            catch (SQLException e) {
                logger.error((Object)"Failed to access the database", (Throwable)e);
                throw new RuntimeException("Failed to access the database", e);
            }
        }

        @Override
        public void remove() {
            throw new NotImplementedException("Remove method not supported");
        }

        private Record makeRecord(Map<String, String> row) {
            int index = this.parseRowIndex(row);
            Record record = new Record(FuzzyJoinRecords.this.table, index);
            for (int i = 0; i < FuzzyJoinRecords.this.matchingConditions.size(); ++i) {
                FuzzyJoinRecipePayloadParams.MatchingCondition condition = FuzzyJoinRecords.this.matchingConditions.get(i);
                TextNormaliser normaliser = FuzzyJoinRecords.this.normalisers.get(i);
                String columnName = FuzzyJoinRecords.this.table == 0 ? condition.column1.name : condition.column2.name;
                Column column = FuzzyJoinRecords.this.cf.getColumn(columnName);
                String joinValue = row.get(columnName);
                record.addJoinValue(normaliser.apply(joinValue, FuzzyJoinRecords.this.schema.get(column.getName())));
            }
            return record;
        }

        private int parseRowIndex(Map<String, String> row) {
            String indexValue = row.get(FuzzyJoinRecords.this.indexName);
            return Integer.parseInt(indexValue);
        }

        @Override
        public void close() throws SQLException {
            this.sqlStatement.close();
            this.h2ResultSet.close();
        }
    }
}

