/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.pivot;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ImpalaConnection;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.pivot.AbstractPivotRecipeSQLlikeExecutor;
import com.dataiku.dip.dataflow.exec.pivot.PivotElementsModalitiesSnapshot;
import com.dataiku.dip.dataflow.exec.pivot.PivotRecipePayloadParams;
import com.dataiku.dip.datasets.DatasetUtils;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.hive.HiveSchemaHandler;
import com.dataiku.dip.impala.ImpalaConfigurator;
import com.dataiku.dip.recipes.code.impala.ImpalaExecutor;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipesBaseService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.sql.ImpalaSQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class PivotRecipeImpalaExecutor
extends AbstractPivotRecipeSQLlikeExecutor {
    private static final ImpalaSQLDialect dialect = new ImpalaSQLDialect();
    private ImpalaExecutor.ImpalaExecutorParams impalaParams;
    private static Logger logger = Logger.getLogger((String)"dip.recipe.pivot.impala.executor");

    public PivotRecipeImpalaExecutor(VisualSQLRecipesBaseService.SQLBasedEngineStatus engine, JobActivity activity, PivotRecipePayloadParams params, ImpalaExecutor.ImpalaExecutorParams impalaParams) {
        super(engine, activity, params);
        this.impalaParams = impalaParams;
    }

    @Override
    protected boolean schemaComparisonIsCaseSensitive() {
        return false;
    }

    @Override
    protected SQLUtils.SQLTable getSQLTable() throws IOException {
        return DatasetUtils.getResolvedTableWithSparkSQLFallback(this.inputDS, this.getInputDialect(), this.params.engineParams);
    }

    @Override
    protected SQLDialect getOutputDialect() throws IOException {
        return dialect;
    }

    @Override
    protected void execute(List<PivotElementsModalitiesSnapshot.PivotElementsModalities> pivotElementsModalities) throws Exception {
        final ImpalaExecutor runner = new ImpalaExecutor(this.activity, this.impalaParams, this.generateSQL(pivotElementsModalities, dialect), StringUtils.isNotBlank((String)this.impalaParams.preQueries) ? Lists.newArrayList((Object[])new String[]{this.impalaParams.preQueries}) : null, null);
        try (AutoCloseable hook = this.startAbortableTask(new Runnable(){

            @Override
            public void run() {
                logger.info((Object)"Aborting pivoting query");
                runner.notifyBeforeAborting();
            }
        });){
            SpringUtils.getInstance().autowire((Object)runner);
            runner.run();
        }
    }

    @Override
    protected SQLDialect getInputDialect() throws IOException {
        return dialect;
    }

    @Override
    protected AbstractSQLConnection getInputSQLConnection() throws IOException, DKUSecurityException, SQLException {
        String inputImpalaDb = HiveSchemaHandler.getResolvedHiveTableRefFromDataset(this.inputDS).getSchemaNullIfBlank();
        ImpalaConnection connection = ImpalaConfigurator.configureConnectionForDatabase(this.authCtxService.getAuthCtx(), inputImpalaDb);
        return connection;
    }
}

