/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.sync;

import com.dataiku.dip.connections.GCSConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dataflow.exec.sync.CloudToSnowflake;
import com.dataiku.dip.dataflow.exec.sync.FastPathDatasetTypeStraightener;
import com.dataiku.dip.dataflow.exec.sync.SnowflakeToCloud;
import com.dataiku.dip.dataflow.exec.sync.SnowflakeToGcs;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.fs.GCSDatasetHandler;
import com.dataiku.dip.datasets.sql.BuiltinSQLDatasets;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.recipes.common.RecipeEngineStatus;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.sql.SnowflakeSQLDialect;
import com.dataiku.dip.utils.DKULogger;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;

public class GcsToSnowflake
extends CloudToSnowflake<GCSDatasetHandler> {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.sync.gcstosnowflake");

    public static void setCompatible(AuthCtx authCtx, Dataset inputDS, Dataset outputDS, RecipeEngineStatus status) throws IOException, DKUSecurityException {
        DatasetHandler.DatasetMeta<?, ?> outputMeta = DatasetHandlerFactory.getMeta(outputDS);
        status.isSelectable = true;
        try {
            if (!new FastPathDatasetTypeStraightener().isEquivalentTo(inputDS, "GCS")) {
                throw new SnowflakeToCloud.SnowflakeCloudFastpathImpossibleException("Input dataset is not in GCS");
            }
            if (outputMeta != BuiltinSQLDatasets.SNOWFLAKE_META) {
                throw new SnowflakeToCloud.SnowflakeCloudFastpathImpossibleException("Output dataset is not in Snowflake");
            }
            GCSConnection gcsConnection = (GCSConnection)new FastPathDatasetTypeStraightener().getMandatoryConnectionUnsafeUnexpanded(authCtx, inputDS, "GCS");
            SnowflakeToGcs.checkGcsConnectionParams(gcsConnection);
            SnowflakeToCloud.getCopyMode(inputDS, true);
        }
        catch (SnowflakeToCloud.SnowflakeCloudFastpathImpossibleException e) {
            status.markAsNonSelectable(e.getMessage(), RecipeEngineStatus.WarningLevel.ERROR);
        }
    }

    @Override
    protected String getRootPath(GCSDatasetHandler blobDShandler) throws DKUSecurityException, CodedException, IOException {
        return blobDShandler.getRootPathForSnowflakeFastPath();
    }

    @Override
    protected String generateCopyStatementFromCloud(String outputTableFullName, String inputRootPath, String specifiedFilePaths, CloudToSnowflake.CopyMode mode, GCSDatasetHandler blobDsHandler, boolean append, StringBuilder displayableSql) {
        GCSConnection inputConnection = (GCSConnection)blobDsHandler.getConnection();
        SnowflakeToGcs.checkGcsConnectionParams(inputConnection);
        SnowflakeSQLDialect dialect = new SnowflakeSQLDialect();
        Object storageIntegrationSql = "";
        if (!inputRootPath.startsWith("@")) {
            if (StringUtils.isBlank((String)inputConnection.params.snowflakeStorageIntegration)) {
                throw new SnowflakeToCloud.SnowflakeCloudFastpathImpossibleException("Snowflake storage integration is not defined for GCS connection: " + inputConnection.name);
            }
            storageIntegrationSql = "STORAGE_INTEGRATION=" + dialect.quoteIdentifier(inputConnection.params.snowflakeStorageIntegration);
        }
        Object copyStatement = String.format("COPY INTO %s FROM '%s'   %s   %s   FILE_FORMAT = (%s " + mode.generateSnowflakeParquetLogicalTypes() + " )   FORCE=%s", outputTableFullName, inputRootPath, mode.generateToSnowflakeCommonOptions(), storageIntegrationSql, mode.generateFormatOptions(), append ? "true" : "false");
        if (StringUtils.isNotBlank((String)specifiedFilePaths)) {
            copyStatement = (String)copyStatement + "   FILES = (" + specifiedFilePaths + ")";
        }
        logger.info((Object)("Executing: " + (String)copyStatement));
        return copyStatement;
    }
}

