/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.sync;

import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.exec.FlowRunnable;
import com.dataiku.dip.dataflow.exec.SISORecipeExecutor;
import com.dataiku.dip.dataflow.exec.sync.CloudToSnowflake;
import com.dataiku.dip.dataflow.exec.sync.FastPathDatasetTypeStraightener;
import com.dataiku.dip.dataflow.exec.sync.FastpathUtils;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.fs.BlobLikeDatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLTableDatasetHandler;
import com.dataiku.dip.datasets.sql.BuiltinSQLDatasets;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.input.formats.csv.CSVFormatConfig;
import com.dataiku.dip.input.formats.parquet.ParquetFormatConfig;
import com.dataiku.dip.partitioning.FilePartitioner;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.SnowflakeSQLDialect;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.ExpressionUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.StringUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;

public abstract class SnowflakeToCloud<T extends BlobLikeDatasetHandler<?>>
extends SISORecipeExecutor {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.sync.snowflaketoscloud");

    protected static void checkCompatible(Dataset inputDS, Dataset outputDS, String outputType) {
        DatasetHandler.DatasetMeta<?, ?> inputMeta = DatasetHandlerFactory.getMeta(inputDS);
        if (inputMeta != BuiltinSQLDatasets.SNOWFLAKE_META) {
            throw new SnowflakeCloudFastpathImpossibleException("Input dataset is not in Snowflake");
        }
        if (!new FastPathDatasetTypeStraightener().isEquivalentTo(outputDS, outputType)) {
            throw new SnowflakeCloudFastpathImpossibleException("Output dataset is not in " + outputType);
        }
        if (!DatasetInspector.isSQLTable(inputDS)) {
            throw new SnowflakeCloudFastpathImpossibleException("Input dataset is not a SQL table dataset");
        }
        if (!SnowflakeToCloud.isValidParquetFastPathSchema(inputDS, outputDS)) {
            throw new SnowflakeCloudFastpathImpossibleException("The output dataset has Parquet format, and contains integer columns, for which direct Snowflake unload is not supported");
        }
        SnowflakeToCloud.getCopyMode(outputDS, false);
    }

    protected static CloudToSnowflake.CopyMode getCopyMode(Dataset ds, boolean fromCloudToSnowflake) {
        String dsFullName = ds.getFullName();
        if ("csv".equals(ds.getFormatType())) {
            CSVFormatConfig config = ds.getFormatParamsAs(CSVFormatConfig.class);
            if (!StringUtils.isUtf8((String)config.charset)) {
                throw new SnowflakeCloudFastpathImpossibleException(String.format("charset not supported: %s for dataset: %s", config.charset, dsFullName));
            }
            if (config.getSeparatorChar() == '\u0000' || config.getSeparatorChar() > '\u00ff') {
                throw new SnowflakeCloudFastpathImpossibleException(String.format("separator not supported: '%s' for dataset: %s", config.getSeparatorStr(), dsFullName));
            }
            CloudToSnowflake.CopyMode mode = new CloudToSnowflake.CopyMode();
            mode.type = CloudToSnowflake.CopyMode.CopyModeType.CSV;
            mode.delimiter = config.getSeparatorChar();
            switch (config.style) {
                case EXCEL: {
                    if (config.getQuoteChar() == '\u0000' || config.getQuoteChar() > '\u00ff') {
                        throw new SnowflakeCloudFastpathImpossibleException(String.format("quoting character not supported: '%s' for dataset: %s", Character.valueOf(config.getQuoteChar()), dsFullName));
                    }
                    mode.quote = config.getQuoteChar();
                    break;
                }
                case UNIX: {
                    if (config.getEscapeChar() != '\\') {
                        throw new SnowflakeCloudFastpathImpossibleException("output escape character not supported: '" + config.getQuoteChar() + "'");
                    }
                    mode.escape = true;
                    mode.quote = config.getQuoteChar();
                    break;
                }
                case ESCAPE_ONLY_NO_QUOTE: {
                    if (config.getEscapeChar() != '\\') {
                        throw new SnowflakeCloudFastpathImpossibleException(String.format("escape character not supported: '%s' for dataset: %s", Character.valueOf(config.getQuoteChar()), dsFullName));
                    }
                    mode.escape = true;
                    break;
                }
                case NO_ESCAPE_NO_QUOTE: {
                    break;
                }
                default: {
                    throw new SnowflakeCloudFastpathImpossibleException(String.format("format not supported: %s for dataset: %s", ds.getFormatType(), dsFullName));
                }
            }
            mode.ignoreHeader = config.skipRowsAfterHeader + config.skipRowsBeforeHeader;
            if (config.parseHeaderRow) {
                ++mode.ignoreHeader;
            }
            return mode;
        }
        if ("parquet".equals(ds.getFormatType())) {
            CloudToSnowflake.CopyMode mode = new CloudToSnowflake.CopyMode();
            mode.type = CloudToSnowflake.CopyMode.CopyModeType.PARQUET;
            ParquetFormatConfig config = ds.getFormatParamsAs(ParquetFormatConfig.class);
            switch (config.parquetCompressionMethod) {
                case UNCOMPRESSED: 
                case SNAPPY: 
                case LZO: {
                    mode.parquetCompressionMethod = config.parquetCompressionMethod;
                    break;
                }
                case ZSTD: {
                    if (fromCloudToSnowflake) {
                        mode.parquetCompressionMethod = config.parquetCompressionMethod;
                        break;
                    }
                    throw new SnowflakeCloudFastpathImpossibleException("Zstd compression is not supported when unloading to a Parquet dataset");
                }
                default: {
                    throw new SnowflakeCloudFastpathImpossibleException(String.format("Unsupported compression type %s for parquet files", new Object[]{config.parquetCompressionMethod}));
                }
            }
            return mode;
        }
        throw new SnowflakeCloudFastpathImpossibleException(String.format("format not supported: %s for dataset: %s", ds.getFormatType(), dsFullName));
    }

    public static boolean isValidParquetFastPathSchema(Dataset inputDS, Dataset outputDS) {
        if (outputDS.getModel() == null || !"parquet".equals(outputDS.getModel().formatType)) {
            return true;
        }
        if (inputDS.getModel() == null || inputDS.getModel().getSchema() == null) {
            return true;
        }
        for (SchemaColumn column : inputDS.getModel().getSchema().columns) {
            Type type = column.getType();
            if (!type.isInteger()) continue;
            return false;
        }
        return true;
    }

    protected abstract String getTemporaryTablePrefix();

    @Override
    public List<FlowRunnable> getRunnables() {
        return Lists.newArrayList();
    }

    @Override
    public void run() throws Exception {
        CloudToSnowflake.CopyMode mode = SnowflakeToCloud.getCopyMode(this.outputDS, false);
        try (AbstractSQLTableDatasetHandler dsh = (AbstractSQLTableDatasetHandler)DatasetHandlerFactory.build(this.authCtx, this.inputDS);
             BlobLikeDatasetHandler blobDSHandler = (BlobLikeDatasetHandler)new FastPathDatasetTypeStraightener().getDatasetHandler(this.authCtx, this.outputDS);){
            SQLConnectionProvider.SQLConnectionData connData = dsh.getConnectionData();
            SQLUtils.SQLTable inputTable = dsh.getResolvedTable();
            String destinationUri = this.createDestinationUri(blobDSHandler);
            SQLConnectionProvider.SQLConnectionWrapper connWrapper = dsh.newConnection();
            try {
                if (FastpathUtils.hasInputPartitions(this.inputPartitions)) {
                    this.unloadPartitionedData(connData, connWrapper, destinationUri, blobDSHandler, mode, inputTable);
                } else {
                    this.unloadNonPartitionedData(connData, connWrapper, destinationUri, blobDSHandler, mode, inputTable);
                }
                connWrapper.commit();
                connWrapper.close();
            }
            catch (Exception e) {
                logger.error((Object)"Snowflake unload failed", (Throwable)e);
                SQLUtils.unsafeRollbackAndClose(connWrapper);
                throw e;
            }
        }
    }

    private void unloadPartitionedData(SQLConnectionProvider.SQLConnectionData connData, SQLConnectionProvider.SQLConnectionWrapper connWrapper, String destinationUri, T blobDSHandler, CloudToSnowflake.CopyMode mode, SQLUtils.SQLTable inputTable) throws SQLException, IOException, DKUSecurityException {
        this.createAndExtractTemporaryData(connData, connWrapper, destinationUri, blobDSHandler, mode, inputTable, true);
    }

    private void unloadNonPartitionedData(SQLConnectionProvider.SQLConnectionData connData, SQLConnectionProvider.SQLConnectionWrapper connWrapper, String destinationUri, T blobDSHandler, CloudToSnowflake.CopyMode mode, SQLUtils.SQLTable inputTable) throws SQLException, IOException, DKUSecurityException {
        if (this.containsDateColumn(this.inputDS)) {
            this.createAndExtractTemporaryData(connData, connWrapper, destinationUri, blobDSHandler, mode, inputTable, false);
        } else {
            SnowflakeSQLDialect dialect = (SnowflakeSQLDialect)connData.getDialect();
            this.performUnloadingJob(connWrapper, destinationUri, blobDSHandler, mode, dialect.getQuotedTableFullName(inputTable));
        }
    }

    private void createAndExtractTemporaryData(SQLConnectionProvider.SQLConnectionData connData, SQLConnectionProvider.SQLConnectionWrapper connWrapper, String destinationUri, T blobDSHandler, CloudToSnowflake.CopyMode mode, SQLUtils.SQLTable inputTable, boolean isPartitionTable) throws SQLException, IOException, DKUSecurityException {
        SnowflakeSQLDialect dialect = (SnowflakeSQLDialect)connData.getDialect();
        Schema temporaryTableSchema = FastpathUtils.getTemporaryTableSchemaForCloudSync(this.inputDS, this.outputDS);
        String temporaryTableId = this.createTemporaryTable(connWrapper, temporaryTableSchema, dialect);
        this.fillTemporaryTable(connWrapper, dialect, inputTable.getCatalog(), inputTable.getSchemaNullIfBlank(), inputTable.getTable(), temporaryTableId, temporaryTableSchema, isPartitionTable);
        this.performUnloadingJob(connWrapper, destinationUri, blobDSHandler, mode, dialect.getQuotedTableFullName(inputTable.getCatalog(), inputTable.getSchemaNullIfBlank(), temporaryTableId));
    }

    private void fillTemporaryTable(SQLConnectionProvider.SQLConnectionWrapper conn, SnowflakeSQLDialect dialect, String catalog, String schema, String inputTableId, String temporaryTableId, Schema temporaryTableSchema, boolean isPartitionTable) throws SQLException {
        logger.info((Object)"Filling temporary Snowflake table from INSERT SELECT");
        String sql = this.createInsertSelectSqlRequest(dialect, catalog, schema, inputTableId, temporaryTableId, temporaryTableSchema, isPartitionTable);
        SQLUtils.safeExec(conn, sql, true);
    }

    private String createDestinationUri(T blobDSHandler) throws IOException, DKUSecurityException, CodedException {
        StringBuilder filePath = new StringBuilder(this.createDestinationRootUri(blobDSHandler));
        PartitioningScheme scheme = this.outputPartition.getScheme();
        if (scheme != null && scheme.isPartitioned()) {
            filePath.setLength(filePath.length() - 1);
            filePath.append(FilePartitioner.computePartitionRelPathAsFolder(this.outputPartition, scheme));
        }
        if (!filePath.toString().endsWith("/")) {
            filePath.append("/");
        }
        return filePath.toString();
    }

    protected abstract String createDestinationRootUri(T var1) throws IOException, DKUSecurityException, CodedException;

    @VisibleForTesting
    boolean containsDateColumn(Dataset dataset) {
        return dataset.getSchema().columns.stream().anyMatch(schemaColumn -> schemaColumn.getType().isTemporal());
    }

    private String createTemporaryTable(SQLConnectionProvider.SQLConnectionWrapper connWrapper, Schema temporaryTableSchema, SnowflakeSQLDialect dialect) throws SQLException {
        String tempTableName = this.getTemporaryTablePrefix() + UUID.randomUUID().toString().replaceAll("-", "");
        String createTempTableStatement = dialect.generateTempTableStatementSQL(tempTableName, this.inputDS, temporaryTableSchema, true);
        logger.info((Object)("Create temporary Snowflake table: " + createTempTableStatement));
        try (Statement stmt = connWrapper.createStatement();){
            stmt.execute(createTempTableStatement);
        }
        return tempTableName;
    }

    private String createInsertSelectSqlRequest(SnowflakeSQLDialect dialect, String catalog, String schema, String sourceTableId, String temporaryTableId, Schema temporaryTableSchema, boolean isPartitionTable) {
        StringBuilder request = new StringBuilder();
        request.append("INSERT INTO ").append(dialect.getQuotedTableFullName(catalog, schema, temporaryTableId));
        request.append("\n");
        request.append("SELECT ").append(String.join((CharSequence)",", this.getColumnNamesAndReplaceDates(this.inputDS, temporaryTableSchema, dialect)));
        request.append("\n");
        request.append("FROM ").append(dialect.getQuotedTableFullName(catalog, schema, sourceTableId));
        if (isPartitionTable) {
            request.append("\n");
            ExpressionBuilder partitionFilterExpression = ExpressionUtils.getPartitionFilterClause(this.inputDS.getPartitioningSchema(), this.inputDS, (List<Partition>)this.inputPartitions, (SQLDialect)dialect);
            request.append("WHERE ").append(partitionFilterExpression.toSQL(dialect));
        }
        return request.toString();
    }

    private List<String> getColumnNamesAndReplaceDates(Dataset inputDS, Schema temporaryTableSchema, SnowflakeSQLDialect dialect) {
        String assumedTz = inputDS.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class).getAssumedJavaTzForUnknownTz();
        return temporaryTableSchema.getColumns().stream().map(input -> {
            String quotedName = dialect.quoteIdentifier(input.getName());
            return input.getType() == Type.DATE ? String.format(this.getDateReplacementQueryTemplate(assumedTz, input.originalType, inputDS.isManaged()), quotedName, quotedName) : dialect.quoteIdentifier(input.getName()) + " as " + quotedName;
        }).collect(Collectors.toList());
    }

    private boolean hasTimeZoneInformation(String originalType) {
        return originalType != null && (originalType.equalsIgnoreCase("TIMESTAMPTZ") || originalType.equalsIgnoreCase("TIMESTAMPLTZ"));
    }

    protected String getDateReplacementQueryTemplate(String assumedTz, String originalType, boolean isManaged) {
        if (isManaged || this.hasTimeZoneInformation(originalType)) {
            return "TO_VARCHAR(CONVERT_TIMEZONE('UTC', %s), 'YYYY-MM-DDTHH24:MI:SS.FF3Z') as %s";
        }
        return "TO_VARCHAR(CONVERT_TIMEZONE('" + assumedTz + "', 'UTC', %s), 'YYYY-MM-DDTHH24:MI:SS.FF3Z') as %s";
    }

    private void performUnloadingJob(SQLConnectionProvider.SQLConnectionWrapper connWrapper, String destinationUri, T blobDSHandler, CloudToSnowflake.CopyMode mode, String inputTableFullName) throws SQLException, IOException, DKUSecurityException {
        logger.info((Object)("Copying from " + inputTableFullName + " table to cloud path: " + destinationUri));
        StringBuilder displayableSql = new StringBuilder();
        String copyStatement = this.generateCopyStatementToCloud(inputTableFullName, destinationUri, mode, blobDSHandler, displayableSql);
        try {
            SQLUtils.safeExec(connWrapper, copyStatement, displayableSql.toString(), true);
        }
        catch (SQLException e) {
            SQLException newException = FastpathUtils.sanitizeSnowflakeExceptions(e, false);
            throw newException != null ? newException : e;
        }
    }

    protected abstract String generateCopyStatementToCloud(String var1, String var2, CloudToSnowflake.CopyMode var3, T var4, StringBuilder var5) throws IOException, DKUSecurityException;

    public static class SnowflakeCloudFastpathImpossibleException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 1L;

        SnowflakeCloudFastpathImpossibleException(String message) {
            super(message);
        }
    }
}

