/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.sync;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.dao.StreamingEndpointsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.sync.SyncRecipeParams;
import com.dataiku.dip.dataflow.exec.sync.SyncRecipeStatusComputer;
import com.dataiku.dip.datasets.ManagedDatasetsHelper;
import com.dataiku.dip.datasets.SchemaUtils;
import com.dataiku.dip.recipes.RecipeSchemaComputer;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.JSON;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class SyncRecipeSchemaComputer
extends RecipeSchemaComputer {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private StreamingEndpointsDAO streamingEndpointsDAO;

    public SyncRecipeSchemaComputer(AuthCtx authCtx, JobActivity activity) {
        super(authCtx, activity);
    }

    @Override
    public boolean computesDiffItself() {
        return false;
    }

    @Override
    public List<Schema> getSchemasForOutputRole_NT(String role) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            Preconditions.checkArgument((boolean)role.equals("main"), (Object)("Recipe only has output role 'main', got: " + role));
            this.recipesValidationService.checkComplianceWithRecipeDesc(this.authCtx, this.recipe);
            ArrayList arrayList = Lists.newArrayList((Object[])new Schema[]{this.getSchema()});
            return arrayList;
        }
    }

    private Schema getSchema() throws Exception {
        SyncRecipeParams syncParams = (SyncRecipeParams)this.recipe.params;
        if (syncParams == null) {
            throw new RecipeSchemaComputer.DontWantToCompute(RecipeCodes.ERR_RECIPE_CANNOT_CHECK_SCHEMA_CONSISTENCY_WITH_RECIPE_CONFIG, "Sync recipe is in 'free output schema' mode");
        }
        switch (syncParams.schemaMode) {
            case FREE_SCHEMA_NAME_BASED: {
                throw new RecipeSchemaComputer.DontWantToCompute(RecipeCodes.ERR_RECIPE_CANNOT_CHECK_SCHEMA_CONSISTENCY_WITH_RECIPE_CONFIG, "Sync recipe is in 'free output schema' mode");
            }
            case STRICT_SYNC: {
                SyncRecipeStatusComputer sc = new SyncRecipeStatusComputer(this.recipe, null);
                String selectedEngineType = sc.fastStatusIgnorePartitions((AuthCtx)this.authCtx).selectedEngine.type;
                AnyLoc inputLoc = this.recipe.getSingleInput("main").getLoc(this.recipe.projectKey);
                Dataset inputDataset = this.datasetAccessService.getMandatory(inputLoc);
                AnyLoc outputLoc = this.recipe.getSingleOutput("main").getLoc(this.recipe.projectKey);
                if (this.streamingEndpointsDAO.getOrNull(outputLoc) != null) {
                    return (Schema)JSON.deepCopy((Object)inputDataset.getSchema());
                }
                Dataset outputDataset = this.datasetAccessService.getMandatory(outputLoc);
                ManagedDatasetsHelper.copySchema(this.authCtx, inputDataset.getSchema(), outputDataset);
                Schema outputSchema = outputDataset.getSchema();
                if ("HIVE".equals(selectedEngineType) || "IMPALA".equals(selectedEngineType)) {
                    outputSchema = SchemaUtils.lowerCase(outputSchema);
                }
                return outputSchema;
            }
        }
        throw new Error("unreachable");
    }
}

