/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.upsert;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.JobAuthCtxService;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.cde.ContainerizedDSSEngineAble;
import com.dataiku.dip.dataflow.cde.ContainerizedStreamEngineExecutor;
import com.dataiku.dip.dataflow.exec.AbortableRecipeRunner;
import com.dataiku.dip.dataflow.exec.ActivityAbortedException;
import com.dataiku.dip.dataflow.exec.EnvironmentStash;
import com.dataiku.dip.dataflow.exec.FlowRunnable;
import com.dataiku.dip.dataflow.exec.Initializable;
import com.dataiku.dip.dataflow.exec.PreRunSchemaPropagationHandler;
import com.dataiku.dip.dataflow.exec.RecipeRunnerWithPayload;
import com.dataiku.dip.dataflow.exec.sql.NonLoopingNonTransformingSQLEngineVisualRecipeRunner;
import com.dataiku.dip.dataflow.exec.sql.NonLoopingSQLEngineVisualRecipeRunner;
import com.dataiku.dip.dataflow.exec.stream.ToDatasetStreamer;
import com.dataiku.dip.dataflow.exec.upsert.UpsertRecipeBuiltinRunner;
import com.dataiku.dip.dataflow.exec.upsert.UpsertRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.upsert.UpsertRecipeStatusComputer;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetUtils;
import com.dataiku.dip.datasets.ManagedDatasetsHelper;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.datasets.UniversalSingleThreadPusher;
import com.dataiku.dip.datasets.cassandra.AbstractCassandraDatasetHandler;
import com.dataiku.dip.datasets.custompython.CustomDatasetHandler;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.datasets.fs.BuiltinFSDatasets;
import com.dataiku.dip.datasets.fs.FilesystemDatasetConfig;
import com.dataiku.dip.datasets.fs.FsToFsProviderTransferer;
import com.dataiku.dip.datasets.fs.HDFSDatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLTableDatasetHandler;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.SchemaMismatchException;
import com.dataiku.dip.fs.FSProvider;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.hive.HiveMetastoreSynchronizer;
import com.dataiku.dip.hive.HiveMetastoreSynchronizerFactory;
import com.dataiku.dip.hive.HiveServer2HiveMetastoreSynchronizer;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.input.formats.csv.CSVFormatConfig;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.FilePartitioner;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.queries.QueryBunch;
import com.dataiku.dip.recipes.InitializableAbortableRecipeRunner;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.recipes.RecipeRunner;
import com.dataiku.dip.recipes.code.hive.HiveRecipeMeta;
import com.dataiku.dip.recipes.code.hive.NonLoopingNonTransformingHiveEngineVisualRecipeRunner;
import com.dataiku.dip.recipes.code.impala.ImpalaExecutor;
import com.dataiku.dip.recipes.code.impala.NonLoopingNonTransformingImpalaEngineVisualRecipeRunner;
import com.dataiku.dip.recipes.code.sparksql.SparkSQLExecutor;
import com.dataiku.dip.recipes.common.RecipeStatusComputer;
import com.dataiku.dip.recipes.consistency.CDECompatibilityCheckerService;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipesBaseService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.recipes.UpsertRecipeService;
import com.dataiku.dip.sql.HiveSQLDialect;
import com.dataiku.dip.sql.ImpalaSQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.SchemaReader;
import com.dataiku.dip.sql.SparkSQLDialect;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.StringTransmogrifier;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dip.variables.VariablesUtils;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class UpsertRecipeRunner
implements RecipeRunner,
AbortableRecipeRunner,
RecipeRunnerWithPayload,
FlowRunnable,
ContainerizedDSSEngineAble {
    @Autowired
    private UpsertRecipeService service;
    @Autowired
    private CDECompatibilityCheckerService cdeCompatibilityCheckerService;
    @Autowired
    protected DatasetsDAO datasetsDAO;
    @Autowired
    protected ConnectionsDAO connectionsDAO;
    @Autowired
    protected VariablesService variablesService;
    @Autowired
    protected VisualSQLRecipesBaseService visualRecipesBaseService;
    @Autowired
    protected JobAuthCtxService authCtxService;
    @Autowired
    protected FutureService futureService;
    private UpsertRecipePayloadParams params;
    protected AbortableRecipeRunner executor;
    protected JobActivity activity;
    protected FlowRecipe recipe;
    protected boolean abortNotified;
    protected String payload;
    private boolean isRunningInContainer = false;
    private Map<String, String> testProps = new HashMap<String, String>();
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.upsert");

    public UpsertRecipeRunner(JobActivity activity) {
        this.activity = activity;
        this.recipe = ((RecipeRunnableSubgraph)activity.getSubgraph()).getRecipe();
        this.activity.initStatus();
        for (AbstractSQLConnection.CustomDatabaseProperty prop : this.recipe.getModel().dkuProperties) {
            if (!StringUtils.defaultIfEmpty((String)prop.name, (String)"").startsWith("testHarness.")) continue;
            this.testProps.put(prop.name, prop.value);
        }
    }

    @Override
    public void setPayload(String payload) {
        logger.info((Object)("SET PAYLOAD: " + payload));
        this.payload = payload;
        this.params = this.service.loadParams(payload, this.recipe.getModel());
    }

    @Override
    public void setIsRunningInContainer() {
        this.isRunningInContainer = true;
    }

    @Override
    public void init() throws Exception {
        if (this.abortNotified) {
            throw new ActivityAbortedException();
        }
        SerializedRecipe.SerializedRecipeAndPayload srp = new PreRunSchemaPropagationHandler(this.activity, this.recipe).propagateIfNeeded();
        if (srp != null && srp.payload != null) {
            this.setPayload(srp.payload);
        }
        RecipeMeta meta = RecipeRegistry.getMeta(this.recipe.getModel().type);
        RecipeStatusComputer computer = meta.buildStatusComputer(this.recipe.getModel(), this.payload);
        UpsertRecipeStatusComputer.UpsertRecipeStatus recipeStatus = (UpsertRecipeStatusComputer.UpsertRecipeStatus)computer.fastStatusIgnorePartitions(this.authCtxService.getAuthCtx());
        this.setExecutor(recipeStatus);
    }

    protected void setExecutor(UpsertRecipeStatusComputer.UpsertRecipeStatus status) throws Exception {
        VisualSQLRecipesBaseService.SQLBasedEngineStatus engineToUse = status.getSelectedSQLBasedEngine();
        if (engineToUse == null || !engineToUse.isSelectable) {
            throw new Exception("No allowed engine could be selected");
        }
        logger.info((Object)("Selected engine type: " + engineToUse.type));
        switch (engineToUse.type) {
            case "SQL": {
                JobContext.getCurrentActivitySummary().engineType = "SQL";
                this.initSqlExecutor(status.possibleModes);
                break;
            }
            case "HIVE": {
                JobContext.getCurrentActivitySummary().engineType = "HIVE";
                this.initHiveExecutor(status.engineParams.hive);
                break;
            }
            case "IMPALA": {
                JobContext.getCurrentActivitySummary().engineType = "IMPALA";
                this.initImpalaExecutor(status.engineParams.impala);
                break;
            }
            case "SPARK": {
                JobContext.getCurrentActivitySummary().engineType = "SPARK";
                this.initSparkExecutor(status.engineParams.sparkSQL);
                break;
            }
            case "DSS": {
                JobContext.getCurrentActivitySummary().engineType = "DSS";
                this.initBuiltinExecutor(engineToUse);
            }
        }
    }

    private void initBuiltinExecutor(VisualSQLRecipesBaseService.SQLBasedEngineStatus engineToUse) throws Exception {
        ContainerExecRuntimeConfig containerConfig = this.cdeCompatibilityCheckerService.getContainerConfig(this.isRunningInContainer, this.authCtxService.getAuthCtx(), this.activity.warnContext, this.params.engineParams.containerSelection, this.recipe.getModel(), this.payload);
        if (containerConfig != null) {
            logger.info((Object)"Run in container");
            ContainerizedStreamEngineExecutor containerizedRunner = new ContainerizedStreamEngineExecutor(this.recipe, this.activity, containerConfig);
            containerizedRunner.init(this.activity, Output.WriteMode.APPEND);
            this.executor = containerizedRunner;
        } else {
            TempDatasetBasedExecutor tempDatasetBasedExecutor = new TempDatasetBasedExecutor();
            JobActivity tempActivity = tempDatasetBasedExecutor.tempActivity;
            UpsertRecipeBuiltinRunner dssRunner = new UpsertRecipeBuiltinRunner(tempActivity, this.params);
            tempDatasetBasedExecutor.setPrepareExecutor(dssRunner);
            tempDatasetBasedExecutor.init();
            this.executor = tempDatasetBasedExecutor;
        }
    }

    protected void initHiveExecutor(HiveRecipeMeta.HiveRecipeParams hiveParams) throws Exception {
        if (this.params.upsertSQLMode == UpsertRecipePayloadParams.UpsertSQLMode.DIRECT) {
            throw new UnsupportedOperationException("Upsert mode " + String.valueOf((Object)this.params.upsertSQLMode) + " is not possible with Hive engine");
        }
        NonLoopingNonTransformingHiveEngineVisualRecipeRunner sqlRunner = new NonLoopingNonTransformingHiveEngineVisualRecipeRunner(this.activity){

            @Override
            protected QueryBunch getQueryBunch(HiveSQLDialect dialect) throws Exception {
                return UpsertRecipeRunner.this.service.generateSQL(this.activity, new HiveSQLDialect(), UpsertRecipeRunner.this.params, "HIVE", false);
            }

            @Override
            protected void initializeTargetTable(Dataset targetDataset, Partition targetPartition, Output.WriteMode writeMode) throws Exception {
                HiveServer2HiveMetastoreSynchronizer synchronizer = new HiveServer2HiveMetastoreSynchronizer(UpsertRecipeRunner.this.authCtxService.getAuthCtx());
                HiveServer2HiveMetastoreSynchronizer.HiveSchemaCompatibility compatibility = synchronizer.isExistingSchemaCompatible(targetDataset);
                if (compatibility == null || compatibility.unknown || !compatibility.tableExists) {
                    logger.info((Object)"Target table doesn't exist yet, creating it");
                    synchronizer.synchronizeOneDatasetPartition(targetDataset, targetPartition, false, HiveMetastoreSynchronizer.SynchronizeOneDatasetPartitionReason.PRESYNCHRONIZE_WRITE_BY_HS2_TARGET, this.activity.warnContext, false);
                } else {
                    if (!compatibility.schemaCompatible) {
                        throw new Exception("Cannot write to table, table already exists but with an incompatible schema.");
                    }
                    logger.info((Object)"Table exists, and schema matches");
                    if (targetDataset.getPartitioningSchema() != null && targetDataset.getPartitioningSchema().isPartitioned()) {
                        synchronizer.synchronizeOneDatasetPartition(targetDataset, targetPartition, false, HiveMetastoreSynchronizer.SynchronizeOneDatasetPartitionReason.PRESYNCHRONIZE_WRITE_BY_HS2_TARGET, this.activity.warnContext, false);
                    }
                }
            }
        };
        SpringUtils.getInstance().autowire((Object)sqlRunner);
        ((InitializableAbortableRecipeRunner)sqlRunner).init();
        this.executor = sqlRunner;
    }

    protected void initImpalaExecutor(ImpalaExecutor.ImpalaExecutorParams impalaParams) throws Exception {
        if (this.params.upsertSQLMode != UpsertRecipePayloadParams.UpsertSQLMode.PREPARE_THEN_REPLACE) {
            throw new UnsupportedOperationException("Upsert mode " + String.valueOf((Object)this.params.upsertSQLMode) + " is not possible with Impala engine");
        }
        NonLoopingNonTransformingImpalaEngineVisualRecipeRunner sqlRunner = new NonLoopingNonTransformingImpalaEngineVisualRecipeRunner(this.activity){

            @Override
            protected QueryBunch getQueryBunch(ImpalaSQLDialect dialect) throws Exception {
                return UpsertRecipeRunner.this.service.generateSQL(this.activity, new ImpalaSQLDialect(), UpsertRecipeRunner.this.params, "IMPALA", false);
            }

            @Override
            protected String prepareMainQuery(String mainQuery, Dataset targetDataset, Partition targetPartition) throws IOException {
                return mainQuery;
            }

            @Override
            protected void initializeTargetTable(Dataset targetDataset, Partition targetPartition, Output.WriteMode writeMode) throws Exception {
                HiveServer2HiveMetastoreSynchronizer synchronizer = new HiveServer2HiveMetastoreSynchronizer(this.authCtxService.getAuthCtx());
                HiveServer2HiveMetastoreSynchronizer.HiveSchemaCompatibility compatibility = synchronizer.isExistingSchemaCompatible(targetDataset);
                if (compatibility == null || compatibility.unknown || !compatibility.tableExists) {
                    logger.info((Object)"Target table doesn't exist yet, creating it");
                    synchronizer.synchronizeOneDatasetPartition(targetDataset, targetPartition, false, HiveMetastoreSynchronizer.SynchronizeOneDatasetPartitionReason.PRESYNCHRONIZE_WRITE_BY_IMPALA_TARGET, this.activity.warnContext, false);
                } else {
                    if (!compatibility.schemaCompatible) {
                        throw new Exception("Cannot write to table, table already exists but with an incompatible schema.");
                    }
                    logger.info((Object)"Table exists, and schema matches");
                    if (targetDataset.getPartitioningSchema() != null && targetDataset.getPartitioningSchema().isPartitioned()) {
                        synchronizer.synchronizeOneDatasetPartition(targetDataset, targetPartition, false, HiveMetastoreSynchronizer.SynchronizeOneDatasetPartitionReason.PRESYNCHRONIZE_WRITE_BY_IMPALA_TARGET, this.activity.warnContext, false);
                    }
                }
            }
        };
        SpringUtils.getInstance().autowire((Object)sqlRunner);
        sqlRunner.init();
        this.executor = sqlRunner;
    }

    protected void initSparkExecutor(SparkSQLExecutor.SparkSQLExecutorParams sparkParams) throws Exception {
        TempDatasetBasedExecutor tempDatasetBasedExecutor = new TempDatasetBasedExecutor();
        FlowDataset target = this.activity.getSubgraph().getSingleTargetDataset();
        Partition targetPartition = this.activity.getSubgraph().getTargetPartition(target);
        Dataset targetDataset = target.getMandatory(this.datasetsDAO);
        if (BuiltinFSDatasets.HDFS_META.getType().equals(targetDataset.getType()) && this.params.engineParams.sparkSQL.useGlobalMetastore) {
            try (HiveMetastoreSynchronizer sync = HiveMetastoreSynchronizerFactory.getSynchronizer(this.authCtxService.getAuthCtx());){
                if (sync instanceof HiveServer2HiveMetastoreSynchronizer) {
                    HiveServer2HiveMetastoreSynchronizer synchronizer = (HiveServer2HiveMetastoreSynchronizer)sync;
                    HiveServer2HiveMetastoreSynchronizer.HiveSchemaCompatibility compatibility = synchronizer.isExistingSchemaCompatible(targetDataset);
                    if (compatibility == null || compatibility.unknown || !compatibility.tableExists) {
                        logger.info((Object)"Target table doesn't exist yet, creating it");
                        synchronizer.synchronizeOneDatasetPartition(targetDataset, targetPartition, false, HiveMetastoreSynchronizer.SynchronizeOneDatasetPartitionReason.PRESYNCHRONIZE_WRITE_BY_HS2_TARGET, this.activity.warnContext, false);
                    } else {
                        if (!compatibility.schemaCompatible) {
                            throw new Exception("Cannot write to table, table already exists but with an incompatible schema.");
                        }
                        logger.info((Object)"Table exists, and schema matches");
                        if (targetDataset.getPartitioningSchema() != null && targetDataset.getPartitioningSchema().isPartitioned()) {
                            synchronizer.synchronizeOneDatasetPartition(targetDataset, targetPartition, false, HiveMetastoreSynchronizer.SynchronizeOneDatasetPartitionReason.PRESYNCHRONIZE_WRITE_BY_HS2_TARGET, this.activity.warnContext, false);
                        }
                    }
                }
            }
        }
        JobActivity tempActivity = tempDatasetBasedExecutor.tempActivity;
        String sql = this.service.generatePrepareDataSQL(this.activity, new SparkSQLDialect(), this.params, "SPARK", false);
        SparkSQLExecutor sparkExecutor = new SparkSQLExecutor(tempActivity, sparkParams, sql);
        SpringUtils.getInstance().autowire((Object)sparkExecutor);
        tempDatasetBasedExecutor.setPrepareExecutor(sparkExecutor);
        tempDatasetBasedExecutor.init();
        this.executor = tempDatasetBasedExecutor;
    }

    private Dataset makeTempTargetDataset() throws IOException, DKUSecurityException {
        FlowDataset target = this.activity.getSubgraph().getSingleTargetDataset();
        Partition targetPartition = this.activity.getSubgraph().getTargetPartition(target);
        Dataset targetDS = target.getMandatory(this.datasetsDAO);
        String tempName = String.format("%s_%s", targetDS.getName(), targetPartition.id());
        String tempFullName = String.format("%s.%s", targetDS.getProjectKey(), tempName);
        Dataset tempDS = Dataset.fromSerialized(tempFullName, targetDS.serialize());
        tempDS.setFullName(tempFullName);
        if (tempDS.getParams() instanceof AbstractFSDatasetHandler.AbstractFSConfig) {
            AbstractFSDatasetHandler.AbstractFSConfig config = (AbstractFSDatasetHandler.AbstractFSConfig)tempDS.getParams();
            String subdir = "_dskupstmp_" + targetPartition.id();
            config.path = config.path.endsWith("/") ? config.path.substring(0, config.path.length() - 1) + subdir + "/" : config.path + subdir + "/";
            if (config instanceof HDFSDatasetHandler.Config) {
                HDFSDatasetHandler.Config hdfsConfig = (HDFSDatasetHandler.Config)config;
                hdfsConfig.hiveTableName = StringUtils.defaultIfBlank((String)hdfsConfig.hiveTableName, (String)targetDS.getName()) + "_dskupstmp_" + targetPartition.id();
            }
        } else if (tempDS.getParams() instanceof AbstractSQLDatasetHandler.AbstractSQLConfig) {
            AbstractSQLDatasetHandler.AbstractSQLConfig config = (AbstractSQLDatasetHandler.AbstractSQLConfig)tempDS.getParams();
            String subtbl = "_dskupstmp_" + targetPartition.id();
            Object table = config.table + subtbl;
            try (AbstractSQLDatasetHandler dh = (AbstractSQLDatasetHandler)DatasetHandlerFactory.build(this.authCtxService.getAuthCtx(), tempDS);){
                SQLDialect dialect = dh.getDialect();
                if (dialect.getIdentifiersMaxLength() > 0) {
                    VariablesContext vc = this.variablesService.getContext(this.recipe.getProjectKey());
                    String expandedTable = vc.expand((String)table);
                    table = StringTransmogrifier.shortenKeepUnicity((String)expandedTable, (int)dialect.getIdentifiersMaxLength());
                }
            }
            config.table = table;
        } else {
            FilesystemDatasetConfig config = new FilesystemDatasetConfig();
            config.path = "_dskupstmp_" + targetPartition.id();
            config.connection = "@virtual(job-tmp):na";
            tempDS = new Dataset();
            tempDS.setFullName(tempFullName);
            tempDS.setManaged(true);
            tempDS.setType("Filesystem");
            tempDS.setParams(config);
            tempDS.setSchema(targetDS.getSchema());
            PartitioningScheme scheme = targetDS.getPartitioningSchema();
            if (scheme != null && scheme.isPartitioned()) {
                tempDS.setPartitioningScheme(ManagedDatasetsHelper.copyToFSLikePartitioning(scheme));
            }
            ManagedDatasetsHelper.setStandardCSVExcel(tempDS);
            tempDS.getFormatParamsAs(CSVFormatConfig.class).compress = "gz";
        }
        this.datasetsDAO.save(tempDS.serialize());
        return tempDS;
    }

    protected void initSqlExecutor(List<UpsertRecipePayloadParams.UpsertSQLMode> possibleModes) throws Exception {
        if (!possibleModes.contains((Object)this.params.upsertSQLMode)) {
            throw new UnsupportedOperationException("Upsert mode " + String.valueOf((Object)this.params.upsertSQLMode) + " is not possible");
        }
        NonLoopingNonTransformingSQLEngineVisualRecipeRunner sqlRunner = switch (this.params.upsertSQLMode) {
            case UpsertRecipePayloadParams.UpsertSQLMode.DIRECT, UpsertRecipePayloadParams.UpsertSQLMode.UPDATE_THEN_INSERT, UpsertRecipePayloadParams.UpsertSQLMode.PREPARE_THEN_REPLACE -> new NonLoopingNonTransformingSQLEngineVisualRecipeRunner(this.activity){

                @Override
                protected QueryBunch getQueryBunch(AbstractSQLConnection conn) throws Exception {
                    return UpsertRecipeRunner.this.service.generateSQL(this.activity, conn.getDialect(), UpsertRecipeRunner.this.params, "SQL", false);
                }

                @Override
                protected void initializeTargetTable(AuthCtx authCtx, SQLConnectionProvider.SQLConnectionData connData, SQLDialect dialect, SQLConnectionProvider.SQLConnectionWrapper conn, Partition targetPartition, Dataset outputDataset, FlowRecipe recipe, InfoMessage.InfoMessages messages) throws Exception {
                    Output.WriteMode wm = Output.WriteMode.APPEND;
                    dialect.prepareTableForWriting(authCtx, connData, conn, wm, outputDataset, targetPartition, false, messages);
                }
            };
            default -> throw new Error("Unreachable");
        };
        SpringUtils.getInstance().autowire((Object)sqlRunner);
        ((InitializableAbortableRecipeRunner)sqlRunner).init();
        this.executor = sqlRunner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyBeforeAborting() {
        AbortableRecipeRunner abortableRunner;
        UpsertRecipeRunner upsertRecipeRunner = this;
        synchronized (upsertRecipeRunner) {
            if (this.abortNotified) {
                return;
            }
            this.abortNotified = true;
            abortableRunner = this.executor;
        }
        if (abortableRunner != null) {
            abortableRunner.notifyBeforeAborting();
        }
    }

    @Override
    public void run() throws Exception {
        if (this.executor == null) {
            throw new Error("Recipe could not run, no runner selected");
        }
        Stopwatch recipeRunDuration = Stopwatch.createStarted();
        logger.info((Object)("Selected executor: " + this.executor.getClass().getName()));
        this.executor.run();
        logger.info((Object)("Recipe run time: " + recipeRunDuration.elapsed(TimeUnit.SECONDS) + " s"));
    }

    private class TempDatasetBasedExecutor
    implements FlowRunnable,
    Initializable,
    EnvironmentStash.AppendModeGetter,
    InitializableAbortableRecipeRunner {
        private final Dataset tempDS;
        private final FlowRecipe tempRecipe;
        private final JobActivity tempActivity;
        private InitializableAbortableRecipeRunner executor;
        private InitializableAbortableRecipeRunner copier;

        TempDatasetBasedExecutor() throws Exception {
            Partition targetPartition;
            Dataset realTargetDS;
            block41: {
                DatasetHandler dh;
                block40: {
                    FlowDataset inputFD = UpsertRecipeRunner.this.activity.getSubgraph().getSingleSourceDataset();
                    FlowDataset outputFD = UpsertRecipeRunner.this.activity.getSubgraph().getSingleTargetDataset();
                    realTargetDS = outputFD.getMandatory(UpsertRecipeRunner.this.datasetsDAO);
                    this.tempDS = UpsertRecipeRunner.this.makeTempTargetDataset();
                    SerializedRecipe tempSR = (SerializedRecipe)JSON.deepCopy((Object)UpsertRecipeRunner.this.recipe.getModel());
                    tempSR.getSingleOutput((String)"main").ref = this.tempDS.getName();
                    tempSR.addInput("main", outputFD.getFullName());
                    this.tempRecipe = new FlowRecipe(tempSR);
                    FlowDataset tempFD = new FlowDataset(this.tempDS);
                    RecipeRunnableSubgraph tempSubgraph = new RecipeRunnableSubgraph(this.tempRecipe);
                    tempSubgraph.addSource_NoRole(inputFD);
                    tempSubgraph.addSource_NoRole(outputFD);
                    tempSubgraph.addTarget_NoRole(tempFD);
                    Map<String, List<Partition>> sourcePartitions = UpsertRecipeRunner.this.activity.getSubgraph().getSourcePartitions();
                    targetPartition = UpsertRecipeRunner.this.activity.getSubgraph().getTargetPartition(outputFD);
                    sourcePartitions.put(outputFD.getFullName(), Lists.newArrayList((Object[])new Partition[]{targetPartition}));
                    tempSubgraph.setSourcePartitions(sourcePartitions);
                    tempSubgraph.getTargetPartitions().put(tempFD.getFullId(), targetPartition);
                    this.tempActivity = new JobActivity(tempSubgraph);
                    dh = DatasetHandlerFactory.build(UpsertRecipeRunner.this.authCtxService.getAuthCtx(), realTargetDS);
                    try {
                        Partition p = UpsertRecipeRunner.this.activity.getSubgraph().getTargetPartition(outputFD);
                        if (!dh.getReadiness(p, null).isReady()) {
                            Output.WriteMode writeMode = Output.WriteMode.APPEND;
                            if (dh instanceof AbstractSQLTableDatasetHandler) {
                                writeMode = Output.WriteMode.OVERWRITE;
                            } else if (dh instanceof AbstractCassandraDatasetHandler) {
                                writeMode = Output.WriteMode.OVERWRITE;
                            } else if (dh instanceof CustomDatasetHandler) {
                                writeMode = Output.WriteMode.OVERWRITE;
                            }
                            DatasetUtils.performWriteOfZeroRows(dh, p, new WarningsContext(), writeMode);
                            break block40;
                        }
                        if (!(dh instanceof AbstractSQLDatasetHandler)) break block40;
                        AbstractSQLDatasetHandler sqlDH = (AbstractSQLDatasetHandler)dh;
                        AbstractSQLDatasetHandler.AbstractSQLConfig config = realTargetDS.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class).getResolved(UpsertRecipeRunner.this.recipe.getProjectKey());
                        SQLConnectionProvider.SQLConnectionData connData = sqlDH.makeConnData();
                        try (SQLConnectionProvider.SQLConnectionWrapper conn = SQLConnectionProvider.newConnection(connData, UpsertRecipeRunner.this.authCtxService.getAuthCtx(), UpsertRecipeRunner.this.recipe.getProjectKey());){
                            SchemaReader.isManagedSchemaCompatible(realTargetDS.getSchema(), realTargetDS, conn, config.catalog, config.schema, config.table, connData);
                        }
                        catch (SchemaMismatchException e) {
                            if (realTargetDS.getPartitioningSchema() != null && realTargetDS.getPartitioningSchema().isPartitioned()) {
                                throw new SQLException("Cannot write to table (partitioned), table already exists but with an incompatible schema: " + e.getMessage(), e);
                            }
                            if (config.noDropOnSchemaMismatch) {
                                throw new SQLException("Cannot write to table, table already exists but with an incompatible schema: " + e.getMessage(), e);
                            }
                        }
                    }
                    finally {
                        if (dh != null) {
                            dh.close();
                        }
                    }
                }
                dh = DatasetHandlerFactory.build(UpsertRecipeRunner.this.authCtxService.getAuthCtx(), this.tempDS);
                try {
                    if (dh instanceof AbstractFSDatasetHandler) {
                        AbstractFSDatasetHandler fsdh = (AbstractFSDatasetHandler)dh;
                        if (fsdh.getFirstNonEmptyPath() != null) {
                            throw new NonEmptyTemporaryDatasetException("Temporary location is not empty; it may contain remnants of a previous failed or aborted run. Check if data needs to be salvaged from " + this.tempDS.getParamsAs(AbstractFSDatasetHandler.AbstractFSConfig.class).path + " in connection " + this.tempDS.getParams().getConnection());
                        }
                        break block41;
                    }
                    if (!(dh instanceof AbstractSQLTableDatasetHandler)) break block41;
                    AbstractSQLTableDatasetHandler sqldh = (AbstractSQLTableDatasetHandler)dh;
                    AbstractSQLDatasetHandler.AbstractSQLConfig rawAbstractConfig = sqldh.getResolvedAbstractConfig();
                    try (SQLConnectionProvider.SQLConnectionWrapper conn = sqldh.newConnection();){
                        AbstractSQLDatasetHandler.AbstractSQLConfig configWithJITResolvedTableLoc = (AbstractSQLDatasetHandler.AbstractSQLConfig)VariablesUtils.expandObjectFieldsAllowUnresolved(UpsertRecipeRunner.this.recipe.getProjectKey(), rawAbstractConfig, new String[]{"catalog", "table", "schema"});
                        SQLDialect dialect = sqldh.getDialect();
                        SQLUtils.SQLTable table = new SQLUtils.SQLTable(configWithJITResolvedTableLoc.catalog, configWithJITResolvedTableLoc.schema, configWithJITResolvedTableLoc.table);
                        if (dialect.tableExists(UpsertRecipeRunner.this.authCtxService.getAuthCtx(), sqldh.getConnectionData(), conn, table.getCatalog(), table.getSchemaNullIfBlank(), table.getTable())) {
                            throw new NonEmptyTemporaryDatasetException("Temporary location is not empty; it may contain remnants of a previous failed or aborted run. Check if data needs to be salvaged from " + dialect.getQuotedTableFullName(table) + " in connection " + this.tempDS.getParams().getConnection());
                        }
                    }
                    catch (NonEmptyTemporaryDatasetException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        logger.warn((Object)"Unable to check for temporary table existence, assuming it doesn't exist", (Throwable)e);
                    }
                }
                finally {
                    if (dh != null) {
                        dh.close();
                    }
                }
            }
            this.copier = realTargetDS.getParams() instanceof AbstractFSDatasetHandler.AbstractFSConfig ? new InitializableAbortableRecipeRunner(){

                @Override
                public void notifyBeforeAborting() {
                }

                @Override
                public void run() throws Exception {
                    try (AbstractFSDatasetHandler realDh = (AbstractFSDatasetHandler)DatasetHandlerFactory.build(UpsertRecipeRunner.this.authCtxService.getAuthCtx(), realTargetDS);
                         AbstractFSDatasetHandler tempDh = (AbstractFSDatasetHandler)DatasetHandlerFactory.build(UpsertRecipeRunner.this.authCtxService.getAuthCtx(), TempDatasetBasedExecutor.this.tempDS);){
                        FSProvider realProvider = realDh.getProvider();
                        FSProvider tempProvider = tempDh.getProvider();
                        String targetPath = realTargetDS.getPartitioningSchema().isPartitioned() ? FilePartitioner.computePartitionRelPathAsFolder(targetPartition, realTargetDS.getPartitioningSchema()) : "";
                        realDh.clearPartitions(Lists.newArrayList((Object[])new Partition[]{targetPartition}));
                        String sourcePath = targetPath;
                        new FsToFsProviderTransferer(tempProvider, realProvider).transfer(sourcePath, targetPath);
                        tempDh.clearAllDataAndStructure();
                    }
                }

                @Override
                public void init() throws Exception {
                }
            } : (realTargetDS.getParams() instanceof AbstractSQLDatasetHandler.AbstractSQLConfig ? new NonLoopingSQLEngineVisualRecipeRunner(UpsertRecipeRunner.this.activity){

                @Override
                protected QueryBunch getQueryBunch(AbstractSQLConnection conn) throws Exception {
                    QueryBunch queryBunch = new QueryBunch();
                    SQLDialect dialect = conn.getDialect();
                    SQLUtils.SQLTable tempTable = DatasetUtils.getResolvedTableWithSparkSQLFallback(TempDatasetBasedExecutor.this.tempDS, dialect, UpsertRecipeRunner.this.params.engineParams);
                    queryBunch.query = String.format("SELECT * FROM %s", dialect.getQuotedTableFullName(tempTable));
                    queryBunch.postQueries.add(String.format("DROP TABLE %s", dialect.getQuotedTableFullName(tempTable)));
                    return queryBunch;
                }

                @Override
                protected String detectMainConnection() throws Exception {
                    return TempDatasetBasedExecutor.this.tempDS.getParams().getConnection();
                }

                @Override
                protected void initializeTargetTable(AuthCtx authCtx, SQLConnectionProvider.SQLConnectionData connData, SQLDialect dialect, SQLConnectionProvider.SQLConnectionWrapper conn, Partition targetPartition, Dataset outputDataset, FlowRecipe recipe, InfoMessage.InfoMessages messages) throws Exception {
                    Output.WriteMode wm = Output.WriteMode.OVERWRITE;
                    dialect.prepareTableForWriting(authCtx, connData, conn, wm, outputDataset, targetPartition, false, messages);
                }
            } : new InitializableAbortableRecipeRunner(){
                ProcessorOutput out = null;

                @Override
                public void notifyBeforeAborting() {
                    if (this.out != null) {
                        try {
                            this.out.cancel();
                        }
                        catch (Exception e) {
                            logger.error((Object)"Failed to abort copy", (Throwable)e);
                        }
                    }
                }

                @Override
                public void run() throws Exception {
                    StreamColumnFactory cf = new StreamColumnFactory();
                    StreamRowFactory rf = new StreamRowFactory();
                    WarningsContext warningsContext = new WarningsContext();
                    Output.WriteMode writeMode = Output.WriteMode.OVERWRITE;
                    try (DatasetHandler dh = DatasetHandlerFactory.build(UpsertRecipeRunner.this.authCtxService.getAuthCtx(), realTargetDS);){
                        if (!dh.outputHandlesClear()) {
                            if (realTargetDS.getPartitioningSchema() != null && realTargetDS.getPartitioningSchema().isPartitioned()) {
                                dh.clearPartitions(Lists.newArrayList((Object[])new Partition[]{targetPartition}));
                            } else {
                                dh.clearAllData();
                            }
                            writeMode = Output.WriteMode.APPEND;
                        }
                    }
                    ToDatasetStreamer streamer = ToDatasetStreamer.newWithAutoBucketing(UpsertRecipeRunner.this.authCtxService.getAuthCtx(), realTargetDS, targetPartition, (ColumnFactory)cf, warningsContext, writeMode);
                    this.out = streamer.getAsOutput();
                    StreamableDatasetSelection selection = StreamableDatasetSelection.full();
                    UniversalSingleThreadPusher pusher = new UniversalSingleThreadPusher(UpsertRecipeRunner.this.authCtxService.getAuthCtx(), TempDatasetBasedExecutor.this.tempDS, this.out, (ColumnFactory)cf, (RowFactory)rf);
                    pusher.setWarningsContext(warningsContext);
                    pusher.setDatasetSelection(selection);
                    pusher.push();
                    this.out.lastRowEmitted();
                    try (AbstractFSDatasetHandler tempDh = (AbstractFSDatasetHandler)DatasetHandlerFactory.build(UpsertRecipeRunner.this.authCtxService.getAuthCtx(), TempDatasetBasedExecutor.this.tempDS);){
                        tempDh.clearAllDataAndStructure();
                    }
                }

                @Override
                public void init() throws Exception {
                }
            });
        }

        void setPrepareExecutor(InitializableAbortableRecipeRunner executor) {
            this.executor = executor;
        }

        @Override
        public void notifyBeforeAborting() {
            this.executor.notifyBeforeAborting();
            this.copier.notifyBeforeAborting();
        }

        @Override
        public boolean isAppendMode(String computableRef) {
            return false;
        }

        @Override
        public void run() throws Exception {
            logger.info((Object)"Computing result data and storing in temp location");
            this.executor.run();
            if ("true".equals(UpsertRecipeRunner.this.testProps.get("testHarness.failBeforeCopy"))) {
                throw new Exception("Data was prepared, bailing out before copy");
            }
            logger.info((Object)"Complete data is ready, starting copy to target");
            this.copier.run();
            logger.info((Object)"Copy done");
        }

        @Override
        public void init() throws Exception {
            this.executor.init();
            this.copier.init();
        }
    }

    public class NonEmptyTemporaryDatasetException
    extends Exception {
        NonEmptyTemporaryDatasetException(String message) {
            super(message);
        }
    }
}

