/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.upsert;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.RecipeEnginesPreferenceConfig;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.VisualSQLRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.upsert.UpsertRecipePayloadParams;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.datasets.DatasetUtils;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.queries.ExecutionPlanService;
import com.dataiku.dip.queries.QueryBunch;
import com.dataiku.dip.recipes.common.RecipeConfigUtils;
import com.dataiku.dip.recipes.common.RecipeEngineStatus;
import com.dataiku.dip.recipes.common.RecipeStatus;
import com.dataiku.dip.recipes.common.VisualSQLRecipeStatusComputer;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipeStatus;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipesBaseService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.recipes.UpsertRecipeService;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class UpsertRecipeStatusComputer
extends VisualSQLRecipeStatusComputer {
    @Autowired
    private UpsertRecipeService service;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.upsert.status");

    public UpsertRecipeStatusComputer(SerializedRecipe recipe, String payload) {
        super(recipe, payload);
    }

    @Override
    public UpsertRecipeStatus fastStatusIgnorePartitions(AuthCtx authCtx) throws Exception {
        return this.fastStatusIgnorePartitions(new StatusInitializer(), true, authCtx);
    }

    private UpsertRecipeStatus getEngineIndependentBaseStatus(AuthCtx authCtx, StatusInitializer init) {
        UpsertRecipePayloadParams params;
        UpsertRecipeStatus status = new UpsertRecipeStatus();
        try {
            init.activity = new JobActivity(this.recipesValidationService.getSampleSubgraph(new FlowRecipe(this.recipe)));
            params = this.service.loadParams(this.payload, this.recipe);
            assert (params != null);
            status.params = params;
            status.engineParams = params.engineParams;
            init.inputDS = init.activity.getSubgraph().getSingleSourceDataset().getMandatoryUnsafe(this.datasetsDAO);
            init.outputDS = init.activity.getSubgraph().getSingleTargetDataset().getMandatoryUnsafe(this.datasetsDAO);
            this.recipesValidationService.checkComplianceWithRecipeDesc(authCtx, this.recipe);
            this.recipesValidationService.checkTargetsAreWritable(init.activity);
        }
        catch (Exception e) {
            logger.error((Object)"Invalid recipe", (Throwable)e);
            status.output.withFatal(RecipeCodes.ERR_RECIPE_INCONSISTENT_RECIPE, ExceptionUtils.getMessageWithCauses((Throwable)e));
            return status;
        }
        status.upsert = new RecipeStatus.StepStatus();
        if (params.keys == null || params.keys.size() == 0) {
            this.handleNoKey(status.upsert);
        }
        return status;
    }

    public UpsertRecipeStatus fastStatusIgnorePartitions(StatusInitializer init, boolean reportUnknownErrorsToStatus, AuthCtx authCtx) throws IOException, DKUSecurityException {
        UpsertRecipePayloadParams params;
        UpsertRecipeStatus status;
        block12: {
            RecipeEnginesPreferenceConfig repc;
            block11: {
                status = this.getEngineIndependentBaseStatus(authCtx, init);
                params = status.params;
                repc = new RecipeConfigUtils().getResolvedPreferenceConfig(this.recipe.projectKey, this.recipe.type, params.enginesPreferences);
                try {
                    this.performBasicStructureChecks(status, authCtx);
                    this.visualRecipesService.initEngines(authCtx, init.activity, status, this.recipe.projectKey);
                    this.performBasicCDEChecks(status, authCtx);
                    this.visualRecipesService.selectEngine(authCtx, init.activity, params.engineType, status, this.recipe.type, repc);
                    this.visualRecipesService.adjustEngineStatus(authCtx, init.activity, status, "Join in database, then streaming of upserted data");
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to init engine", (Throwable)e);
                    if (status.isInvalid()) break block11;
                    status.output.withFatalV(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Failed to init engine: %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
                }
            }
            if (!status.isInvalid()) {
                try {
                    this.makeRecipeSpecificEnginesStatus(authCtx, init, status, params);
                    this.visualRecipesService.selectEngine(authCtx, init.activity, params.engineType, status, this.recipe.type, repc);
                    this.visualRecipesService.adjustEngineStatus(authCtx, init.activity, status, "Aggregation in-database, then streaming of aggregates");
                    if (status.selectedEngine == null && !status.isInvalid()) {
                        status.output.withFatalV(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "No engine selected", new Object[0]);
                        return status;
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to init engine", (Throwable)e);
                    status.output.withFatalV(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Failed to init engine: %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
                    return status;
                }
                if (status.getSelectedSQLBasedEngine().queryBased) {
                    try {
                        init.dialect = this.visualRecipesService.getDialect(authCtx, init.activity, status.getSelectedSQLBasedEngine());
                        this.checkUpsertSQLMode(init, status);
                        QueryBunch queryBunch = this.service.generateSQLIgnorePartitions(init.dialect, params, status.selectedEngine.type, init.inputDS, init.outputDS, true);
                        status.sql = Stream.concat(Stream.concat(queryBunch.preQueries.stream(), Stream.of(queryBunch.query)), queryBunch.postQueries.stream()).collect(Collectors.joining(";\n"));
                        status.sqlToTest = queryBunch.inputQuery;
                        this.checkPartitionKeyUsedAsUpsert(init, status);
                    }
                    catch (Exception e) {
                        logger.info((Object)"Failed to generate SQL", (Throwable)e);
                        init.error = ExceptionUtils.getMessageWithCauses((Throwable)e);
                        if (!reportUnknownErrorsToStatus) break block12;
                        status.output.withFatalV(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Failed to generate SQL: %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
                    }
                }
            }
        }
        if (!status.isInvalid() && params.preFilter != null && params.preFilter.enabled) {
            status.preFilter = new RecipeStatus.StepStatus();
            this.visualRecipesService.checkFilter(params.preFilter, init.inputDS, init.dialect, status.preFilter, false);
        }
        if (!status.isInvalid() && params.computedColumns != null && !params.computedColumns.isEmpty()) {
            status.computedColumns = new RecipeStatus.StepStatus();
            boolean mustLowercaseColumns = this.visualRecipesService.mustLowerCaseColumnsNames((VisualSQLRecipePayloadParams)params, status.getSelectedSQLBasedEngine());
            this.visualRecipesService.checkComputedColumns(params.computedColumns, init.inputDS.getSchema(), status.getSelectedSQLBasedEngine(), init.dialect, mustLowercaseColumns, status.computedColumns);
        }
        return status;
    }

    @Override
    public UpsertRecipeStatus getStatusForConversion_NT(AuthCtx authCtx) throws Exception {
        UpsertRecipeStatus status;
        StatusInitializer init = new StatusInitializer();
        try (Transaction t = this.transactionService.beginRead();){
            status = this.fastStatusIgnorePartitions(init, true, authCtx);
            if (status.isInvalid()) {
                logger.warn((Object)"Recipe status is invalid. Try to generate query anyway:");
            }
            QueryBunch queryBunch = this.service.generateSQL(init.activity, init.dialect, status.params, status.selectedEngine.type, true);
            status.sql = Stream.concat(Stream.concat(queryBunch.preQueries.stream(), Stream.of(queryBunch.query)), queryBunch.postQueries.stream()).collect(Collectors.joining(";\n"));
        }
        return status;
    }

    @Override
    public RecipeStatus getFullStatus_NT(AuthCtx authCtx, String requestData) throws IOException, DKUSecurityException {
        boolean lowerCaseColumnsNames;
        UpsertRecipeStatus status;
        StatusInitializer init = new StatusInitializer();
        try (Transaction t = this.transactionService.beginRead();){
            status = this.fastStatusIgnorePartitions(init, false, authCtx);
            if (status.isInvalid()) {
                this.fixupStatusOutputInvalid(status);
                UpsertRecipeStatus upsertRecipeStatus = status;
                return upsertRecipeStatus;
            }
        }
        UpsertRecipePayloadParams params = status.params;
        VisualSQLRecipesBaseService.SQLBasedEngineStatus selectedEngine = status.getSelectedSQLBasedEngine();
        Dataset inputDS = init.inputDS;
        SQLDialect dialect = init.dialect;
        VisualSQLRecipeStatus.VisualSQLRecipeStatusRequest request = (VisualSQLRecipeStatus.VisualSQLRecipeStatusRequest)JSON.parse((String)requestData, VisualSQLRecipeStatus.VisualSQLRecipeStatusRequest.class);
        if (request != null && !request.exactPlan) {
            this.visualRecipesService.enableSimplifiedExplainPlan(selectedEngine, params);
        }
        String preFilterSQLExpression = null;
        if (dialect != null && params.preFilter != null && (params.preFilter.enabled || params.preFilter.distinct)) {
            status.preFilter = new RecipeStatus.StepStatus();
            boolean translateFully = selectedEngine.queryBased && !selectedEngine.type.equals("DSS");
            preFilterSQLExpression = this.visualRecipesService.checkFilter(params.preFilter, inputDS, dialect, status.preFilter, translateFully);
        }
        try {
            lowerCaseColumnsNames = this.visualRecipesService.mustLowerCaseColumnsNames((VisualSQLRecipePayloadParams)params, selectedEngine);
            status.outputSchemaBeforeOverride = this.service.getOutputSchemaBeforeOverride(inputDS, params, lowerCaseColumnsNames, dialect == null ? null : Integer.valueOf(dialect.getIdentifiersMaxLength()));
        }
        catch (Exception e) {
            logger.error((Object)"Failed to compute output schema", (Throwable)e);
            status.output.withFatalV(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Failed to compute output schema: %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
            return status;
        }
        String postFilterSQLExpression = null;
        if (status.isInvalid()) {
            this.fixupStatusOutputInvalid(status);
            return status;
        }
        this.checkOutputSchema(status, params, lowerCaseColumnsNames);
        if (this.needToComputeExecutionPlan(selectedEngine, status, request)) {
            boolean executionPlanFailed = false;
            String executionPlanErrMsg = null;
            try {
                status.executionPlan = this.getExecutionPlan(authCtx, inputDS, selectedEngine, status.sqlToTest, params.engineParams);
            }
            catch (ExecutionPlanService.HiveTableNotFound e) {
                logger.error((Object)"Failed to compute execution plan", (Throwable)e);
                status.output.withFatalV(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Failed to compute execution plan, table not found in Hive metastore %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
            }
            catch (Exception e) {
                logger.error((Object)"Failed to compute execution plan", (Throwable)e);
                logger.info((Object)("Query:\n" + status.sqlToTest));
                executionPlanFailed = true;
                executionPlanErrMsg = e.getMessage();
                status.output.withFatalV(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Failed to compute execution plan: %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
            }
            if (executionPlanFailed) {
                try {
                    this.investigateExecutionPlanFailure(status, init, executionPlanErrMsg, authCtx, preFilterSQLExpression, postFilterSQLExpression);
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to determine error cause", (Throwable)e);
                }
            }
        }
        if (init.error != null && !status.isInvalid()) {
            status.output.withFatalV(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Unknown error: %s", new Object[]{init.error});
        }
        this.fixupStatusOutputInvalid(status);
        return status;
    }

    private void fixupStatusOutputInvalid(VisualSQLRecipeStatus status) {
        if (status.isInvalid() && !status.output.anyFatal()) {
            status.output.withFatal(RecipeCodes.ERR_RECIPE_GENERIC_ERROR, "Failed to validate all recipe steps");
        }
    }

    private void makeRecipeSpecificEnginesStatus(AuthCtx authCtx, StatusInitializer init, UpsertRecipeStatus status, UpsertRecipePayloadParams params) throws Exception {
        logger.infoV("Computing engine status for upsert recipe", new Object[0]);
        for (VisualSQLRecipesBaseService.SQLBasedEngineStatus engine : status.getEngines()) {
            if (!engine.isSelectable) continue;
            if (!engine.canDistinctSelect && params.preFilter != null && params.preFilter.distinct) {
                RecipeEngineStatus.setErrorStatus("Cannot use DISTINCT in pre-filter", engine);
                continue;
            }
            if ("SQL".equals(engine.type) && !StringUtils.equals((String)init.inputDS.getParams().getConnection(), (String)init.outputDS.getParams().getConnection())) {
                engine.markAsNonSelectable("Cannot run upsert SQL cross-connections", RecipeEngineStatus.WarningLevel.ERROR);
                continue;
            }
            if (!engine.queryBased || status.selectedEngine == null || !status.selectedEngine.type.equals(engine.type)) continue;
            try {
                SQLDialect dialect = this.visualRecipesService.getDialect(authCtx, init.activity, engine);
                this.service.generateSQLIgnorePartitions(dialect, status.params, status.selectedEngine.type, init.inputDS, init.outputDS, false);
            }
            catch (Exception e) {
                RecipeEngineStatus.setErrorStatus("Recipe cannot be translated to SQL: " + ExceptionUtils.getMessageWithCauses((Throwable)e), engine);
            }
        }
    }

    private void checkOutputSchema(UpsertRecipeStatus status, UpsertRecipePayloadParams params, boolean lowerCaseColumnsNames) {
        try {
            if (status.outputSchemaBeforeOverride != null) {
                status.outputSchema = new Schema(status.outputSchemaBeforeOverride);
                if (status.outputSchema.columns.size() == 0) {
                    status.output.withFatalV(RecipeCodes.ERR_RECIPE_EMPTY_OUTPUT_SCHEMA, "Empty output schema", new Object[0]);
                }
            }
        }
        catch (Exception e) {
            status.output.withFatalV(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Error computing schema: %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
        }
    }

    private void investigateExecutionPlanFailure(UpsertRecipeStatus status, StatusInitializer init, String executionPlanErrMsg, AuthCtx authCtx, String preFilterSQLExpression, String postFilterSQLExpression) throws Exception {
        if (status.getSelectedSQLBasedEngine().type.equals("HIVE")) {
            status.output.withFatal(RecipeCodes.ERR_RECIPE_EXECUTION_PLAN_COMPUTATION_FAILED, executionPlanErrMsg);
            return;
        }
        boolean errorOriginFound = false;
        ExpressionBuilder.ExpressionBuilderFactory ef = new ExpressionBuilder.ExpressionBuilderFactory();
        SQLUtils.SQLTable table = VisualSQLRecipesBaseService.SQLBasedEngineStatus.isH2Mode(status.getSelectedSQLBasedEngine()) ? new SQLUtils.SQLTable(null, null, init.inputDS.getFullName(), false) : DatasetUtils.getResolvedTableWithSparkSQLFallback(init.inputDS, init.dialect, status.params.engineParams);
        if (status.params.keys != null && status.params.keys.size() > 0) {
            for (int k = 0; k < status.params.keys.size(); ++k) {
                UpsertRecipePayloadParams.UpsertKey key = status.params.keys.get(k);
                if (key.column != null) continue;
                status.upsert.addMessage(InfoMessage.fatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_UPSERT_INVALID_KEY, (String)"Upsert key without column", (Object[])new Object[0]).withPos(k, 0));
            }
        }
        if (preFilterSQLExpression != null) {
            SelectQueryBuilder qb = new SelectQueryBuilder();
            qb.from(table, null);
            qb.where(ef.expr(preFilterSQLExpression));
            String sql = qb.toSQL(init.dialect);
            try {
                this.getExecutionPlan(authCtx, init.inputDS, status.getSelectedSQLBasedEngine(), sql, status.params.engineParams);
            }
            catch (Exception e) {
                logger.error((Object)"Prefilter execution failed:", (Throwable)e);
                logger.error((Object)sql);
                status.preFilter.addMessage(InfoMessage.fatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_UPSERT_INVALID_FILTER, (String)this.formatDatabaseErrorMsg(e.getMessage(), init.dialect)).withPos(1, 0));
                errorOriginFound = true;
            }
        }
        if (!errorOriginFound) {
            status.output.withFatal(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, executionPlanErrMsg);
        }
    }

    private void checkPartitionKeyUsedAsUpsert(StatusInitializer init, UpsertRecipeStatus status) {
        PartitioningScheme partitionScheme = init.outputDS.getPartitioningSchema();
        if (partitionScheme != null) {
            List partitionKeys = partitionScheme.getDimensionNames();
            for (UpsertRecipePayloadParams.UpsertKey upsertKey : status.params.keys) {
                if (!partitionKeys.contains(upsertKey.column)) continue;
                this.handlePartitionUsedAsUpsertKey(status.upsert, upsertKey.column);
            }
        }
    }

    private void checkUpsertSQLMode(StatusInitializer init, UpsertRecipeStatus status) {
        String selectedEngineType = status.selectedEngine != null ? status.selectedEngine.type : "SQL";
        RecipeEngineStatus selectedEngine = status.engines.stream().filter(e -> selectedEngineType.equals(e.type)).findFirst().orElse(null);
        status.possibleModes.add(UpsertRecipePayloadParams.UpsertSQLMode.PREPARE_THEN_REPLACE);
        if ("SQL".equals(selectedEngineType)) {
            if (StringUtils.equals((String)init.inputDS.getParams().getConnection(), (String)init.outputDS.getParams().getConnection())) {
                SQLDialect.UpsertWriter upsertWriter;
                if (init.dialect.getUpdateSelectWriter() != null) {
                    status.possibleModes.add(UpsertRecipePayloadParams.UpsertSQLMode.UPDATE_THEN_INSERT);
                }
                if ((upsertWriter = init.dialect.getUpsertWriter()) != null) {
                    status.possibleModes.add(UpsertRecipePayloadParams.UpsertSQLMode.DIRECT);
                    status.usesIndex = upsertWriter.usesIndex();
                }
            }
            if (status.possibleModes.contains((Object)status.params.upsertSQLMode) && status.params.upsertSQLMode == UpsertRecipePayloadParams.UpsertSQLMode.DIRECT && status.usesIndex && status.params.upsertIndexMode == UpsertRecipePayloadParams.UpsertIndexMode.USE_EXISTING && StringUtils.isBlank((String)status.params.upsertIndexName)) {
                RecipeEngineStatus.setErrorStatus("An index is needed for direct insert", selectedEngine);
            }
            if (!status.possibleModes.contains((Object)status.params.upsertSQLMode)) {
                RecipeEngineStatus.setErrorStatus(status.params.upsertSQLMode.toString() + " upsert mode not possible", selectedEngine);
            }
        }
    }

    protected void handlePartitionUsedAsUpsertKey(RecipeStatus.StepStatus stepStatus, String col) {
        stepStatus.withWarning(RecipeCodes.WARN_RECIPE_UPSERT_PARTITION_USED_AS_KEY, "\"" + col + "\" is a partition column. Be aware that the partitioning mechanism might override the output of this recipe.");
    }

    protected void handleNoKey(RecipeStatus.StepStatus stepStatus) {
        stepStatus.withWarning(RecipeCodes.WARN_RECIPE_UPSERT_NO_KEY, "No selected upsert key, output dataset will have a single record.");
    }

    public static class StatusInitializer {
        public Dataset inputDS;
        public Dataset outputDS;
        public SQLDialect dialect;
        public JobActivity activity;
        public String error;
    }

    public static class UpsertRecipeStatus
    extends VisualSQLRecipeStatus {
        RecipeStatus.StepStatus preFilter;
        RecipeStatus.StepStatus computedColumns;
        RecipeStatus.StepStatus upsert;
        String sqlToTest;
        List<UpsertRecipePayloadParams.UpsertSQLMode> possibleModes = new ArrayList<UpsertRecipePayloadParams.UpsertSQLMode>();
        boolean usesIndex;
        UpsertRecipePayloadParams params;

        @Override
        public InfoMessage.InfoMessages gatherAllMessages() {
            InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
            ret.mergeFrom(this.topLevelMessages);
            if (this.output != null) {
                ret.mergeFrom((InfoMessage.InfoMessages)this.output);
            }
            if (this.preFilter != null) {
                ret.mergeFrom((InfoMessage.InfoMessages)this.preFilter);
            }
            if (this.computedColumns != null) {
                ret.mergeFrom((InfoMessage.InfoMessages)this.computedColumns);
            }
            return ret;
        }

        @Override
        public boolean isInvalid() {
            return this.gatherAllMessages().anyFatal();
        }
    }
}

